/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.datamodel;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;

@ThreadSafe
public abstract class AbstractDMVMAdapter
extends AbstractVMAdapter {
    private final DsfSession fSession;
    private boolean fRegisteredAsEventListener = false;

    public AbstractDMVMAdapter(DsfSession session) {
        this.fSession = session;
        try {
            session.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (DsfSession.isSessionActive((String)AbstractDMVMAdapter.this.getSession().getId())) {
                        AbstractDMVMAdapter.this.getSession().addServiceEventListener((Object)AbstractDMVMAdapter.this, null);
                        AbstractDMVMAdapter.this.fRegisteredAsEventListener = true;
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    @Override
    public void dispose() {
        try {
            this.getSession().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (AbstractDMVMAdapter.this.fRegisteredAsEventListener && AbstractDMVMAdapter.this.getSession().isActive()) {
                        AbstractDMVMAdapter.this.fSession.removeServiceEventListener((Object)AbstractDMVMAdapter.this);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        super.dispose();
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    @DsfServiceEventHandler
    public final void eventDispatched(IDMEvent<?> event) {
        if (this.isDisposed()) {
            return;
        }
        this.handleEvent(event);
    }
}

