/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.MathUtil;
import com.nvidia.viper.report.util.IWTGraphicsObject;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.IDataGridPainter;
import java.text.DecimalFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class OccupancyDataTablePainter
implements IDataGridPainter {
    private static final int BAR_HEIGHT = 10;
    private static final int BAR_INSET = 2;
    private int rowHeight = -1;

    private void drawActualValueMark(BarData data, IWTGraphicsObject wtgo, int barX, int barY, int width) {
        double datapoint = data.actual;
        if (!Double.isNaN(datapoint)) {
            Color markColor = wtgo.getColor(26);
            int x = barX + (int)((double)width * datapoint / (double)data.deviceLimit);
            Rectangle marker = new Rectangle(x, barY + 2, 3, 14);
            wtgo.fillRoundRectangle(marker.x, marker.y, marker.width, marker.height, 3, 3, markColor);
        }
    }

    private void drawMainBar(IWTGraphicsObject wtgo, int barX, int barY, int width, Color color) {
        Rectangle clipping = new Rectangle(0, 0, 0, 0);
        clipping.x = barX;
        clipping.y = 4 + barY;
        clipping.height = 10;
        clipping.width = width;
        wtgo.setBackground(color);
        wtgo.setLineWidth(2);
        wtgo.drawRectangle(clipping.x - 1, clipping.y + 1, clipping.width + 1, clipping.height - 2);
    }

    private void drawMarks(IWTGraphicsObject wtgo, BarData data, int barX, int barY, int width, Color grayColor) {
        Datatype datatype;
        int labelWidth = wtgo.stringExtent((String)((datatype = data.datatype) == Datatype.percentage || datatype == Datatype.kilos ? "00000000" : "00000")).x;
        this.paintLabel(wtgo, data.deviceLimit, datatype, barX + width, barY + 10 + 6, grayColor, grayColor, labelWidth);
        int step = this.getStep(width, labelWidth, data.deviceLimit, datatype);
        if (step > 0) {
            int i = 0;
            while (i < data.deviceLimit) {
                int x = width * i / data.deviceLimit;
                this.paintLabel(wtgo, i, datatype, barX + x, barY + 10 + 6, grayColor, grayColor, labelWidth);
                i += step;
            }
        }
    }

    private void drawTheorBar(IWTGraphicsObject wtgo, int barX, int barY, int width, Color color) {
        int y = 6 + barY;
        Rectangle clipping = new Rectangle(barX, y, width, 6);
        wtgo.fillRectangle(clipping, color);
    }

    private String getLabel(double actual, Datatype datatype) {
        if (datatype == Datatype.kilos) {
            if (actual >= 1024.0) {
                return datatype.decimalFormat.format(actual / 1024.0);
            }
            return Datatype.powof2.decimalFormat.format(actual);
        }
        if (datatype == Datatype.percentage) {
            return datatype.decimalFormat.format(actual / 100.0);
        }
        return datatype.decimalFormat.format(actual);
    }

    @Override
    public int getRowHeight(IWTGraphicsObject gc, DataGrid dataGrid, Object[] row) {
        if (this.rowHeight < 0) {
            int fontHeight = gc.getFontHeight();
            this.rowHeight = dataGrid.isHeader() ? fontHeight : fontHeight + 10 + 6;
        }
        return this.rowHeight;
    }

    private int getStep(int barWidth, int labelWidth, int deviceLimit, Datatype datatype) {
        int numLabels;
        if (datatype == Datatype.kilos) {
            deviceLimit /= 1024;
        }
        if ((numLabels = Math.min(barWidth / labelWidth, deviceLimit)) <= 0) {
            return 0;
        }
        int step = deviceLimit / numLabels;
        if (datatype == Datatype.kilos || datatype == Datatype.powof2) {
            return MathUtil.pow2roundup(step) * (datatype == Datatype.kilos ? 1024 : 1);
        }
        if (datatype == Datatype.percentage) {
            if (step == 1) {
                return 1;
            }
            if (step <= 5) {
                return 5;
            }
            if (step <= 10) {
                return 10;
            }
            if (step <= 15) {
                return 15;
            }
            if (step <= 25) {
                return 25;
            }
            if (step <= 50) {
                return 50;
            }
            return 100;
        }
        return step;
    }

    private int getTextX(IWTGraphicsObject wtgo, String text, Rectangle bounds, int align, boolean isHeader) {
        Point extent = wtgo.stringExtent(text);
        Point noUnitExtent = isHeader ? extent : wtgo.stringExtent(this.stripUnits(text));
        switch (align & 0x1024000) {
            case 16384: {
                return 0;
            }
            case 131072: {
                return bounds.width - extent.x;
            }
        }
        return (bounds.width - noUnitExtent.x) / 2;
    }

    private void paintBar(IWTGraphicsObject wtgo, BarData data, Rectangle bounds) {
        if (data == null) {
            return;
        }
        Point fontDim = wtgo.stringExtent("00000");
        int barX = bounds.x + fontDim.x / 2;
        int barY = bounds.y + 2;
        int width = bounds.width - fontDim.x;
        Color grayColor = wtgo.getColor(16);
        this.drawMainBar(wtgo, barX, barY, width, grayColor);
        if (data.theoretical > 0.0) {
            int w;
            Color color;
            if (data.gridTheor > 0.0) {
                color = wtgo.getColor(15);
                w = (int)Math.round((double)width * data.gridTheor / (double)data.deviceLimit);
                this.drawTheorBar(wtgo, barX, barY, w, color);
            }
            color = wtgo.getColor(data.isLimiter ? 4 : 2);
            w = (int)Math.round((double)width * data.theoretical / (double)data.deviceLimit);
            this.drawTheorBar(wtgo, barX, barY, w, color);
        }
        this.drawMarks(wtgo, data, barX, barY, width, grayColor);
        this.drawActualValueMark(data, wtgo, barX, barY, width);
    }

    @Override
    public void paintCell(IWTGraphicsObject wtgo, DataGrid grid, Object data, Rectangle rectangle, int align, boolean highlight) {
        if (rectangle.height <= 0 || rectangle.width <= 0) {
            return;
        }
        if (data instanceof String) {
            this.paintText(wtgo, (String)data, rectangle, align, highlight, grid.isHeader());
        } else {
            this.paintBar(wtgo, (BarData)data, rectangle);
        }
    }

    private void paintLabel(IWTGraphicsObject wtgo, int datapoint, Datatype datatype, int x, int y, Color color, Color mark, int width) {
        String label = this.getLabel(datapoint, datatype);
        wtgo.setForeground(color);
        Point textExtent = wtgo.stringExtent(this.stripUnits(label));
        wtgo.drawString(label, x - textExtent.x / 2, y, true);
        if (mark != null) {
            wtgo.setForeground(mark);
            wtgo.drawRectangle(x - 1, y - 2, 1, 2);
        }
    }

    private void paintText(IWTGraphicsObject wtgo, String text, Rectangle bounds, int align, boolean highlight, boolean isHeader) {
        int x = Math.max(0, this.getTextX(wtgo, text, bounds, align, isHeader)) + bounds.x;
        int y = (bounds.height - wtgo.getFontHeight()) / 2 + bounds.y;
        Color c = wtgo.getForeground();
        if (highlight) {
            wtgo.setForeground(wtgo.getColor(4));
        }
        wtgo.drawString(text, x, y, true);
        wtgo.setForeground(c);
    }

    private String stripUnits(String extentString) {
        int i = extentString.length() - 1;
        while (i > 0) {
            if (Character.isDigit(extentString.charAt(i))) break;
            --i;
        }
        return extentString.substring(0, i + 1);
    }

    public static final class BarData {
        public final double actual;
        public final Datatype datatype;
        public final int deviceLimit;
        public final double gridTheor;
        public final boolean isLimiter;
        public final double theoretical;

        public BarData(int deviceLimit, double theoretical, Number actual, Number theoreticalAcrossGrid, Datatype datatype, boolean isLimiter) {
            this.deviceLimit = deviceLimit;
            this.theoretical = theoretical;
            this.isLimiter = isLimiter;
            this.gridTheor = theoreticalAcrossGrid == null ? 0.0 : theoreticalAcrossGrid.doubleValue();
            this.datatype = datatype;
            this.actual = actual != null ? actual.doubleValue() : Double.NaN;
        }
    }

    public static enum Datatype {
        integer("####0.##"),
        kilos("####0k"),
        percentage("####0.#%"),
        powof2("####0");

        public final DecimalFormat decimalFormat;

        private Datatype(String format) {
            this.decimalFormat = new DecimalFormat(format);
        }
    }
}

