/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityPCSamplingRecordInfo;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimelineIntervalBase
implements IModel,
ITimelineInterval {
    protected TimelineIntervalKind kind = TimelineIntervalKind.UNKNOWN;
    protected long start = 0L;
    protected long end = 0L;
    protected long id = 0L;
    protected Timeline primaryTimeline;

    public TimelineIntervalBase(TimelineIntervalKind kind, long start, long end, long id) {
        this.kind = kind;
        this.start = start;
        this.end = end;
        this.id = id;
        this.primaryTimeline = null;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return this.kind;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return "<unknown>";
    }

    @Override
    public String getDisplayName() {
        return "<unknown>";
    }

    @Override
    public Set<Integer> getCorrelationIds() {
        return new HashSet<Integer>();
    }

    @Override
    public int getPrimaryCorrelationId() {
        return 0;
    }

    @Override
    public boolean isCorrelated(Set<Integer> other) {
        Set<Integer> mine = this.getCorrelationIds();
        for (int id : other) {
            if (!mine.contains(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        return null;
    }

    @Override
    public int getHeight(int intervalRowHeight) {
        return -1;
    }

    @Override
    public long getStart() {
        return this.start - this.getNormalizedTime();
    }

    @Override
    public long getEnd() {
        return this.end - this.getNormalizedTime();
    }

    public String getStreamName(int id) {
        Session session = this.primaryTimeline.getSession();
        List<Timeline> tls = session.getTimelines(TimelineKind.STREAM);
        for (Timeline tl : tls) {
            TimelineStream stream = (TimelineStream)tl;
            if (stream.getId() != id) continue;
            return stream.getDisplayName(true);
        }
        return null;
    }

    protected long getNormalizedTime() {
        Session session;
        long normalizedTime = 0L;
        Timeline timeline = this.getPrimaryTimeline();
        if (timeline != null && (session = timeline.getSession()) != null) {
            normalizedTime = session.getSessionStartTime(this);
        }
        return normalizedTime;
    }

    @Override
    public long getDuration() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public long getExtendedEnd() {
        return this.getEnd();
    }

    @Override
    public long getExtendedDuration() {
        return this.getDuration();
    }

    @Override
    public Timeline getPrimaryTimeline() {
        return this.primaryTimeline;
    }

    @Override
    public void setPrimaryTimeline(Timeline timeline) {
        this.primaryTimeline = timeline;
    }

    @Override
    public Set<Event> getEvents() {
        return Collections.emptySet();
    }

    @Override
    public Long getEventValue(Event event) {
        return null;
    }

    @Override
    public Long getEventsTotalValue(Collection<Event> events) {
        return null;
    }

    @Override
    public void setEventValue(Event event, Long value) {
    }

    @Override
    public Set<Metric> getAggregateMetrics() {
        return Collections.emptySet();
    }

    @Override
    public Number getAggregateMetricValue(Metric metric) {
        return null;
    }

    @Override
    public void setAggregateMetricActivity(Metric metric, CuptiActivityMetric activity) {
    }

    @Override
    public CuptiActivityMetric getAggregateMetricActivity(Metric metric) {
        return null;
    }

    @Override
    public boolean isAggregateMetricOverflow(Metric metric) {
        return false;
    }

    @Override
    public boolean isAggregateMetricInvalid(Metric metric) {
        return false;
    }

    @Override
    public Set<Metric> getInstanceMetrics() {
        return Collections.emptySet();
    }

    @Override
    public Number getInstanceMetricValue(Metric metric, int instance) {
        return null;
    }

    @Override
    public void setInstanceMetricActivity(Metric metric, int instance, CuptiActivityMetric activity) {
    }

    @Override
    public CuptiActivityMetric getInstanceMetricActivity(Metric metric, int instance) {
        return null;
    }

    @Override
    public List<CuptiActivityMetric> getInstanceMetricActivities(Metric metric) {
        return Collections.emptyList();
    }

    @Override
    public boolean isInstanceMetricOverflow(Metric metric, int instance) {
        return false;
    }

    @Override
    public boolean isInstanceMetricInvalid(Metric metric, int instance) {
        return false;
    }

    @Override
    public Collection<ICuptiActivitySourceLevelResult> getSourceLevelResults() {
        return Collections.emptySet();
    }

    @Override
    public boolean addSourceLevelResult(ICuptiActivitySourceLevelResult result) {
        return false;
    }

    @Override
    public boolean removeSourceLevelResult(ICuptiActivitySourceLevelResult result) {
        return false;
    }

    @Override
    public void clearSourceLevelResults() {
    }

    @Override
    public boolean addEvent(CuptiActivityEvent eventActivity) throws Exception {
        return false;
    }

    @Override
    public boolean addMetric(CuptiActivityMetric metricActivity) throws Exception {
        return false;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
    }

    @Override
    public boolean isAllAnalysisDataLoaded() {
        return true;
    }

    @Override
    public void setAnalysisLoaded(boolean loaded) {
    }

    @Override
    public void addPCSamplingRecordInfo(CuptiActivityPCSamplingRecordInfo recordInfo) {
    }

    @Override
    public CuptiActivityPCSamplingRecordInfo getPCSamplingRecordInfo() {
        return null;
    }
}

