/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.KernelOccupancyResultGraphicFactory;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;

public final class AnalysisResultKernelOccupancy
extends AnalysisResult {
    private final TimelineDevice device;
    private final TimelineIntervalKernel kernel;
    private final OccupancyCalculator calculator;
    private final double achievedOccupancy;

    public AnalysisResultKernelOccupancy(TimelineDevice device, TimelineIntervalKernel kernel, OccupancyCalculator calculator, double achievedOccupancy) {
        super(AnalysisResultKernelOccupancy.getDescriptor(calculator));
        this.device = device;
        this.kernel = kernel;
        this.calculator = calculator;
        this.achievedOccupancy = achievedOccupancy;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        return Collections.singletonList(new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel));
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelOccupancyResultGraphicFactory();
    }

    @Override
    public String getLabel(ResultOutput otpt) {
        if (this.calculator.getTheoreticOccupancy() >= 0.5) {
            switch (this.getDescriptor()) {
                case KERNEL_OCCUPANCY_LIMIT_BLOCK: {
                    return ViperMessages.KernelLatency_Occupancy_BlockLimit_Good_Label;
                }
                case KERNEL_OCCUPANCY_LIMIT_REGISTER: {
                    return ViperMessages.KernelLatency_Occupancy_RegisterLimit_Good_Label;
                }
                case KERNEL_OCCUPANCY_LIMIT_SHARED_MEMORY: {
                    return ViperMessages.KernelLatency_Occupancy_SharedMemoryLimit_Good_Label;
                }
            }
        }
        return super.getLabel(otpt);
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        desc = desc.replace("%DEVICE%", "\"" + this.device.getName() + "\"");
        int maxBlocksPerSM = this.device.getMaxBlocksPerMultiprocessor();
        desc = desc.replace("%MAXBLOCKSPERSM%", String.valueOf(maxBlocksPerSM) + (maxBlocksPerSM > 1 ? " blocks" : " block"));
        int maxRegistersPerBlock = this.device.getMaxRegistersPerBlock();
        desc = desc.replace("%MAXREGISTERSPERBLOCK%", String.valueOf(maxRegistersPerBlock) + (maxRegistersPerBlock > 1 ? " registers" : " register"));
        OccupancyCalculator oc = new OccupancyCalculator(this.kernel, this.device);
        int occupancyWarpsPerSM = oc.getWarpsPerSM();
        int occupancyBlocksPerSM = oc.getBlocksPerSM();
        desc = desc.replace("%WARPSPERSM%", String.valueOf(occupancyWarpsPerSM) + (occupancyWarpsPerSM > 1 ? " warps" : " warp"));
        desc = desc.replace("%BLOCKSPERSM%", String.valueOf(occupancyBlocksPerSM) + (occupancyBlocksPerSM > 1 ? " blocks" : " block"));
        switch (this.getDescriptor()) {
            case KERNEL_OCCUPANCY_LIMIT_BLOCK: {
                int threadsPerBlock = this.kernel.getThreadsPerBlock();
                desc = desc.replace("%THREADSPERBLOCK%", String.valueOf(threadsPerBlock) + (threadsPerBlock > 1 ? " threads" : " thread"));
                int warpsPerBlock = (threadsPerBlock + this.device.getNumThreadsPerWarp() - 1) / this.device.getNumThreadsPerWarp();
                desc = desc.replace("%WARPSPERBLOCK%", String.valueOf(warpsPerBlock) + (warpsPerBlock > 1 ? " warps" : " warp"));
                desc = desc.replace("%CHARTNAME%", ViperMessages.Chart_Block_Size_Title);
                break;
            }
            case KERNEL_OCCUPANCY_LIMIT_REGISTER: {
                int registersPerThread = this.kernel.getRegistersPerThread();
                desc = desc.replace("%REGISTERSPERTHREAD%", String.valueOf(registersPerThread) + (registersPerThread > 1 ? " registers" : " register"));
                int registersPerBlock = this.kernel.getThreadsPerBlock() * registersPerThread;
                desc = desc.replace("%REGISTERSPERBLOCK%", String.valueOf(registersPerBlock) + (registersPerBlock > 1 ? " registers" : " register"));
                desc = desc.replace("%CHARTNAME%", ViperMessages.Chart_Register_Title);
                break;
            }
            case KERNEL_OCCUPANCY_LIMIT_SHARED_MEMORY: {
                CuCacheConfig ccExecuted = this.kernel.getCacheConfigExecuted();
                Long totalSharedMemory = ccExecuted == null ? -1L : this.device.getMaxSharedMemory(ccExecuted);
                desc = desc.replace("%TOTALSHAREDMEMORY%", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(totalSharedMemory));
                int sharedMemoryPerBlock = this.kernel.getStaticSharedMemory() + this.kernel.getDynamicSharedMemory();
                desc = desc.replace("%SHAREDMEMORYPERBLOCK%", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(sharedMemoryPerBlock));
                desc = desc.replace("%CHARTNAME%", ViperMessages.Chart_Shared_Memory_Title);
                break;
            }
        }
        if (!AnalysisDescriptor.KERNEL_OCCUPANCY_GOOD.equals((Object)this.getDescriptor()) && this.calculator.getTheoreticOccupancy() >= 0.5) {
            desc = String.valueOf(ViperMessages.KernelLatency_Occupancy_Limit_Good_Desc) + "\n\n" + desc;
        }
        return desc;
    }

    @Override
    public String getActionDescription(ResultOutput otpt) {
        String desc = super.getActionDescription(otpt);
        if (this.isSharedMemoryLimitedNotPrefer()) {
            desc = String.valueOf(desc) + " " + ViperMessages.KernelLatency_Occupancy_SharedMemoryPrefer_ActionDesc;
        }
        return desc;
    }

    public OccupancyCalculator getOccupancyCalculator() {
        return this.calculator;
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public double getAchievedOccupancy() {
        return this.achievedOccupancy;
    }

    private boolean isSharedMemoryLimitedNotPrefer() {
        return this.getDescriptor().equals((Object)AnalysisDescriptor.KERNEL_OCCUPANCY_LIMIT_SHARED_MEMORY) && !CuCacheConfig.CU_FUNC_CACHE_PREFER_SHARED.equals((Object)this.kernel.getCacheConfigExecuted());
    }

    private static AnalysisDescriptor getDescriptor(OccupancyCalculator calculator) {
        OccupancyCalculator.Limiter limiter = calculator.getLimiter();
        if (limiter != null) {
            switch (limiter) {
                case BLOCK: {
                    return AnalysisDescriptor.KERNEL_OCCUPANCY_LIMIT_BLOCK;
                }
                case REGISTER: {
                    return AnalysisDescriptor.KERNEL_OCCUPANCY_LIMIT_REGISTER;
                }
                case SHARED_MEMORY: {
                    return AnalysisDescriptor.KERNEL_OCCUPANCY_LIMIT_SHARED_MEMORY;
                }
            }
        }
        return AnalysisDescriptor.KERNEL_OCCUPANCY_GOOD;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                switch (AnalysisResultKernelOccupancy.this.getDescriptor()) {
                    case KERNEL_OCCUPANCY_LIMIT_BLOCK: {
                        ViperHelp.displayHelp(ViperHelp.OCCUPANCY_BLOCK);
                        break;
                    }
                    case KERNEL_OCCUPANCY_LIMIT_REGISTER: {
                        ViperHelp.displayHelp(ViperHelp.OCCUPANCY_REG);
                        break;
                    }
                    case KERNEL_OCCUPANCY_LIMIT_SHARED_MEMORY: {
                        ViperHelp.displayHelp(ViperHelp.OCCUPANCY_SHARED);
                        break;
                    }
                    default: {
                        ViperHelp.displayHelp(ViperHelp.OCCUPANCY);
                    }
                }
            }
        };
    }
}

