/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.Arrays;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ICache;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.runtime.CoreException;

public abstract class Transaction<V> {
    private static final InvalidCacheException INVALID_CACHE_EXCEPTION = new InvalidCacheException();
    private DataRequestMonitor<V> fRm;

    public void request(DataRequestMonitor<V> rm) {
        if (this.fRm != null) {
            assert (this.fRm.isCanceled());
            this.fRm.done();
        }
        this.fRm = rm;
        assert (this.fRm != null);
        this.execute();
    }

    protected abstract V process() throws InvalidCacheException, CoreException;

    private void execute() {
        if (this.fRm.isCanceled()) {
            this.fRm.done();
            this.fRm = null;
            return;
        }
        try {
            V data = this.process();
            this.fRm.setData(data);
            this.fRm.done();
            this.fRm = null;
        }
        catch (CoreException e) {
            this.fRm.setStatus(e.getStatus());
            this.fRm.done();
            this.fRm = null;
        }
        catch (InvalidCacheException invalidCacheException) {}
    }

    public void validate(ICache<?> cache) throws InvalidCacheException, CoreException {
        if (cache.isValid()) {
            if (!cache.getStatus().isOK()) {
                throw new CoreException(cache.getStatus());
            }
        } else {
            cache.update(new RequestMonitor(ImmediateExecutor.getInstance(), this.fRm){

                @Override
                protected void handleCompleted() {
                    Transaction.this.execute();
                }
            });
            throw INVALID_CACHE_EXCEPTION;
        }
    }

    public <T> void validate(ICache<?> ... caches) throws InvalidCacheException, CoreException {
        this.validate(Arrays.asList(caches));
    }

    public void validate(Iterable caches) throws InvalidCacheException, CoreException {
        boolean allValid = true;
        for (Object cacheObj : caches) {
            ICache cache = (ICache)cacheObj;
            if (cache.isValid()) {
                if (cache.getStatus().isOK()) continue;
                throw new CoreException(cache.getStatus());
            }
            allValid = false;
        }
        if (!allValid) {
            CountingRequestMonitor countringRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), this.fRm){

                @Override
                protected void handleCompleted() {
                    Transaction.this.execute();
                }
            };
            int count = 0;
            for (Object cacheObj : caches) {
                ICache cache = (ICache)cacheObj;
                if (cache.isValid()) continue;
                cache.update(countringRm);
                ++count;
            }
            countringRm.setDoneCount(count);
            throw INVALID_CACHE_EXCEPTION;
        }
    }

    public static class InvalidCacheException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

