/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.EFSExtensionProvider;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ICBuildOutputParser;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractLanguageSettingsOutputScanner
extends LanguageSettingsSerializableProvider
implements ICBuildOutputParser {
    protected static final String ATTR_KEEP_RELATIVE_PATHS = "keep-relative-paths";
    private static final String PROJ_NAME_PREFIX = String.valueOf('/') + CdtVariableResolver.createVariableReference((String)"ProjName") + '/';
    protected ICConfigurationDescription currentCfgDescription = null;
    protected IWorkingDirectoryTracker cwdTracker = null;
    protected IProject currentProject = null;
    protected IResource currentResource = null;
    protected String currentLanguageId = null;
    protected String parsedResourceName = null;
    protected boolean isResolvingPaths = true;
    protected EFSExtensionProvider efsProvider = null;
    private static final EFSExtensionProvider efsProviderDefault = new EFSExtensionProvider(){
        final EFSExtensionManager efsManager = EFSExtensionManager.getDefault();

        public String getPathFromURI(URI locationURI) {
            return this.efsManager.getPathFromURI(locationURI);
        }

        public URI getLinkedURI(URI locationURI) {
            return this.efsManager.getLinkedURI(locationURI);
        }

        public URI createNewURIFromPath(URI locationOnSameFilesystem, String path) {
            return this.efsManager.createNewURIFromPath(locationOnSameFilesystem, path);
        }

        public String getMappedPath(URI locationURI) {
            return this.efsManager.getMappedPath(locationURI);
        }

        public boolean isVirtual(URI locationURI) {
            return this.efsManager.isVirtual(locationURI);
        }

        public URI append(URI baseURI, String extension) {
            return this.efsManager.append(baseURI, extension);
        }
    };

    protected abstract String parseResourceName(String var1);

    protected abstract List<String> parseOptions(String var1);

    protected abstract AbstractOptionParser[] getOptionParsers();

    public boolean isResolvingPaths() {
        return this.isResolvingPaths;
    }

    public void setResolvingPaths(boolean resolvePaths) {
        this.isResolvingPaths = resolvePaths;
    }

    public void startup(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker) throws CoreException {
        this.currentCfgDescription = cfgDescription;
        this.currentProject = cfgDescription != null ? cfgDescription.getProjectDescription().getProject() : null;
        this.cwdTracker = cwdTracker;
        this.efsProvider = this.getEFSProvider();
    }

    public void shutdown() {
        this.parsedResourceName = null;
        this.currentLanguageId = null;
        this.currentResource = null;
        this.cwdTracker = null;
    }

    public boolean processLine(String line) {
        this.parsedResourceName = this.parseResourceName(line);
        this.currentResource = this.findResource(this.parsedResourceName);
        this.currentLanguageId = this.determineLanguage();
        if (!this.isLanguageInScope(this.currentLanguageId)) {
            return false;
        }
        URI buildDirURI = null;
        URI mappedRootURI = null;
        if (this.isResolvingPaths) {
            mappedRootURI = this.getMappedRootURI(this.currentResource, this.parsedResourceName);
            buildDirURI = this.getBuildDirURI(mappedRootURI);
        }
        ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>();
        List<String> options = this.parseOptions(line);
        if (options != null) {
            AbstractOptionParser[] optionParsers = this.getOptionParsers();
            block2: for (String option : options) {
                AbstractOptionParser[] abstractOptionParserArray = optionParsers;
                int n = optionParsers.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractOptionParser optionParser = abstractOptionParserArray[n2];
                    try {
                        if (optionParser.parseOption(option)) {
                            ICLanguageSettingEntry entry = null;
                            if (this.isResolvingPaths && (optionParser.isForFile() || optionParser.isForFolder())) {
                                URI baseURI = mappedRootURI;
                                if (buildDirURI != null && !new Path(optionParser.parsedName).isAbsolute()) {
                                    baseURI = mappedRootURI != null ? this.efsProvider.append(mappedRootURI, buildDirURI.getPath()) : buildDirURI;
                                }
                                entry = this.createResolvedPathEntry(optionParser, optionParser.parsedName, 0, baseURI);
                            } else {
                                entry = optionParser.createEntry(optionParser.parsedName, optionParser.parsedValue, 0);
                            }
                            if (entry != null && !entries.contains(entry)) {
                                entries.add(entry);
                                continue block2;
                            }
                        }
                    }
                    catch (Throwable e) {
                        String msg = "Exception trying to parse option [" + option + "], class " + ((Object)((Object)this)).getClass().getSimpleName();
                        ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, e));
                    }
                    ++n2;
                }
            }
            if (entries.size() > 0) {
                this.setSettingEntries(entries);
            } else {
                this.setSettingEntries(null);
            }
        }
        return false;
    }

    protected URI getMappedRootURI(IResource resource, String parsedResourceName) {
        int relSegmentsCount;
        IPath absResourcePath;
        int absSegmentsCount;
        Path parsedSrcPath;
        if (resource == null) {
            return null;
        }
        URI resourceURI = resource.getLocationURI();
        String mappedRoot = "/";
        if (parsedResourceName != null && (parsedSrcPath = new Path(parsedResourceName)).isAbsolute() && (absSegmentsCount = (absResourcePath = resource.getLocation()).segmentCount()) >= (relSegmentsCount = parsedSrcPath.segmentCount())) {
            IPath ending = absResourcePath.removeFirstSegments(absSegmentsCount - relSegmentsCount);
            if ((ending = ending.setDevice(parsedSrcPath.getDevice()).makeAbsolute()).equals((Object)parsedSrcPath.makeAbsolute())) {
                mappedRoot = absResourcePath.removeLastSegments(relSegmentsCount).toString();
            }
        }
        URI uri = this.efsProvider.createNewURIFromPath(resourceURI, mappedRoot);
        return uri;
    }

    protected URI getBuildDirURI(URI mappedRootURI) {
        IPath pathBuilderCWD;
        String cwdPath;
        URI buildDirURI = null;
        URI cwdURI = null;
        if (this.currentResource != null && this.parsedResourceName != null && !new Path(this.parsedResourceName).isAbsolute()) {
            cwdURI = AbstractLanguageSettingsOutputScanner.findBaseLocationURI(this.currentResource.getLocationURI(), this.parsedResourceName);
        }
        if ((buildDirURI = (cwdPath = cwdURI != null ? this.efsProvider.getPathFromURI(cwdURI) : null) != null && mappedRootURI != null ? this.efsProvider.append(mappedRootURI, cwdPath) : cwdURI) == null && this.cwdTracker != null) {
            buildDirURI = this.cwdTracker.getWorkingDirectoryURI();
        }
        if (buildDirURI == null && this.currentCfgDescription != null && (pathBuilderCWD = this.currentCfgDescription.getBuildSetting().getBuilderCWD()) != null) {
            String builderCWD = pathBuilderCWD.toString();
            try {
                ICdtVariableManager vmanager = CCorePlugin.getDefault().getCdtVariableManager();
                builderCWD = vmanager.resolveValue(builderCWD, "", null, this.currentCfgDescription);
            }
            catch (CdtVariableException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            if (builderCWD != null && !builderCWD.isEmpty()) {
                buildDirURI = URIUtil.toURI((String)builderCWD);
            }
        }
        if (buildDirURI == null && this.currentProject != null) {
            buildDirURI = this.currentProject.getLocationURI();
        }
        if (buildDirURI == null && this.currentResource != null) {
            IContainer container = this.currentResource instanceof IContainer ? (IContainer)this.currentResource : this.currentResource.getParent();
            buildDirURI = container.getLocationURI();
        }
        return buildDirURI;
    }

    protected void setSettingEntries(List<? extends ICLanguageSettingEntry> entries) {
        this.setSettingEntries(this.currentCfgDescription, this.currentResource, this.currentLanguageId, entries);
    }

    protected String determineLanguage() {
        IResource rc = this.currentResource;
        if (rc == null && this.currentProject != null && this.parsedResourceName != null) {
            String fileName = new Path(this.parsedResourceName).lastSegment().toString();
            rc = this.currentProject.getFile("__" + fileName);
        }
        if (rc == null) {
            return null;
        }
        List languageIds = LanguageSettingsManager.getLanguages((IResource)rc, (ICConfigurationDescription)this.currentCfgDescription);
        if (languageIds.isEmpty()) {
            return null;
        }
        return (String)languageIds.get(0);
    }

    protected boolean isLanguageInScope(String languageId) {
        List languageIds = this.getLanguageScope();
        return languageIds == null || languageIds.contains(languageId);
    }

    private static IResource findFileForLocationURI(URI uri, IProject preferredProject, boolean checkExistence) {
        IFile[] resources;
        IFile sourceFile = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] iFileArray = resources = root.findFilesForLocationURI(uri);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile rc = iFileArray[n2];
            if (!checkExistence || rc.isAccessible()) {
                if (rc.getProject().equals((Object)preferredProject)) {
                    sourceFile = rc;
                    break;
                }
                if (sourceFile == null) {
                    sourceFile = rc;
                }
            }
            ++n2;
        }
        return sourceFile;
    }

    private static IResource findContainerForLocationURI(URI uri, IProject preferredProject, boolean checkExistence) {
        IContainer[] resources;
        IContainer resource = null;
        IContainer[] iContainerArray = resources = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer rc = iContainerArray[n2];
            if ((rc instanceof IProject || rc instanceof IFolder) && (!checkExistence || rc.isAccessible())) {
                if (rc.getProject().equals((Object)preferredProject)) {
                    resource = rc;
                    break;
                }
                if (resource == null) {
                    resource = rc;
                }
            }
            ++n2;
        }
        return resource;
    }

    private IResource findResource(String parsedResourceName) {
        IPath builderCWD;
        URI cwdURI;
        if (parsedResourceName == null || parsedResourceName.isEmpty()) {
            return null;
        }
        IFile sourceFile = null;
        if (this.cwdTracker instanceof ErrorParserManager) {
            sourceFile = ((ErrorParserManager)this.cwdTracker).findFileName(parsedResourceName);
        }
        if (sourceFile == null && new Path(parsedResourceName).isAbsolute()) {
            URI uri = URIUtil.toURI((String)parsedResourceName);
            sourceFile = AbstractLanguageSettingsOutputScanner.findFileForLocationURI(uri, this.currentProject, true);
        }
        if (sourceFile == null && this.cwdTracker != null && (cwdURI = this.cwdTracker.getWorkingDirectoryURI()) != null) {
            URI uri = this.efsProvider.append(cwdURI, parsedResourceName);
            sourceFile = AbstractLanguageSettingsOutputScanner.findFileForLocationURI(uri, this.currentProject, true);
        }
        if (sourceFile == null && this.currentCfgDescription != null && (builderCWD = this.currentCfgDescription.getBuildSetting().getBuilderCWD()) != null) {
            String strBuilderCWD = builderCWD.toString();
            try {
                ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
                strBuilderCWD = varManager.resolveValue(strBuilderCWD, "", null, this.currentCfgDescription);
            }
            catch (Exception e) {
                String msg = "Exception trying to resolve value [" + strBuilderCWD + "]";
                ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, (Throwable)e));
            }
            builderCWD = new Path(strBuilderCWD);
            IPath path = builderCWD.append(parsedResourceName);
            URI uri = URIUtil.toURI((IPath)path);
            sourceFile = AbstractLanguageSettingsOutputScanner.findFileForLocationURI(uri, this.currentProject, true);
        }
        if (sourceFile == null && this.currentProject != null) {
            sourceFile = this.currentProject.findMember(parsedResourceName);
        }
        return sourceFile;
    }

    private static URI findBaseLocationURI(URI fileURI, String relativeFileName) {
        URI cwdURI = null;
        String path = fileURI.getPath();
        String[] segments = relativeFileName.split("[/\\\\]");
        int i = segments.length - 1;
        while (i >= 0) {
            String lastSegment = segments[i];
            if (lastSegment.length() > 0 && !lastSegment.equals(".")) {
                if (lastSegment.equals("..")) {
                    return null;
                }
                if (path.endsWith("/" + lastSegment)) {
                    int pos = path.lastIndexOf("/" + lastSegment);
                    path = path.substring(0, pos);
                } else {
                    return null;
                }
            }
            --i;
        }
        try {
            cwdURI = new URI(fileURI.getScheme(), fileURI.getUserInfo(), fileURI.getHost(), fileURI.getPort(), String.valueOf(path) + '/', fileURI.getQuery(), fileURI.getFragment());
        }
        catch (URISyntaxException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return cwdURI;
    }

    private static URI resolvePathFromBaseLocation(String pathStr0, IPath baseLocation) {
        String device;
        String pathStr = pathStr0;
        if (baseLocation != null && !baseLocation.isEmpty() && ((device = new Path(pathStr = pathStr.replace(File.separatorChar, '/')).getDevice()) == null || device.equals(baseLocation.getDevice()))) {
            if (device != null && device.length() > 0) {
                pathStr = pathStr.substring(device.length());
            }
            baseLocation = baseLocation.addTrailingSeparator();
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            pathStr = String.valueOf(baseLocation.toString()) + pathStr;
        }
        try {
            File file = new File(pathStr);
            file = file.getCanonicalFile();
            URI uri = file.toURI();
            if (file.exists()) {
                return uri;
            }
            Path path0 = new Path(pathStr0);
            if (!path0.isAbsolute()) {
                return uri;
            }
            String device2 = path0.getDevice();
            if (device2 == null || device2.isEmpty()) {
                pathStr = path0.setDevice(null).toString();
            } else if (pathStr.charAt(0) != '/') {
                pathStr = String.valueOf('/') + pathStr;
            }
            return new URI(uri.getScheme(), uri.getAuthority(), pathStr, uri.getQuery(), uri.getFragment());
        }
        catch (Exception e) {
            ManagedBuilderCorePlugin.log(e);
            return URIUtil.toURI((String)pathStr);
        }
    }

    private URI determineMappedURI(String pathStr, URI baseURI) {
        URI uri = null;
        if (baseURI == null) {
            if (new Path(pathStr).isAbsolute()) {
                uri = AbstractLanguageSettingsOutputScanner.resolvePathFromBaseLocation(pathStr, (IPath)Path.ROOT);
            }
        } else if (baseURI.getScheme().equals("file")) {
            IPath baseLocation = URIUtil.toPath((URI)baseURI);
            uri = AbstractLanguageSettingsOutputScanner.resolvePathFromBaseLocation(pathStr, baseLocation);
        } else {
            String localPath;
            Path path = new Path(pathStr);
            URI remoteUri = this.efsProvider.append(baseURI, path.toString());
            if (remoteUri != null && (localPath = this.efsProvider.getMappedPath(remoteUri)) != null) {
                uri = URIUtil.toURI((String)localPath);
            }
        }
        if (uri == null) {
            uri = URIUtil.toURI((String)pathStr);
        }
        return uri;
    }

    private static List<IResource> findPathInFolder(IPath path, IContainer folder) {
        ArrayList<IResource> paths = new ArrayList<IResource>();
        IResource resource = folder.findMember(path);
        if (resource != null) {
            paths.add(resource);
        }
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IContainer) {
                    paths.addAll(AbstractLanguageSettingsOutputScanner.findPathInFolder(path, (IContainer)res));
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return paths;
    }

    private IResource findBestFitInWorkspace(String parsedName) {
        IProject[] projects;
        Path path;
        LinkedHashSet referencedProjectsNames = new LinkedHashSet();
        if (this.currentCfgDescription != null) {
            Map refs = this.currentCfgDescription.getReferenceInfo();
            referencedProjectsNames.addAll(refs.keySet());
        }
        if ((path = new Path(parsedName)).equals((Object)new Path(".")) || path.equals((Object)new Path(".."))) {
            return null;
        }
        if (this.currentProject != null) {
            List<IResource> result = AbstractLanguageSettingsOutputScanner.findPathInFolder((IPath)path, (IContainer)this.currentProject);
            int size = result.size();
            if (size == 1) {
                return result.get(0);
            }
            if (size > 1) {
                return null;
            }
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (referencedProjectsNames.size() > 0) {
            IResource rc = null;
            for (String prjName : referencedProjectsNames) {
                IProject prj = root.getProject(prjName);
                if (!prj.isOpen()) continue;
                List<IResource> result = AbstractLanguageSettingsOutputScanner.findPathInFolder((IPath)path, (IContainer)prj);
                int size = result.size();
                if (size == 1 && rc == null) {
                    rc = result.get(0);
                    continue;
                }
                if (size <= 0) continue;
                rc = null;
                break;
            }
            if (rc != null) {
                return rc;
            }
        }
        if ((projects = root.getProjects()).length > 0) {
            IResource rc = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                if (!prj.equals((Object)this.currentProject) && !referencedProjectsNames.contains(prj.getName()) && prj.isOpen()) {
                    List<IResource> result = AbstractLanguageSettingsOutputScanner.findPathInFolder((IPath)path, (IContainer)prj);
                    int size = result.size();
                    if (size == 1 && rc == null) {
                        rc = result.get(0);
                    } else if (size > 0) {
                        rc = null;
                        break;
                    }
                }
                ++n2;
            }
            if (rc != null) {
                return rc;
            }
        }
        return null;
    }

    private IPath getFilesystemLocation(URI uri) {
        if (uri == null) {
            return null;
        }
        String pathStr = this.efsProvider.getMappedPath(uri);
        if ((uri = URIUtil.toURI((String)pathStr)) != null && uri.isAbsolute()) {
            try {
                File file = new File(uri);
                String canonicalPathStr = file.getCanonicalPath();
                if (new Path(pathStr).getDevice() == null) {
                    return new Path(canonicalPathStr).setDevice(null);
                }
                return new Path(canonicalPathStr);
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        return null;
    }

    private ICLanguageSettingEntry createResolvedPathEntry(AbstractOptionParser optionParser, String parsedPath, int flag, URI baseURI) {
        URI uri = this.determineMappedURI(parsedPath, baseURI);
        boolean isRelative = !new Path(parsedPath).isAbsolute();
        boolean isRemapped = baseURI != null && this.currentProject != null && !baseURI.equals(this.currentProject.getLocationURI());
        boolean presentAsRelative = isRelative || isRemapped;
        ICLanguageSettingEntry entry = this.resolvePathEntryInWorkspace(optionParser, uri, flag, presentAsRelative);
        if (entry != null) {
            return entry;
        }
        entry = this.resolvePathEntryInFilesystem(optionParser, uri, flag);
        if (entry != null) {
            return entry;
        }
        entry = this.resolvePathEntryInWorkspaceAsBestFit(optionParser, parsedPath, flag, presentAsRelative);
        if (entry != null) {
            return entry;
        }
        entry = this.resolvePathEntryInWorkspaceToNonexistingResource(optionParser, uri, flag, presentAsRelative);
        if (entry != null) {
            return entry;
        }
        entry = this.resolvePathEntryInFilesystemToNonExistingResource(optionParser, uri, flag);
        if (entry != null) {
            return entry;
        }
        return optionParser.createEntry(parsedPath, parsedPath, flag);
    }

    private ICLanguageSettingEntry createPathEntry(AbstractOptionParser optionParser, IResource rc, boolean isRelative, int flag) {
        String path;
        if (isRelative && rc.getProject().equals((Object)this.currentProject)) {
            path = String.valueOf(PROJ_NAME_PREFIX) + rc.getFullPath().removeFirstSegments(1);
            flag |= 8;
        } else {
            path = rc.getFullPath().toString();
            flag = flag | 8 | 0x10;
        }
        return optionParser.createEntry(path, path, flag);
    }

    private ICLanguageSettingEntry resolvePathEntryInWorkspace(AbstractOptionParser optionParser, URI uri, int flag, boolean isRelative) {
        if (uri != null && uri.isAbsolute()) {
            IResource rc = null;
            if (optionParser.isForFolder()) {
                rc = AbstractLanguageSettingsOutputScanner.findContainerForLocationURI(uri, this.currentProject, true);
            } else if (optionParser.isForFile()) {
                rc = AbstractLanguageSettingsOutputScanner.findFileForLocationURI(uri, this.currentProject, true);
            }
            if (rc != null) {
                return this.createPathEntry(optionParser, rc, isRelative, flag);
            }
        }
        return null;
    }

    private ICLanguageSettingEntry resolvePathEntryInFilesystem(AbstractOptionParser optionParser, URI uri, int flag) {
        String loc;
        IPath location = this.getFilesystemLocation(uri);
        if (location != null && new File(loc = location.toString()).exists()) {
            return optionParser.createEntry(loc, loc, flag);
        }
        return null;
    }

    private ICLanguageSettingEntry resolvePathEntryInWorkspaceAsBestFit(AbstractOptionParser optionParser, String parsedPath, int flag, boolean isRelative) {
        IResource rc = this.findBestFitInWorkspace(parsedPath);
        if (rc != null) {
            return this.createPathEntry(optionParser, rc, isRelative, flag);
        }
        return null;
    }

    private ICLanguageSettingEntry resolvePathEntryInWorkspaceToNonexistingResource(AbstractOptionParser optionParser, URI uri, int flag, boolean isRelative) {
        if (uri != null && uri.isAbsolute()) {
            IResource rc = null;
            if (optionParser.isForFolder()) {
                rc = AbstractLanguageSettingsOutputScanner.findContainerForLocationURI(uri, this.currentProject, false);
            } else if (optionParser.isForFile()) {
                rc = AbstractLanguageSettingsOutputScanner.findFileForLocationURI(uri, this.currentProject, false);
            }
            if (rc != null) {
                return this.createPathEntry(optionParser, rc, isRelative, flag);
            }
        }
        return null;
    }

    private ICLanguageSettingEntry resolvePathEntryInFilesystemToNonExistingResource(AbstractOptionParser optionParser, URI uri, int flag) {
        IPath location = this.getFilesystemLocation(uri);
        if (location != null) {
            return optionParser.createEntry(location.toString(), location.toString(), flag);
        }
        return null;
    }

    protected static int countGroups(String str) {
        int count = str.replaceAll("[^\\(]", "").length();
        return count;
    }

    private static String expressionLogicalOr(Set<String> fileExts) {
        String pattern = "(";
        for (String ext : fileExts) {
            if (pattern.length() != 1) {
                pattern = String.valueOf(pattern) + "|";
            }
            pattern = String.valueOf(pattern) + "(" + Pattern.quote(ext) + ")";
            if (fileExts.contains(ext = ext.toUpperCase())) continue;
            pattern = String.valueOf(pattern) + "|(" + Pattern.quote(ext) + ")";
        }
        pattern = String.valueOf(pattern) + ")";
        return pattern;
    }

    protected String getPatternFileExtensions() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        HashSet<String> fileExts = new HashSet<String>();
        IContentType contentTypeCpp = manager.getContentType("org.eclipse.cdt.core.cxxSource");
        fileExts.addAll(Arrays.asList(contentTypeCpp.getFileSpecs(8)));
        IContentType contentTypeC = manager.getContentType("org.eclipse.cdt.core.cSource");
        fileExts.addAll(Arrays.asList(contentTypeC.getFileSpecs(8)));
        String pattern = AbstractLanguageSettingsOutputScanner.expressionLogicalOr(fileExts);
        return pattern;
    }

    protected EFSExtensionProvider getEFSProvider() {
        return efsProviderDefault;
    }

    public Element serializeAttributes(Element parentElement) {
        Element elementProvider = super.serializeAttributes(parentElement);
        elementProvider.setAttribute(ATTR_KEEP_RELATIVE_PATHS, Boolean.toString(!this.isResolvingPaths));
        return elementProvider;
    }

    public void loadAttributes(Element providerNode) {
        super.loadAttributes(providerNode);
        String expandRelativePathsValue = XmlUtil.determineAttributeValue((Node)providerNode, (String)ATTR_KEEP_RELATIVE_PATHS);
        if (expandRelativePathsValue != null) {
            this.isResolvingPaths = !Boolean.parseBoolean(expandRelativePathsValue);
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isResolvingPaths ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractLanguageSettingsOutputScanner other = (AbstractLanguageSettingsOutputScanner)((Object)obj);
        return this.isResolvingPaths == other.isResolvingPaths;
    }

    protected static abstract class AbstractOptionParser {
        private final int kind;
        private final String patternStr;
        private final Pattern pattern;
        private final String nameExpression;
        private final String valueExpression;
        private final int extraFlag;
        private String parsedName;
        private String parsedValue;

        public AbstractOptionParser(int kind, String pattern, String nameExpression, String valueExpression, int extraFlag) {
            this.kind = kind;
            this.patternStr = pattern;
            this.nameExpression = nameExpression;
            this.valueExpression = valueExpression;
            this.extraFlag = extraFlag;
            this.pattern = Pattern.compile(pattern);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return (ICLanguageSettingEntry)CDataUtil.createEntry((int)this.kind, (String)name, (String)value, null, (int)(flag | this.extraFlag));
        }

        public boolean isForFile() {
            return this.kind == 2 || this.kind == 8;
        }

        public boolean isForFolder() {
            return this.kind == 1 || this.kind == 16;
        }

        private String parseStr(Matcher matcher, String str) {
            if (str != null) {
                return matcher.replaceAll(str);
            }
            return null;
        }

        public boolean parseOption(String optionString) {
            String option = optionString.replaceFirst("(" + this.patternStr + ").*", "$1");
            Matcher matcher = this.pattern.matcher(option);
            boolean isMatch = matcher.matches();
            if (isMatch) {
                this.parsedName = this.parseStr(matcher, this.nameExpression);
                this.parsedValue = this.parseStr(matcher, this.valueExpression);
            }
            return isMatch;
        }
    }

    protected static class IncludeFileOptionParser
    extends AbstractOptionParser {
        public IncludeFileOptionParser(String pattern, String nameExpression) {
            super(2, pattern, nameExpression, nameExpression, 0);
        }

        public IncludeFileOptionParser(String pattern, String nameExpression, int extraFlag) {
            super(2, pattern, nameExpression, nameExpression, extraFlag);
        }
    }

    protected static class IncludePathOptionParser
    extends AbstractOptionParser {
        public IncludePathOptionParser(String pattern, String nameExpression) {
            super(1, pattern, nameExpression, nameExpression, 0);
        }

        public IncludePathOptionParser(String pattern, String nameExpression, int extraFlag) {
            super(1, pattern, nameExpression, nameExpression, extraFlag);
        }
    }

    protected static class LibraryFileOptionParser
    extends AbstractOptionParser {
        public LibraryFileOptionParser(String pattern, String nameExpression) {
            super(32, pattern, nameExpression, nameExpression, 0);
        }

        public LibraryFileOptionParser(String pattern, String nameExpression, int extraFlag) {
            super(32, pattern, nameExpression, nameExpression, extraFlag);
        }
    }

    protected static class LibraryPathOptionParser
    extends AbstractOptionParser {
        public LibraryPathOptionParser(String pattern, String nameExpression) {
            super(16, pattern, nameExpression, nameExpression, 0);
        }

        public LibraryPathOptionParser(String pattern, String nameExpression, int extraFlag) {
            super(16, pattern, nameExpression, nameExpression, extraFlag);
        }
    }

    protected static class MacroFileOptionParser
    extends AbstractOptionParser {
        public MacroFileOptionParser(String pattern, String nameExpression) {
            super(8, pattern, nameExpression, nameExpression, 0);
        }

        public MacroFileOptionParser(String pattern, String nameExpression, int extraFlag) {
            super(8, pattern, nameExpression, nameExpression, extraFlag);
        }
    }

    protected static class MacroOptionParser
    extends AbstractOptionParser {
        public MacroOptionParser(String pattern, String nameExpression, String valueExpression) {
            super(4, pattern, nameExpression, valueExpression, 0);
        }

        public MacroOptionParser(String pattern, String nameExpression, String valueExpression, int extraFlag) {
            super(4, pattern, nameExpression, valueExpression, extraFlag);
        }

        public MacroOptionParser(String pattern, String nameExpression, int extraFlag) {
            super(4, pattern, nameExpression, null, extraFlag);
        }
    }
}

