/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionParseAction
extends Action {
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor editor) {
        this.fEditor = editor;
        this.fSite = editor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite site) {
        this.fSite = site;
    }

    public IWorkbenchSite getSite() {
        return this.fSite;
    }

    protected void showStatusLineMessage(String message) {
        StatusLineHandler.showStatusLineMessage(this.fSite, message);
    }

    protected void clearStatusLine() {
        StatusLineHandler.clearStatusLine(this.fSite);
    }

    protected ISelection getSelection() {
        ISelection sel = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            sel = this.fSite.getSelectionProvider().getSelection();
        }
        return sel;
    }

    protected ITextSelection getSelectedStringFromEditor() {
        ISelection selection = this.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    protected void open(IPath path, int currentOffset, int currentLength) throws CoreException {
        this.clearStatusLine();
        IEditorPart editor = EditorUtility.openInEditor(path, (ICElement)this.fEditor.getInputCElement());
        ITextEditor textEditor = EditorUtility.getTextEditor(editor);
        if (textEditor != null) {
            textEditor.selectAndReveal(currentOffset, currentLength);
        } else {
            this.reportSourceFileOpenFailure(path);
        }
    }

    protected void open(ITranslationUnit tu, int currentOffset, int currentLength) throws CoreException {
        this.clearStatusLine();
        IEditorPart editor = EditorUtility.openInEditor(tu, true);
        ITextEditor textEditor = EditorUtility.getTextEditor(editor);
        if (textEditor != null) {
            textEditor.selectAndReveal(currentOffset, currentLength);
        } else {
            this.reportSourceFileOpenFailure(tu.getPath());
        }
    }

    protected void reportSourceFileOpenFailure(IPath path) {
        this.showStatusLineMessage(MessageFormat.format((String)CSearchMessages.SelectionParseAction_FileOpenFailure_format, (Object[])new Object[]{path.toOSString()}));
    }

    protected void reportSelectionMatchFailure() {
        this.showStatusLineMessage(CSearchMessages.SelectionParseAction_SelectedTextNotSymbol_message);
    }

    protected void reportSymbolLookupFailure(String symbol) {
        this.showStatusLineMessage(MessageFormat.format((String)CSearchMessages.SelectionParseAction_SymbolNotFoundInIndex_format, (Object[])new Object[]{symbol}));
    }

    protected void reportIncludeLookupFailure(String filename) {
        this.showStatusLineMessage(MessageFormat.format((String)CSearchMessages.SelectionParseAction_IncludeNotFound_format, (Object[])new Object[]{filename}));
    }
}

