/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.io.IOException;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.IErrorMarkeredOutputStream;
import org.eclipse.cdt.internal.ui.buildconsole.BuildOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

class MultiBuildConsoleAdapter
implements IConsole {
    private final IConsole fProjectConsole;
    private final IConsole fGlobalConsole;

    public MultiBuildConsoleAdapter(IConsole projectConsole, IConsole globalConsole) {
        this.fProjectConsole = projectConsole;
        this.fGlobalConsole = globalConsole;
    }

    public void start(IProject project) {
        this.fProjectConsole.start(project);
    }

    public ConsoleOutputStream getOutputStream() throws CoreException {
        return new BuildOutputStreamAdapter((BuildOutputStream)this.fProjectConsole.getOutputStream(), (BuildOutputStream)this.fGlobalConsole.getOutputStream());
    }

    public ConsoleOutputStream getInfoStream() throws CoreException {
        return new BuildOutputStreamAdapter((BuildOutputStream)this.fProjectConsole.getInfoStream(), (BuildOutputStream)this.fGlobalConsole.getInfoStream());
    }

    public ConsoleOutputStream getErrorStream() throws CoreException {
        return new BuildOutputStreamAdapter((BuildOutputStream)this.fProjectConsole.getErrorStream(), (BuildOutputStream)this.fGlobalConsole.getErrorStream());
    }

    private static class BuildOutputStreamAdapter
    extends ConsoleOutputStream
    implements IErrorMarkeredOutputStream {
        private final BuildOutputStream one;
        private final BuildOutputStream two;

        public BuildOutputStreamAdapter(BuildOutputStream one, BuildOutputStream two) {
            this.one = one;
            this.two = two;
        }

        public synchronized String readBuffer() {
            return this.one.readBuffer();
        }

        public synchronized void write(int c) throws IOException {
            this.one.write(c);
            this.two.write(c);
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.one.write(b, off, len);
            this.two.write(b, off, len);
        }

        public void write(String s, ProblemMarkerInfo marker) throws IOException {
            this.one.write(s, marker);
            this.two.write(s, marker);
        }

        public void close() throws IOException {
            this.one.flush();
            this.two.flush();
            this.one.close();
            this.two.close();
        }
    }
}

