/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.sync.core.RemoteLocation;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.remote.core.IRemoteConnection;

public class SyncConfig
implements Comparable<SyncConfig> {
    private String fName;
    private String fSyncProviderId;
    private RemoteLocation remoteLocation;
    private IProject fProject;
    private boolean fSyncOnPreBuild = true;
    private boolean fSyncOnPostBuild = true;
    private boolean fSyncOnSave = true;
    private final Map<String, String> fProperties = new HashMap<String, String>();

    public SyncConfig(String name) {
        this.fName = name;
        this.remoteLocation = new RemoteLocation();
    }

    @Override
    public int compareTo(SyncConfig config) {
        return this.getName().compareTo(config.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncConfig other = (SyncConfig)obj;
        return this.fName.equals(other.fName);
    }

    public String getConnectionName() {
        return this.remoteLocation.getConnectionName();
    }

    public String[] getKeys() {
        return this.fProperties.keySet().toArray(new String[0]);
    }

    public String getLocation() {
        return this.remoteLocation.getDirectory();
    }

    public String getLocation(IProject project) {
        assert (this.fProject == project);
        return this.remoteLocation.getDirectory(project);
    }

    public String getName() {
        return this.fName;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getProperty(String key) {
        return this.fProperties.get(key);
    }

    public IRemoteConnection getRemoteConnection() throws MissingConnectionException {
        return this.remoteLocation.getConnection();
    }

    public RemoteLocation getRemoteLocation() {
        return this.remoteLocation;
    }

    public String getRemoteServicesId() {
        return this.remoteLocation.getRemoteServicesId();
    }

    public String getSyncProviderId() {
        return this.fSyncProviderId;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public boolean isSyncOnPostBuild() {
        return this.fSyncOnPostBuild;
    }

    public boolean isSyncOnPreBuild() {
        return this.fSyncOnPreBuild;
    }

    public boolean isSyncOnSave() {
        return this.fSyncOnSave;
    }

    public void setConfigName(String configName) {
        this.fName = configName;
    }

    public void setConnection(IRemoteConnection connection) {
        this.remoteLocation.setConnection(connection);
    }

    public void setConnectionName(String connectionName) {
        this.remoteLocation.setConnectionName(connectionName);
    }

    public void setLocation(String location) {
        this.remoteLocation.setLocation(location);
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void setProperty(String key, String value) {
        this.fProperties.put(key, value);
    }

    public void setRemoteServicesId(String remoteServicesId) {
        this.remoteLocation.setRemoteServicesId(remoteServicesId);
    }

    public void setSyncOnPostBuild(boolean syncOnPostBuild) {
        this.fSyncOnPostBuild = syncOnPostBuild;
    }

    public void setSyncOnPreBuild(boolean syncOnPreBuild) {
        this.fSyncOnPreBuild = syncOnPreBuild;
    }

    public void setSyncOnSave(boolean syncOnSave) {
        this.fSyncOnSave = syncOnSave;
    }

    public void setSyncProviderId(String syncProviderId) {
        this.fSyncProviderId = syncProviderId;
    }
}

