/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataHandler;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.util.ParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class MetaDataReader {
    private static Logger logger = Logger.getLogger(MetaDataReader.class.getName());

    public static void read(String fileName) throws MetaDataParserException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage());
            MetaLogManager.log("Metadata definition file not found", e);
            throw new MetaDataParserException(fileName, "FILE_NOT_FOUND");
        }
        try {
            try {
                MetaDataReader.read(inputStream);
            }
            catch (MetaDataParserException e) {
                e.setFileName(fileName);
                throw e;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException iOException) {}
    }

    public static void read(InputStream inputStream) throws MetaDataParserException {
        InputStream internalStream = inputStream;
        if (inputStream != null && !inputStream.markSupported()) {
            internalStream = new BufferedInputStream(inputStream);
            assert (internalStream.markSupported());
        }
        assert (MetaDataDictionary.getInstance().isEmpty());
        MetaDataHandler handler = new MetaDataHandler();
        SAXParser parser = null;
        try {
            try {
                parser = ParserFactory.getInstance().getParser(null);
                parser.parse(internalStream, (DefaultHandler)handler);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage());
                MetaLogManager.log("Metadata parsing error", e);
                throw new MetaDataParserException(e, "PARSER_ERROR");
            }
        }
        catch (Throwable throwable) {
            try {
                ParserFactory.getInstance().releaseParser(parser, null);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ParserFactory.getInstance().releaseParser(parser, null);
        }
        catch (Exception exception) {}
    }
}

