/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.timeFunction;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.data.adapter.api.timeFunction.BaseTimeFunction;
import org.eclipse.birt.report.data.adapter.i18n.Message;

public class TimeFunctionHandle {
    private static TimeFunctionHandle instance;
    private static Map<ULocale, TimeFunctionHandle> handleCache;
    private Map<String, BaseTimeFunction> baseTimeFunctionMap = new HashMap<String, BaseTimeFunction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeFunctionHandle getInstance(ULocale locale) {
        Class<TimeFunctionHandle> clazz = TimeFunctionHandle.class;
        synchronized (TimeFunctionHandle.class) {
            if (handleCache == null) {
                handleCache = new HashMap<ULocale, TimeFunctionHandle>();
                instance = new TimeFunctionHandle(locale);
                handleCache.put(locale, instance);
            } else if (handleCache.containsKey(locale)) {
                instance = handleCache.get(locale);
            } else {
                instance = new TimeFunctionHandle(locale);
                handleCache.put(locale, instance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private TimeFunctionHandle(ULocale local) {
        this.buildTimeFunctionMap(local);
    }

    private void buildTimeFunctionMap(ULocale local) {
        this.baseTimeFunctionMap.put("CURRENT QUARTER", new BaseTimeFunction("CURRENT QUARTER", Message.getMessage("timeFunction.CURRENT_QUARTER.name", local), Message.getMessage("timeFunction.CURRENT_QUARTER.description", local)));
        this.baseTimeFunctionMap.put("CURRENT MONTH", new BaseTimeFunction("CURRENT MONTH", Message.getMessage("timeFunction.CURRENT_MONTH.name", local), Message.getMessage("timeFunction.CURRENT_MONTH.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS MONTH", new BaseTimeFunction("PREVIOUS MONTH", Message.getMessage("timeFunction.PREVIOUS_MONTH.name", local), Message.getMessage("timeFunction.PREVIOUS_MONTH.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS WEEK TO DATE", new BaseTimeFunction("PREVIOUS WEEK TO DATE", Message.getMessage("timeFunction.PREVIOUS_WEEK_TO_DATE.name", local), Message.getMessage("timeFunction.PREVIOUS_WEEK_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS MONTH TO DATE", new BaseTimeFunction("PREVIOUS MONTH TO DATE", Message.getMessage("timeFunction.PREVIOUS_MONTH_TO_DATE.name", local), Message.getMessage("timeFunction.PREVIOUS_MONTH_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS QUARTER", new BaseTimeFunction("PREVIOUS QUARTER", Message.getMessage("timeFunction.PREVIOUS_QUARTER.name", local), Message.getMessage("timeFunction.PREVIOUS_QUARTER.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS QUARTER TO DATE", new BaseTimeFunction("PREVIOUS QUARTER TO DATE", Message.getMessage("timeFunction.PREVIOUS_QUARTER_TO_DATE.name", local), Message.getMessage("timeFunction.PREVIOUS_QUARTER_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS YEAR", new BaseTimeFunction("PREVIOUS YEAR", Message.getMessage("timeFunction.PREVIOUS_PREVIOUS_YEAR.name", local), Message.getMessage("timeFunction.PREVIOUS_PREVIOUS_YEAR.description", local)));
        this.baseTimeFunctionMap.put("YEAR TO DATE", new BaseTimeFunction("YEAR TO DATE", Message.getMessage("timeFunction.YEAR_TO_DATE.name", local), Message.getMessage("timeFunction.YEAR_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("QUARTER TO DATE", new BaseTimeFunction("QUARTER TO DATE", Message.getMessage("timeFunction.QUARTER_TO_DATE.name", local), Message.getMessage("timeFunction.QUARTER_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("MONTH TO DATE", new BaseTimeFunction("MONTH TO DATE", Message.getMessage("timeFunction.MONTH_TO_DATE.name", local), Message.getMessage("timeFunction.MONTH_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("PREVIOUS YEAR TO DATE", new BaseTimeFunction("PREVIOUS YEAR TO DATE", Message.getMessage("timeFunction.PREVIOUS_YEAR_TO_DATE.name", local), Message.getMessage("timeFunction.PREVIOUS_YEAR_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("WEEK TO DATE LAST YEAR", new BaseTimeFunction("WEEK TO DATE LAST YEAR", Message.getMessage("timeFunction.WEEK_TO_DATE_LAST_YEAR.name", local), Message.getMessage("timeFunction.WEEK_TO_DATE_LAST_YEAR.description", local)));
        this.baseTimeFunctionMap.put("MONTH TO DATE LAST YEAR", new BaseTimeFunction("MONTH TO DATE LAST YEAR", Message.getMessage("timeFunction.MONTH_TO_DATE_LAST_YEAR.name", local), Message.getMessage("timeFunction.MONTH_TO_DATE_LAST_YEAR.description", local)));
        this.baseTimeFunctionMap.put("QUARTER TO DATE LAST YEAR", new BaseTimeFunction("QUARTER TO DATE LAST YEAR", Message.getMessage("timeFunction.QUARTER_TO_DATE_LAST_YEAR.name", local), Message.getMessage("timeFunction.QUARTER_TO_DATE_LAST_YEAR.description", local)));
        this.baseTimeFunctionMap.put("CURRENT YEAR", new BaseTimeFunction("CURRENT YEAR", Message.getMessage("timeFunction.CURRENT_YEAR.name", local), Message.getMessage("timeFunction.CURRENT_YEAR.description", local)));
        this.baseTimeFunctionMap.put("WEEK TO DATE", new BaseTimeFunction("WEEK TO DATE", Message.getMessage("timeFunction.WEEK_TO_DATE.name", local), Message.getMessage("timeFunction.WEEK_TO_DATE.description", local)));
        this.baseTimeFunctionMap.put("CURRENT PERIOD FROM N PERIODS AGO", new BaseTimeFunction("CURRENT PERIOD FROM N PERIODS AGO", Message.getMessage("timeFunction.CURRENT_PERIOD_FROM_N_PERIOD_AGO.name", local), Message.getMessage("timeFunction.CURRENT_PERIOD_FROM_N_PERIOD_AGO.description", local)));
        this.baseTimeFunctionMap.put("PERIOD TO DATE FROM N PERIODS AGO", new BaseTimeFunction("PERIOD TO DATE FROM N PERIODS AGO", Message.getMessage("timeFunction.PERIOD_TO_DATE_FROM_N_PERIOD_AGO.name", local), Message.getMessage("timeFunction.PERIOD_TO_DATE_FROM_N_PERIOD_AGO.description", local)));
        this.baseTimeFunctionMap.put("TRAILING N MONTHS", new BaseTimeFunction("TRAILING N MONTHS", Message.getMessage("timeFunction.TRAILING_N_MONTHS.name", local), Message.getMessage("timeFunction.TRAILING_N_MONTHS.name", local)));
        this.baseTimeFunctionMap.put("TRAILING N DAYS", new BaseTimeFunction("TRAILING N DAYS", Message.getMessage("timeFunction.TRAILING_N_DAYS.name", local), Message.getMessage("timeFunction.TRAILING_N_DAYS.name", local)));
        this.baseTimeFunctionMap.put("TRAILING N PERIODS FROM N PERIODS AGO", new BaseTimeFunction("TRAILING N PERIODS FROM N PERIODS AGO", Message.getMessage("timeFunction.TRAILING_N_PERIOD_FROM_N_PERIOD_AGO.name", local), Message.getMessage("timeFunction.TRAILING_N_PERIOD_FROM_N_PERIOD_AGO.description", local)));
        this.baseTimeFunctionMap.put("NEXT_N_PERIODS", new BaseTimeFunction("NEXT_N_PERIODS", Message.getMessage("timeFunction.NEXT_N_PERIODS.name", local), Message.getMessage("timeFunction.NEXT_N_PERIODS.description", local)));
    }

    public BaseTimeFunction getFunction(String functionName) {
        return this.baseTimeFunctionMap.get(functionName);
    }
}

