/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.actions;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.internal.ui.build.BuildConfigurationsMenuBuilder;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.cview.BuildGroup;
import org.eclipse.cdt.ui.actions.ChangeBuildConfigActionBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.statushandlers.StatusManager;

public class BuildActiveConfigMenuAction
extends ChangeBuildConfigActionBase
implements IWorkbenchWindowPulldownDelegate2 {
    private BuildAction buildaction;
    private IAction tooltipActionCache = null;

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.addMenuListener(menu);
        return menu;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.buildaction = new BuildGroup.CDTBuildAction((IShellProvider)window, 10);
    }

    public void run(IAction action) {
        this.buildaction.selectionChanged((IStructuredSelection)new StructuredSelection(this.fProjects.toArray()));
        this.buildaction.run();
    }

    private void updateTooltip(IAction action) {
        String toolTipText = "";
        if (this.fProjects.size() <= 5) {
            CoreModel cm = CoreModel.getDefault();
            for (IProject prj : this.fProjects) {
                if (prj == null) continue;
                ICProjectDescription desc = cm.getProjectDescription(prj, false);
                SyncConfig syncConf = SyncConfigManager.getActive((IProject)prj);
                String prjName = prj.getName();
                String confName = desc.getActiveConfiguration().getName();
                String syncConfName = syncConf != null ? syncConf.getConnectionName() : null;
                toolTipText = syncConfName != null ? String.valueOf(toolTipText) + String.format("Build %s for %s on %s\n", confName, prjName, syncConfName) : String.valueOf(toolTipText) + String.format("Build %s for %s\n", confName, prjName);
            }
            toolTipText = toolTipText.trim();
        }
        if (toolTipText.length() == 0) {
            toolTipText = ActionMessages.BuildActiveConfigMenuAction_defaultTooltip;
        }
        action.setToolTipText(toolTipText);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.tooltipActionCache == null) {
            this.tooltipActionCache = action;
        }
        this.onSelectionChanged(action, selection);
        this.updateTooltip(action);
    }

    public Menu getMenu(Menu parent) {
        throw new UnsupportedOperationException();
    }

    private void addMenuListener(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                BuildActiveConfigMenuAction.this.fillMenu((Menu)e.widget);
            }
        });
    }

    private static void cleanupMenu(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
    }

    private void changeAndBuild(IProject project, SyncConfig target, String configuration) {
        try {
            BuildConfigurationsMenuBuilder.updateCurrentBuildConfigurationAndTarget(project, target, configuration);
            this.buildaction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)project));
            this.buildaction.run();
        }
        catch (CoreException e) {
            StatusManager mgr = StatusManager.getManager();
            mgr.handle(CoreUtil.errorStatus((Throwable)e, (String)"Unable to update project %s configuration", (Object[])new Object[]{project.getName()}));
        }
        if (this.tooltipActionCache != null) {
            this.updateTooltip(this.tooltipActionCache);
        }
    }

    protected void fillMenu(Menu menu) {
        if (menu == null) {
            return;
        }
        if (this.fProjects.size() == 1) {
            IAction[] actions;
            final IProject project = (IProject)this.fProjects.iterator().next();
            BuildActiveConfigMenuAction.cleanupMenu(menu);
            IAction[] iActionArray = actions = new BuildConfigurationsMenuBuilder(){

                @Override
                protected IAction createMenuItem(String label, final SyncConfig target, final String configuration) {
                    return new Action(label){

                        public void run() {
                            BuildActiveConfigMenuAction.this.changeAndBuild(project, target, configuration);
                        }
                    };
                }
            }.buildMenu(project);
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                ActionContributionItem item = new ActionContributionItem(action);
                item.fill(menu, -1);
                ++n2;
            }
        } else {
            super.fillMenu(menu);
        }
    }
}

