/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import com.nvidia.common.util.CoreUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static String[] getStringList(Element element, String childName) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Element child : XmlUtil.iter(element, childName)) {
            linkedList.add(CoreUtil.notNull(child.getNodeValue()));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static Iterable<Element> iter(Element root, String childElements) {
        NodeList name = root.getElementsByTagName(childElements);
        Iterable<Element> iter = XmlUtil.iter(name, Element.class);
        return iter;
    }

    public static <T extends Node> Iterable<T> iter(final NodeList nodes, final Class<T> type) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new NodelistIterator(nodes, type);
            }
        };
    }

    public static Element createTextElement(Document document, String elementName, String text) {
        Element element = document.createElement(elementName);
        CDATASection section = document.createCDATASection(text);
        element.appendChild(section);
        return element;
    }

    public static String[] getStringList(Element root, String element, String attribute) {
        LinkedList<String> result = new LinkedList<String>();
        Iterable<Element> iter = XmlUtil.iter(root, element);
        for (Element el : iter) {
            result.add(CoreUtil.notNull(el.getAttribute(attribute)));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String escapeString(String str) {
        if (str == null) {
            return null;
        }
        boolean needEscape = false;
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            boolean escapeChars;
            char ch = str.charAt(i);
            boolean controlCharacter = ch < ' ';
            boolean unicodeButNotAscii = ch > '~';
            boolean bl = escapeChars = ch == '\"' || ch == '\'' || ch == '<' || ch == '&' || ch == '>';
            if (escapeChars || unicodeButNotAscii || controlCharacter) {
                stringBuffer.append("&#" + ch + ";");
                needEscape = true;
            } else {
                stringBuffer.append(ch);
            }
            ++i;
        }
        if (!needEscape) {
            return str;
        }
        return stringBuffer.toString();
    }

    private static class NodelistIterator<T>
    implements Iterator<T> {
        private int i = 0;
        private final NodeList nodes;
        private final Class<T> type;

        public NodelistIterator(NodeList nodes, Class<T> type) {
            this.nodes = nodes;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            int j = this.i;
            T next = this.nextElement();
            this.i = j;
            return next != null;
        }

        @Override
        public T next() {
            T next = this.nextElement();
            if (next == null) {
                throw new NoSuchElementException();
            }
            return next;
        }

        private T nextElement() {
            while (this.i < this.nodes.getLength()) {
                Node node = this.nodes.item(this.i);
                if (this.type.isInstance(node)) {
                    ++this.i;
                    return this.type.cast(node);
                }
                ++this.i;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

