/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.report.util.IWTGraphicsObject;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.IDataGridPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MemoryDataTablePainter
implements IDataGridPainter {
    private static final int BAR_HEIGHT = 10;
    private static final int BAR_INSET = 2;
    private static final MemoryDataTablePainter singleton = new MemoryDataTablePainter();

    public static MemoryDataTablePainter getSingleton() {
        return singleton;
    }

    private void drawBar(IWTGraphicsObject wtgo, int barX, int barY, int width, Color color) {
        Rectangle clipping = new Rectangle(0, 0, 0, 0);
        clipping.x = barX;
        clipping.y = 4 + barY;
        clipping.height = 10;
        clipping.width = width;
        wtgo.setBackground(color);
        wtgo.setLineWidth(2);
        wtgo.drawRectangle(clipping.x - 1, clipping.y + 1, clipping.width + 1, clipping.height - 2);
    }

    private void drawMarks(IWTGraphicsObject wtgo, int barX, int barY, int width, Color color) {
        CuptiMetricValueUtilizationLevel[] utils;
        CuptiMetricValueUtilizationLevel[] cuptiMetricValueUtilizationLevelArray = utils = CuptiMetricValueUtilizationLevel.values();
        int n = utils.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiMetricValueUtilizationLevel util = cuptiMetricValueUtilizationLevelArray[n2];
            String label = null;
            switch (util) {
                case CUPTI_METRIC_VALUE_UTILIZATION_IDLE: {
                    label = "Idle";
                    break;
                }
                case CUPTI_METRIC_VALUE_UTILIZATION_LOW: {
                    label = "Low";
                    break;
                }
                case CUPTI_METRIC_VALUE_UTILIZATION_MID: {
                    label = "Medium";
                    break;
                }
                case CUPTI_METRIC_VALUE_UTILIZATION_HIGH: {
                    label = "High";
                    break;
                }
                case CUPTI_METRIC_VALUE_UTILIZATION_MAX: {
                    label = "Max";
                    break;
                }
            }
            this.drawMark(wtgo, barX + this.getUtilizationMarkOffset(util, width), barY + 10 + 6, color, color, label);
            ++n2;
        }
    }

    private void drawMark(IWTGraphicsObject wtgo, int x, int y, Color markColor, Color labelColor, String label) {
        wtgo.setForeground(labelColor);
        if (label != null) {
            Point textExtent = wtgo.stringExtent(label);
            wtgo.drawString(label, x - textExtent.x / 2, y, true);
        }
        if (markColor != null) {
            wtgo.setForeground(markColor);
            wtgo.drawRectangle(x - 1, y - 2, 1, 2);
        }
    }

    private int getUtilizationMarkOffset(CuptiMetricValueUtilizationLevel utilLevel, int width) {
        return (int)((double)width * (double)utilLevel.ordinal() / (double)(CuptiMetricValueUtilizationLevel.values().length - 1));
    }

    private void fillBar(IWTGraphicsObject wtgo, int barX, int barY, int width, Color color) {
        int y = 6 + barY;
        int height = 6;
        Rectangle clipping = new Rectangle(barX, y, width, height);
        wtgo.fillRectangle(clipping, color);
    }

    @Override
    public int getRowHeight(IWTGraphicsObject wtgo, DataGrid dataGrid, Object[] row) {
        if (row[row.length - 1] instanceof MemoryData) {
            return wtgo.getFontHeight() + 10 + 6;
        }
        return wtgo.getFontHeight() + 2;
    }

    @Override
    public void paintCell(IWTGraphicsObject wtgo, DataGrid grid, Object data, Rectangle rectangle, int align, boolean highlight) {
        if (rectangle.height <= 0 || rectangle.width <= 0) {
            return;
        }
        if (data instanceof String) {
            this.paintText(wtgo, (String)data, rectangle, align, highlight, grid.isHeader());
        } else if (data instanceof Image) {
            wtgo.drawImage((Image)data, rectangle.x, rectangle.y);
        } else {
            this.paintBar(wtgo, (MemoryData)data, rectangle);
        }
    }

    private void paintBar(IWTGraphicsObject wtgo, MemoryData data, Rectangle bounds) {
        if (data == null || data.utilLevel == null) {
            return;
        }
        Point fontDim = wtgo.stringExtent("00000");
        int barX = bounds.x + fontDim.x / 2;
        int barY = bounds.y + 2;
        int width = bounds.width - fontDim.x;
        Color barColor = wtgo.getColor(16);
        this.drawBar(wtgo, barX, barY, width, barColor);
        Color fillColor = wtgo.getColor(data != null && data.isLimiter ? 4 : 15);
        int w = this.getUtilizationMarkOffset(data.utilLevel, width);
        this.fillBar(wtgo, barX, barY, w, fillColor);
        this.drawMarks(wtgo, barX, barY, width, barColor);
    }

    private void paintText(IWTGraphicsObject wtgo, String text, Rectangle bounds, int align, boolean highlight, boolean isHeader) {
        int x = Math.max(0, this.getTextX(wtgo, text, bounds, align, isHeader)) + bounds.x;
        int y = (bounds.height - wtgo.getFontHeight()) / 2 + bounds.y;
        Color c = wtgo.getForeground();
        if (highlight) {
            wtgo.setForeground(wtgo.getColor(4));
        }
        wtgo.drawString(text, x, y, true);
        wtgo.setForeground(c);
    }

    private int getTextX(IWTGraphicsObject wtgo, String text, Rectangle bounds, int align, boolean isHeader) {
        Point extent = wtgo.stringExtent(text);
        Point marginExtent = wtgo.stringExtent("X");
        switch (align & 0x1024000) {
            case 16384: {
                return 0;
            }
            case 131072: {
                return bounds.width - extent.x - marginExtent.x;
            }
        }
        return (bounds.width - extent.x) / 2;
    }

    public static class MemoryData {
        private final CuptiMetricValueUtilizationLevel utilLevel;
        private final boolean isLimiter;

        public MemoryData(CuptiMetricValueUtilizationLevel utilLevel, boolean isLimiter) {
            this.utilLevel = utilLevel;
            this.isLimiter = isLimiter;
        }

        public boolean isLimiter() {
            return this.isLimiter;
        }
    }
}

