/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class ViperObservables {
    protected static IRemoteConnection getConnection(final String connectionName) {
        try {
            return (IRemoteConnection)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, IRemoteConnection>(){

                public IRemoteConnection runWithService(IRemoteConnectionsService service) {
                    if (connectionName == null) {
                        IRemoteConnection[] connections;
                        IRemoteConnection[] iRemoteConnectionArray = connections = service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
                        int n = connections.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRemoteConnection connection = iRemoteConnectionArray[n2];
                            if (connection.isLocalSystem()) {
                                return connection;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    return service.getConnection(connectionName, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static IObservableValue observeConnection(IObservableValue executableHandle) {
        return new ConnectionObservable(executableHandle);
    }

    private static final class ConnectionObservable
    extends ComputedValue
    implements ISessionPropertyChangeListener {
        private IRemoteConnection connection = null;
        private Executable executable;
        private IObservableValue executableHandle;

        private ConnectionObservable(IObservableValue executableHandle) {
            this.executableHandle = executableHandle;
        }

        protected Object calculate() {
            Executable value = (Executable)this.executableHandle.getValue();
            if (!CoreUtil.equals((Object)this.executable, (Object)value)) {
                if (this.executable != null) {
                    this.executable.removePropertyChangeListener(this);
                }
                if (value != null) {
                    value.addPropertyChangeListener(this);
                }
                this.executable = value;
                if (this.executable != null) {
                    this.executable.setConnectionName(this.connection == null ? null : this.connection.getName());
                }
            }
            return this.executable == null ? null : ViperObservables.getConnection(this.executable.getConnectionName());
        }

        protected void doSetValue(Object value) {
            this.connection = (IRemoteConnection)value;
            if (this.executable != null) {
                this.executable.setConnectionName(this.connection == null ? null : this.connection.getName());
            }
        }

        public Object getValueType() {
            return IRemoteConnection.class;
        }

        @Override
        public void propertyChange(IModel model, String propertyName) {
            if ("exec:connectionname".equals(propertyName)) {
                this.makeDirty();
            }
        }
    }
}

