const char cgGLCylFragmentShader[] = 
"// this is the fragment program\n"
"\n"
"struct inputs\n"
"{\n"
"	float4 HPOS : POSITION;\n"
"	float4 texcoord : TEXCOORD0;\n"
"	float4 texcoord1 : TEXCOORD1;\n"
"	float4 texcoord2 : TEXCOORD2;\n"
"	float4 texcoord3 : TEXCOORD3;\n"
"	float4 primarycolor : COLOR0;\n"
"	float3 secondarycolor : COLOR1;\n"
"};\n"
"\n"
"float3 expand(float3 vector)\n"
"{\n"
"    return 2.0 * (vector - 0.5);\n"
"}\n"
"\n"
"// register combiner vector normalization function\n"
"float3 normalize(float3 vector)\n"
"{\n"
"    float3 VdotV = dot(expand(vector), expand(vector));\n"
"    return (1-saturate(VdotV)) * (vector-0.5) + expand(vector);\n"
"}\n"
"\n"
"float4 main(inputs IN, out float depth: DEPTH,\n"
"			uniform float4 maincolor,\n"
"			uniform sampler1D normalmap,\n"
"			uniform sampler2D depthmap) : COLOR\n"
"{\n"
"\n"
"	\n"
"	//float3 color = tex2D(alphamap, IN.texcoord.xy).xyz;\n"
"	float4 normal = 2.0 * (tex1D(normalmap, IN.texcoord.x) - 0.5);\n"
"\n"
"\n"
"	//float3 normal = (tex2D(normalmap, IN.texcoord1.xy)).rgb;\n"
"	\n"
"	//IN.secondarycolor.rgb = 2.0*(IN.secondarycolor.rgb-0.5);\n"
"	IN.secondarycolor.rgb = normalize(IN.secondarycolor.rgb);\n"
"\n"
"	float3 NdotL = dot(normal.rgb, IN.secondarycolor);\n"
"	float3 color = IN.primarycolor.rgb*(saturate(NdotL) + IN.primarycolor.w);\n"
"	//float3 diffuse = IN.col1.rgb;\n"
"	//float3 specular = (float3)lighting.a;\n"
"\n"
"    // calculate reflection vector\n"
"    // R = 2 * (N * (N dot L) - L/2)\n"
"    //   = 2 * N * (N dot L) - L\n"
"    float3 reflectVec = ((NdotL * normal.rgb) + (-0.5 * IN.secondarycolor)) * 2.0;\n"
"\n"
"    // eye vector E = (0, 0, 1)\n"
"    // R dot E = (R.r*0 + R.g*0 + 1*R.b) = R.b\n"
"    float RdotE = saturate(reflectVec.b);   // max(0, RdotE);\n"
"\n"
"    // calculate specular as pow(RdotE, 16)\n"
"	float specular = pow(RdotE, 16); \n"
"\n"
"    // add specular light contribution to final color\n"
"	color += specular;\n"
"    //finalColor += specular;\n"
"\n"
"\n"
"	//IN.color.rgb = IN.color.rgb * diffuse;// + specular;\n"
"	//IN.color.w = 1.0;\n"
"	\n"
"    float3 depthVal = tex2D(depthmap, IN.texcoord1.xy).rgb;\n"
"	// check with no extra depth to see whats being drawn.\n"
"	//depthVal.x = 0.0;\n"
"\n"
"    float z = dot(IN.texcoord2.xyz, depthVal);\n"
"    float w = dot(IN.texcoord3.xyz, depthVal);\n"
"    depth = (z / w);\n"
"\n"
"	float4 outcolor = float4(color, normal.w);\n"
"	return outcolor;\n"
"}\n";

