/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class COCMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int n) throws IOException {
        int n2 = this.nCompBytes();
        if (n2 == 0) {
            this._repInfo.setMessage((Message)new ErrorMessage("COC marker segment at wrong position in codestream"));
            return false;
        }
        int n3 = n2 < 257 ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module) : this._module.readUnsignedShort(this._dstream);
        int n4 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int n5 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int n6 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int n7 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int n8 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int n9 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int[] nArray = null;
        if ((n4 & 1) != 0) {
            nArray = new int[n5 + 1];
            for (int i = 0; i < n5 + 1; ++i) {
                nArray[i] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            }
        }
        MainOrTile mainOrTile = this.getMainOrTile();
        ArrayList<Property> arrayList = new ArrayList<Property>(10);
        arrayList.add(new Property("CodingStyle", PropertyType.INTEGER, (Object)new Integer(n4)));
        arrayList.add(new Property("NumberDecompositionLevels", PropertyType.INTEGER, (Object)new Integer(n5)));
        arrayList.add(new Property("CodeBlockWidth", PropertyType.INTEGER, (Object)new Integer(n6)));
        arrayList.add(new Property("CodeBlockHeight", PropertyType.INTEGER, (Object)new Integer(n7)));
        arrayList.add(new Property("CodeBlockStyle", PropertyType.INTEGER, (Object)new Integer(n8)));
        arrayList.add(new Property("Transformation", PropertyType.INTEGER, (Object)new Integer(n9)));
        arrayList.add(new Property("PrecinctSize", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray));
        mainOrTile.setCompProperty(n3, new Property("COC", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

