/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefsWindow
extends JDialog {
    private JhoveWindow jhoveWin;
    private JCheckBox rawCheckBox;
    private JCheckBox checksumCheckBox;
    private boolean saveRawOutput;
    private boolean saveChecksum;

    public PrefsWindow(JhoveWindow jhoveWindow) {
        super(jhoveWindow, "Jhove Preferences", true);
        this.addWindowListener(new PrefsWindowListener(this));
        this.jhoveWin = jhoveWindow;
        JPanel jPanel = new JPanel(new GridLayout(4, 1));
        this.getContentPane().add((Component)jPanel, "Center");
        this.rawCheckBox = new JCheckBox("Raw data", false);
        jPanel.add(this.rawCheckBox);
        this.checksumCheckBox = new JCheckBox("Calculate checksums", false);
        jPanel.add(this.checksumCheckBox);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        this.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsWindow.this.setPrefsFromDialog();
                PrefsWindow.this.hide();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsWindow.this.hide();
                PrefsWindow.this.restore();
            }
        });
        jPanel2.add(new JLabel(""));
        jPanel2.add(jButton2);
        jPanel2.add(jButton);
    }

    public void saveAndShow() {
        this.saveRawOutput = this.rawCheckBox.isSelected();
        this.saveChecksum = this.checksumCheckBox.isSelected();
        this.show();
    }

    private void restore() {
        this.rawCheckBox.setSelected(this.saveRawOutput);
        this.checksumCheckBox.setSelected(this.saveChecksum);
    }

    private void setPrefsFromDialog() {
        this.jhoveWin.setRawOutput(this.rawCheckBox.isSelected());
        this.jhoveWin.setDoChecksum(this.checksumCheckBox.isSelected());
    }

    private class PrefsWindowListener
    extends WindowAdapter {
        private PrefsWindow prefsWin;

        public PrefsWindowListener(PrefsWindow prefsWindow2) {
            this.prefsWin = prefsWindow2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.prefsWin.restore();
        }
    }
}

