/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.analysis.directed.InsertSizeMetricsCollector;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Reads a SAM or BAM file and writes a file containing metrics about the statistical distribution of insert size (excluding duplicates) and generates a Histogram plot.", usageShort="Writes insert size distribution metrics for a SAM or BAM file", programGroup=Metrics.class)
public class CollectInsertSizeMetrics
extends SinglePassSamProgram {
    private static final Log log = Log.getInstance(CollectInsertSizeMetrics.class);
    private static final String Histogram_R_SCRIPT = "picard/analysis/insertSizeHistogram.R";
    @Option(shortName="H", doc="File to write insert size Histogram chart to.")
    public File Histogram_FILE;
    @Option(doc="Generate mean, sd and plots by trimming the data down to MEDIAN + DEVIATIONS*MEDIAN_ABSOLUTE_DEVIATION. This is done because insert size data typically includes enough anomalous values from chimeras and other artifacts to make the mean and sd grossly misleading regarding the real distribution.")
    public double DEVIATIONS = 10.0;
    @Option(shortName="W", doc="Explicitly sets the Histogram width, overriding automatic truncation of Histogram tail. Also, when calculating mean and standard deviation, only bins <= Histogram_WIDTH will be included.", optional=true)
    public Integer Histogram_WIDTH = null;
    @Option(shortName="M", doc="When generating the Histogram, discard any data categories (out of FR, TANDEM, RF) that have fewer than this percentage of overall reads. (Range: 0 to 1).")
    public float MINIMUM_PCT = 0.05f;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    private InsertSizeMetricsCollector multiCollector;

    public static void main(String[] argv) {
        new CollectInsertSizeMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MINIMUM_PCT < 0.0f || (double)this.MINIMUM_PCT > 0.5) {
            return new String[]{"MINIMUM_PCT was set to " + this.MINIMUM_PCT + ". It must be between 0 and 0.5 so all data categories don't get discarded."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.Histogram_FILE);
        this.multiCollector = new InsertSizeMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, header.getReadGroups(), this.MINIMUM_PCT, this.Histogram_WIDTH, this.DEVIATIONS);
    }

    @Override
    protected void acceptRead(SAMRecord record, ReferenceSequence ref) {
        this.multiCollector.acceptRecord(record, ref);
    }

    @Override
    protected void finish() {
        this.multiCollector.finish();
        MetricsFile file = this.getMetricsFile();
        this.multiCollector.addAllLevelsToFile(file);
        if (file.getNumHistograms() == 0) {
            log.warn(new Object[]{"All data categories were discarded because they contained < " + this.MINIMUM_PCT + " of the total aligned paired data."});
            InsertSizeMetricsCollector.PerUnitInsertSizeMetricsCollector allReadsCollector = (InsertSizeMetricsCollector.PerUnitInsertSizeMetricsCollector)this.multiCollector.getAllReadsCollector();
            log.warn(new Object[]{"Total mapped pairs in all categories: " + (allReadsCollector == null ? allReadsCollector : Double.valueOf(allReadsCollector.getTotalInserts()))});
        } else {
            file.write(this.OUTPUT);
            int rResult = this.Histogram_WIDTH == null ? RExecutor.executeFromClasspath(Histogram_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.Histogram_FILE.getAbsolutePath(), this.INPUT.getName()) : RExecutor.executeFromClasspath(Histogram_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.Histogram_FILE.getAbsolutePath(), this.INPUT.getName(), String.valueOf(this.Histogram_WIDTH));
            if (rResult != 0) {
                throw new PicardException("R script picard/analysis/insertSizeHistogram.R failed with return code " + rResult);
            }
        }
    }
}

