/*++

Copyright (c) 2004 - 2010, Intel Corporation. All rights reserved.<BR>
This program and the accompanying materials                          
are licensed and made available under the terms and conditions of the BSD License         
which accompanies this distribution.  The full text of the license may be found at        
http://opensource.org/licenses/bsd-license.php                                            
                                                                                          
THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,                     
WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.             

Module Name:
  
  BsSerialStatusCode.c
   
Abstract:

  Lib to provide Serial I/O status code reporting Routines.

--*/

#include "BsSerialStatusCode.h"

//
// All of the lookup tables are only needed in debug.
//
#ifdef EFI_DEBUG

typedef struct {
  UINT32  Value;
  CHAR8   *Token;
} STATUS_CODE_LOOKUP_TABLE;

STATUS_CODE_LOOKUP_TABLE  mSeverityToken[] = {
  {
    EFI_ERROR_MINOR,
    "ERROR_MINOR"
  },
  {
    EFI_ERROR_MAJOR,
    "ERROR_MAJOR"
  },
  {
    EFI_ERROR_UNRECOVERED,
    "ERROR_UNRECOVERED"
  },
  {
    EFI_ERROR_UNCONTAINED,
    "ERROR_UNCONTAINED"
  },
  {
    0xFFFFFFFF,
    "ERROR_UNRECOGNIZED"
  }
};
STATUS_CODE_LOOKUP_TABLE  mClassSubClassToken[] = {
  {
    EFI_COMPUTING_UNIT_UNSPECIFIED,
    "COMPUTING_UNIT_UNSPECIFIED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR,
    "COMPUTING_UNIT_HOST_PROCESSOR"
  },
  {
    EFI_COMPUTING_UNIT_FIRMWARE_PROCESSOR,
    "COMPUTING_UNIT_FIRMWARE_PROCESSOR"
  },
  {
    EFI_COMPUTING_UNIT_IO_PROCESSOR,
    "COMPUTING_UNIT_IO_PROCESSOR"
  },
  {
    EFI_COMPUTING_UNIT_CACHE,
    "COMPUTING_UNIT_CACHE"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY,
    "COMPUTING_UNIT_MEMORY"
  },
  {
    EFI_COMPUTING_UNIT_CHIPSET,
    "COMPUTING_UNIT_CHIPSET"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED,
    "PERIPHERAL_UNSPECIFIED"
  },
  {
    EFI_PERIPHERAL_KEYBOARD,
    "PERIPHERAL_KEYBOARD"
  },
  {
    EFI_PERIPHERAL_MOUSE,
    "PERIPHERAL_MOUSE"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE,
    "PERIPHERAL_LOCAL_CONSOLE"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE,
    "PERIPHERAL_REMOTE_CONSOLE"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT,
    "PERIPHERAL_SERIAL_PORT"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT,
    "PERIPHERAL_PARALLEL_PORT"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA,
    "PERIPHERAL_FIXED_MEDIA"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA,
    "PERIPHERAL_REMOVABLE_MEDIA"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT,
    "PERIPHERAL_AUDIO_INPUT"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT,
    "PERIPHERAL_AUDIO_OUTPUT"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE,
    "PERIPHERAL_LCD_DEVICE"
  },
  {
    EFI_IO_BUS_UNSPECIFIED,
    "IO_BUS_UNSPECIFIED"
  },
  {
    EFI_IO_BUS_PCI,
    "IO_BUS_PCI"
  },
  {
    EFI_IO_BUS_USB,
    "IO_BUS_USB"
  },
  {
    EFI_IO_BUS_IBA,
    "IO_BUS_IBA"
  },
  {
    EFI_IO_BUS_AGP,
    "IO_BUS_AGP"
  },
  {
    EFI_IO_BUS_PC_CARD,
    "IO_BUS_PC_CARD"
  },
  {
    EFI_IO_BUS_LPC,
    "IO_BUS_LPC"
  },
  {
    EFI_IO_BUS_SCSI,
    "IO_BUS_SCSI"
  },
  {
    EFI_IO_BUS_ATA_ATAPI,
    "IO_BUS_ATA_ATAPI"
  },
  {
    EFI_IO_BUS_FC,
    "IO_BUS_FC"
  },
  {
    EFI_IO_BUS_IP_NETWORK,
    "IO_BUS_IP_NETWORK"
  },
  {
    EFI_IO_BUS_SMBUS,
    "IO_BUS_SMBUS"
  },
  {
    EFI_IO_BUS_I2C,
    "IO_BUS_I2C"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED,
    "SOFTWARE_UNSPECIFIED"
  },
  {
    EFI_SOFTWARE_SEC,
    "SOFTWARE_EFI_SEC"
  },
  {
    EFI_SOFTWARE_PEI_CORE,
    "SOFTWARE_EFI_PEI_CORE"
  },
  {
    EFI_SOFTWARE_PEI_MODULE,
    "SOFTWARE_EFI_PEI_MODULE"
  },
  {
    EFI_SOFTWARE_DXE_CORE,
    "SOFTWARE_EFI_DXE_CORE"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE,
    "SOFTWARE_EFI_BOOT_SERVICE"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE,
    "SOFTWARE_EFI_RUNTIME_SERVICE"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER,
    "SOFTWARE_DXE_BS_DRIVER"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER,
    "SOFTWARE_DXE_RT_DRIVER"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER,
    "SOFTWARE_SMM_DRIVER"
  },
  {
    EFI_SOFTWARE_RT,
    "SOFTWARE_RT"
  },
  {
    EFI_SOFTWARE_AL,
    "SOFTWARE_AL"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION,
    "SOFTWARE_EFI_APPLICATION"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER,
    "SOFTWARE_EFI_OS_LOADER"
  },
  {
    0xFFFFFFFF,
    "ERROR_UNRECOGNIZED"
  }
};

STATUS_CODE_LOOKUP_TABLE  mOperationToken[] = {
  {
    EFI_COMPUTING_UNIT_UNSPECIFIED | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_UNSPECIFIED | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_UNSPECIFIED | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_UNSPECIFIED | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_UNSPECIFIED | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_INVALID_TYPE,
    "INVALID_TYPE"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_INVALID_SPEED,
    "INVALID_SPEED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_MISMATCH,
    "MISMATCH"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_TIMER_EXPIRED,
    "TIMER_EXPIRED"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_SELF_TEST,
    "SELF_TEST"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_INTERNAL,
    "INTERNAL"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_THERMAL,
    "THERMAL"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_LOW_VOLTAGE,
    "LOW_VOLTAGE"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_HIGH_VOLTAGE,
    "HIGH_VOLTAGE"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_CACHE,
    "CACHE"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_MICROCODE_UPDATE,
    "MICROCODE_UPDATE"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_NO_MICROCODE_UPDATE,
    "NO_MICROCODE_UPDATE"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_CORRECTABLE,
    "1XECC"
  },
  {
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_EC_UNCORRECTABLE,
    "2XECC"
  },
  {
    EFI_COMPUTING_UNIT_FIRMWARE_PROCESSOR | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_FIRMWARE_PROCESSOR | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_FIRMWARE_PROCESSOR | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_FIRMWARE_PROCESSOR | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_FIRMWARE_PROCESSOR | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_COMPUTING_UNIT_IO_PROCESSOR | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_IO_PROCESSOR | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_IO_PROCESSOR | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_IO_PROCESSOR | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_IO_PROCESSOR | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_CACHE_EC_INVALID_TYPE,
    "INVALID_TYPE"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_CACHE_EC_INVALID_SPEED,
    "INVALID_SPEED"
  },
  {
    EFI_COMPUTING_UNIT_CACHE | EFI_CU_CACHE_EC_INVALID_SIZE,
    "INVALID_SIZE"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_INVALID_TYPE,
    "INVALID_TYPE"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_INVALID_SPEED,
    "INVALID_SPEED"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_CORRECTABLE,
    "1XECC"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_UNCORRECTABLE,
    "2XECC"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_SPD_FAIL,
    "SPD_FAIL"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_INVALID_SIZE,
    "INVALID_SIZE"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_MISMATCH,
    "MISMATCH"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_S3_RESUME_FAIL,
    "S3_RESUME_FAIL"
  },
  {
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_UPDATE_FAIL,
    "UPDATE_FAIL"
  },
  {
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_UNSPECIFIED | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_KEYBOARD_EC_LOCKED,
    "LOCKED"
  },
  {
    EFI_PERIPHERAL_KEYBOARD | EFI_P_KEYBOARD_EC_STUCK_KEY,
    "STUCK_KEY"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_MOUSE | EFI_P_MOUSE_EC_LOCKED,
    "LOCKED"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOTE_CONSOLE | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_SERIAL_PORT | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_PARALLEL_PORT | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_INPUT | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_AUDIO_OUTPUT | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_INPUT_ERROR,
    "INPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_OUTPUT_ERROR,
    "OUTPUT_ERROR"
  },
  {
    EFI_PERIPHERAL_LCD_DEVICE | EFI_P_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_UNSPECIFIED | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_PCI_EC_PERR,
    "PERR"
  },
  {
    EFI_IO_BUS_PCI | EFI_IOB_PCI_EC_SERR,
    "SERR"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_USB | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_IBA | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_AGP | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_PC_CARD | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_LPC | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_SCSI | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_ATA_ATAPI | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_FC | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_IP_NETWORK | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_SMBUS | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_DISABLED,
    "DISABLED"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_NOT_SUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_NOT_DETECTED,
    "NOT_DETECTED"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_NOT_CONFIGURED,
    "NOT_CONFIGURED"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_INTERFACE_ERROR,
    "INTERFACE_ERROR"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_CONTROLLER_ERROR,
    "CONTROLLER_ERROR"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_READ_ERROR,
    "READ_ERROR"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_WRITE_ERROR,
    "WRITE_ERROR"
  },
  {
    EFI_IO_BUS_I2C | EFI_IOB_EC_RESOURCE_CONFLICT,
    "RESOURCE_CONFLICT"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_UNSPECIFIED | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_SEC | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_PEI_CORE | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_DXE_CORE | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_BOOT_SERVICE | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_RUNTIME_SERVICE | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_DXE_RT_DRIVER | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_SMM_DRIVER | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_RT | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_AL | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_APPLICATION | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_NON_SPECIFIC,
    "NON_SPECIFIC"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_LOAD_ERROR,
    "LOAD_ERROR"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_INVALID_PARAMETER,
    "INVALID_PARAMETER"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_UNSUPPORTED,
    "NOT_SUPPORTED"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_INVALID_BUFFER,
    "INVALID_BUFFER"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_OUT_OF_RESOURCES,
    "OUT_OF_RESOURCES"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_ABORTED,
    "ABORTED"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_ILLEGAL_SOFTWARE_STATE,
    "ILLEGAL_SOFTWARE_STATE"
  },
  {
    EFI_SOFTWARE_EFI_OS_LOADER | EFI_SW_EC_ILLEGAL_HARDWARE_STATE,
    "ILLEGAL_HARDWARE_STATE"
  },
  {
    0xFFFFFFFF,
    "ERROR_UNRECOGNIZED"
  }
};

#endif
//
// Private function declarations
//
//
// Match is only needed for debug.
//
#ifdef EFI_DEBUG

EFI_STATUS
EFIAPI
MatchString (
  IN  STATUS_CODE_LOOKUP_TABLE  *Table,
  IN  UINT32                    Value,
  OUT CHAR8                     **Token
  );
#endif
//
// Function implemenations
//
//
// Match is only needed for debug.
//
#ifdef EFI_DEBUG

EFI_STATUS
EFIAPI
MatchString (
  IN  STATUS_CODE_LOOKUP_TABLE  *Table,
  IN  UINT32                    Value,
  OUT CHAR8                     **Token
  )
/*++

Routine Description: 

  Search the input table for a matching value and return the token associated
  with that value.  Well formed tables will have the last value == 0 and will 
  return a default token.

Arguments:  

  Table     Pointer to first entry in an array of table entries.
  Value     Value to look up.
  Token     String to return.

Returns:  

  EFI_SUCCESS   The function always returns success.

--*/
{
  UINTN Current;

  ASSERT (Table != NULL);
  ASSERT (Token != NULL);

  Current = 0;
  *Token  = 0;

  while (!*Token) {
    //
    // Found token if values match or current entry is the last entry.
    //
    if ((Table[Current].Value == (-1)) || (Table[Current].Value == Value)) {
      *Token = Table[Current].Token;
    }

    Current++;
  }

  return EFI_SUCCESS;
}
#endif

VOID
EFIAPI
BsSerialInitializeStatusCode (
  IN EFI_HANDLE         ImageHandle,
  IN EFI_SYSTEM_TABLE   *SystemTable
  )
/*++

Routine Description:

  Initialize Serial Port

    The Baud Rate Divisor registers are programmed and the LCR 
    is used to configure the communications format. Hard coded
    UART config comes from globals in DebugSerialPlatform lib.

Arguments: 

  Unused

Returns: 

  None

--*/
{
  UINTN Divisor;
  UINT8 OutputData;
  UINT8 Data;

  //
  // Some init is done by the platform status code initialization.
  //
  //
  // Map 5..8 to 0..3
  //
  Data = (UINT8) (gData - (UINT8) 5);

  //
  // Calculate divisor for baud generator
  //
  Divisor = 115200 / gBps;

  //
  // Set communications format
  //
  OutputData = (UINT8) ((DLAB << 7) | ((gBreakSet << 6) | ((gParity << 3) | ((gStop << 2) | Data))));
  IoWrite8 (gComBase + LCR_OFFSET, OutputData);

  //
  // Configure baud rate
  //
  IoWrite8 (gComBase + BAUD_HIGH_OFFSET, (UINT8) (Divisor >> 8));
  IoWrite8 (gComBase + BAUD_LOW_OFFSET, (UINT8) (Divisor & 0xff));

  //
  // Switch back to bank 0
  //
  OutputData = (UINT8) ((~DLAB << 7) | ((gBreakSet << 6) | ((gParity << 3) | ((gStop << 2) | Data))));
  IoWrite8 (gComBase + LCR_OFFSET, OutputData);
}

VOID
DebugSerialWrite (
  IN UINT8  Character
  )
/*++

Routine Description:

 DebugSerialWrite - Outputs a character to the Serial port

  Repeatedly polls the TXRDY bit of the Line Status Register
  until the Transmitter Holding Register is empty.  The character
  is then written to the Serial port.

Arguments:

  Character   - Character to write

Returns:

  None

--*/
{
  UINT8 Data;

  //
  // Wait for the serail port to be ready.
  //
  do {
    Data = IoRead8 (gComBase + LSR_OFFSET);
  } while ((Data & LSR_TXRDY) == 0);

  IoWrite8 (gComBase, Character);
#ifdef SERIAL_OUTPUT_STALL
  EfiStall (SERIAL_OUTPUT_STALL);
#endif
}

VOID
DebugSerialPrint (
  IN UINT8    *OutputString
  )
/*++

Routine Description:

  Prints a string to the Serial port

Arguments:

  OutputString - Ascii string to print to serial port.

Returns:

  None

--*/
{
  EFI_STATUS  Status;

  Status = EFI_SUCCESS;

  for (; *OutputString != 0; OutputString++) {
    DebugSerialWrite (*OutputString);
  }
}

EFI_STATUS
EFIAPI
BsSerialReportStatusCode (
  IN EFI_STATUS_CODE_TYPE     CodeType,
  IN EFI_STATUS_CODE_VALUE    Value,
  IN UINT32                   Instance,
  IN EFI_GUID                 * CallerId,
  IN EFI_STATUS_CODE_DATA     * Data OPTIONAL
  )
/*++

Routine Description:

  Provide a serial port print

Arguments:

    
Returns:

  Status -  EFI_SUCCESS if the interface could be successfully
            installed

--*/
{
  CHAR8   Buffer[EFI_STATUS_CODE_DATA_MAX_SIZE * 3];
  UINT32  LineNumber;
  CHAR8   *Filename;
  CHAR8   *Description;
  CHAR8   *Format;
  VA_LIST Marker;
  UINT32  ErrorLevel;
  UINTN   CharCount;

  Buffer[0] = '\0';

  if (ReportStatusCodeExtractAssertInfo (CodeType, Value, Data, &Filename, &Description, &LineNumber)) {
    //
    // Processes ASSERT ()
    //
    ASPrint (
      Buffer,
      EFI_STATUS_CODE_DATA_MAX_SIZE,
      "\nDXE_ASSERT!: %a (%d): %a\n",
      Filename,
      LineNumber,
      Description
      );

  } else if (ReportStatusCodeExtractDebugInfo (Data, &ErrorLevel, &Marker, &Format)) {
    //
    // Process DEBUG () macro to Serial
    //
    AvSPrint (Buffer, EFI_STATUS_CODE_DATA_MAX_SIZE, Format, Marker);

  } else if ((CodeType & EFI_STATUS_CODE_TYPE_MASK) == EFI_ERROR_CODE) {
    //
    // Process Errors
    //
    CharCount = ASPrint (Buffer, EFI_STATUS_CODE_DATA_MAX_SIZE, "ERROR: C%x:V%x I%x", CodeType, Value, Instance);
    //
    // Make sure we don't try to print values that weren't intended to be printed, especially NULL GUID pointers.
    //
    if (CallerId) {
      CharCount += ASPrint (
                    &Buffer[CharCount - 1],
                    (EFI_STATUS_CODE_DATA_MAX_SIZE - (sizeof (Buffer[0]) * CharCount)),
                    " %g",
                    CallerId
                    );
    }

    if (Data) {
      CharCount += ASPrint (
                    &Buffer[CharCount - 1],
                    (EFI_STATUS_CODE_DATA_MAX_SIZE - (sizeof (Buffer[0]) * CharCount)),
                    " %x",
                    Data
                    );
    }

    CharCount += ASPrint (
                  &Buffer[CharCount - 1],
                  (EFI_STATUS_CODE_DATA_MAX_SIZE - (sizeof (Buffer[0]) * CharCount)),
                  "\n"
                  );

  }

  if (Buffer[0] != '\0') {
    //
    // Callout to platform Lib function to do print.
    //
    DebugSerialPrint ((UINT8 *) Buffer);
  }
  //
  // Debug code to display human readable code information.
  //
#ifdef EFI_DEBUG
  {
    CHAR8 *SeverityToken;
    CHAR8 *SubClassToken;
    CHAR8 *OperationToken;

    if ((CodeType & EFI_STATUS_CODE_TYPE_MASK) == EFI_ERROR_CODE) {
      //
      // Get the severity token
      //
      MatchString (
        mSeverityToken,
        (CodeType & EFI_STATUS_CODE_SEVERITY_MASK),
        &SeverityToken
        );

      //
      // Get the Class/SubClass token
      //
      MatchString (
        mClassSubClassToken,
        (Value & (EFI_STATUS_CODE_CLASS_MASK | EFI_STATUS_CODE_SUBCLASS_MASK)),
        &SubClassToken
        );

      //
      // Get the operation token
      //
      MatchString (
        mOperationToken,
        (Value & (EFI_STATUS_CODE_CLASS_MASK | EFI_STATUS_CODE_SUBCLASS_MASK | EFI_STATUS_CODE_OPERATION_MASK)),
        &OperationToken
        );

      //
      // Concatenate the instance
      //
      ASPrint (
        Buffer,
        EFI_STATUS_CODE_DATA_MAX_SIZE,
        "%a:%a:%a:%d\n",
        SeverityToken,
        SubClassToken,
        OperationToken,
        Instance
        );

      DebugSerialPrint ((UINT8 *) Buffer);
    }
  }
#endif

  return EFI_SUCCESS;
}
