/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_SC.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgScanCounter(struct Cfg_Getopt * const optstru, int * const num);

 *	Interprete a counter value
 *	As optGetCounter(), but if not argument is given the boolean flags
 *	are evaluated:
 *	* "+" --> set to one (set)
 *	* "-" --> set to zero (clear)
 *	* none --> inc
 *	Return:
 *		0: success, *num changed
 *		1: failed, *num not changed
  
ob(ject): cfgScanCounter
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Perform a counter option
he(ader files): 
lo(ng description): Check if the current option is a counter.
	If so, the \para{*num} value is modified according the rules.
pr(erequistes): 
va(lue): 0: success \item 1: no failure
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_sc.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <limits.h>
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_SC.C 1.4 1999/12/13 02:22:06 ska Exp ska $";
#endif

int cfgScanCounter(struct Cfg_Getopt * const optstru, int * const num)
{	int n, err;

	DBG_ENTER("cfgScanCounter", Suppl_cmdline)

	assert(optstru);

	n = *num;
	switch(err = cfgGetCounter(optstru, &n)) {
	case 1:		/* no argument at all */
		switch(optHasBool()) {
		case '+': /* set to one */
			*num = 1;
			DBG_RETURN_I( 0)
		case '-': /* clear to zero */
			*num = 0;
			DBG_RETURN_I( 0)
		}
		/* none --> increment */
		++*num;
		DBG_RETURN_I( 0)

	case 0:		/* OK */
		*num = n;
		DBG_RETURN_I( 0)
	}

	DBG_RETURN_I( err)
}
