/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PDS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushDynString(struct Cfg_Getopt *optstru, char *string)

 *	Push a dynamically allocted string, which is not preprocessed in
 *	any way. The string is free()'ed as soon as the input stream is poped.
 
ob(ject): cfgPushDynString
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Push a dynamically allocated string
he(ader files): 
lo(ng description): Push a dynamically allocated string onto the input
	stack. The string is freed automatically, when the input stack
	item is closed.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pds.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PDS.C 1.4 1999/12/13 02:22:02 ska Exp ska $";
#endif

void cfgPushDynString(struct Cfg_Getopt * const optstru
 , const char * const string)
{	struct Cfg_ArgDynString *p;

	DBG_ENTER("cfgPushDynString", Suppl_cmdline)

	if(string) {
		chkHeap
		p = Emalloc(sizeof(struct Cfg_ArgDynString));
		p->cfg_a_p = p->cfg_a_string = string;
		cfg_addContext(optstru, (void*)p, aF(cfg_rdDynString)
		 , aF(cfg_clDynString));
	}

	chkHeap
	DBG_EXIT
}
