/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared.impl;

import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.impl.AutoBeanCodexImpl;
import com.google.web.bindery.autobean.shared.impl.HasSplittable;
import com.google.web.bindery.autobean.shared.impl.SplittableList;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittableComplexMap<K, V>
implements Map<K, V>,
HasSplittable {
    private final Splittable data;
    private final List<K> keys;
    private final List<V> values;

    public SplittableComplexMap(Splittable data, AutoBeanCodexImpl.Coder keyCoder, AutoBeanCodexImpl.Coder valueCoder, AutoBeanCodexImpl.EncodeState state) {
        this.data = data;
        this.keys = new SplittableList<K>(data.get(0), keyCoder, state);
        this.values = new SplittableList<V>(data.get(1), valueCoder, state);
        assert (this.keys.size() == this.values.size());
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<K> keyIt;
                    ListIterator<V> valueIt;
                    {
                        this.keyIt = SplittableComplexMap.this.keys.iterator();
                        this.valueIt = SplittableComplexMap.this.values.listIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        assert (this.keyIt.hasNext() == this.valueIt.hasNext());
                        return this.keyIt.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new Map.Entry<K, V>(){
                            final K key;
                            final V value;
                            {
                                this.key = keyIt.next();
                                this.value = valueIt.next();
                            }

                            @Override
                            public K getKey() {
                                return this.key;
                            }

                            @Override
                            public V getValue() {
                                return this.value;
                            }

                            @Override
                            public V setValue(V value) {
                                valueIt.set(value);
                                return value;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.keyIt.remove();
                        this.valueIt.remove();
                    }
                };
            }

            @Override
            public int size() {
                return SplittableComplexMap.this.keys.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        int idx = this.keys.indexOf(key);
        if (idx == -1) {
            return null;
        }
        return this.values.get(idx);
    }

    @Override
    public Splittable getSplittable() {
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return SplittableComplexMap.this.keys.iterator();
            }

            @Override
            public int size() {
                return SplittableComplexMap.this.keys.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        int idx = this.keys.indexOf(key);
        if (idx == -1) {
            this.keys.add(key);
            this.values.add(value);
            return null;
        }
        return this.values.set(idx, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int idx = this.keys.indexOf(key);
        if (idx == -1) {
            return null;
        }
        this.keys.remove(idx);
        return this.values.remove(idx);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final Iterator<K> keyIt;
                    final Iterator<V> valueIt;
                    {
                        this.keyIt = SplittableComplexMap.this.keys.iterator();
                        this.valueIt = SplittableComplexMap.this.values.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIt.hasNext();
                    }

                    @Override
                    public V next() {
                        this.keyIt.next();
                        return this.valueIt.next();
                    }

                    @Override
                    public void remove() {
                        this.keyIt.remove();
                        this.valueIt.remove();
                    }
                };
            }

            @Override
            public int size() {
                return SplittableComplexMap.this.keys.size();
            }
        };
    }
}

