// GENERATED FILE - DO NOT EDIT.
// Generated by gen_wgpu_format_table.py using data from wgpu_format_map.json
//
// Copyright 2024 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// wgpu_format_table_autogen.cpp:
//   Queries for full WebGPU format information based on GL format.

#include "libANGLE/renderer/wgpu/wgpu_format_utils.h"

#include "image_util/loadimage.h"

using namespace angle;

namespace rx
{
namespace webgpu
{

void Format::initialize(const angle::Format &angleFormat)
{
    switch (angleFormat.id)
    {
        case angle::FormatID::A16_FLOAT:
            mIntendedGLFormat         = GL_ALPHA16F_EXT;
            mActualImageFormatID      = angle::FormatID::R16_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::A1R5G5B5_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::A2R10G10B10_SINT_VERTEX:
            mIntendedGLFormat             = GL_INT_10_10_10_2_OES;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SINT;
            mVertexLoadFunction           = CopyW2XYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::A2R10G10B10_SNORM_VERTEX:
            mIntendedGLFormat             = GL_A2_RGB10_SNORM_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = false;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SNORM;
            mVertexLoadFunction           = CopyW2XYZ10ToXYZWFloatVertexData<true, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::A2R10G10B10_SSCALED_VERTEX:
            mIntendedGLFormat             = GL_A2_RGB10_SSCALED_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyW2XYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::A2R10G10B10_UINT_VERTEX:
            mIntendedGLFormat             = GL_UNSIGNED_INT_10_10_10_2_OES;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_UINT;
            mVertexLoadFunction           = CopyW2XYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::A2R10G10B10_UNORM_VERTEX:
            mIntendedGLFormat             = GL_A2_RGB10_UNORM_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyW2XYZ10ToXYZWFloatVertexData<false, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::A2R10G10B10_USCALED_VERTEX:
            mIntendedGLFormat             = GL_A2_RGB10_USCALED_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyW2XYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::A32_FLOAT:
            mIntendedGLFormat         = GL_ALPHA32F_EXT;
            mActualImageFormatID      = angle::FormatID::R32_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::A8_UNORM:
            mIntendedGLFormat         = GL_ALPHA8_EXT;
            mActualImageFormatID      = angle::FormatID::R8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ASTC_10x10_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x10_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x10_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x10_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x6_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x6_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x6_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x6_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x8_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x8_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_10x8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_12x10_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x10_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_12x10_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_12x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x10_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_12x12_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x12_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_12x12_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_12x12_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x12_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_3x3x3_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_3x3x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_4x3x3_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_4x3x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_4x4_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_4x4_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_4x4_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_4x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_4x4_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_4x4x3_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_4x4x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_4x4x4_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_4x4x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_5x4_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x4_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_5x4_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_5x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x4_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_5x4x4_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_5x4x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_5x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_5x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_5x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_5x5x4_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_5x5x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_5x5x5_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_5x5x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_6x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_6x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_6x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_6x5x5_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_6x5x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_6x6_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x6_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_6x6_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_6x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x6_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_6x6x5_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_6x6x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_6x6x6_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_6x6x6_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ASTC_8x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_8x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_8x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_8x6_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x6_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_8x6_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_8x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x6_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_8x8_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x8_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ASTC_8x8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_8x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::B10G10R10A2_UNORM:
            mIntendedGLFormat         = GL_BGR10_A2_ANGLEX;
            mActualImageFormatID      = angle::FormatID::R10G10B10A2_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::B4G4R4A4_UNORM:
            mIntendedGLFormat         = GL_BGRA4_ANGLEX;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::B5G5R5A1_UNORM:
            mIntendedGLFormat         = GL_BGR5_A1_ANGLEX;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::B5G6R5_UNORM:
            mIntendedGLFormat         = GL_BGR565_ANGLEX;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::B8G8R8A8_TYPELESS:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::B8G8R8A8_TYPELESS_SRGB:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::B8G8R8A8_UNORM:
            mIntendedGLFormat         = GL_BGRA8_EXT;
            mActualImageFormatID      = angle::FormatID::B8G8R8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::B8G8R8A8_UNORM_SRGB:
            mIntendedGLFormat = GL_BGRA8_SRGB_ANGLEX;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::B8G8R8A8_UNORM_SRGB, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::B8G8R8X8_UNORM:
            mIntendedGLFormat             = GL_BGRX8_ANGLEX;
            mActualImageFormatID          = angle::FormatID::B8G8R8A8_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::B8G8R8X8_UNORM_SRGB:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::BC1_RGBA_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGBA_S3TC_DXT1_EXT;
            mActualImageFormatID      = angle::FormatID::BC1_RGBA_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
            mActualImageFormatID      = angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC1_RGB_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::BC2_RGBA_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE;
            mActualImageFormatID      = angle::FormatID::BC2_RGBA_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
            mActualImageFormatID      = angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC3_RGBA_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE;
            mActualImageFormatID      = angle::FormatID::BC3_RGBA_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
            mActualImageFormatID      = angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC4_RED_SNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SIGNED_RED_RGTC1_EXT;
            mActualImageFormatID      = angle::FormatID::BC4_RED_SNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = false;

            break;

        case angle::FormatID::BC4_RED_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RED_RGTC1_EXT;
            mActualImageFormatID      = angle::FormatID::BC4_RED_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC5_RG_SNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT;
            mActualImageFormatID      = angle::FormatID::BC5_RG_SNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = false;

            break;

        case angle::FormatID::BC5_RG_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RED_GREEN_RGTC2_EXT;
            mActualImageFormatID      = angle::FormatID::BC5_RG_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC6H_RGB_SFLOAT_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;
            mActualImageFormatID      = angle::FormatID::BC6H_RGB_SFLOAT_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC6H_RGB_UFLOAT_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT;
            mActualImageFormatID      = angle::FormatID::BC6H_RGB_UFLOAT_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC7_RGBA_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGBA_BPTC_UNORM_EXT;
            mActualImageFormatID      = angle::FormatID::BC7_RGBA_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT;
            mActualImageFormatID      = angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::D16_UNORM:
            mIntendedGLFormat         = GL_DEPTH_COMPONENT16;
            mActualImageFormatID      = angle::FormatID::D16_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::D24_UNORM_S8_UINT:
            mIntendedGLFormat         = GL_DEPTH24_STENCIL8;
            mActualImageFormatID      = angle::FormatID::D24_UNORM_S8_UINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::D24_UNORM_X8_UINT:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::D32_FLOAT:
            mIntendedGLFormat         = GL_DEPTH_COMPONENT32F;
            mActualImageFormatID      = angle::FormatID::D32_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::D32_FLOAT_S8X24_UINT:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::D32_UNORM:
            mIntendedGLFormat             = GL_DEPTH_COMPONENT32_OES;
            mActualImageFormatID          = angle::FormatID::D32_FLOAT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::EAC_R11G11_SNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SIGNED_RG11_EAC;
            mActualImageFormatID      = angle::FormatID::EAC_R11G11_SNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = false;

            break;

        case angle::FormatID::EAC_R11G11_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RG11_EAC;
            mActualImageFormatID      = angle::FormatID::EAC_R11G11_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::EAC_R11_SNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SIGNED_R11_EAC;
            mActualImageFormatID      = angle::FormatID::EAC_R11_SNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = false;

            break;

        case angle::FormatID::EAC_R11_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_R11_EAC;
            mActualImageFormatID      = angle::FormatID::EAC_R11_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ETC1_LOSSY_DECODE_R8G8B8_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::ETC1_R8G8B8_UNORM_BLOCK:
            mIntendedGLFormat         = GL_ETC1_RGB8_OES;
            mActualImageFormatID      = angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2;
            mActualImageFormatID      = angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2;
            mActualImageFormatID      = angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;
            mActualImageFormatID      = angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA8_ETC2_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(kInfo, ArraySize(kInfo));
            }

            break;

        case angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_SRGB8_ETC2;
            mActualImageFormatID      = angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK:
            mIntendedGLFormat         = GL_COMPRESSED_RGB8_ETC2;
            mActualImageFormatID      = angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::EXTERNAL0:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL0;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL0;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL1:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL1;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL1;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL2:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL2;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL2;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL3:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL3;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL3;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL4:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL4;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL4;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL5:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL5;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL5;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL6:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL6;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL6;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL7:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::EXTERNAL7;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::EXTERNAL7;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::G8_B8R8_2PLANE_420_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::G8_B8_R8_3PLANE_420_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::L16A16_FLOAT:
            mIntendedGLFormat         = GL_LUMINANCE_ALPHA16F_EXT;
            mActualImageFormatID      = angle::FormatID::R16G16_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::L16_FLOAT:
            mIntendedGLFormat         = GL_LUMINANCE16F_EXT;
            mActualImageFormatID      = angle::FormatID::R16_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::L32A32_FLOAT:
            mIntendedGLFormat         = GL_LUMINANCE_ALPHA32F_EXT;
            mActualImageFormatID      = angle::FormatID::R32G32_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::L32_FLOAT:
            mIntendedGLFormat         = GL_LUMINANCE32F_EXT;
            mActualImageFormatID      = angle::FormatID::R32_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::L4A4_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::L8A8_UNORM:
            mIntendedGLFormat         = GL_LUMINANCE8_ALPHA8_EXT;
            mActualImageFormatID      = angle::FormatID::R8G8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::L8_UNORM:
            mIntendedGLFormat         = GL_LUMINANCE8_EXT;
            mActualImageFormatID      = angle::FormatID::R8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::NONE:
            mIntendedGLFormat             = GL_NONE;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::PALETTE4_R4G4B4A4_UNORM:
            mIntendedGLFormat         = GL_PALETTE4_RGBA4_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE4_R5G5B5A1_UNORM:
            mIntendedGLFormat         = GL_PALETTE4_RGB5_A1_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE4_R5G6B5_UNORM:
            mIntendedGLFormat         = GL_PALETTE4_R5_G6_B5_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE4_R8G8B8A8_UNORM:
            mIntendedGLFormat         = GL_PALETTE4_RGBA8_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE4_R8G8B8_UNORM:
            mIntendedGLFormat         = GL_PALETTE4_RGB8_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE8_R4G4B4A4_UNORM:
            mIntendedGLFormat         = GL_PALETTE8_RGBA4_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE8_R5G5B5A1_UNORM:
            mIntendedGLFormat         = GL_PALETTE8_RGB5_A1_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE8_R5G6B5_UNORM:
            mIntendedGLFormat         = GL_PALETTE8_R5_G6_B5_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE8_R8G8B8A8_UNORM:
            mIntendedGLFormat         = GL_PALETTE8_RGBA8_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PALETTE8_R8G8B8_UNORM:
            mIntendedGLFormat         = GL_PALETTE8_RGB8_OES;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::PVRTC1_RGBA_2BPP_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGBA_2BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGBA_4BPP_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGBA_4BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGB_2BPP_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGB_2BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGB_4BPP_UNORM_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::PVRTC1_RGB_4BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R10G10B10A2_SINT:
            mIntendedGLFormat         = GL_RGB10_A2_SINT_ANGLEX;
            mActualImageFormatID      = angle::FormatID::R10G10B10A2_SINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R10G10B10A2_SNORM:
            mIntendedGLFormat = GL_RGB10_A2_SNORM_ANGLEX;

            mActualBufferFormatID = angle::FormatID::R16G16B16A16_SNORM;
            mVertexLoadFunction   = CopyXYZ10W2ToXYZWFloatVertexData<true, true, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R10G10B10A2_SSCALED:
            mIntendedGLFormat = GL_RGB10_A2_SSCALED_ANGLEX;

            mActualBufferFormatID = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction   = CopyXYZ10W2ToXYZWFloatVertexData<true, false, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R10G10B10A2_UINT:
            mIntendedGLFormat = GL_RGB10_A2UI;

            mActualBufferFormatID = angle::FormatID::R16G16B16A16_UINT;
            mVertexLoadFunction   = CopyXYZ10W2ToXYZWFloatVertexData<false, false, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R10G10B10A2_UNORM:
            mIntendedGLFormat         = GL_RGB10_A2;
            mActualImageFormatID      = angle::FormatID::R10G10B10A2_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;
            mActualBufferFormatID     = angle::FormatID::R10G10B10A2_UNORM;
            mVertexLoadFunction       = CopyXYZ10W2ToXYZWFloatVertexData<false, true, true, true>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R10G10B10A2_USCALED:
            mIntendedGLFormat = GL_RGB10_A2_USCALED_ANGLEX;

            mActualBufferFormatID = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction   = CopyXYZ10W2ToXYZWFloatVertexData<false, false, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R10G10B10X2_UNORM:
            mIntendedGLFormat             = GL_RGB10_EXT;
            mActualImageFormatID          = angle::FormatID::R10G10B10A2_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R11G11B10_FLOAT:
            mIntendedGLFormat         = GL_R11F_G11F_B10F;
            mActualImageFormatID      = angle::FormatID::R11G11B10_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R16G16B16A16_FLOAT:
            mIntendedGLFormat             = GL_RGBA16F;
            mActualImageFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLhalf, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_SINT:
            mIntendedGLFormat             = GL_RGBA16I;
            mActualImageFormatID          = angle::FormatID::R16G16B16A16_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLshort, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_SNORM:
            mIntendedGLFormat             = GL_RGBA16_SNORM_EXT;
            mActualImageFormatID          = angle::FormatID::R16G16B16A16_SNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = false;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLshort, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_SSCALED:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R16G16B16A16_UINT:
            mIntendedGLFormat             = GL_RGBA16UI;
            mActualImageFormatID          = angle::FormatID::R16G16B16A16_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLushort, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_UNORM:
            mIntendedGLFormat             = GL_RGBA16_EXT;
            mActualImageFormatID          = angle::FormatID::R16G16B16A16_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_UNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLushort, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16B16A16_USCALED:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R16G16B16_FLOAT:
            mIntendedGLFormat    = GL_RGB16F;
            mActualImageFormatID = angle::FormatID::R16G16B16A16_FLOAT;
            mImageInitializerFunction =
                Initialize4ComponentData<GLhalf, 0x0000, 0x0000, 0x0000, gl::Float16One>;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLhalf, 3, 4, gl::Float16One>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R16G16B16_SINT:
            mIntendedGLFormat    = GL_RGB16I;
            mActualImageFormatID = angle::FormatID::R16G16B16A16_SINT;
            mImageInitializerFunction =
                Initialize4ComponentData<GLshort, 0x0000, 0x0000, 0x0000, 0x0001>;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLshort, 3, 4, 1>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R16G16B16_SNORM:
            mIntendedGLFormat    = GL_RGB16_SNORM_EXT;
            mActualImageFormatID = angle::FormatID::R16G16B16A16_SNORM;
            mImageInitializerFunction =
                Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0x7FFF>;
            mIsRenderable         = false;
            mActualBufferFormatID = angle::FormatID::R16G16B16A16_SNORM;
            mVertexLoadFunction =
                CopyNativeVertexData<GLshort, 3, 4, std::numeric_limits<GLshort>::max()>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R16G16B16_SSCALED:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R16G16B16_UINT:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R16G16B16_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R16G16B16_USCALED:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R16G16_FLOAT:
            mIntendedGLFormat             = GL_RG16F;
            mActualImageFormatID          = angle::FormatID::R16G16_FLOAT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLhalf, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_SINT:
            mIntendedGLFormat             = GL_RG16I;
            mActualImageFormatID          = angle::FormatID::R16G16_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLshort, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_SNORM:
            mIntendedGLFormat             = GL_RG16_SNORM_EXT;
            mActualImageFormatID          = angle::FormatID::R16G16_SNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = false;
            mActualBufferFormatID         = angle::FormatID::R16G16_SNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLshort, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_SSCALED:
            mIntendedGLFormat = GL_RG16_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLshort, 2, 2, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R16G16_UINT:
            mIntendedGLFormat             = GL_RG16UI;
            mActualImageFormatID          = angle::FormatID::R16G16_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLushort, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_UNORM:
            mIntendedGLFormat             = GL_RG16_EXT;
            mActualImageFormatID          = angle::FormatID::R16G16_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16_UNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLushort, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R16G16_USCALED:
            mIntendedGLFormat = GL_RG16_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLushort, 2, 2, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R16_FLOAT:
            mIntendedGLFormat         = GL_R16F;
            mActualImageFormatID      = angle::FormatID::R16_FLOAT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R16_SINT:
            mIntendedGLFormat         = GL_R16I;
            mActualImageFormatID      = angle::FormatID::R16_SINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R16_SNORM:
            mIntendedGLFormat         = GL_R16_SNORM_EXT;
            mActualImageFormatID      = angle::FormatID::R16_SNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = false;

            break;

        case angle::FormatID::R16_SSCALED:
            mIntendedGLFormat = GL_R16_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLshort, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R16_UINT:
            mIntendedGLFormat         = GL_R16UI;
            mActualImageFormatID      = angle::FormatID::R16_UINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R16_UNORM:
            mIntendedGLFormat         = GL_R16_EXT;
            mActualImageFormatID      = angle::FormatID::R16_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R16_USCALED:
            mIntendedGLFormat = GL_R16_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLushort, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_FIXED:
            mIntendedGLFormat = GL_RGBA32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<4, 4>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_FLOAT:
            mIntendedGLFormat             = GL_RGBA32F;
            mActualImageFormatID          = angle::FormatID::R32G32B32A32_FLOAT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLfloat, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32A32_SINT:
            mIntendedGLFormat             = GL_RGBA32I;
            mActualImageFormatID          = angle::FormatID::R32G32B32A32_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLint, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32A32_SNORM:
            mIntendedGLFormat = GL_RGBA32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 4, 4, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_SSCALED:
            mIntendedGLFormat = GL_RGBA32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 4, 4, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_UINT:
            mIntendedGLFormat             = GL_RGBA32UI;
            mActualImageFormatID          = angle::FormatID::R32G32B32A32_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLuint, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32A32_UNORM:
            mIntendedGLFormat = GL_RGBA32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 4, 4, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_USCALED:
            mIntendedGLFormat = GL_RGBA32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 4, 4, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_FIXED:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R32G32B32_FLOAT:
            mIntendedGLFormat = GL_RGB32F;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLfloat, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_SINT:
            mIntendedGLFormat    = GL_RGB32I;
            mActualImageFormatID = angle::FormatID::R32G32B32A32_SINT;
            mImageInitializerFunction =
                Initialize4ComponentData<GLint, 0x00000000, 0x00000000, 0x00000000, 0x00000001>;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32B32_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLint, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_SNORM:
            mIntendedGLFormat = GL_RGB32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 3, 3, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_SSCALED:
            mIntendedGLFormat = GL_RGB32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 3, 3, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_UINT:
            mIntendedGLFormat = GL_RGB32UI;

            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_UINT, CopyNativeVertexData<GLuint, 3, 3, 0>, false},
                    {angle::FormatID::R32G32B32A32_UINT, CopyNativeVertexData<GLuint, 3, 4, 1>,
                     true}};
                initBufferFallback(kInfo, ArraySize(kInfo));
            }
            break;

        case angle::FormatID::R32G32B32_UNORM:
            mIntendedGLFormat = GL_RGB32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 3, 3, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_USCALED:
            mIntendedGLFormat = GL_RGB32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 3, 3, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_FIXED:
            mIntendedGLFormat = GL_RG32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<2, 2>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_FLOAT:
            mIntendedGLFormat             = GL_RG32F;
            mActualImageFormatID          = angle::FormatID::R32G32_FLOAT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLfloat, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32_SINT:
            mIntendedGLFormat             = GL_RG32I;
            mActualImageFormatID          = angle::FormatID::R32G32_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLint, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32_SNORM:
            mIntendedGLFormat = GL_RG32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 2, 2, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_SSCALED:
            mIntendedGLFormat = GL_RG32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 2, 2, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_UINT:
            mIntendedGLFormat             = GL_RG32UI;
            mActualImageFormatID          = angle::FormatID::R32G32_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32G32_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLuint, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32_UNORM:
            mIntendedGLFormat = GL_RG32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 2, 2, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_USCALED:
            mIntendedGLFormat = GL_RG32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 2, 2, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_FIXED:
            mIntendedGLFormat = GL_R32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<1, 1>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_FLOAT:
            mIntendedGLFormat             = GL_R32F;
            mActualImageFormatID          = angle::FormatID::R32_FLOAT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyNativeVertexData<GLfloat, 1, 1, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32_SINT:
            mIntendedGLFormat             = GL_R32I;
            mActualImageFormatID          = angle::FormatID::R32_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLint, 1, 1, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32_SNORM:
            mIntendedGLFormat = GL_R32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 1, 1, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_SSCALED:
            mIntendedGLFormat = GL_R32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_UINT:
            mIntendedGLFormat             = GL_R32UI;
            mActualImageFormatID          = angle::FormatID::R32_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R32_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32_UNORM:
            mIntendedGLFormat = GL_R32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 1, 1, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_USCALED:
            mIntendedGLFormat = GL_R32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R4G4B4A4_UNORM:
            mIntendedGLFormat         = GL_RGBA4;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R5G5B5A1_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R5G6B5_UNORM:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R8G8B8A8_SINT:
            mIntendedGLFormat             = GL_RGBA8I;
            mActualImageFormatID          = angle::FormatID::R8G8B8A8_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R8G8B8A8_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_SNORM:
            mIntendedGLFormat             = GL_RGBA8_SNORM;
            mActualImageFormatID          = angle::FormatID::R8G8B8A8_SNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = false;
            mActualBufferFormatID         = angle::FormatID::R8G8B8A8_SNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_SSCALED:
            mIntendedGLFormat = GL_RGBA8_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLbyte, 4, 4, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8A8_TYPELESS:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R8G8B8A8_TYPELESS_SRGB:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R8G8B8A8_UINT:
            mIntendedGLFormat             = GL_RGBA8UI;
            mActualImageFormatID          = angle::FormatID::R8G8B8A8_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R8G8B8A8_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_UNORM:
            mIntendedGLFormat             = GL_RGBA8;
            mActualImageFormatID          = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R8G8B8A8_UNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8A8_UNORM_SRGB:
            mIntendedGLFormat         = GL_SRGB8_ALPHA8;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R8G8B8A8_USCALED:
            mIntendedGLFormat = GL_RGBA8_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLubyte, 4, 4, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8X8_UNORM:
            mIntendedGLFormat             = GL_RGBX8_ANGLE;
            mActualImageFormatID          = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8X8_UNORM_SRGB:
            mIntendedGLFormat             = GL_RGBX8_SRGB_ANGLEX;
            mActualImageFormatID          = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8_SINT:
            mIntendedGLFormat         = GL_RGB8I;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_SINT;
            mImageInitializerFunction = Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x01>;
            mIsRenderable             = true;
            mActualBufferFormatID     = angle::FormatID::R8G8B8A8_SINT;
            mVertexLoadFunction       = CopyNativeVertexData<GLbyte, 3, 4, 1>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8_SNORM:
            mIntendedGLFormat         = GL_RGB8_SNORM;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_SNORM;
            mImageInitializerFunction = Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x7F>;
            mIsRenderable             = false;
            mActualBufferFormatID     = angle::FormatID::R8G8B8A8_SNORM;
            mVertexLoadFunction =
                CopyNativeVertexData<GLbyte, 3, 4, std::numeric_limits<GLbyte>::max()>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8_SSCALED:
            mIntendedGLFormat = GL_RGB8_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLbyte, 3, 4, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8_UINT:
            mIntendedGLFormat         = GL_RGB8UI;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UINT;
            mImageInitializerFunction = Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0x01>;
            mIsRenderable             = true;
            mActualBufferFormatID     = angle::FormatID::R8G8B8A8_UINT;
            mVertexLoadFunction       = CopyNativeVertexData<GLubyte, 3, 4, 1>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8_UNORM:
            mIntendedGLFormat         = GL_RGB8;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction = Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>;
            mIsRenderable             = true;
            mActualBufferFormatID     = angle::FormatID::R8G8B8A8_UNORM;
            mVertexLoadFunction =
                CopyNativeVertexData<GLubyte, 3, 4, std::numeric_limits<GLubyte>::max()>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8B8_UNORM_SRGB:
            mIntendedGLFormat         = GL_SRGB8;
            mActualImageFormatID      = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            mImageInitializerFunction = Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R8G8B8_USCALED:
            mIntendedGLFormat = GL_RGB8_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLubyte, 3, 4, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8_SINT:
            mIntendedGLFormat             = GL_RG8I;
            mActualImageFormatID          = angle::FormatID::R8G8_SINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R8G8_SINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8_SNORM:
            mIntendedGLFormat             = GL_RG8_SNORM;
            mActualImageFormatID          = angle::FormatID::R8G8_SNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = false;
            mActualBufferFormatID         = angle::FormatID::R8G8_SNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8_SSCALED:
            mIntendedGLFormat = GL_RG8_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R16G16_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLbyte, 2, 2, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8G8_UINT:
            mIntendedGLFormat             = GL_RG8UI;
            mActualImageFormatID          = angle::FormatID::R8G8_UINT;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R8G8_UINT;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8_UNORM:
            mIntendedGLFormat             = GL_RG8;
            mActualImageFormatID          = angle::FormatID::R8G8_UNORM;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R8G8_UNORM;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 2, 2, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8_UNORM_SRGB:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R8G8_USCALED:
            mIntendedGLFormat = GL_RG8_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R16G16_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLubyte, 2, 2, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8_SINT:
            mIntendedGLFormat         = GL_R8I;
            mActualImageFormatID      = angle::FormatID::R8_SINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R8_SNORM:
            mIntendedGLFormat         = GL_R8_SNORM;
            mActualImageFormatID      = angle::FormatID::R8_SNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = false;

            break;

        case angle::FormatID::R8_SSCALED:
            mIntendedGLFormat = GL_R8_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLbyte, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R8_UINT:
            mIntendedGLFormat         = GL_R8UI;
            mActualImageFormatID      = angle::FormatID::R8_UINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R8_UNORM:
            mIntendedGLFormat         = GL_R8;
            mActualImageFormatID      = angle::FormatID::R8_UNORM;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::R8_UNORM_SRGB:
            // This format is not implemented in WebGPU.
            break;

        case angle::FormatID::R8_USCALED:
            mIntendedGLFormat = GL_R8_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVertexLoadFunction           = CopyToFloatVertexData<GLubyte, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R9G9B9E5_SHAREDEXP:
            mIntendedGLFormat         = GL_RGB9_E5;
            mActualImageFormatID      = angle::FormatID::R9G9B9E5_SHAREDEXP;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::S8_UINT:
            mIntendedGLFormat         = GL_STENCIL_INDEX8;
            mActualImageFormatID      = angle::FormatID::S8_UINT;
            mImageInitializerFunction = nullptr;
            mIsRenderable             = true;

            break;

        case angle::FormatID::X2R10G10B10_SINT_VERTEX:
            mIntendedGLFormat             = GL_X2_RGB10_SINT_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SINT;
            mVertexLoadFunction           = CopyXYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::X2R10G10B10_SNORM_VERTEX:
            mIntendedGLFormat             = GL_X2_RGB10_SNORM_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = false;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_SNORM;
            mVertexLoadFunction           = CopyXYZ10ToXYZWFloatVertexData<true, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::X2R10G10B10_SSCALED_VERTEX:
            mIntendedGLFormat             = GL_X2_RGB10_SSCALED_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyXYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::X2R10G10B10_UINT_VERTEX:
            mIntendedGLFormat             = GL_X2_RGB10_UINT_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_UINT;
            mVertexLoadFunction           = CopyXYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::X2R10G10B10_UNORM_VERTEX:
            mIntendedGLFormat             = GL_X2_RGB10_UNORM_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_UNORM;
            mVertexLoadFunction           = CopyXYZ10ToXYZWFloatVertexData<false, true, true>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::X2R10G10B10_USCALED_VERTEX:
            mIntendedGLFormat             = GL_X2_RGB10_USCALED_ANGLEX;
            mActualImageFormatID          = angle::FormatID::NONE;
            mImageInitializerFunction     = nullptr;
            mIsRenderable                 = true;
            mActualBufferFormatID         = angle::FormatID::R16G16B16A16_FLOAT;
            mVertexLoadFunction           = CopyXYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion = true;
            break;

        default:
            UNREACHABLE();
            break;
    }
}

wgpu::TextureFormat GetWgpuTextureFormatFromFormatID(angle::FormatID formatID)
{
    static constexpr angle::FormatMap<wgpu::TextureFormat> kMap = {
        {angle::FormatID::ASTC_10x10_SRGB_BLOCK, wgpu::TextureFormat::ASTC10x10UnormSrgb},
        {angle::FormatID::ASTC_10x10_UNORM_BLOCK, wgpu::TextureFormat::ASTC10x10Unorm},
        {angle::FormatID::ASTC_10x5_SRGB_BLOCK, wgpu::TextureFormat::ASTC10x5UnormSrgb},
        {angle::FormatID::ASTC_10x5_UNORM_BLOCK, wgpu::TextureFormat::ASTC10x5Unorm},
        {angle::FormatID::ASTC_10x6_SRGB_BLOCK, wgpu::TextureFormat::ASTC10x6UnormSrgb},
        {angle::FormatID::ASTC_10x6_UNORM_BLOCK, wgpu::TextureFormat::ASTC10x6Unorm},
        {angle::FormatID::ASTC_10x8_SRGB_BLOCK, wgpu::TextureFormat::ASTC10x8UnormSrgb},
        {angle::FormatID::ASTC_10x8_UNORM_BLOCK, wgpu::TextureFormat::ASTC10x8Unorm},
        {angle::FormatID::ASTC_12x10_SRGB_BLOCK, wgpu::TextureFormat::ASTC12x10UnormSrgb},
        {angle::FormatID::ASTC_12x10_UNORM_BLOCK, wgpu::TextureFormat::ASTC12x10Unorm},
        {angle::FormatID::ASTC_12x12_SRGB_BLOCK, wgpu::TextureFormat::ASTC12x12UnormSrgb},
        {angle::FormatID::ASTC_12x12_UNORM_BLOCK, wgpu::TextureFormat::ASTC12x12Unorm},
        {angle::FormatID::ASTC_4x4_SRGB_BLOCK, wgpu::TextureFormat::ASTC4x4UnormSrgb},
        {angle::FormatID::ASTC_4x4_UNORM_BLOCK, wgpu::TextureFormat::ASTC4x4Unorm},
        {angle::FormatID::ASTC_5x4_SRGB_BLOCK, wgpu::TextureFormat::ASTC5x4UnormSrgb},
        {angle::FormatID::ASTC_5x4_UNORM_BLOCK, wgpu::TextureFormat::ASTC5x4Unorm},
        {angle::FormatID::ASTC_5x5_SRGB_BLOCK, wgpu::TextureFormat::ASTC5x5UnormSrgb},
        {angle::FormatID::ASTC_5x5_UNORM_BLOCK, wgpu::TextureFormat::ASTC5x5Unorm},
        {angle::FormatID::ASTC_6x5_SRGB_BLOCK, wgpu::TextureFormat::ASTC6x5UnormSrgb},
        {angle::FormatID::ASTC_6x5_UNORM_BLOCK, wgpu::TextureFormat::ASTC6x5Unorm},
        {angle::FormatID::ASTC_6x6_SRGB_BLOCK, wgpu::TextureFormat::ASTC6x6UnormSrgb},
        {angle::FormatID::ASTC_6x6_UNORM_BLOCK, wgpu::TextureFormat::ASTC6x6Unorm},
        {angle::FormatID::ASTC_8x5_SRGB_BLOCK, wgpu::TextureFormat::ASTC8x5UnormSrgb},
        {angle::FormatID::ASTC_8x5_UNORM_BLOCK, wgpu::TextureFormat::ASTC8x5Unorm},
        {angle::FormatID::ASTC_8x6_SRGB_BLOCK, wgpu::TextureFormat::ASTC8x6UnormSrgb},
        {angle::FormatID::ASTC_8x6_UNORM_BLOCK, wgpu::TextureFormat::ASTC8x6Unorm},
        {angle::FormatID::ASTC_8x8_SRGB_BLOCK, wgpu::TextureFormat::ASTC8x8UnormSrgb},
        {angle::FormatID::ASTC_8x8_UNORM_BLOCK, wgpu::TextureFormat::ASTC8x8Unorm},
        {angle::FormatID::B8G8R8A8_UNORM, wgpu::TextureFormat::BGRA8Unorm},
        {angle::FormatID::B8G8R8A8_UNORM_SRGB, wgpu::TextureFormat::BGRA8UnormSrgb},
        {angle::FormatID::BC1_RGBA_UNORM_BLOCK, wgpu::TextureFormat::BC1RGBAUnorm},
        {angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK, wgpu::TextureFormat::BC1RGBAUnormSrgb},
        {angle::FormatID::BC2_RGBA_UNORM_BLOCK, wgpu::TextureFormat::BC2RGBAUnorm},
        {angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK, wgpu::TextureFormat::BC2RGBAUnormSrgb},
        {angle::FormatID::BC3_RGBA_UNORM_BLOCK, wgpu::TextureFormat::BC3RGBAUnorm},
        {angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK, wgpu::TextureFormat::BC3RGBAUnormSrgb},
        {angle::FormatID::BC4_RED_SNORM_BLOCK, wgpu::TextureFormat::BC4RSnorm},
        {angle::FormatID::BC4_RED_UNORM_BLOCK, wgpu::TextureFormat::BC4RUnorm},
        {angle::FormatID::BC5_RG_SNORM_BLOCK, wgpu::TextureFormat::BC5RGSnorm},
        {angle::FormatID::BC5_RG_UNORM_BLOCK, wgpu::TextureFormat::BC5RGUnorm},
        {angle::FormatID::BC6H_RGB_SFLOAT_BLOCK, wgpu::TextureFormat::BC6HRGBFloat},
        {angle::FormatID::BC6H_RGB_UFLOAT_BLOCK, wgpu::TextureFormat::BC6HRGBUfloat},
        {angle::FormatID::BC7_RGBA_UNORM_BLOCK, wgpu::TextureFormat::BC7RGBAUnorm},
        {angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK, wgpu::TextureFormat::BC7RGBAUnormSrgb},
        {angle::FormatID::D16_UNORM, wgpu::TextureFormat::Depth16Unorm},
        {angle::FormatID::D24_UNORM_S8_UINT, wgpu::TextureFormat::Depth24PlusStencil8},
        {angle::FormatID::D32_FLOAT, wgpu::TextureFormat::Depth32Float},
        {angle::FormatID::EAC_R11G11_SNORM_BLOCK, wgpu::TextureFormat::EACRG11Snorm},
        {angle::FormatID::EAC_R11G11_UNORM_BLOCK, wgpu::TextureFormat::EACRG11Unorm},
        {angle::FormatID::EAC_R11_SNORM_BLOCK, wgpu::TextureFormat::EACR11Snorm},
        {angle::FormatID::EAC_R11_UNORM_BLOCK, wgpu::TextureFormat::EACR11Unorm},
        {angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK, wgpu::TextureFormat::ETC2RGB8A1UnormSrgb},
        {angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK, wgpu::TextureFormat::ETC2RGB8A1Unorm},
        {angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK, wgpu::TextureFormat::ETC2RGBA8UnormSrgb},
        {angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK, wgpu::TextureFormat::ETC2RGBA8Unorm},
        {angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK, wgpu::TextureFormat::ETC2RGB8UnormSrgb},
        {angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK, wgpu::TextureFormat::ETC2RGB8Unorm},
        {angle::FormatID::EXTERNAL0, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL1, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL2, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL3, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL4, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL5, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL6, wgpu::TextureFormat::Undefined},
        {angle::FormatID::EXTERNAL7, wgpu::TextureFormat::Undefined},
        {angle::FormatID::NONE, wgpu::TextureFormat::Undefined},
        {angle::FormatID::R10G10B10A2_SINT, wgpu::TextureFormat::RGB10A2Uint},
        {angle::FormatID::R10G10B10A2_UNORM, wgpu::TextureFormat::RGB10A2Unorm},
        {angle::FormatID::R11G11B10_FLOAT, wgpu::TextureFormat::RG11B10Ufloat},
        {angle::FormatID::R16G16B16A16_FLOAT, wgpu::TextureFormat::RGBA16Float},
        {angle::FormatID::R16G16B16A16_SINT, wgpu::TextureFormat::RGBA16Sint},
        {angle::FormatID::R16G16B16A16_SNORM, wgpu::TextureFormat::RGBA16Snorm},
        {angle::FormatID::R16G16B16A16_UINT, wgpu::TextureFormat::RGBA16Uint},
        {angle::FormatID::R16G16B16A16_UNORM, wgpu::TextureFormat::RGBA16Unorm},
        {angle::FormatID::R16G16_FLOAT, wgpu::TextureFormat::RG16Float},
        {angle::FormatID::R16G16_SINT, wgpu::TextureFormat::RG16Sint},
        {angle::FormatID::R16G16_SNORM, wgpu::TextureFormat::RG16Snorm},
        {angle::FormatID::R16G16_UINT, wgpu::TextureFormat::RG16Uint},
        {angle::FormatID::R16G16_UNORM, wgpu::TextureFormat::RG16Unorm},
        {angle::FormatID::R16_FLOAT, wgpu::TextureFormat::R16Float},
        {angle::FormatID::R16_SINT, wgpu::TextureFormat::R16Sint},
        {angle::FormatID::R16_SNORM, wgpu::TextureFormat::R16Snorm},
        {angle::FormatID::R16_UINT, wgpu::TextureFormat::R16Uint},
        {angle::FormatID::R16_UNORM, wgpu::TextureFormat::R16Unorm},
        {angle::FormatID::R32G32B32A32_FLOAT, wgpu::TextureFormat::RGBA32Float},
        {angle::FormatID::R32G32B32A32_SINT, wgpu::TextureFormat::RGBA32Sint},
        {angle::FormatID::R32G32B32A32_UINT, wgpu::TextureFormat::RGBA32Uint},
        {angle::FormatID::R32G32_FLOAT, wgpu::TextureFormat::RG32Float},
        {angle::FormatID::R32G32_SINT, wgpu::TextureFormat::RG32Sint},
        {angle::FormatID::R32G32_UINT, wgpu::TextureFormat::RG32Uint},
        {angle::FormatID::R32_FLOAT, wgpu::TextureFormat::R32Float},
        {angle::FormatID::R32_SINT, wgpu::TextureFormat::R32Sint},
        {angle::FormatID::R32_UINT, wgpu::TextureFormat::R32Uint},
        {angle::FormatID::R8G8B8A8_SINT, wgpu::TextureFormat::RGBA8Sint},
        {angle::FormatID::R8G8B8A8_SNORM, wgpu::TextureFormat::RGBA8Snorm},
        {angle::FormatID::R8G8B8A8_UINT, wgpu::TextureFormat::RGBA8Uint},
        {angle::FormatID::R8G8B8A8_UNORM, wgpu::TextureFormat::RGBA8Unorm},
        {angle::FormatID::R8G8B8A8_UNORM_SRGB, wgpu::TextureFormat::RGBA8UnormSrgb},
        {angle::FormatID::R8G8_SINT, wgpu::TextureFormat::RG8Sint},
        {angle::FormatID::R8G8_SNORM, wgpu::TextureFormat::RG8Snorm},
        {angle::FormatID::R8G8_UINT, wgpu::TextureFormat::RG8Uint},
        {angle::FormatID::R8G8_UNORM, wgpu::TextureFormat::RG8Unorm},
        {angle::FormatID::R8_SINT, wgpu::TextureFormat::R8Sint},
        {angle::FormatID::R8_SNORM, wgpu::TextureFormat::R8Snorm},
        {angle::FormatID::R8_UINT, wgpu::TextureFormat::R8Uint},
        {angle::FormatID::R8_UNORM, wgpu::TextureFormat::R8Unorm},
        {angle::FormatID::R9G9B9E5_SHAREDEXP, wgpu::TextureFormat::RGB9E5Ufloat},
        {angle::FormatID::S8_UINT, wgpu::TextureFormat::Stencil8}};

    return kMap[formatID];
}

angle::FormatID GetFormatIDFromWgpuTextureFormat(wgpu::TextureFormat wgpuFormat)
{
    switch (wgpuFormat)
    {
        case wgpu::TextureFormat::ASTC10x10UnormSrgb:
            return angle::FormatID::ASTC_10x10_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC10x10Unorm:
            return angle::FormatID::ASTC_10x10_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC10x5UnormSrgb:
            return angle::FormatID::ASTC_10x5_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC10x5Unorm:
            return angle::FormatID::ASTC_10x5_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC10x6UnormSrgb:
            return angle::FormatID::ASTC_10x6_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC10x6Unorm:
            return angle::FormatID::ASTC_10x6_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC10x8UnormSrgb:
            return angle::FormatID::ASTC_10x8_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC10x8Unorm:
            return angle::FormatID::ASTC_10x8_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC12x10UnormSrgb:
            return angle::FormatID::ASTC_12x10_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC12x10Unorm:
            return angle::FormatID::ASTC_12x10_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC12x12UnormSrgb:
            return angle::FormatID::ASTC_12x12_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC12x12Unorm:
            return angle::FormatID::ASTC_12x12_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC4x4UnormSrgb:
            return angle::FormatID::ASTC_4x4_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC4x4Unorm:
            return angle::FormatID::ASTC_4x4_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC5x4UnormSrgb:
            return angle::FormatID::ASTC_5x4_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC5x4Unorm:
            return angle::FormatID::ASTC_5x4_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC5x5UnormSrgb:
            return angle::FormatID::ASTC_5x5_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC5x5Unorm:
            return angle::FormatID::ASTC_5x5_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC6x5UnormSrgb:
            return angle::FormatID::ASTC_6x5_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC6x5Unorm:
            return angle::FormatID::ASTC_6x5_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC6x6UnormSrgb:
            return angle::FormatID::ASTC_6x6_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC6x6Unorm:
            return angle::FormatID::ASTC_6x6_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC8x5UnormSrgb:
            return angle::FormatID::ASTC_8x5_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC8x5Unorm:
            return angle::FormatID::ASTC_8x5_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC8x6UnormSrgb:
            return angle::FormatID::ASTC_8x6_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC8x6Unorm:
            return angle::FormatID::ASTC_8x6_UNORM_BLOCK;
        case wgpu::TextureFormat::ASTC8x8UnormSrgb:
            return angle::FormatID::ASTC_8x8_SRGB_BLOCK;
        case wgpu::TextureFormat::ASTC8x8Unorm:
            return angle::FormatID::ASTC_8x8_UNORM_BLOCK;
        case wgpu::TextureFormat::BGRA8Unorm:
            return angle::FormatID::B8G8R8A8_UNORM;
        case wgpu::TextureFormat::BGRA8UnormSrgb:
            return angle::FormatID::B8G8R8A8_UNORM_SRGB;
        case wgpu::TextureFormat::BC1RGBAUnorm:
            return angle::FormatID::BC1_RGBA_UNORM_BLOCK;
        case wgpu::TextureFormat::BC1RGBAUnormSrgb:
            return angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
        case wgpu::TextureFormat::BC2RGBAUnorm:
            return angle::FormatID::BC2_RGBA_UNORM_BLOCK;
        case wgpu::TextureFormat::BC2RGBAUnormSrgb:
            return angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
        case wgpu::TextureFormat::BC3RGBAUnorm:
            return angle::FormatID::BC3_RGBA_UNORM_BLOCK;
        case wgpu::TextureFormat::BC3RGBAUnormSrgb:
            return angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
        case wgpu::TextureFormat::BC4RSnorm:
            return angle::FormatID::BC4_RED_SNORM_BLOCK;
        case wgpu::TextureFormat::BC4RUnorm:
            return angle::FormatID::BC4_RED_UNORM_BLOCK;
        case wgpu::TextureFormat::BC5RGSnorm:
            return angle::FormatID::BC5_RG_SNORM_BLOCK;
        case wgpu::TextureFormat::BC5RGUnorm:
            return angle::FormatID::BC5_RG_UNORM_BLOCK;
        case wgpu::TextureFormat::BC6HRGBFloat:
            return angle::FormatID::BC6H_RGB_SFLOAT_BLOCK;
        case wgpu::TextureFormat::BC6HRGBUfloat:
            return angle::FormatID::BC6H_RGB_UFLOAT_BLOCK;
        case wgpu::TextureFormat::BC7RGBAUnorm:
            return angle::FormatID::BC7_RGBA_UNORM_BLOCK;
        case wgpu::TextureFormat::BC7RGBAUnormSrgb:
            return angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK;
        case wgpu::TextureFormat::Depth16Unorm:
            return angle::FormatID::D16_UNORM;
        case wgpu::TextureFormat::Depth24PlusStencil8:
            return angle::FormatID::D24_UNORM_S8_UINT;
        case wgpu::TextureFormat::Depth32Float:
            return angle::FormatID::D32_FLOAT;
        case wgpu::TextureFormat::EACRG11Snorm:
            return angle::FormatID::EAC_R11G11_SNORM_BLOCK;
        case wgpu::TextureFormat::EACRG11Unorm:
            return angle::FormatID::EAC_R11G11_UNORM_BLOCK;
        case wgpu::TextureFormat::EACR11Snorm:
            return angle::FormatID::EAC_R11_SNORM_BLOCK;
        case wgpu::TextureFormat::EACR11Unorm:
            return angle::FormatID::EAC_R11_UNORM_BLOCK;
        case wgpu::TextureFormat::ETC2RGB8A1UnormSrgb:
            return angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK;
        case wgpu::TextureFormat::ETC2RGB8A1Unorm:
            return angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK;
        case wgpu::TextureFormat::ETC2RGBA8UnormSrgb:
            return angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK;
        case wgpu::TextureFormat::ETC2RGBA8Unorm:
            return angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK;
        case wgpu::TextureFormat::ETC2RGB8UnormSrgb:
            return angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK;
        case wgpu::TextureFormat::ETC2RGB8Unorm:
            return angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
        case wgpu::TextureFormat::Undefined:
            return angle::FormatID::NONE;
        case wgpu::TextureFormat::RGB10A2Uint:
            return angle::FormatID::R10G10B10A2_SINT;
        case wgpu::TextureFormat::RGB10A2Unorm:
            return angle::FormatID::R10G10B10A2_UNORM;
        case wgpu::TextureFormat::RG11B10Ufloat:
            return angle::FormatID::R11G11B10_FLOAT;
        case wgpu::TextureFormat::RGBA16Float:
            return angle::FormatID::R16G16B16A16_FLOAT;
        case wgpu::TextureFormat::RGBA16Sint:
            return angle::FormatID::R16G16B16A16_SINT;
        case wgpu::TextureFormat::RGBA16Snorm:
            return angle::FormatID::R16G16B16A16_SNORM;
        case wgpu::TextureFormat::RGBA16Uint:
            return angle::FormatID::R16G16B16A16_UINT;
        case wgpu::TextureFormat::RGBA16Unorm:
            return angle::FormatID::R16G16B16A16_UNORM;
        case wgpu::TextureFormat::RG16Float:
            return angle::FormatID::R16G16_FLOAT;
        case wgpu::TextureFormat::RG16Sint:
            return angle::FormatID::R16G16_SINT;
        case wgpu::TextureFormat::RG16Snorm:
            return angle::FormatID::R16G16_SNORM;
        case wgpu::TextureFormat::RG16Uint:
            return angle::FormatID::R16G16_UINT;
        case wgpu::TextureFormat::RG16Unorm:
            return angle::FormatID::R16G16_UNORM;
        case wgpu::TextureFormat::R16Float:
            return angle::FormatID::R16_FLOAT;
        case wgpu::TextureFormat::R16Sint:
            return angle::FormatID::R16_SINT;
        case wgpu::TextureFormat::R16Snorm:
            return angle::FormatID::R16_SNORM;
        case wgpu::TextureFormat::R16Uint:
            return angle::FormatID::R16_UINT;
        case wgpu::TextureFormat::R16Unorm:
            return angle::FormatID::R16_UNORM;
        case wgpu::TextureFormat::RGBA32Float:
            return angle::FormatID::R32G32B32A32_FLOAT;
        case wgpu::TextureFormat::RGBA32Sint:
            return angle::FormatID::R32G32B32A32_SINT;
        case wgpu::TextureFormat::RGBA32Uint:
            return angle::FormatID::R32G32B32A32_UINT;
        case wgpu::TextureFormat::RG32Float:
            return angle::FormatID::R32G32_FLOAT;
        case wgpu::TextureFormat::RG32Sint:
            return angle::FormatID::R32G32_SINT;
        case wgpu::TextureFormat::RG32Uint:
            return angle::FormatID::R32G32_UINT;
        case wgpu::TextureFormat::R32Float:
            return angle::FormatID::R32_FLOAT;
        case wgpu::TextureFormat::R32Sint:
            return angle::FormatID::R32_SINT;
        case wgpu::TextureFormat::R32Uint:
            return angle::FormatID::R32_UINT;
        case wgpu::TextureFormat::RGBA8Sint:
            return angle::FormatID::R8G8B8A8_SINT;
        case wgpu::TextureFormat::RGBA8Snorm:
            return angle::FormatID::R8G8B8A8_SNORM;
        case wgpu::TextureFormat::RGBA8Uint:
            return angle::FormatID::R8G8B8A8_UINT;
        case wgpu::TextureFormat::RGBA8Unorm:
            return angle::FormatID::R8G8B8A8_UNORM;
        case wgpu::TextureFormat::RGBA8UnormSrgb:
            return angle::FormatID::R8G8B8A8_UNORM_SRGB;
        case wgpu::TextureFormat::RG8Sint:
            return angle::FormatID::R8G8_SINT;
        case wgpu::TextureFormat::RG8Snorm:
            return angle::FormatID::R8G8_SNORM;
        case wgpu::TextureFormat::RG8Uint:
            return angle::FormatID::R8G8_UINT;
        case wgpu::TextureFormat::RG8Unorm:
            return angle::FormatID::R8G8_UNORM;
        case wgpu::TextureFormat::R8Sint:
            return angle::FormatID::R8_SINT;
        case wgpu::TextureFormat::R8Snorm:
            return angle::FormatID::R8_SNORM;
        case wgpu::TextureFormat::R8Uint:
            return angle::FormatID::R8_UINT;
        case wgpu::TextureFormat::R8Unorm:
            return angle::FormatID::R8_UNORM;
        case wgpu::TextureFormat::RGB9E5Ufloat:
            return angle::FormatID::R9G9B9E5_SHAREDEXP;
        case wgpu::TextureFormat::Stencil8:
            return angle::FormatID::S8_UINT;

        default:
            UNREACHABLE();
            return angle::FormatID::NONE;
    }
}

wgpu::VertexFormat GetWgpuVertexFormatFromFormatID(angle::FormatID formatID)
{
    static constexpr angle::FormatMap<wgpu::VertexFormat> kMap = {
        {angle::FormatID::EXTERNAL0, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL1, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL2, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL3, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL4, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL5, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL6, wgpu::VertexFormat(0u)},
        {angle::FormatID::EXTERNAL7, wgpu::VertexFormat(0u)},
        {angle::FormatID::NONE, wgpu::VertexFormat(0u)},
        {angle::FormatID::R10G10B10A2_UNORM, wgpu::VertexFormat::Unorm10_10_10_2},
        {angle::FormatID::R16G16B16A16_FLOAT, wgpu::VertexFormat::Float16x4},
        {angle::FormatID::R16G16B16A16_SINT, wgpu::VertexFormat::Sint16x4},
        {angle::FormatID::R16G16B16A16_SNORM, wgpu::VertexFormat::Snorm16x4},
        {angle::FormatID::R16G16B16A16_UINT, wgpu::VertexFormat::Uint16x4},
        {angle::FormatID::R16G16B16A16_UNORM, wgpu::VertexFormat::Unorm16x4},
        {angle::FormatID::R16G16_FLOAT, wgpu::VertexFormat::Float16x2},
        {angle::FormatID::R16G16_SINT, wgpu::VertexFormat::Sint16x2},
        {angle::FormatID::R16G16_SNORM, wgpu::VertexFormat::Snorm16x2},
        {angle::FormatID::R16G16_UINT, wgpu::VertexFormat::Uint16x2},
        {angle::FormatID::R16G16_UNORM, wgpu::VertexFormat::Unorm16x2},
        {angle::FormatID::R32G32B32A32_FLOAT, wgpu::VertexFormat::Float32x4},
        {angle::FormatID::R32G32B32A32_SINT, wgpu::VertexFormat::Sint32x4},
        {angle::FormatID::R32G32B32A32_UINT, wgpu::VertexFormat::Uint32x4},
        {angle::FormatID::R32G32B32_FLOAT, wgpu::VertexFormat::Float32x3},
        {angle::FormatID::R32G32B32_SINT, wgpu::VertexFormat::Sint32x3},
        {angle::FormatID::R32G32B32_UINT, wgpu::VertexFormat::Uint32x3},
        {angle::FormatID::R32G32_FLOAT, wgpu::VertexFormat::Float32x2},
        {angle::FormatID::R32G32_SINT, wgpu::VertexFormat::Sint32x2},
        {angle::FormatID::R32G32_UINT, wgpu::VertexFormat::Uint32x2},
        {angle::FormatID::R32_FLOAT, wgpu::VertexFormat::Float32},
        {angle::FormatID::R32_SINT, wgpu::VertexFormat::Sint32},
        {angle::FormatID::R32_UINT, wgpu::VertexFormat::Uint32},
        {angle::FormatID::R8G8B8A8_SINT, wgpu::VertexFormat::Sint8x4},
        {angle::FormatID::R8G8B8A8_SNORM, wgpu::VertexFormat::Snorm8x4},
        {angle::FormatID::R8G8B8A8_UINT, wgpu::VertexFormat::Uint8x4},
        {angle::FormatID::R8G8B8A8_UNORM, wgpu::VertexFormat::Unorm8x4},
        {angle::FormatID::R8G8_SINT, wgpu::VertexFormat::Sint8x2},
        {angle::FormatID::R8G8_SNORM, wgpu::VertexFormat::Snorm8x2},
        {angle::FormatID::R8G8_UINT, wgpu::VertexFormat::Uint8x2},
        {angle::FormatID::R8G8_UNORM, wgpu::VertexFormat::Unorm8x2}};

    return kMap[formatID];
}

angle::FormatID GetFormatIDFromWgpuBufferFormat(wgpu::VertexFormat wgpuFormat)
{
    switch (wgpuFormat)
    {
        case wgpu::VertexFormat::Unorm10_10_10_2:
            return angle::FormatID::R10G10B10A2_UNORM;
        case wgpu::VertexFormat::Float16x4:
            return angle::FormatID::R16G16B16A16_FLOAT;
        case wgpu::VertexFormat::Sint16x4:
            return angle::FormatID::R16G16B16A16_SINT;
        case wgpu::VertexFormat::Snorm16x4:
            return angle::FormatID::R16G16B16A16_SNORM;
        case wgpu::VertexFormat::Uint16x4:
            return angle::FormatID::R16G16B16A16_UINT;
        case wgpu::VertexFormat::Unorm16x4:
            return angle::FormatID::R16G16B16A16_UNORM;
        case wgpu::VertexFormat::Float16x2:
            return angle::FormatID::R16G16_FLOAT;
        case wgpu::VertexFormat::Sint16x2:
            return angle::FormatID::R16G16_SINT;
        case wgpu::VertexFormat::Snorm16x2:
            return angle::FormatID::R16G16_SNORM;
        case wgpu::VertexFormat::Uint16x2:
            return angle::FormatID::R16G16_UINT;
        case wgpu::VertexFormat::Unorm16x2:
            return angle::FormatID::R16G16_UNORM;
        case wgpu::VertexFormat::Float32x4:
            return angle::FormatID::R32G32B32A32_FLOAT;
        case wgpu::VertexFormat::Sint32x4:
            return angle::FormatID::R32G32B32A32_SINT;
        case wgpu::VertexFormat::Uint32x4:
            return angle::FormatID::R32G32B32A32_UINT;
        case wgpu::VertexFormat::Float32x3:
            return angle::FormatID::R32G32B32_FLOAT;
        case wgpu::VertexFormat::Sint32x3:
            return angle::FormatID::R32G32B32_SINT;
        case wgpu::VertexFormat::Uint32x3:
            return angle::FormatID::R32G32B32_UINT;
        case wgpu::VertexFormat::Float32x2:
            return angle::FormatID::R32G32_FLOAT;
        case wgpu::VertexFormat::Sint32x2:
            return angle::FormatID::R32G32_SINT;
        case wgpu::VertexFormat::Uint32x2:
            return angle::FormatID::R32G32_UINT;
        case wgpu::VertexFormat::Float32:
            return angle::FormatID::R32_FLOAT;
        case wgpu::VertexFormat::Sint32:
            return angle::FormatID::R32_SINT;
        case wgpu::VertexFormat::Uint32:
            return angle::FormatID::R32_UINT;
        case wgpu::VertexFormat::Sint8x4:
            return angle::FormatID::R8G8B8A8_SINT;
        case wgpu::VertexFormat::Snorm8x4:
            return angle::FormatID::R8G8B8A8_SNORM;
        case wgpu::VertexFormat::Uint8x4:
            return angle::FormatID::R8G8B8A8_UINT;
        case wgpu::VertexFormat::Unorm8x4:
            return angle::FormatID::R8G8B8A8_UNORM;
        case wgpu::VertexFormat::Sint8x2:
            return angle::FormatID::R8G8_SINT;
        case wgpu::VertexFormat::Snorm8x2:
            return angle::FormatID::R8G8_SNORM;
        case wgpu::VertexFormat::Uint8x2:
            return angle::FormatID::R8G8_UINT;
        case wgpu::VertexFormat::Unorm8x2:
            return angle::FormatID::R8G8_UNORM;

        default:
            UNREACHABLE();
            return angle::FormatID::NONE;
    }
}
}  // namespace webgpu
}  // namespace rx
