/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ssgui
extends JFrame {
    private static final String ssstats = "files/ssstats.csv";
    private static final String ssindex = "files/ss_index.mat";
    private static final String all_kinds = "(all kinds)";
    private static final String all_groups = "(all groups)";
    private static final int K = 1024;
    private static final int M = 0x100000;
    private static final int buffersize = 1024;
    private static final int MSEC_PER_DAY = 86400000;
    private static long INF = Long.MAX_VALUE;
    private long refresh;
    private int nselected;
    private int[] download_ids = null;
    private boolean gui_ready = false;
    private boolean downloading = false;
    private boolean cancel = false;
    private boolean get_icons;
    private boolean debug = false;
    private matrix_Table_Model matrix_model = null;
    private File mat;
    private File MM;
    private File RB;
    private File iconDir;
    private String[] Kinds;
    private String[] Groups;
    private Object[][] Stats;
    private Date today;
    private Date last_download;
    private static String ftemp_name = null;
    private static BufferedOutputStream ftemp_out = null;
    private static BufferedInputStream url_in = null;
    private static BufferedReader in_reader = null;
    private static PrintWriter print_out = null;
    private static String sssite;
    private static String ssarchive;
    private static String proxy_server;
    private static String proxy_port;
    private JTable matrix_Table;
    private JButton download_Button;
    private JButton cancel_Button;
    private JTextField minrow_Field;
    private JTextField maxrow_Field;
    private JTextField mincol_Field;
    private JTextField maxcol_Field;
    private JTextField minnentries_Field;
    private JTextField maxnentries_Field;
    private JTextField minpsym_Field;
    private JTextField maxpsym_Field;
    private JTextField minnsym_Field;
    private JTextField maxnsym_Field;
    private JRadioButton posdef_yes_Button;
    private JRadioButton posdef_no_Button;
    private JRadioButton posdef_either_Button;
    private JRadioButton nd_yes_Button;
    private JRadioButton nd_no_Button;
    private JRadioButton nd_either_Button;
    private JRadioButton real_yes_Button;
    private JRadioButton real_no_Button;
    private JRadioButton real_either_Button;
    private JRadioButton shape_square_Button;
    private JRadioButton shape_rect_Button;
    private JRadioButton shape_either_Button;
    private JLabel nselected_Label;
    private JLabel progress_size_Label;
    private JLabel icon_Label;
    private JCheckBox format_mat_Button;
    private JCheckBox format_mm_Button;
    private JCheckBox format_rb_Button;
    private JProgressBar progress1_Bar;
    private JProgressBar progress2_Bar;
    private JFileChooser chooser;
    private JList Group_List;
    private JList Kind_List;
    protected String[] matrix_column_tooltips = new String[]{"Click to select a matrix.  This is the only column you can edit.", "'x' if MAT format already downloaded", "'x' if MM format already downloaded", "'x' if RB format already downloaded", "matrix id", "matrix group (typically a person or organization)", "matrix name (full name is Group/Name)", "# of rows in the matrix", "# of columns in the matrix", "# of entries in the matrix (both nonzeros and explicit zeros)", "if the matrix is real (not complex)", "if the matrix is binary", "if the matrix arises from a 2D/3D discretization", "if the matrix is symmetric positive definite", "symmetry of pattern (0: none, 1: pattern(A)=pattern(A')", "symmetry of nonzero values (0: none, 1: A=A'", "the matrix 'kind' is the problem domain from which it arises"};
    public boolean fire_status = true;

    private ssgui() {
        Font font = new Font("SansSerif", 0, 12);
        final Font font2 = new Font("SansSerif", 0, 10);
        this.today = new Date();
        this.last_download = new Date();
        ssarchive = "";
        sssite = "https://sparse.tamu.edu";
        this.refresh = 30L;
        proxy_server = "";
        proxy_port = "";
        if (proxy_server.length() > 0) {
            if (proxy_port.length() == 0) {
                proxy_port = "80";
            }
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", proxy_server);
            System.setProperty("http.proxyPort", proxy_port);
        }
        if (ssarchive.length() == 0) {
            ssarchive = System.getProperty("user.dir");
        }
        ssarchive = ssarchive.replace('\\', File.separatorChar);
        char c = (ssarchive = ssarchive.replace('/', File.separatorChar)).charAt(ssarchive.length() - 1);
        if (c != File.separatorChar) {
            ssarchive = ssarchive + File.separatorChar;
        }
        if (this.debug) {
            System.out.println("");
            System.out.println("ssgui, debugging enabled.");
            System.out.println("local archive: [" + ssarchive + "]");
            System.out.println("ss url:        [" + sssite + "]");
            System.out.println("refresh:       [" + this.refresh + "]");
            System.out.println("proxy server:  [" + proxy_server + "]");
            System.out.println("proxy port:    [" + proxy_port + "]");
        }
        this.mat = this.CheckDir("mat");
        this.MM = this.CheckDir("MM");
        this.RB = this.CheckDir("RB");
        this.iconDir = this.CheckDir("files");
        this.Stats = this.load_ssstats();
        if (this.Stats == null || (this.today.getTime() - this.last_download.getTime()) / 86400000L > this.refresh) {
            this.Stats = this.download_matrix_stats();
            if (this.debug) {
                System.out.println("downloading new ssstats.csv file");
            }
        }
        if (this.Stats == null) {
            JOptionPane.showMessageDialog(this, "Download of matrix statistics file failed.", "Error", 0);
            System.exit(-1);
        }
        this.setTitle("ssgui: SuiteSparse Matrix Collection");
        this.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Select");
        JButton jButton2 = new JButton("Deselect");
        JButton jButton3 = new JButton("Reset criteria");
        JButton jButton4 = new JButton("Clear selections");
        JButton jButton5 = new JButton("Help");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        jButton.setToolTipText("Click to add matrices that fit the criteria to your selection.");
        jButton2.setToolTipText("Click to remove matrices that fit the criteria from your selection.");
        jButton3.setToolTipText("Click to reset criteria, above.  Prior selections, below, are not cleared.");
        jButton4.setToolTipText("Click to clear selections, below.  Criteria, above, is not reset).");
        jButton5.setToolTipText("For help, click here");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.make_selection(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.make_selection(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.reset_Button_action(actionEvent);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.clear_Button_action(actionEvent);
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.help_Button_action(actionEvent);
            }
        });
        JPanel jPanel2 = new JPanel();
        this.format_mat_Button = new JCheckBox("MATLAB (mat)");
        this.format_mm_Button = new JCheckBox("Matrix Market (MM)");
        this.format_rb_Button = new JCheckBox("Rutherford/Boeing (RB)    ");
        this.format_mat_Button.setSelected(true);
        this.format_mat_Button.setToolTipText("Download in MATLAB *.mat format.");
        this.format_mm_Button.setToolTipText("Download in Matrix Market.");
        this.format_rb_Button.setToolTipText("Download in Rutherford/Boeing format.");
        this.nselected = 0;
        this.nselected_Label = new JLabel();
        this.download_Button = new JButton("Download");
        jPanel2.add(this.download_Button);
        jPanel2.add(this.format_mat_Button);
        jPanel2.add(this.format_mm_Button);
        jPanel2.add(this.format_rb_Button);
        jPanel2.add(this.nselected_Label);
        jPanel2.setMaximumSize(new Dimension(0, 0));
        FlowLayout flowLayout = new FlowLayout(3);
        JPanel jPanel3 = new JPanel(flowLayout);
        this.cancel_Button = new JButton("Cancel");
        this.cancel_Button.setEnabled(false);
        this.progress1_Bar = new JProgressBar();
        this.progress2_Bar = new JProgressBar();
        this.progress_size_Label = new JLabel("");
        this.progress1_Bar.setMinimumSize(new Dimension(200, 16));
        this.progress2_Bar.setMinimumSize(new Dimension(200, 16));
        jPanel3.add(this.cancel_Button);
        jPanel3.add(new JLabel("   Overall progress:"));
        jPanel3.add(this.progress1_Bar);
        jPanel3.add(new JLabel("   Current file:"));
        jPanel3.add(this.progress2_Bar);
        jPanel3.add(this.progress_size_Label);
        jPanel3.setMaximumSize(new Dimension(0, 0));
        this.cancel_Button.setToolTipText("No downloads in progress.");
        this.download_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.download_Button_action(actionEvent);
            }
        });
        this.cancel_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.cancel_Button_action(actionEvent);
            }
        });
        JPanel jPanel4 = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel4);
        jPanel4.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(false);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel2).addComponent(jPanel3));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jPanel2).addComponent(jPanel3));
        jPanel4.setBorder(BorderFactory.createTitledBorder("download"));
        jPanel4.setMaximumSize(new Dimension(0, 0));
        this.minrow_Field = new JTextField("");
        JLabel jLabel = new JLabel(" \u2264 number of rows \u2264 ");
        this.maxrow_Field = new JTextField("");
        this.minrow_Field.setColumns(16);
        this.maxrow_Field.setColumns(16);
        this.minrow_Field.setToolTipText("Leave blank for 'zero'.");
        this.maxrow_Field.setToolTipText("Leave blank for 'infinite'.");
        this.minrow_Field.setMinimumSize(new Dimension(120, 0));
        this.maxrow_Field.setMinimumSize(new Dimension(120, 0));
        this.mincol_Field = new JTextField("");
        JLabel jLabel2 = new JLabel(" \u2264 number of columns \u2264 ");
        this.maxcol_Field = new JTextField("");
        this.mincol_Field.setColumns(16);
        this.maxcol_Field.setColumns(16);
        this.mincol_Field.setToolTipText("Leave blank for 'zero'.");
        this.maxcol_Field.setToolTipText("Leave blank for 'infinite'.");
        this.mincol_Field.setMinimumSize(new Dimension(120, 0));
        this.maxcol_Field.setMinimumSize(new Dimension(120, 0));
        this.minnentries_Field = new JTextField("");
        JLabel jLabel3 = new JLabel(" \u2264 number of entries \u2264 ");
        this.maxnentries_Field = new JTextField("");
        this.minnentries_Field.setColumns(16);
        this.maxnentries_Field.setColumns(16);
        this.minnentries_Field.setToolTipText("Leave blank for 'zero'.");
        this.maxnentries_Field.setToolTipText("Leave blank for 'infinite'.");
        this.minnentries_Field.setMinimumSize(new Dimension(120, 0));
        this.maxnentries_Field.setMinimumSize(new Dimension(120, 0));
        this.minpsym_Field = new JTextField("0.0");
        JLabel jLabel4 = new JLabel(" \u2264 pattern symmetry \u2264 ");
        this.maxpsym_Field = new JTextField("1.0");
        this.minpsym_Field.setColumns(16);
        this.maxpsym_Field.setColumns(16);
        this.maxpsym_Field.setToolTipText("Refers to position of entries, not their values.\n1 = perfectly symmetric pattern, 0 = perfectly unsymmetric pattern.");
        this.minpsym_Field.setMinimumSize(new Dimension(120, 0));
        this.maxpsym_Field.setMinimumSize(new Dimension(120, 0));
        this.minnsym_Field = new JTextField("0.0");
        JLabel jLabel5 = new JLabel(" \u2264 numerical symmetry \u2264 ");
        this.maxnsym_Field = new JTextField("1.0");
        this.minnsym_Field.setColumns(16);
        this.maxnsym_Field.setColumns(16);
        this.maxnsym_Field.setToolTipText("1 means A=A', 0 means no nonzero entry A(i,j) = A(j,i).");
        this.minnsym_Field.setMinimumSize(new Dimension(120, 0));
        this.maxnsym_Field.setMinimumSize(new Dimension(120, 0));
        JPanel jPanel5 = new JPanel();
        GroupLayout groupLayout2 = new GroupLayout(jPanel5);
        jPanel5.setLayout(groupLayout2);
        groupLayout2.setAutoCreateGaps(false);
        groupLayout2.setAutoCreateContainerGaps(false);
        groupLayout2.setHorizontalGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minrow_Field).addComponent(this.mincol_Field).addComponent(this.minnentries_Field).addComponent(this.minpsym_Field).addComponent(this.minnsym_Field)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel4).addComponent(jLabel5)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxrow_Field).addComponent(this.maxcol_Field).addComponent(this.maxnentries_Field).addComponent(this.maxpsym_Field).addComponent(this.maxnsym_Field)));
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minrow_Field).addComponent(jLabel).addComponent(this.maxrow_Field)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mincol_Field).addComponent(jLabel2).addComponent(this.maxcol_Field)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minnentries_Field).addComponent(jLabel3).addComponent(this.maxnentries_Field)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minpsym_Field).addComponent(jLabel4).addComponent(this.maxpsym_Field)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minnsym_Field).addComponent(jLabel5).addComponent(this.maxnsym_Field)));
        jPanel5.setMaximumSize(new Dimension(0, 0));
        JLabel jLabel6 = new JLabel("shape ");
        this.shape_square_Button = new JRadioButton("square   ");
        this.shape_rect_Button = new JRadioButton("rectangular   ");
        this.shape_either_Button = new JRadioButton("either   ");
        this.shape_either_Button.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.shape_square_Button);
        buttonGroup.add(this.shape_rect_Button);
        buttonGroup.add(this.shape_either_Button);
        this.shape_square_Button.setToolTipText("Select 'yes' for square matrices.");
        this.shape_rect_Button.setToolTipText("Select 'no' for rectangular matrices only.");
        this.shape_either_Button.setToolTipText("Select 'either' for any matrix.");
        JLabel jLabel7 = new JLabel("positive definite? ");
        this.posdef_yes_Button = new JRadioButton("yes");
        this.posdef_no_Button = new JRadioButton("no");
        this.posdef_either_Button = new JRadioButton("either");
        this.posdef_either_Button.setSelected(true);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.posdef_yes_Button);
        buttonGroup2.add(this.posdef_no_Button);
        buttonGroup2.add(this.posdef_either_Button);
        this.posdef_yes_Button.setToolTipText("Select 'yes' for symmetric positive definite matrices only.");
        this.posdef_no_Button.setToolTipText("Select 'no' for non-positive definite matrices only.");
        this.posdef_either_Button.setToolTipText("Select 'either' for any matrix.");
        JLabel jLabel8 = new JLabel("2D/3D discretization?    ");
        this.nd_yes_Button = new JRadioButton("yes");
        this.nd_no_Button = new JRadioButton("no");
        this.nd_either_Button = new JRadioButton("either");
        this.nd_either_Button.setSelected(true);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.nd_yes_Button);
        buttonGroup3.add(this.nd_no_Button);
        buttonGroup3.add(this.nd_either_Button);
        this.nd_yes_Button.setToolTipText("Select 'yes' for matrices arising from 2D or 3D discretizations only.");
        this.nd_no_Button.setToolTipText("Select 'no' to exclude matrices arising from 2D or 3D discretizations.");
        this.nd_either_Button.setToolTipText("Select 'either' for any matrix.");
        JLabel jLabel9 = new JLabel("real or complex? ");
        this.real_yes_Button = new JRadioButton("real");
        this.real_no_Button = new JRadioButton("complex");
        this.real_either_Button = new JRadioButton("either");
        this.real_either_Button.setSelected(true);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.real_yes_Button);
        buttonGroup4.add(this.real_no_Button);
        buttonGroup4.add(this.real_either_Button);
        this.real_yes_Button.setToolTipText("Select 'real' for real matrices only (includes integer and binary).");
        this.real_no_Button.setToolTipText("Select 'complex' for complex matrices only.");
        this.real_either_Button.setToolTipText("Select 'either' for any matrix.");
        JPanel jPanel6 = new JPanel();
        GroupLayout groupLayout3 = new GroupLayout(jPanel6);
        jPanel6.setLayout(groupLayout3);
        groupLayout3.setAutoCreateGaps(false);
        groupLayout3.setAutoCreateContainerGaps(false);
        groupLayout3.setHorizontalGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel6).addComponent(jLabel7).addComponent(jLabel8).addComponent(jLabel9)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.shape_square_Button).addComponent(this.posdef_yes_Button).addComponent(this.nd_yes_Button).addComponent(this.real_yes_Button)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.shape_rect_Button).addComponent(this.posdef_no_Button).addComponent(this.nd_no_Button).addComponent(this.real_no_Button)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.shape_either_Button).addComponent(this.posdef_either_Button).addComponent(this.nd_either_Button).addComponent(this.real_either_Button)));
        groupLayout3.setVerticalGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel6).addComponent(this.shape_square_Button).addComponent(this.shape_rect_Button).addComponent(this.shape_either_Button)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel7).addComponent(this.posdef_yes_Button).addComponent(this.posdef_no_Button).addComponent(this.posdef_either_Button)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel8).addComponent(this.nd_yes_Button).addComponent(this.nd_no_Button).addComponent(this.nd_either_Button)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel9).addComponent(this.real_yes_Button).addComponent(this.real_no_Button).addComponent(this.real_either_Button)));
        jPanel6.setMaximumSize(new Dimension(0, 0));
        this.Kinds = this.FindKinds();
        this.Groups = this.FindGroups();
        this.Group_List = new JList<String>(this.Groups);
        this.Kind_List = new JList<String>(this.Kinds);
        JScrollPane jScrollPane = new JScrollPane(this.Group_List);
        JScrollPane jScrollPane2 = new JScrollPane(this.Kind_List);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("kind"));
        jScrollPane.setBorder(BorderFactory.createTitledBorder("group"));
        this.Group_List.setFont(font);
        this.Kind_List.setFont(font);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        this.Group_List.setVisibleRowCount(5);
        this.Kind_List.setVisibleRowCount(5);
        JPanel jPanel7 = new JPanel();
        GroupLayout groupLayout4 = new GroupLayout(jPanel7);
        jPanel7.setLayout(groupLayout4);
        groupLayout4.setAutoCreateGaps(true);
        groupLayout4.setAutoCreateContainerGaps(false);
        groupLayout4.setHorizontalGroup(groupLayout4.createSequentialGroup().addComponent(jScrollPane).addComponent(jScrollPane2));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane).addComponent(jScrollPane2));
        jPanel7.setMinimumSize(new Dimension(450, 150));
        JPanel jPanel8 = new JPanel();
        GroupLayout groupLayout5 = new GroupLayout(jPanel8);
        jPanel8.setLayout(groupLayout5);
        groupLayout5.setAutoCreateGaps(true);
        groupLayout5.setAutoCreateContainerGaps(false);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel5).addComponent(jPanel6).addComponent(jPanel7).addComponent(jPanel));
        groupLayout5.setVerticalGroup(groupLayout5.createSequentialGroup().addComponent(jPanel5).addComponent(jPanel6).addComponent(jPanel7).addComponent(jPanel));
        jPanel8.setBorder(BorderFactory.createTitledBorder("selection criteria"));
        jPanel8.setMaximumSize(new Dimension(0, 0));
        this.matrix_model = new matrix_Table_Model();
        this.matrix_Table = new JTable(this.matrix_model){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        Object var2_2 = null;
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return ssgui.this.matrix_column_tooltips[n2];
                    }
                };
            }
        };
        JTableHeader jTableHeader = this.matrix_Table.getTableHeader();
        final TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setFont(font2);
                return component;
            }
        });
        this.matrix_model.load_data(this.Stats);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Select highlighted matrices");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.popup_action(actionEvent, true);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Deselect highlighted matrices");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.popup_action(actionEvent, false);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Export selected matrices as CSV file");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.export_list_action(actionEvent, true);
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Export selected matrices as MATLAB *.m file");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ssgui.this.export_list_action(actionEvent, false);
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        this.matrix_Table.addMouseListener(new matrix_Table_PopupListener(jPopupMenu));
        int[] nArray = new int[]{40, 30, 25, 25, 38, 110, 150, 70, 70, 70, 40, 40, 40, 40, 50, 50, 200};
        TableColumn tableColumn = null;
        for (int i = 0; i < 17; ++i) {
            tableColumn = this.matrix_Table.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(nArray[i]);
        }
        this.matrix_Table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.matrix_Table.setFillsViewportHeight(true);
        this.matrix_Table.setAutoCreateRowSorter(true);
        this.matrix_Table.getSelectionModel().addListSelectionListener(new matrix_Table_RowListener());
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(4, SortOrder.ASCENDING));
        this.matrix_Table.getRowSorter().setSortKeys(arrayList);
        this.matrix_Table.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.matrix_Table);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder(ssarchive));
        this.icon_Label = new JLabel();
        this.icon_Label.setFont(font);
        this.icon_Label.setVerticalTextPosition(3);
        this.icon_Label.setHorizontalTextPosition(0);
        this.icon_Label.setBorder(BorderFactory.createTitledBorder("matrix icon"));
        this.update_icon("HB/west0479");
        JPanel jPanel9 = new JPanel();
        GroupLayout groupLayout6 = new GroupLayout(jPanel9);
        jPanel9.setLayout(groupLayout6);
        groupLayout6.setAutoCreateGaps(true);
        groupLayout6.setAutoCreateContainerGaps(false);
        groupLayout6.setHorizontalGroup(groupLayout6.createSequentialGroup().addComponent(jPanel8).addComponent(this.icon_Label));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel8).addComponent(this.icon_Label));
        jPanel9.setMaximumSize(new Dimension(0, 0));
        Container container = this.getContentPane();
        GroupLayout groupLayout7 = new GroupLayout(container);
        container.setLayout(groupLayout7);
        groupLayout7.setAutoCreateGaps(true);
        groupLayout7.setAutoCreateContainerGaps(false);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel9).addComponent(jScrollPane3).addComponent(jPanel4));
        groupLayout7.setVerticalGroup(groupLayout7.createSequentialGroup().addComponent(jPanel9).addComponent(jScrollPane3).addComponent(jPanel4));
        this.setSize(1100, 750);
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(2);
        this.gui_ready = true;
        this.set_selected_label(true);
        this.get_all_icons();
    }

    private String yes_no(int n) {
        if (n < 0) {
            return "?";
        }
        if (n == 0) {
            return "no";
        }
        return "yes";
    }

    private int ternary(String string) {
        long l = Long.parseLong(string);
        if (l < 0L) {
            return -1;
        }
        if (l == 0L) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] load_ssstats() {
        if (this.debug) {
            System.out.println("reading ssstats.csv file");
        }
        Object[][] objectArray = null;
        int n = 0;
        in_reader = null;
        try {
            in_reader = new BufferedReader(new FileReader(ssgui.fix_name(ssstats)));
            n = Integer.parseInt(in_reader.readLine());
            String string = in_reader.readLine();
            this.last_download = new Date(new File(ssgui.fix_name(ssstats)).lastModified());
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("reading ssstats.csv file failed");
            }
            return null;
        }
        try {
            objectArray = new Object[n][13];
            for (int i = 1; i <= n; ++i) {
                String[] stringArray = in_reader.readLine().split(",");
                objectArray[i - 1][0] = i;
                objectArray[i - 1][1] = stringArray[0];
                objectArray[i - 1][2] = stringArray[1];
                objectArray[i - 1][3] = Long.parseLong(stringArray[2]);
                objectArray[i - 1][4] = Long.parseLong(stringArray[3]);
                objectArray[i - 1][5] = Long.parseLong(stringArray[12]);
                objectArray[i - 1][6] = this.ternary(stringArray[5]);
                objectArray[i - 1][7] = this.ternary(stringArray[6]);
                objectArray[i - 1][8] = this.ternary(stringArray[7]);
                objectArray[i - 1][9] = this.ternary(stringArray[8]);
                objectArray[i - 1][10] = Double.parseDouble(stringArray[9]);
                objectArray[i - 1][11] = Double.parseDouble(stringArray[10]);
                objectArray[i - 1][12] = stringArray[11];
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("reading ssstats.csv file failed");
            }
            Object[][] objectArray2 = null;
            return objectArray2;
        }
        finally {
            ssgui.close_reader(in_reader);
        }
        return objectArray;
    }

    public void fire_updates(boolean bl) {
        this.fire_status = bl;
        if (bl) {
            this.set_table_value(this.get_table_value(1, 0), 1, 0);
        }
    }

    private Object get_table_value(int n, int n2) {
        int n3 = this.matrix_Table.convertRowIndexToView(n - 1);
        return this.matrix_Table.getValueAt(n3, n2);
    }

    private void set_table_value(Object object, int n, int n2) {
        int n3 = this.matrix_Table.convertRowIndexToView(n - 1);
        this.matrix_Table.setValueAt(object, n3, n2);
    }

    private int[] get_highlighted_ids() {
        int[] nArray = this.matrix_Table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = nArray[i];
            nArray[i] = n = 1 + this.matrix_Table.convertRowIndexToModel(n2);
        }
        return nArray;
    }

    private int[] get_download_ids() {
        this.nselected = 0;
        for (int i = 0; i < this.Stats.length; ++i) {
            if (!((Boolean)this.matrix_Table.getValueAt(i, 0)).booleanValue()) continue;
            ++this.nselected;
        }
        int[] nArray = new int[this.nselected];
        int n = 0;
        for (int i = 0; i < this.Stats.length; ++i) {
            if (!((Boolean)this.matrix_Table.getValueAt(i, 0)).booleanValue()) continue;
            int n2 = 1 + this.matrix_Table.convertRowIndexToModel(i);
            nArray[n++] = n2;
        }
        return nArray;
    }

    private void set_selected_label(boolean bl) {
        if (this.gui_ready) {
            this.nselected_Label.setText("   Matrices selected: " + this.nselected + "   ");
            this.download_Button.setEnabled(bl);
            if (bl) {
                if (this.nselected == 0) {
                    this.download_Button.setToolTipText("No matrices have been selected for download");
                } else if (this.nselected == 1) {
                    this.download_Button.setToolTipText("Click to download the single selected matrix");
                } else {
                    this.download_Button.setToolTipText("Click to download the " + this.nselected + " selected matrices");
                }
            } else {
                this.download_Button.setToolTipText("Download in progress.");
            }
        }
    }

    private void show_highlighted_icon() {
        int[] nArray = this.get_highlighted_ids();
        int n = nArray.length;
        if (n > 0) {
            int n2 = nArray[n - 1];
            String string = (String)this.Stats[n2 - 1][1];
            String string2 = (String)this.Stats[n2 - 1][2];
            this.update_icon(string + "/" + string2);
        }
    }

    private String[] FindKinds() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(all_kinds);
        for (int i = 1; i <= this.Stats.length; ++i) {
            treeSet.add(this.SimplifyKind((String)this.Stats[i - 1][12]));
        }
        return treeSet.toArray(new String[0]);
    }

    private String[] FindGroups() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(all_groups);
        for (int i = 1; i <= this.Stats.length; ++i) {
            treeSet.add((String)this.Stats[i - 1][1]);
        }
        return treeSet.toArray(new String[0]);
    }

    private String SimplifyKind(String string) {
        String string2 = null;
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("subsequent") || stringArray[i].equals("sequence") || stringArray[i].equals("problem") || stringArray[i].equals("duplicate")) continue;
            string2 = string2 == null ? stringArray[i] : string2 + " " + stringArray[i];
        }
        return string2;
    }

    private File CheckDir(String string) {
        File file = new File(ssgui.fix_name(string));
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    private void CheckExistence() {
        this.fire_updates(false);
        for (int i = 1; i <= this.Stats.length; ++i) {
            this.CheckExistence(i);
        }
        this.fire_updates(true);
    }

    private boolean[] CheckExistence(int n) {
        int n2;
        boolean[] blArray = new boolean[4];
        boolean[] blArray2 = new boolean[3];
        String string = (String)this.Stats[n - 1][1];
        String string2 = (String)this.Stats[n - 1][2];
        for (n2 = 0; n2 < 3; ++n2) {
            blArray2[n2] = ((String)this.get_table_value(n, n2 + 1)).charAt(0) == 'x';
        }
        for (n2 = 0; n2 < 4; ++n2) {
            blArray[n2] = false;
        }
        File file = new File(this.mat, string);
        if (file.isDirectory() && new File(file, string2 + ".mat").exists()) {
            blArray[0] = true;
        }
        if ((file = new File(this.MM, string)).isDirectory() && new File(file, string2 + ".tar.gz").exists()) {
            blArray[1] = true;
        }
        if ((file = new File(this.RB, string)).isDirectory() && new File(file, string2 + ".tar.gz").exists()) {
            blArray[2] = true;
        }
        if ((file = new File(this.iconDir, string)).isDirectory() && new File(file, string2 + ".png").exists()) {
            blArray[3] = true;
        }
        for (int i = 0; i < 3; ++i) {
            if (blArray2[i] == blArray[i]) continue;
            this.set_table_value(blArray[i] ? "x" : "-", n, i + 1);
        }
        return blArray;
    }

    private long getLong(JTextField jTextField, long l) {
        String string = jTextField.getText();
        long l2 = l;
        if (string.length() > 0) {
            try {
                l2 = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l2;
    }

    private double getDouble(JTextField jTextField, double d) {
        String string = jTextField.getText();
        double d2 = d;
        if (string.length() > 0) {
            try {
                d2 = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d2;
    }

    private void please_wait() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void the_long_wait_is_over() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void make_selection(boolean bl) {
        int n;
        this.please_wait();
        this.fire_updates(false);
        long l = this.getLong(this.minrow_Field, 0L);
        long l2 = this.getLong(this.maxrow_Field, INF);
        long l3 = this.getLong(this.mincol_Field, 0L);
        long l4 = this.getLong(this.maxcol_Field, INF);
        long l5 = this.getLong(this.minnentries_Field, 0L);
        long l6 = this.getLong(this.maxnentries_Field, INF);
        double d = this.getDouble(this.minpsym_Field, 0.0);
        double d2 = this.getDouble(this.maxpsym_Field, 1.0);
        double d3 = this.getDouble(this.minnsym_Field, 0.0);
        double d4 = this.getDouble(this.maxnsym_Field, 1.0);
        boolean bl2 = this.shape_square_Button.isSelected();
        boolean bl3 = this.shape_rect_Button.isSelected();
        boolean bl4 = this.shape_either_Button.isSelected();
        boolean bl5 = this.posdef_yes_Button.isSelected();
        boolean bl6 = this.posdef_no_Button.isSelected();
        boolean bl7 = this.posdef_either_Button.isSelected();
        boolean bl8 = this.nd_yes_Button.isSelected();
        boolean bl9 = this.nd_no_Button.isSelected();
        boolean bl10 = this.nd_either_Button.isSelected();
        boolean bl11 = this.real_yes_Button.isSelected();
        boolean bl12 = this.real_no_Button.isSelected();
        boolean bl13 = this.real_either_Button.isSelected();
        HashSet<String> hashSet = null;
        Object[] objectArray = this.Group_List.getSelectedValuesList().toArray();
        int n2 = objectArray.length;
        if (n2 > 0) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!((String)objectArray[n3]).equals(all_groups)) continue;
                n2 = 0;
            }
            hashSet = new HashSet<String>();
            for (n3 = 0; n3 < n2; ++n3) {
                hashSet.add((String)objectArray[n3]);
                if (!this.debug) continue;
                System.out.println("Group: " + (String)objectArray[n3]);
            }
        }
        HashSet<String> hashSet2 = null;
        Object[] objectArray2 = this.Kind_List.getSelectedValuesList().toArray();
        int n4 = objectArray2.length;
        if (n4 > 0) {
            for (n = 0; n < n4; ++n) {
                if (!((String)objectArray2[n]).equals(all_kinds)) continue;
                n4 = 0;
            }
            hashSet2 = new HashSet<String>();
            for (n = 0; n < n4; ++n) {
                hashSet2.add((String)objectArray2[n]);
                if (!this.debug) continue;
                System.out.println("Kind: " + (String)objectArray2[n]);
            }
        }
        for (n = 1; n <= this.Stats.length; ++n) {
            long l7 = (Long)this.Stats[n - 1][3];
            long l8 = (Long)this.Stats[n - 1][4];
            long l9 = (Long)this.Stats[n - 1][5];
            int n5 = (Integer)this.Stats[n - 1][6];
            int n6 = (Integer)this.Stats[n - 1][7];
            int n7 = (Integer)this.Stats[n - 1][8];
            int n8 = (Integer)this.Stats[n - 1][9];
            double d5 = (Double)this.Stats[n - 1][10];
            double d6 = (Double)this.Stats[n - 1][11];
            boolean bl14 = true;
            if (n2 > 0) {
                String string = (String)this.Stats[n - 1][1];
                bl14 = hashSet.contains(string);
            }
            boolean bl15 = true;
            if (n4 > 0) {
                String string = this.SimplifyKind((String)this.Stats[n - 1][12]);
                bl15 = hashSet2.contains(string);
            }
            if (l > l7 || l7 > l2 || l3 > l8 || l8 > l4 || l5 > l9 || l9 > l6 || !(d <= d5) || !(d5 <= d2) || !(d3 <= d6) || !(d6 <= d4) || !bl7 && (!bl5 || n8 != 1) && (!bl6 || n8 != 0) || !bl10 && (!bl8 || n7 != 1) && (!bl9 || n7 != 0) || !bl13 && (!bl11 || n5 != 1) && (!bl12 || n5 != 0) || !bl4 && (!bl2 || l7 != l8) && (!bl3 || l7 == l8) || !bl14 || !bl15) continue;
            this.set_table_value(bl, n, 0);
        }
        this.fire_updates(true);
        this.progress1_Bar.setValue(0);
        this.progress2_Bar.setValue(0);
        this.the_long_wait_is_over();
    }

    private void reset_Button_action(ActionEvent actionEvent) {
        this.minrow_Field.setText("");
        this.maxrow_Field.setText("");
        this.mincol_Field.setText("");
        this.maxcol_Field.setText("");
        this.minnentries_Field.setText("");
        this.maxnentries_Field.setText("");
        this.minpsym_Field.setText("0.0");
        this.maxpsym_Field.setText("1.0");
        this.minnsym_Field.setText("0.0");
        this.maxnsym_Field.setText("1.0");
        this.shape_either_Button.setSelected(true);
        this.posdef_either_Button.setSelected(true);
        this.nd_either_Button.setSelected(true);
        this.real_either_Button.setSelected(true);
        this.Group_List.clearSelection();
        this.Kind_List.clearSelection();
        this.progress1_Bar.setValue(0);
        this.progress2_Bar.setValue(0);
    }

    private void clear_Button_action(ActionEvent actionEvent) {
        this.please_wait();
        this.fire_updates(false);
        for (int i = 1; i <= this.Stats.length; ++i) {
            this.set_table_value(false, i, 0);
        }
        this.fire_updates(true);
        this.progress1_Bar.setValue(0);
        this.progress2_Bar.setValue(0);
        this.the_long_wait_is_over();
    }

    private void popup_action(ActionEvent actionEvent, boolean bl) {
        this.please_wait();
        int[] nArray = this.get_highlighted_ids();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.set_table_value(bl, nArray[i], 0);
        }
        this.the_long_wait_is_over();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export_list_action(ActionEvent actionEvent, boolean bl) {
        if (this.chooser.showSaveDialog(this) == 0) {
            this.please_wait();
            print_out = null;
            try {
                print_out = new PrintWriter(this.chooser.getSelectedFile());
                int[] nArray = this.get_download_ids();
                int n = nArray.length;
                if (bl) {
                    print_out.println("mat, MM, RB, id, Group, Name, rows, cols, entries, real, binary, 2D/3D, posdef, psym, nsym, kind");
                } else {
                    print_out.println("%% Matrices selected from ssgui:");
                    print_out.println("% Example usage:");
                    print_out.println("% for k = 1:length(ids)");
                    print_out.println("%    Problem = ssget (ids (k))");
                    print_out.println("% end");
                    print_out.println("ids = [");
                }
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray[i];
                    boolean[] blArray = this.CheckExistence(n2);
                    String string = (String)this.Stats[n2 - 1][1];
                    String string2 = (String)this.Stats[n2 - 1][2];
                    long l = (Long)this.Stats[n2 - 1][3];
                    long l2 = (Long)this.Stats[n2 - 1][4];
                    long l3 = (Long)this.Stats[n2 - 1][5];
                    int n3 = (Integer)this.Stats[n2 - 1][6];
                    int n4 = (Integer)this.Stats[n2 - 1][7];
                    int n5 = (Integer)this.Stats[n2 - 1][8];
                    int n6 = (Integer)this.Stats[n2 - 1][9];
                    double d = (Double)this.Stats[n2 - 1][10];
                    double d2 = (Double)this.Stats[n2 - 1][11];
                    String string3 = (String)this.Stats[n2 - 1][12];
                    if (bl) {
                        print_out.println(blArray[0] + ", " + blArray[1] + ", " + blArray[2] + ", " + n2 + ", " + string + ", " + string2 + ", " + l + ", " + l2 + ", " + l3 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ", " + d + ", " + d2 + ", " + string3);
                        continue;
                    }
                    print_out.println(n2 + " % " + string + "/" + string2);
                }
                if (!bl) {
                    print_out.println("] ;");
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Export failed.", "Warning", 2);
            }
            finally {
                ssgui.close_printer_stream(print_out);
            }
            this.the_long_wait_is_over();
        }
    }

    private void help_Button_action(ActionEvent actionEvent) {
        this.please_wait();
        JFrame jFrame = new JFrame("Help: SuiteSparse Matrix Collection");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        URL uRL = ssgui.class.getResource("sshelp.html");
        if (uRL != null) {
            try {
                jEditorPane.setPage(uRL);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Sorry, Help document sshelp.html not found.", "Warning", 2);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
        this.the_long_wait_is_over();
    }

    private String icon_file(String string) {
        return "files/" + string + ".png";
    }

    private void update_icon(String string) {
        this.icon_Label.setText(string);
        ImageIcon imageIcon = new ImageIcon(ssgui.fix_name(this.icon_file(string)));
        if (imageIcon.getIconWidth() < 0) {
            imageIcon = new ImageIcon(this.get_url(sssite + "/" + this.icon_file(string)));
        }
        this.icon_Label.setIcon(imageIcon);
    }

    private void cancel_Button_action(ActionEvent actionEvent) {
        if (this.downloading && !this.cancel) {
            this.cancel = true;
            this.cancel_Button.setEnabled(false);
            this.cancel_Button.setToolTipText("canceling...");
        }
    }

    private void get_all_icons() {
        this.start_download_thread(0);
    }

    private void download_Button_action(ActionEvent actionEvent) {
        this.start_download_thread(2);
    }

    private void start_download_thread(int n) {
        if (!this.downloading) {
            this.downloading = true;
            this.cancel = false;
            if (this.gui_ready) {
                this.cancel_Button.setEnabled(true);
                this.cancel_Button.setToolTipText("Click to cancel the current download.");
            }
            if (n == 0) {
                this.get_icons = true;
                this.download_ids = null;
            } else {
                this.get_icons = false;
                this.download_ids = this.get_download_ids();
            }
            this.set_selected_label(false);
            ssdownload ssdownload2 = new ssdownload();
        }
    }

    private URL get_url(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, "Invalid URL: " + string, "Warning", 2);
            return null;
        }
    }

    private void download_file(String string) {
        Object object;
        URL uRL;
        boolean bl = true;
        if (this.cancel) {
            return;
        }
        String string2 = sssite + "/" + string;
        if (this.debug) {
            System.out.println("downloading: " + string2);
        }
        if ((uRL = this.get_url(string2)) == null) {
            return;
        }
        url_in = null;
        ftemp_out = null;
        ftemp_name = string + "_IN_PROGREss";
        int n = 1;
        try {
            int n2 = uRL.openConnection().getContentLength();
            if (this.gui_ready) {
                if (n2 < 0) {
                    this.progress2_Bar.setIndeterminate(true);
                    this.progress_size_Label.setText("");
                } else {
                    this.progress2_Bar.setValue(0);
                    if (n2 < 0x100000) {
                        n = 1 + n2 / 1024;
                        this.progress_size_Label.setText((n2 + 512) / 1024 + " KB");
                    } else {
                        n = 1 + n2 / 0x100000;
                        this.progress_size_Label.setText((n2 + 524288) / 0x100000 + " MB");
                    }
                }
                this.progress2_Bar.setMaximum(n);
            }
            url_in = new BufferedInputStream(uRL.openStream());
            ftemp_out = new BufferedOutputStream(new FileOutputStream(ssgui.fix_name(ftemp_name)), 1024);
            object = new byte[1024];
            long l = 0L;
            int n3 = 0;
            while (!this.cancel && (n3 = url_in.read((byte[])object, 0, 1024)) >= 0) {
                if (ftemp_out != null) {
                    ftemp_out.write((byte[])object, 0, n3);
                }
                l += (long)n3;
                if (!this.gui_ready || n2 <= 0) continue;
                if (n2 < 0x100000) {
                    this.progress2_Bar.setValue((int)(l / 1024L));
                    continue;
                }
                this.progress2_Bar.setValue((int)(l / 0x100000L));
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Download failed: " + string2, "Warning", 2);
            bl = false;
        }
        if (this.gui_ready) {
            this.progress2_Bar.setIndeterminate(false);
            this.progress2_Bar.setValue(n);
            this.progress_size_Label.setText("");
        }
        if (bl && !this.cancel) {
            ssgui.cleanup(false);
            File file = new File(ssgui.fix_name(ftemp_name));
            object = new File(ssgui.fix_name(string));
            file.renameTo((File)object);
        } else {
            ssgui.cleanup(true);
        }
    }

    private Object[][] download_matrix_stats() {
        this.download_file(ssindex);
        this.download_file(ssstats);
        return this.load_ssstats();
    }

    private static String fix_name(String string) {
        String string2 = ssarchive;
        if (string != null) {
            string2 = string2 + string;
        }
        return string2.replace('/', File.separatorChar);
    }

    private static void close_output(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void close_reader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void close_printer_stream(PrintWriter printWriter) {
        if (printWriter != null) {
            printWriter.close();
        }
    }

    private static void delete_file(String string) {
        File file;
        if (string != null && (file = new File(ssgui.fix_name(string))).exists()) {
            file.delete();
        }
    }

    private static void cleanup(boolean bl) {
        try {
            if (url_in != null) {
                url_in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        url_in = null;
        ssgui.close_output(ftemp_out);
        ftemp_out = null;
        if (bl) {
            ssgui.delete_file(ftemp_name);
            ftemp_name = null;
        }
        ssgui.close_printer_stream(print_out);
        ssgui.close_reader(in_reader);
    }

    public static void main(String[] stringArray) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ssgui.cleanup(true);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ssgui().setVisible(true);
            }
        });
    }

    private class ssdownload
    implements Runnable {
        public ssdownload() {
            Thread thread = new Thread(this);
            thread.start();
        }

        @Override
        public void run() {
            int n;
            if (ssgui.this.get_icons) {
                ssgui.this.progress1_Bar.setValue(1);
                ssgui.this.progress1_Bar.setMaximum(ssgui.this.Stats.length);
                ssgui.this.icon_Label.setBorder(BorderFactory.createTitledBorder("checking for new matrix icons"));
                for (n = 1; !ssgui.this.cancel && n <= ssgui.this.Stats.length; ++n) {
                    boolean[] blArray = ssgui.this.CheckExistence(n);
                    if (!blArray[3]) {
                        ssgui.this.icon_Label.setBorder(BorderFactory.createTitledBorder("downloading new matrix icons"));
                        String string = (String)ssgui.this.Stats[n - 1][1];
                        String string2 = (String)ssgui.this.Stats[n - 1][2];
                        String string3 = string + "/" + string2;
                        ssgui.this.CheckDir("files/" + string);
                        ssgui.this.download_file(ssgui.this.icon_file(string3));
                        ssgui.this.update_icon(string3);
                    }
                    ssgui.this.progress1_Bar.setValue(n + 2);
                }
                ssgui.this.progress1_Bar.setValue(ssgui.this.Stats.length);
                ssgui.this.icon_Label.setBorder(BorderFactory.createTitledBorder("matrix icon"));
            }
            if (ssgui.this.download_ids != null && ssgui.this.download_ids.length > 0) {
                int n2;
                int n3;
                n = ssgui.this.download_ids.length + 2;
                boolean bl = ssgui.this.format_mat_Button.isSelected();
                boolean bl2 = ssgui.this.format_mm_Button.isSelected();
                boolean bl3 = ssgui.this.format_rb_Button.isSelected();
                ssgui.this.progress1_Bar.setValue(1);
                ssgui.this.progress1_Bar.setMaximum(n);
                for (n3 = 0; !ssgui.this.cancel && n3 < ssgui.this.download_ids.length; ++n3) {
                    n2 = ssgui.this.download_ids[n3];
                    String string = (String)ssgui.this.Stats[n2 - 1][1];
                    String string4 = (String)ssgui.this.Stats[n2 - 1][2];
                    String string5 = string + "/" + string4;
                    boolean[] blArray = ssgui.this.CheckExistence(n2);
                    if (!blArray[3]) {
                        ssgui.this.CheckDir("files/" + string);
                        ssgui.this.download_file(ssgui.this.icon_file(string5));
                        ssgui.this.update_icon(string5);
                    }
                    if (!blArray[0] && bl) {
                        ssgui.this.update_icon(string5);
                        ssgui.this.CheckDir("mat/" + string);
                        ssgui.this.download_file("mat/" + string5 + ".mat");
                    }
                    if (!blArray[1] && bl2) {
                        ssgui.this.update_icon(string5);
                        ssgui.this.CheckDir("MM/" + string);
                        ssgui.this.download_file("MM/" + string5 + ".tar.gz");
                    }
                    if (!blArray[2] && bl3) {
                        ssgui.this.update_icon(string5);
                        ssgui.this.CheckDir("RB/" + string);
                        ssgui.this.download_file("RB/" + string5 + ".tar.gz");
                    }
                    ssgui.this.progress1_Bar.setValue(n3 + 2);
                }
                for (n3 = 0; n3 < ssgui.this.download_ids.length; ++n3) {
                    n2 = ssgui.this.download_ids[n3];
                    ssgui.this.CheckExistence(n2);
                }
                ssgui.this.progress1_Bar.setValue(n);
            }
            ssgui.this.cancel_Button.setEnabled(false);
            ssgui.this.cancel_Button.setToolTipText("No downloads in progress.");
            ssgui.this.set_selected_label(true);
            ssgui.this.cancel = false;
            ssgui.this.downloading = false;
        }
    }

    private class matrix_Table_RowListener
    implements ListSelectionListener {
        private matrix_Table_RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ssgui.this.show_highlighted_icon();
        }
    }

    private class matrix_Table_PopupListener
    extends MouseAdapter {
        JPopupMenu pop;

        matrix_Table_PopupListener(JPopupMenu jPopupMenu) {
            this.pop = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.pop.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class matrix_Table_Model
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"select", "mat", "MM", "RB", "id", "Group", "Name", "# rows", "# cols", "# entries", "real", "binary", "2D/3D", "posdef", "psym", "nsym", "kind"};
        private Object[][] data = null;

        matrix_Table_Model() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && ssgui.this.gui_ready && (Boolean)this.data[n][0] != object) {
                if (!((Boolean)object).booleanValue()) {
                    ssgui.this.nselected--;
                } else {
                    ssgui.this.nselected++;
                }
                ssgui.this.set_selected_label(ssgui.this.download_Button.isEnabled());
            }
            this.data[n][n2] = object;
            if (ssgui.this.fire_status) {
                this.fireTableDataChanged();
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void load_data(Object[][] objectArray) {
            this.data = new Object[objectArray.length][17];
            ssgui.this.nselected = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                this.data[i][0] = false;
                for (n = 1; n < 4; ++n) {
                    this.data[i][n] = "-";
                }
                for (n = 0; n < 13; ++n) {
                    if (n >= 6 && n <= 9) {
                        int n2 = (Integer)objectArray[i][n];
                        if (n2 < 0) {
                            this.data[i][n + 4] = " ?";
                            continue;
                        }
                        if (n2 == 0) {
                            this.data[i][n + 4] = " no";
                            continue;
                        }
                        this.data[i][n + 4] = " yes";
                        continue;
                    }
                    this.data[i][n + 4] = objectArray[i][n];
                }
            }
            this.fireTableDataChanged();
        }
    }
}

