RabbitMQ `3.9.11` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * When a TLS-enabled listener failed to stop, it logged all of its settings
   which could contain sensitive values.

   GitHub issue: [#3803](https://github.com/rabbitmq/rabbitmq-server/issues/3803)

#### Enhancements

 * Quorum queues now store commands for enqueued messages in a more compact format
   on disk (some derivative data has been dropped).

   GitHub issue: [#3804](https://github.com/rabbitmq/rabbitmq-server/pull/3804)

 * `queue.declare-ok` response to AMQP 0-9-1 clients operating on a stream could return a ready-for-delivery
   message count value that was out of sync with the stream leader replica.

   GitHub issue: [#3814](https://github.com/rabbitmq/rabbitmq-server/pull/3814)

 * Classic queues now deliver more efficiently on channels that had global QoS changed
   during consumer operation.

   Contributed by @tomyouyou.

   GitHub issue: [#3805](https://github.com/rabbitmq/rabbitmq-server/pull/3805)


### Prometheus Plugin

#### Enhancements

 * New optional metrics provided by the `GET /metrics/detailed` endpoint. These metrics are **cluster-wide**,
   and therefore must not be aggregated.

   GitHub issue: [#3779](https://github.com/rabbitmq/rabbitmq-server/pull/3779)


### Management Plugin

#### Bug Fixes

 * A help tip on the policies page was misplaced.

   Contributed by @johanrhodin

   GitHub issue: [#3825](https://github.com/rabbitmq/rabbitmq-server/pull/3825)


### Management Agent Plugin

#### Enhancements

 * Disabling the plugin will stop metric collection performed periodically by
   queues, streams, connections, et cetera.

   Contributed by @tomyouyou.

   GitHub issue: [#3800](https://github.com/rabbitmq/rabbitmq-server/pull/3800)



## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.11.tar.xz`
instead of the source tarball produced by GitHub.
