/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimationEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "WebKitAnimationEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitAnimationEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationEventTableValues[4] =
{
    { "animationName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEventAnimationName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "elapsedTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEventElapsedTime), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationEventTable = { 9, 7, JSWebKitAnimationEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationEventConstructorTable = { 1, 0, JSWebKitAnimationEventConstructorTableValues, 0 };
class JSWebKitAnimationEventConstructor : public DOMConstructorObject {
public:
    JSWebKitAnimationEventConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebKitAnimationEventConstructor::s_info = { "WebKitAnimationEventConstructor", &DOMConstructorObject::s_info, &JSWebKitAnimationEventConstructorTable, 0 };

JSWebKitAnimationEventConstructor::JSWebKitAnimationEventConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitAnimationEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitAnimationEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEventConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationEventConstructorTable, this, propertyName, slot);
}

bool JSWebKitAnimationEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationEventConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationEventPrototypeTableValues[2] =
{
    { "initWebKitAnimationEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent), (intptr_t)5 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationEventPrototypeTable = { 2, 1, JSWebKitAnimationEventPrototypeTableValues, 0 };
const ClassInfo JSWebKitAnimationEventPrototype::s_info = { "WebKitAnimationEventPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSWebKitAnimationEventPrototypeTable, 0 };

JSObject* JSWebKitAnimationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimationEvent>(exec, globalObject);
}

bool JSWebKitAnimationEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitAnimationEventPrototypeTable, this, propertyName, slot);
}

bool JSWebKitAnimationEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitAnimationEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebKitAnimationEvent::s_info = { "WebKitAnimationEvent", &JSEvent::s_info, &JSWebKitAnimationEventTable, 0 };

JSWebKitAnimationEvent::JSWebKitAnimationEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimationEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitAnimationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebKitAnimationEventPrototype(exec->globalData(), globalObject, JSWebKitAnimationEventPrototype::createStructure(exec->globalData(), JSEventPrototype::self(exec, globalObject)));
}

bool JSWebKitAnimationEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, this, propertyName, slot);
}

bool JSWebKitAnimationEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, this, propertyName, descriptor);
}

JSValue jsWebKitAnimationEventAnimationName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimationEvent* castedThis = static_cast<JSWebKitAnimationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->animationName());
    return result;
}


JSValue jsWebKitAnimationEventElapsedTime(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimationEvent* castedThis = static_cast<JSWebKitAnimationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    JSValue result = jsNumber(imp->elapsedTime());
    return result;
}


JSValue jsWebKitAnimationEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimationEvent* domObject = static_cast<JSWebKitAnimationEvent*>(asObject(slotBase));
    return JSWebKitAnimationEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebKitAnimationEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimationEvent::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimationEvent* castedThis = static_cast<JSWebKitAnimationEvent*>(asObject(thisValue));
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    const String& typeArg(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& animationNameArg(ustringToString(exec->argument(3).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double elapsedTimeArg(exec->argument(4).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->initWebKitAnimationEvent(typeArg, canBubbleArg, cancelableArg, animationNameArg, elapsedTimeArg);
    return JSValue::encode(jsUndefined());
}


}
