/* -*- Mode: C; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/***************************************************************************
 *
 * Copyright (C) 2008 Dan Williams, <dcbw@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 **************************************************************************/

#ifndef _IMPORT_EXPORT_H_
#define _IMPORT_EXPORT_H_

#include <glib.h>

#ifdef NM_OPENVPN_OLD
#include <nm-connection.h>
#else /* !NM_OPENVPN_OLD */
#include <NetworkManager.h>
#endif

extern const char *_nmovpn_test_temp_path;

gboolean _nmovpn_test_args_parse_line (const char *line,
                                       gsize line_len,
                                       const char ***out_p,
                                       char **out_error);

NMConnection *do_import (const char *path, const char *contents, gsize contents_len, GError **error);

gboolean do_export (const char *path, NMConnection *connection, GError **error);

#endif
