// |reftest| skip-if(!this.hasOwnProperty('BigInt')) -- BigInt is not enabled unconditionally
// Copyright (C) 2018 Caio Lima. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
description: Relational comparison of BigInt and boolean values
esid: sec-abstract-relational-comparison
features: [BigInt]
---*/
assert.sameValue(0n > false, false, 'The result of (0n > false) is false');
assert.sameValue(false > 0n, false, 'The result of (false > 0n) is false');
assert.sameValue(0n > true, false, 'The result of (0n > true) is false');
assert.sameValue(true > 0n, true, 'The result of (true > 0n) is true');
assert.sameValue(1n > false, true, 'The result of (1n > false) is true');
assert.sameValue(false > 1n, false, 'The result of (false > 1n) is false');
assert.sameValue(1n > true, false, 'The result of (1n > true) is false');
assert.sameValue(true > 1n, false, 'The result of (true > 1n) is false');
assert.sameValue(31n > true, true, 'The result of (31n > true) is true');
assert.sameValue(true > 31n, false, 'The result of (true > 31n) is false');
assert.sameValue(-3n > true, false, 'The result of (-3n > true) is false');
assert.sameValue(true > -3n, true, 'The result of (true > -3n) is true');
assert.sameValue(-3n > false, false, 'The result of (-3n > false) is false');
assert.sameValue(false > -3n, true, 'The result of (false > -3n) is true');
reportCompare(0, 0);
