/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from wlr-foreign-toplevel-management-unstable-v1.xml
 * To regenerate, run the “refresh-wayland-wrapper” target.
 */

#include "wlr-foreign-toplevel-management-unstable-v1_wrapper.h"

#include <boost/throw_exception.hpp>
#include <boost/exception/diagnostic_information.hpp>

#include <wayland-server-core.h>

#include "mir/log.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const wl_output_interface_data;
extern struct wl_interface const wl_seat_interface_data;
extern struct wl_interface const wl_surface_interface_data;
extern struct wl_interface const zwlr_foreign_toplevel_handle_v1_interface_data;
extern struct wl_interface const zwlr_foreign_toplevel_manager_v1_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// ForeignToplevelManagerV1

struct mw::ForeignToplevelManagerV1::Thunks
{
    static int const supported_version;

    static void stop_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelManagerV1*>(wl_resource_get_user_data(resource));
            me->stop();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelManagerV1::stop()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ForeignToplevelManagerV1*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<ForeignToplevelManagerV1::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &zwlr_foreign_toplevel_manager_v1_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelManagerV1 global bind");
        }
    }

    static struct wl_interface const* toplevel_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::ForeignToplevelManagerV1::Thunks::supported_version = 2;

mw::ForeignToplevelManagerV1::ForeignToplevelManagerV1(struct wl_resource* resource, Version<2>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::ForeignToplevelManagerV1::~ForeignToplevelManagerV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::ForeignToplevelManagerV1::send_toplevel_event(struct wl_resource* toplevel) const
{
    wl_resource_post_event(resource, Opcode::toplevel, toplevel);
}

void mw::ForeignToplevelManagerV1::send_finished_event() const
{
    wl_resource_post_event(resource, Opcode::finished);
}

bool mw::ForeignToplevelManagerV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwlr_foreign_toplevel_manager_v1_interface_data, Thunks::request_vtable);
}

void mw::ForeignToplevelManagerV1::destroy_and_delete() const
{
    // Will result in this object being deleted
    wl_resource_destroy(resource);
}

mw::ForeignToplevelManagerV1::Global::Global(wl_display* display, Version<2>)
    : wayland::Global{
          wl_global_create(
              display,
              &zwlr_foreign_toplevel_manager_v1_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::ForeignToplevelManagerV1::Global::interface_name() const -> char const*
{
    return ForeignToplevelManagerV1::interface_name;
}

struct wl_interface const* mw::ForeignToplevelManagerV1::Thunks::toplevel_types[] {
    &zwlr_foreign_toplevel_handle_v1_interface_data};

struct wl_message const mw::ForeignToplevelManagerV1::Thunks::request_messages[] {
    {"stop", "", all_null_types}};

struct wl_message const mw::ForeignToplevelManagerV1::Thunks::event_messages[] {
    {"toplevel", "n", toplevel_types},
    {"finished", "", all_null_types}};

void const* mw::ForeignToplevelManagerV1::Thunks::request_vtable[] {
    (void*)Thunks::stop_thunk};

mw::ForeignToplevelManagerV1* mw::ForeignToplevelManagerV1::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwlr_foreign_toplevel_manager_v1_interface_data, ForeignToplevelManagerV1::Thunks::request_vtable))
    {
        return static_cast<ForeignToplevelManagerV1*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

// ForeignToplevelHandleV1

struct mw::ForeignToplevelHandleV1::Thunks
{
    static int const supported_version;

    static void set_maximized_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->set_maximized();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::set_maximized()");
        }
    }

    static void unset_maximized_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->unset_maximized();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::unset_maximized()");
        }
    }

    static void set_minimized_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->set_minimized();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::set_minimized()");
        }
    }

    static void unset_minimized_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->unset_minimized();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::unset_minimized()");
        }
    }

    static void activate_thunk(struct wl_client* client, struct wl_resource* resource, struct wl_resource* seat)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->activate(seat);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::activate()");
        }
    }

    static void close_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->close();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::close()");
        }
    }

    static void set_rectangle_thunk(struct wl_client* client, struct wl_resource* resource, struct wl_resource* surface, int32_t x, int32_t y, int32_t width, int32_t height)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->set_rectangle(surface, x, y, width, height);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::set_rectangle()");
        }
    }

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::destroy()");
        }
    }

    static void set_fullscreen_thunk(struct wl_client* client, struct wl_resource* resource, struct wl_resource* output)
    {
        std::optional<struct wl_resource*> output_resolved;
        if (output != nullptr)
        {
            output_resolved = {output};
        }
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->set_fullscreen(output_resolved);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::set_fullscreen()");
        }
    }

    static void unset_fullscreen_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            auto me = static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
            me->unset_fullscreen();
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ForeignToplevelHandleV1::unset_fullscreen()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* activate_types[];
    static struct wl_interface const* set_rectangle_types[];
    static struct wl_interface const* set_fullscreen_types[];
    static struct wl_interface const* output_enter_types[];
    static struct wl_interface const* output_leave_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::ForeignToplevelHandleV1::Thunks::supported_version = 2;

mw::ForeignToplevelHandleV1::ForeignToplevelHandleV1(ForeignToplevelManagerV1 const& parent)
    : client{wl_resource_get_client(parent.resource)},
      resource{wl_resource_create(client, &zwlr_foreign_toplevel_handle_v1_interface_data, wl_resource_get_version(parent.resource), 0)}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::ForeignToplevelHandleV1::~ForeignToplevelHandleV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::ForeignToplevelHandleV1::send_title_event(std::string const& title) const
{
    const char* title_resolved = title.c_str();
    wl_resource_post_event(resource, Opcode::title, title_resolved);
}

void mw::ForeignToplevelHandleV1::send_app_id_event(std::string const& app_id) const
{
    const char* app_id_resolved = app_id.c_str();
    wl_resource_post_event(resource, Opcode::app_id, app_id_resolved);
}

void mw::ForeignToplevelHandleV1::send_output_enter_event(struct wl_resource* output) const
{
    wl_resource_post_event(resource, Opcode::output_enter, output);
}

void mw::ForeignToplevelHandleV1::send_output_leave_event(struct wl_resource* output) const
{
    wl_resource_post_event(resource, Opcode::output_leave, output);
}

void mw::ForeignToplevelHandleV1::send_state_event(struct wl_array* state) const
{
    wl_resource_post_event(resource, Opcode::state, state);
}

void mw::ForeignToplevelHandleV1::send_done_event() const
{
    wl_resource_post_event(resource, Opcode::done);
}

void mw::ForeignToplevelHandleV1::send_closed_event() const
{
    wl_resource_post_event(resource, Opcode::closed);
}

bool mw::ForeignToplevelHandleV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwlr_foreign_toplevel_handle_v1_interface_data, Thunks::request_vtable);
}

uint32_t const mw::ForeignToplevelHandleV1::State::maximized;
uint32_t const mw::ForeignToplevelHandleV1::State::minimized;
uint32_t const mw::ForeignToplevelHandleV1::State::activated;
uint32_t const mw::ForeignToplevelHandleV1::State::fullscreen;
uint32_t const mw::ForeignToplevelHandleV1::Error::invalid_rectangle;

struct wl_interface const* mw::ForeignToplevelHandleV1::Thunks::activate_types[] {
    &wl_seat_interface_data};

struct wl_interface const* mw::ForeignToplevelHandleV1::Thunks::set_rectangle_types[] {
    &wl_surface_interface_data,
    nullptr,
    nullptr,
    nullptr,
    nullptr};

struct wl_interface const* mw::ForeignToplevelHandleV1::Thunks::set_fullscreen_types[] {
    &wl_output_interface_data};

struct wl_interface const* mw::ForeignToplevelHandleV1::Thunks::output_enter_types[] {
    &wl_output_interface_data};

struct wl_interface const* mw::ForeignToplevelHandleV1::Thunks::output_leave_types[] {
    &wl_output_interface_data};

struct wl_message const mw::ForeignToplevelHandleV1::Thunks::request_messages[] {
    {"set_maximized", "", all_null_types},
    {"unset_maximized", "", all_null_types},
    {"set_minimized", "", all_null_types},
    {"unset_minimized", "", all_null_types},
    {"activate", "o", activate_types},
    {"close", "", all_null_types},
    {"set_rectangle", "oiiii", set_rectangle_types},
    {"destroy", "", all_null_types},
    {"set_fullscreen", "2?o", set_fullscreen_types},
    {"unset_fullscreen", "2", all_null_types}};

struct wl_message const mw::ForeignToplevelHandleV1::Thunks::event_messages[] {
    {"title", "s", all_null_types},
    {"app_id", "s", all_null_types},
    {"output_enter", "o", output_enter_types},
    {"output_leave", "o", output_leave_types},
    {"state", "a", all_null_types},
    {"done", "", all_null_types},
    {"closed", "", all_null_types}};

void const* mw::ForeignToplevelHandleV1::Thunks::request_vtable[] {
    (void*)Thunks::set_maximized_thunk,
    (void*)Thunks::unset_maximized_thunk,
    (void*)Thunks::set_minimized_thunk,
    (void*)Thunks::unset_minimized_thunk,
    (void*)Thunks::activate_thunk,
    (void*)Thunks::close_thunk,
    (void*)Thunks::set_rectangle_thunk,
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::set_fullscreen_thunk,
    (void*)Thunks::unset_fullscreen_thunk};

mw::ForeignToplevelHandleV1* mw::ForeignToplevelHandleV1::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwlr_foreign_toplevel_handle_v1_interface_data, ForeignToplevelHandleV1::Thunks::request_vtable))
    {
        return static_cast<ForeignToplevelHandleV1*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

namespace mir
{
namespace wayland
{

struct wl_interface const zwlr_foreign_toplevel_manager_v1_interface_data {
    mw::ForeignToplevelManagerV1::interface_name,
    mw::ForeignToplevelManagerV1::Thunks::supported_version,
    1, mw::ForeignToplevelManagerV1::Thunks::request_messages,
    2, mw::ForeignToplevelManagerV1::Thunks::event_messages};

struct wl_interface const zwlr_foreign_toplevel_handle_v1_interface_data {
    mw::ForeignToplevelHandleV1::interface_name,
    mw::ForeignToplevelHandleV1::Thunks::supported_version,
    10, mw::ForeignToplevelHandleV1::Thunks::request_messages,
    7, mw::ForeignToplevelHandleV1::Thunks::event_messages};

}
}
