const char *code =
"//The scripts for the tooltip and moveobj are based on work from\n"
"//SVG - Learning By Coding - http://www.datenverdrahten.de/svglbc/\n"
"//Author: Dr. Thomas Meinike 11/03 - thomas@handmadecode.de\n"
"var svgdoc,svgroot,paths,revert;\n"
"var collapsed = new Array(2);\n"
"var name = new Array(%i);\n"
"var clickStatus = new Array(%i);\n"
"var redCount = new Array(%i);\n"
"var salmonCount = new Array(%i);\n"
"var moveObj,rect,x,y,attr1,attr2,wert1,wert2,zoom=1,active=false;\n"
"\n"
"function MoveObj(evt)\n"
"{\n"
"    if (active) {\n"
"	var roundx, roundy;\n"
"	var curtrans=svgroot.currentTranslate;\n"
"	var ctx=curtrans.x;\n"
"	var cty=curtrans.y;\n"
"\n"
"	x=evt.clientX()\n"
"	y=evt.clientY()\n"
"	wert1=(x-ctx)*zoom*%.2f+%.2f+attr1-5;\n"
"	wert2=(y-cty)*zoom*%.2f+%.2f+attr2-5;\n"
"	roundx=Math.round(wert1*100)/100;\n"
"	roundy=Math.round(wert2*100)/100;\n"
"\n"
"	moveObj.setAttribute(\"transform\",\"translate(\"+roundx+\",\"+roundy+\")\");\n"
"    }\n"
"}\n"
"\n"
"function ClickObj(evt)\n"
"{\n"
"    rect=evt.target.parentNode.getElementsByTagName(\"rect\").item(0);\n"
"    moveObj=evt.target.parentNode;\n"
"    attr1=rect.getAttribute(\"width\")/2;\n"
"    attr2=rect.getAttribute(\"height\")/2;\n"
"    active=true;\n"
"}\n"
"\n"
"function OutOfObj(evt)\n"
"{\n"
"    if (active) {\n"
"	active=false;\n"
"	findAdjacentEdges();\n"
"    }\n"
"}\n"
"\n"
"function findAdjacentEdges()\n"
"{\n"
"    var rectl, rectlid, i, nodenames;\n"
"    rectl = rect;\n"
"    rectlid = rectl.getAttribute(\"id\");\n"
"    for (i=0; i<paths.length; i++) {\n"
"	nodenames = paths.item(i).getAttribute(\"id\").split(\"-\");\n"
"	if (nodenames[0] == rectlid || nodenames[1] == rectlid) {\n"
"	    repaintEdge(paths.item(i), nodenames, i);\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"function repaintEdge(edge, nodenames, j)\n"
"{\n"
"    var startnode, endnode, attr, i, k, l, m, alpha, beta;\n"
"    var nodesx, nodesy, nodeex, nodeey, nodesw, nodesh, nodeew, nodeeh;\n"
"    var edgesx, edgesy, edgeex, edgeey, sx, sy, ex, ey;\n"
"\n"
"    //extract node coordinates and dimensions\n"
"    startnode = svgdoc.getElementById(nodenames[0]);\n"
"    nodesw=startnode.getAttribute(\"width\");\n"
"    nodesh=startnode.getAttribute(\"height\");\n"
"    attr = startnode.parentNode.attributes;\n"
"    for (i=0;i<attr.length;i++) {\n"
"        if (attr.item(i).nodeName == \"transform\") {\n"
"	    k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"	    l = attr.item(i).nodeValue.indexOf(\",\");\n"
"	    m = attr.item(i).nodeValue.indexOf(\")\");\n"
"	    nodesx = parseFloat(attr.item(i).nodeValue.substring(k+1,l));\n"
"	    nodesy = parseFloat(attr.item(i).nodeValue.substring(l+1,m));\n"
"	}\n"
"    }\n"
"    endnode = svgdoc.getElementById(nodenames[1]);\n"
"    nodeew=endnode.getAttribute(\"width\");\n"
"    nodeeh=endnode.getAttribute(\"height\");\n"
"    attr = endnode.parentNode.attributes;\n"
"    for (i=0;i<attr.length;i++) {\n"
"        if (attr.item(i).nodeName == \"transform\") {\n"
"	    k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"	    l = attr.item(i).nodeValue.indexOf(\",\");\n"
"	    m = attr.item(i).nodeValue.indexOf(\")\");\n"
"	    nodeex = parseFloat(attr.item(i).nodeValue.substring(k+1,l));\n"
"	    nodeey = parseFloat(attr.item(i).nodeValue.substring(l+1,m));\n"
"	}\n"
"    }\n"
"\n"
"    alpha = Math.atan((nodesy-nodeey)/(nodesx-nodeex));\n"
"    if (alpha < 0)\n"
"	alpha += Math.PI;\n"
"\n"
"    //calculate intersection of edge and startNode\n"
"    beta = Math.atan(nodesh/nodesw);\n"
"    if (alpha < beta\n"
"	|| (alpha > Math.PI-beta && alpha < Math.PI+beta)\n"
"	|| alpha > 2*Math.PI-beta) {\n"
"	//intersection at left or right border\n"
"	if (nodesx < nodeex) {\n"
"	    edgesx = nodesx - 0 + nodesw/2;\n"
"	} else {\n"
"	    edgesx = nodesx - nodesw/2;\n"
"	}\n"
"	if (nodesy < nodeey) {\n"
"	    edgesy = nodesy - 0 + Math.abs(nodesw*Math.tan(alpha)/2);\n"
"	} else {\n"
"	    edgesy = nodesy - Math.abs(nodesw*Math.tan(alpha)/2);\n"
"	}\n"
"    } else {\n"
"	//intersection at top or bottom border\n"
"	if (nodesy < nodeey) {\n"
"	    edgesy = nodesy - 0 + nodesh/2;\n"
"	} else {\n"
"	    edgesy = nodesy - nodesh/2;\n"
"	}\n"
"	if (nodesx < nodeex) {\n"
"	    edgesx = nodesx - 0 + Math.abs(nodesh/(2*Math.tan(alpha)));\n"
"	} else {\n"
"	    edgesx = nodesx - Math.abs(nodesh/(2*Math.tan(alpha)));\n"
"	}\n"
"    }\n"
"\n"
"    //calculate intersection of edge and endNode\n"
"    beta = Math.atan(nodeeh/nodeew);\n"
"    if (alpha < beta\n"
"	|| (alpha > Math.PI-beta && alpha < Math.PI+beta)\n"
"	|| alpha > 2*Math.PI-beta) {\n"
"	//intersection at left or right border\n"
"	if (nodesx > nodeex) {\n"
"	    edgeex = nodeex - 0 + nodeew/2;\n"
"	} else {\n"
"	    edgeex = nodeex - nodeew/2;\n"
"	}\n"
"	if (nodesy > nodeey) {\n"
"	    edgeey = nodeey - 0 + Math.abs(nodeew*Math.tan(alpha)/2);\n"
"	} else {\n"
"	    edgeey = nodeey - Math.abs(nodeew*Math.tan(alpha)/2);\n"
"	}\n"
"    } else {\n"
"	//intersection at top or bottom border\n"
"	if (nodesy > nodeey) {\n"
"	    edgeey = nodeey - 0 + nodeeh/2;\n"
"	} else {\n"
"	    edgeey = nodeey - nodeeh/2;\n"
"	}\n"
"	if (nodesx > nodeex) {\n"
"	    edgeex = nodeex - 0 + Math.abs(nodeeh/(2*Math.tan(alpha)));\n"
"	} else {\n"
"	    edgeex = nodeex - Math.abs(nodeeh/(2*Math.tan(alpha)));\n"
"	}\n"
"    }\n"
"\n"
"    //set new edge coordinates\n"
"    sx=Math.round(edgesx*100)/100;\n"
"    ex=Math.round(edgeex*100)/100;\n"
"    sy=Math.round(edgesy*100)/100;\n"
"    ey=Math.round(edgeey*100)/100;\n"
"\n"
"    if (sx < ex) {\n"
"	if (revert[j] == 1) {\n"
"	    revert[j] = 0;\n"
"	    flipEdgeMarks(edge);\n"
"	}\n"
"	edge.setAttribute(\"d\",\"M \"+sx+\" \"+sy+\" \"+ex+\" \"+ey);\n"
"    } else {\n"
"	if (revert[j] == 0) {\n"
"	    revert[j] = 1;\n"
"	    flipEdgeMarks(edge);\n"
"	}\n"
"	edge.setAttribute(\"d\",\"M \"+ex+\" \"+ey+\" \"+sx+\" \"+sy);\n"
"    }\n"
"}\n"
"\n"
"function flipEdgeMarks(edge)\n"
"{\n"
"    var attr, i, j, done, textpaths, pathnamei, offset;\n"
"\n"
"    //revert start- and end-markers\n"
"    attr = edge.attributes;\n"
"    done = 0;\n"
"    for (i=0;i<attr.length;i++) {\n"
"        if (attr.item(i).nodeName == \"marker-start\") {\n"
"	    for (j=i;j<attr.length;j++) {\n"
"		if (attr.item(j).nodeName == \"marker-end\") {\n"
"		    done = 1;\n"
"		}\n"
"	    }\n"
"	    if (done == 0) {\n"
"		//start->end\n"
"		edge.removeAttribute(\"marker-start\");\n"
"		edge.setAttribute(\"marker-end\",\"url(#arrowend)\");\n"
"		break;\n"
"	    }\n"
"	}\n"
"        if (attr.item(i).nodeName == \"marker-end\") {\n"
"	    for (j=i;j<attr.length;j++) {\n"
"		if (attr.item(j).nodeName == \"marker-start\") {\n"
"		    done = 1;\n"
"		}\n"
"	    }\n"
"	    if (done == 0) {\n"
"		//end->start\n"
"		edge.removeAttribute(\"marker-end\");\n"
"		edge.setAttribute(\"marker-start\",\"url(#arrowstart)\");\n"
"		break;\n"
"	    }\n"
"	}\n"
"    }\n"
"\n"
"    //revert cardinalities\n"
"    textpaths = svgdoc.getElementsByTagName(\"textPath\");\n"
"    for (i=0;i<textpaths.length;i++) {\n"
"	pathname = textpaths.item(i).getAttribute(\"xlink:href\").replace(/#/,\"\");\n"
"	if (pathname == edge.getAttribute(\"id\")) {\n"
"	    offset = textpaths.item(i).getAttribute(\"startOffset\").substr(0,2);\n"
"	    textpaths.item(i).setAttribute(\"startOffset\",100 - offset + \"%\")\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"function getSVGDoc(load_evt)\n"
"{\n"
"    svgdoc=load_evt.target.ownerDocument;\n"
"    svgroot=svgdoc.documentElement;\n"
"    texte=svgdoc.getElementById(\"tooltip\").getElementsByTagName(\"text\");\n"
"    for (i=1; i<%i; i++) {\n"
"	textNode=texte.item(1).cloneNode(\"true\");\n"
"	svgdoc.getElementById(\"tooltip\").appendChild(textNode);\n"
"    }\n"
"    texte=svgdoc.getElementById(\"tooltip\").getElementsByTagName(\"text\");\n"
"}\n"
"\n"
"function ShowTooltipMZ(mousemove_event,txt)\n"
"{\n"
"    var ttrelem,tttelem,ttline,posx,posy,curtrans,ctx,cty,txt;\n"
"    var maxbreite,tmp,i;\n"
"    ttrelem=svgdoc.getElementById(\"ttr\");\n"
"    tttelem=svgdoc.getElementById(\"ttt\");\n"
"    ttline=svgdoc.getElementById(\"ttl\");\n"
"    posx=mousemove_event.clientX;\n"
"    posy=mousemove_event.clientY;\n"
"    for (i=1;i<=%i;i++)\n"
"	texte.item(i).firstChild.data=\"\";\n"
"    tttelem.childNodes.item(0).data=\"\";\n"
"    tmp=txt.split(\"\\n\");\n"
"    maxbreite=0;\n"
"    for (i=0;i<tmp.length;i++) {\n"
"	if (tmp[i]==\"\")\n"
"	    continue;\n"
"	tttelem.childNodes.item(0).data=tmp[i];\n"
"	if (maxbreite<tttelem.getComputedTextLength())\n"
"	    maxbreite=tttelem.getComputedTextLength();\n"
"    }\n"
"    curtrans=svgroot.currentTranslate;\n"
"    ctx=curtrans.x;\n"
"    cty=curtrans.y;\n"
"    ttrelem.setAttribute(\"x\",posx-ctx+10);\n"
"    ttrelem.setAttribute(\"y\",posy-cty-20+10);\n"
"    ttrelem.setAttribute(\"width\",maxbreite*0.92+10);\n"
"    ttrelem.setAttribute(\"height\",tmp.length*15+3);\n"
"    ttrelem.setAttribute(\"style\",\n"
"			    \"fill: #FFC; stroke: #000; stroke-width: 0.5px\");\n"
"    for (i=1; i<=tmp.length; i++) {\n"
"	if (tmp[i-1]==\"-- -- --\") {\n"
"	    ttline.setAttribute(\"x1\", posx-ctx+10);\n"
"	    ttline.setAttribute(\"y1\", parseInt(i-1)*15+posy-cty);\n"
"	    ttline.setAttribute(\"x2\", posx-ctx+10+maxbreite*0.92+10);\n"
"	    ttline.setAttribute(\"y2\", parseInt(i-1)*15+posy-cty);\n"
"	    ttline.setAttribute(\"style\", \"stroke: #000; stroke-width: 0.5px\");\n"
"	} else {\n"
"	    texte.item(i).firstChild.data=tmp[i-1];\n"
"	    texte.item(i).setAttribute(\"x\",posx-ctx+15);\n"
"	    texte.item(i).setAttribute(\"y\",parseInt(i-1)*15+posy-cty+3);\n"
"	    texte.item(i).setAttribute(\"style\",\"fill: #00E; font-size: 11px\");\n"
"	}\n"
"    }\n"
"    svgdoc.getElementById(\"tooltip\").style.setProperty(\"visibility\",\"visible\");\n"
"}\n"
"\n"
"function HideTooltip()\n"
"{\n"
"    svgdoc.getElementById(\"ttl\").style.setProperty(\"visibility\",\"hidden\");\n"
"    svgdoc.getElementById(\"tooltip\").style.setProperty(\"visibility\",\"hidden\");\n"
"}\n"
"\n"
"function ZoomControl()\n"
"{\n"
"    var curzoom;\n"
"    curzoom=svgroot.currentScale;\n"
"    svgdoc.getElementById(\"tooltip\").setAttribute(\"transform\",\n"
"							\"scale(\"+1/curzoom+\")\");\n"
"    zoom=1/curzoom;\n"
"}\n"
"\n"
"function collapse(evt)\n"
"{\n"
"    var i, k, l, m, svgdoc, obj, targetID, targetX, targetY, attr;\n"
"    obj = evt.getTarget();\n"
"    svgdoc = obj.ownerDocument;\n"
"    //extract coordinates and id of the clicked text\n"
"    attr = obj.parentNode.parentNode.attributes;\n"
"    for (i=0;i<attr.length;i++) {\n"
"        if (attr.item(i).nodeName == \"transform\") {\n"
"            k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"            l = attr.item(i).nodeValue.indexOf(\",\");\n"
"            m = attr.item(i).nodeValue.indexOf(\")\");\n"
"            targetX = attr.item(i).nodeValue.substring(k+1,l);\n"
"            targetY = attr.item(i).nodeValue.substring(l+1,m);\n"
"        }\n"
"        if (attr.item(i).nodeName == \"id\") {\n"
"            targetID = attr.item(i).nodeValue.substr(2);\n"
"        }\n"
"    }\n"
"    //decide if we are collapsing or uncollapsing\n"
"    if (collapsed[0][targetID] == 0) {\n"
"        hideInfos(evt, obj, svgdoc, targetX, targetY, targetID, attr);\n"
"        collapsed[0][targetID] = 1;\n"
"    } else {\n"
"        showHiddenInfos(evt, obj, svgdoc, targetX, targetY, targetID, attr);\n"
"        collapsed[0][targetID] = 0;\n"
"    }\n"
"}\n"
"\n"
"function showHiddenInfos(evt, obj, svgdoc, targetX, targetY, targetID, attr)\n"
"{\n"
"    var i, k, l, m, nextObj, nextX, nextY, gapY=0, clickedID;\n"
"    //change clicked text\n"
"    obj.firstChild.data=\"--\";\n"
"    targetID++;\n"
"    nextObj = svgdoc.getElementById(\"MI\"+targetID);\n"
"    if (nextObj == null)\n"
"        return;\n"
"    //show child texts again\n"
"    for (;;) {\n"
"        attr = nextObj.attributes;\n"
"        for (i=0;i<attr.length;i++) {\n"
"            if (attr.item(i).nodeName == \"transform\") {\n"
"                k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"                l = attr.item(i).nodeValue.indexOf(\",\");\n"
"                m = attr.item(i).nodeValue.indexOf(\")\");\n"
"                nextX = attr.item(i).nodeValue.substring(k+1,l);\n"
"                nextY = attr.item(i).nodeValue.substring(l+1,m);\n"
"            }\n"
"        }\n"
"        if (nextX > targetX) {\n"
"            nextObj.style.setProperty(\"visibility\",\"visible\");\n"
"            gapY += 15;\n"
"            if (collapsed[0][targetID] == 1) {\n"
"                targetID = collapsed[1][targetID];\n"
"            } else {\n"
"                targetID++;\n"
"            }\n"
"            nextObj = svgdoc.getElementById(\"MI\"+targetID);\n"
"            if (nextObj == null)\n"
"                break;\n"
"        } else {\n"
"            break;\n"
"        }\n"
"    }\n"
"    if (nextObj == null)\n"
"        return;\n"
"    //move following texts downwards\n"
"    while (nextObj != null) {\n"
"        attr = nextObj.attributes;\n"
"        for (i=0;i<attr.length;i++) {\n"
"            if (attr.item(i).nodeName == \"transform\") {\n"
"                k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"                l = attr.item(i).nodeValue.indexOf(\",\");\n"
"                m = attr.item(i).nodeValue.indexOf(\")\");\n"
"                nextX = attr.item(i).nodeValue.substring(k+1,l);\n"
"                nextY = attr.item(i).nodeValue.substring(l+1,m);\n"
"            }\n"
"        }\n"
"        nextY = nextY - 1 + gapY + 1;\n"
"        nextObj.setAttribute(\"transform\",\"translate(\"+nextX+\",\"+nextY+\")\");\n"
"        targetID++;\n"
"        nextObj = svgdoc.getElementById(\"MI\"+targetID);\n"
"    }\n"
"}\n"
"\n"
"function hideInfos(evt, obj, svgdoc, targetX, targetY, targetID, attr)\n"
"{\n"
"    var i, k, l, m, nextObj, nextX, nextY, gapY=0;\n"
"    clickedID = targetID;\n"
"    //change clicked text\n"
"    obj.firstChild.data=\"+\";\n"
"    targetID++;\n"
"    nextObj = svgdoc.getElementById(\"MI\"+targetID);\n"
"    if (nextObj == null)\n"
"        return;\n"
"    //wipe out child texts\n"
"    for (;;) {\n"
"        attr = nextObj.attributes;\n"
"        for (i=0;i<attr.length;i++) {\n"
"            if (attr.item(i).nodeName == \"transform\") {\n"
"                k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"                l = attr.item(i).nodeValue.indexOf(\",\");\n"
"                m = attr.item(i).nodeValue.indexOf(\")\");\n"
"                nextX = attr.item(i).nodeValue.substring(k+1,l);\n"
"                nextY = attr.item(i).nodeValue.substring(l+1,m);\n"
"            }\n"
"        }\n"
"        if (nextX > targetX) {\n"
"            nextObj.style.setProperty(\"visibility\",\"hidden\");\n"
"            gapY += 15;\n"
"            if (collapsed[0][targetID] == 1) {\n"
"                targetID = collapsed[1][targetID];\n"
"            } else {\n"
"                targetID++;\n"
"            }\n"
"            nextObj = svgdoc.getElementById(\"MI\"+targetID);\n"
"            if (nextObj == null)\n"
"                break;\n"
"        } else {\n"
"            break;\n"
"        }\n"
"    }\n"
"    //save next uncollapsed element in array\n"
"    collapsed[1][clickedID] = targetID;\n"
"    if (nextObj == null)\n"
"        return;\n"
"    //move following texts upwards\n"
"    while (nextObj != null) {\n"
"        attr = nextObj.attributes;\n"
"        for (i=0;i<attr.length;i++) {\n"
"            if (attr.item(i).nodeName == \"transform\") {\n"
"                k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"                l = attr.item(i).nodeValue.indexOf(\",\");\n"
"                m = attr.item(i).nodeValue.indexOf(\")\");\n"
"                nextX = attr.item(i).nodeValue.substring(k+1,l);\n"
"                nextY = attr.item(i).nodeValue.substring(l+1,m);\n"
"            }\n"
"        }\n"
"        nextY -= gapY;\n"
"        nextObj.setAttribute(\"transform\",\"translate(\"+nextX+\",\"+nextY+\")\");\n"
"        targetID++;\n"
"        nextObj = svgdoc.getElementById(\"MI\"+targetID);\n"
"    }\n"
"}\n"
"\n"
"function init(evt)\n"
"{\n"
"    var nodenames, startnode, endnode, attr, i, j, k, l, m, nodesx, nodeex;\n"
"    collapsed[0] = new Array(%i);\n"
"    collapsed[1] = new Array(%i);\n"
"    for (i=0; i<%i; i++) {\n"
"        collapsed[0][i] = 0;\n"
"        collapsed[1][i] = 0;\n"
"    }\n"
"    for (i=0; i<%i; i++) {\n"
"	name[i] = \"\";\n"
"	clickStatus[i] = 0;\n"
"	redCount[i] = 0;\n"
"	salmonCount[i] = 0;\n"
"    }\n"
"    getSVGDoc(evt);\n"
"\n"
"    //check which edges are printed from right to left\n"
"    paths = svgdoc.getElementsByTagName(\"path\");\n"
"    revert = new Array(paths.length);\n"
"    for (j=0; j<paths.length; j++) {\n"
"	nodenames = paths.item(j).getAttribute(\"id\").split(\"-\");\n"
"	startnode = svgdoc.getElementById(nodenames[0]);\n"
"	attr = startnode.parentNode.attributes;\n"
"	for (i=0;i<attr.length;i++) {\n"
"	    if (attr.item(i).nodeName == \"transform\") {\n"
"		k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"		l = attr.item(i).nodeValue.indexOf(\",\");\n"
"		m = attr.item(i).nodeValue.indexOf(\")\");\n"
"		nodesx = parseFloat(attr.item(i).nodeValue.substring(k+1,l));\n"
"	    }\n"
"	}\n"
"	endnode = svgdoc.getElementById(nodenames[1]);\n"
"	attr = endnode.parentNode.attributes;\n"
"	for (i=0;i<attr.length;i++) {\n"
"	    if (attr.item(i).nodeName == \"transform\") {\n"
"		k = attr.item(i).nodeValue.indexOf(\"(\");\n"
"		l = attr.item(i).nodeValue.indexOf(\",\");\n"
"		m = attr.item(i).nodeValue.indexOf(\")\");\n"
"		nodeex = parseFloat(attr.item(i).nodeValue.substring(k+1,l));\n"
"	    }\n"
"	}\n"
"	if (nodesx > nodeex) {\n"
"	    revert[j] = 1;\n"
"	} else {\n"
"	    revert[j] = 0;\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"function setStatus(evt, color1, color2)\n"
"{\n"
"    var clickObj = evt.getTarget();\n"
"    var clickObjName = clickObj.getAttribute('id');\n"
"\n"
"    //find i corresponding to the clicked object\n"
"    for (i=0; i<%i; i++) {\n"
"	if (name[i] == \"\") {\n"
"	    name[i] = clickObjName;\n"
"	    break;\n"
"	}\n"
"	if (name[i] != clickObjName)\n"
"	    continue;\n"
"	break;\n"
"    }\n"
"\n"
"    //toggle click status, color clicked object\n"
"    if (clickStatus[i] == 0) {\n"
"	clickStatus[i] = 1;\n"
"	clickObj.setAttribute(\"style\",\"fill: \"+color1);\n"
"    } else {\n"
"	clickStatus[i] = 0;\n"
"	clickObj.setAttribute(\"style\",\"fill: \"+color2);\n"
"    }\n"
"\n"
"    //adjust color-counter\n"
"    if (color1 == 'red') {\n"
"	if (clickStatus[i] == 1) {\n"
"	    redCount[i]++;\n"
"	} else {\n"
"	    redCount[i]--;\n"
"	}\n"
"    }\n"
"    if (color1 == 'salmon') {\n"
"	if (clickStatus[i] == 1) {\n"
"	    salmonCount[i]++;\n"
"	} else {\n"
"	    salmonCount[i]--;\n"
"	}\n"
"    }\n"
"\n"
"    if (clickStatus[i] == 0 && salmonCount[i] > 0) {\n"
"	clickObj.setAttribute(\"style\",\"fill: salmon\");\n"
"    }\n"
"}\n"
"\n"
"function changeColor(evt, targetObjName, color1, color2)\n"
"{\n"
"    var clickObj = evt.getTarget();\n"
"    var clickObjName = clickObj.getAttribute('id');\n"
"    var targetObj = svgDocument.getElementById(targetObjName);\n"
"\n"
"    //find i corresponding to the clicked object\n"
"    for (i=0; i<%i; i++) {\n"
"	if (name[i] != clickObjName)\n"
"	    continue;\n"
"	break;\n"
"    }\n"
"\n"
"    //find j corresponding to the target object\n"
"    for (j=0; j<%i; j++) {\n"
"	if (name[j] == \"\") {\n"
"	    name[j] = targetObjName;\n"
"	    break;\n"
"	}\n"
"	if (name[j] != targetObjName)\n"
"	    continue;\n"
"	break;\n"
"    }\n"
"\n"
"    //adjust color-counter\n"
"    if (color1 == 'red') {\n"
"	if (clickStatus[i] == 1) {\n"
"	    redCount[j]++;\n"
"	} else {\n"
"	    redCount[j]--;\n"
"	}\n"
"    }\n"
"    if (color1 == 'salmon') {\n"
"	if (clickStatus[i] == 1) {\n"
"	    salmonCount[j]++;\n"
"	} else {\n"
"	    salmonCount[j]--;\n"
"	}\n"
"    }\n"
"}\n"
"\n"
"function colorText(targetObjName, color)\n"
"{\n"
"    var targetObj = svgDocument.getElementById(targetObjName);\n"
"\n"
"    //find i corresponding to the target object\n"
"    for (i=0; i<%i; i++) {\n"
"	if (name[i] != targetObjName)\n"
"	    continue;\n"
"	break;\n"
"    }\n"
"\n"
"    //color text\n"
"    if (i == %i) {\n"
"	targetObj.setAttribute(\"style\",\"fill: \"+color);\n"
"	return;\n"
"    }\n"
"    if (redCount[i] == 0 && salmonCount[i] == 0) {\n"
"	targetObj.setAttribute(\"style\",\"fill: \"+color);\n"
"    }\n"
"    if (salmonCount[i] > 0) {\n"
"	if (color == 'red') {\n"
"	    targetObj.setAttribute(\"style\",\"fill: red\");\n"
"	} else {\n"
"	    if (redCount[i] > 0) {\n"
"		targetObj.setAttribute(\"style\",\"fill: red\");\n"
"	    } else {\n"
"		targetObj.setAttribute(\"style\",\"fill: salmon\");\n"
"	    }\n"
"	}\n"
"    }\n"
"}\n"
;
