/* queue.c generated by valac 0.46.6, the Vala compiler
 * generated from queue.vala, do not modify */

/* queue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib-object.h>
#include <glib.h>

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;
typedef gboolean (*GeeForallFunc) (gpointer g, gpointer user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;
typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy* * lazy, gpointer user_data);

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, gpointer user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, gpointer user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, gpointer user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, gpointer user_data);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, gpointer f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, gpointer f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, gint* result_length1);
	gpointer (*first_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*any_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*all_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gpointer (*max) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	gpointer (*min) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	GeeIterator* (*order_by) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, gint* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void gee_value_set_lazy (GValue* value,
                         gpointer v_object);
void gee_value_take_lazy (GValue* value,
                          gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeLazy, gee_lazy_unref)
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
gboolean gee_queue_offer (GeeQueue* self,
                          gconstpointer element);
static gboolean gee_queue_real_offer (GeeQueue* self,
                               gconstpointer element);
gboolean gee_collection_add (GeeCollection* self,
                             gconstpointer item);
gpointer gee_queue_peek (GeeQueue* self);
gpointer gee_queue_poll (GeeQueue* self);
gint gee_queue_drain (GeeQueue* self,
                      GeeCollection* recipient,
                      gint amount);
static gint gee_queue_real_drain (GeeQueue* self,
                           GeeCollection* recipient,
                           gint amount);
#define GEE_QUEUE_UNBOUNDED_CAPACITY -1
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);

/**
 * Offers the specified element to this queue.
 *
 * @param element the element to offer to the queue
 *
 * @return        ``true`` if the element was added to the queue
 */
static gboolean
gee_queue_real_offer (GeeQueue* self,
                      gconstpointer element)
{
	gboolean result = FALSE;
	result = gee_collection_add ((GeeCollection*) self, element);
	return result;
}

gboolean
gee_queue_offer (GeeQueue* self,
                 gconstpointer element)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_QUEUE_GET_INTERFACE (self)->offer (self, element);
}

/**
 * Peeks (retrieves, but not remove) an element from this queue.
 *
 * @return the element peeked from the queue (or ``null`` if none was
 *         available)
 */
gpointer
gee_queue_peek (GeeQueue* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_QUEUE_GET_INTERFACE (self)->peek (self);
}

/**
 * Polls (retrieves and remove) an element from this queue.
 *
 * @return the element polled from the queue (or ``null`` if none was
 *         available)
 */
gpointer
gee_queue_poll (GeeQueue* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_QUEUE_GET_INTERFACE (self)->poll (self);
}

/**
 * Drains the specified amount of elements from this queue in the specified
 * recipient collection.
 *
 * @param recipient the recipient collection to drain the elements to
 * @param amount    the amount of elements to drain
 *
 * @return          the amount of elements that were actually drained
 */
static gint
gee_queue_real_drain (GeeQueue* self,
                      GeeCollection* recipient,
                      gint amount)
{
	gpointer item = NULL;
	gint drained = 0;
	gint result = 0;
	g_return_val_if_fail (recipient != NULL, 0);
	item = NULL;
	drained = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gconstpointer _tmp4_;
		gint _tmp5_;
		if (amount == -1) {
			_tmp1_ = TRUE;
		} else {
			amount = amount - 1;
			_tmp1_ = amount >= 0;
		}
		if (_tmp1_) {
			gpointer _tmp2_;
			gconstpointer _tmp3_;
			_tmp2_ = gee_queue_poll (self);
			((item == NULL) || (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
			item = _tmp2_;
			_tmp3_ = item;
			_tmp0_ = _tmp3_ != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = item;
		gee_collection_add (recipient, _tmp4_);
		_tmp5_ = drained;
		drained = _tmp5_ + 1;
	}
	result = drained;
	((item == NULL) || (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

gint
gee_queue_drain (GeeQueue* self,
                 GeeCollection* recipient,
                 gint amount)
{
	g_return_val_if_fail (self != NULL, 0);
	return GEE_QUEUE_GET_INTERFACE (self)->drain (self, recipient, amount);
}

gint
gee_queue_get_capacity (GeeQueue* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return GEE_QUEUE_GET_INTERFACE (self)->get_capacity (self);
}

gint
gee_queue_get_remaining_capacity (GeeQueue* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return GEE_QUEUE_GET_INTERFACE (self)->get_remaining_capacity (self);
}

gboolean
gee_queue_get_is_full (GeeQueue* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_QUEUE_GET_INTERFACE (self)->get_is_full (self);
}

static void
gee_queue_default_init (GeeQueueIface * iface,
                        gpointer iface_data)
{
	/**
	 * The capacity of this queue (or ``UNBOUNDED_CAPACITY`` if capacity is not bound).
	 */
	g_object_interface_install_property (iface, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The remaining capacity of this queue (or ``UNBOUNDED_CAPACITY`` if capacity is not
	 * bound).
	 */
	g_object_interface_install_property (iface, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this queue is full.
	 */
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->offer = gee_queue_real_offer;
	iface->drain = gee_queue_real_drain;
}

/**
 * A collection designed for holding elements prior to processing.
 *
 * Although all Queue implementations do not limit the amount of elements they
 * can contain, this interface supports for capacity-bounded queues. When
 * capacity is not bound, then the {@link capacity} and
 * {@link remaining_capacity} both return {@link UNBOUNDED_CAPACITY}.
 *
 * This interface defines methods that will never fail whatever the state of
 * the queue is. For capacity-bounded queues, those methods will either return
 * ``false`` or ``null`` to specify that the insert or retrieval did not occur
 * because the queue was full or empty.
 *
 * Queue implementations are not limited to First-In-First-Out behavior and can
 * propose different ordering of their elements. Each Queue implementation have
 * to specify how it orders its elements.
 *
 * Queue implementations do not allow insertion of ``null`` elements, although
 * some implementations, such as {@link LinkedList}, do not prohibit insertion
 * of ``null``. Even in the implementations that permit it, ``null`` should not be
 * inserted into a Queue, as ``null`` is also used as a special return value by
 * the poll method to indicate that the queue contains no elements.
 */
GType
gee_queue_get_type (void)
{
	static volatile gsize gee_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeQueueIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_queue_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_queue_type_id;
		gee_queue_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeQueue", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_queue_type_id, GEE_TYPE_COLLECTION);
		g_once_init_leave (&gee_queue_type_id__volatile, gee_queue_type_id);
	}
	return gee_queue_type_id__volatile;
}

