/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

import alt.jiapi.Rule;
import alt.jiapi.event.IdentityList;
import alt.jiapi.event.JiapiEvent;

public class EventProducer {
    private String[] resolutions;
    private Rule[] rules;
    private IdentityList locks = new IdentityList();

    public EventProducer() {
        this(new String[]{"*"});
    }

    public EventProducer(String resolution) {
        this(new String[]{resolution});
    }

    public EventProducer(String[] resolutions) {
        this.resolutions = resolutions;
        this.rules = new Rule[resolutions.length];
        for (int i = 0; i < this.rules.length; ++i) {
            try {
                this.rules[i] = new Rule(resolutions[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println("Invalid rule: " + e);
            }
        }
    }

    public boolean match(String s) {
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].match(s)) continue;
            return true;
        }
        return false;
    }

    public String[] getResolutions() {
        return this.resolutions;
    }

    public boolean isProtected(Object sourceObject) {
        return this.locks.contains(sourceObject);
    }

    public boolean isProtected(JiapiEvent je) {
        Object sourceObject = je.getSourceObject();
        return this.locks.contains(sourceObject);
    }

    public void protect(JiapiEvent je) {
        Object sourceObject = je.getSourceObject();
        this.locks.add(sourceObject);
    }

    public void release(JiapiEvent je) {
        Object sourceObject = je.getSourceObject();
        this.locks.remove(sourceObject);
    }
}

