/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaComponentMarker;
import net.sf.saxon.type.SchemaType;

public class NamePool
implements Serializable {
    private static NamePool defaultNamePool = new NamePool();
    private transient WeakHashMap documentNumberMap = new WeakHashMap(10);
    private int numberOfDocuments = 0;
    private HashMap typeIndex = new HashMap();
    private HashMap elementIndex = new HashMap();
    private HashMap attributeIndex = new HashMap();
    NameEntry[] hashslots = new NameEntry[1024];
    String[] prefixes = new String[100];
    short prefixesUsed = 0;
    String[] uris = new String[100];
    String[] prefixesForUri = new String[100];
    short urisUsed = 0;

    public static NamePool getDefaultNamePool() {
        return defaultNamePool;
    }

    public static void setDefaultNamePool(NamePool namePool) {
        defaultNamePool = namePool;
    }

    public NamePool() {
        this.prefixes[0] = "";
        this.uris[0] = "";
        this.prefixesForUri[0] = "";
        this.prefixes[1] = "xml";
        this.uris[1] = "http://www.w3.org/XML/1998/namespace";
        this.prefixesForUri[1] = "xml ";
        this.prefixes[2] = "xsl";
        this.uris[2] = "http://www.w3.org/1999/XSL/Transform";
        this.prefixesForUri[2] = "xsl ";
        this.prefixes[3] = "saxon";
        this.uris[3] = "http://saxon.sf.net/";
        this.prefixesForUri[3] = "saxon ";
        this.prefixes[4] = "xs";
        this.uris[4] = "http://www.w3.org/2001/XMLSchema";
        this.prefixesForUri[4] = "xs ";
        this.prefixes[5] = "xdt";
        this.uris[5] = "http://www.w3.org/2003/11/xpath-datatypes";
        this.prefixesForUri[5] = "xdt ";
        this.prefixes[6] = "xsi";
        this.uris[6] = "http://www.w3.org/2001/XMLSchema-instance";
        this.prefixesForUri[6] = "xsi ";
        this.prefixes[7] = "func";
        this.uris[7] = "http://exslt.org/functions";
        this.prefixesForUri[7] = "func ";
        this.prefixesUsed = (short)8;
        this.urisUsed = (short)8;
    }

    public synchronized int allocateDocumentNumber(DocumentInfo documentInfo) {
        Integer n;
        if (this.documentNumberMap == null) {
            this.documentNumberMap = new WeakHashMap(10);
        }
        if ((n = (Integer)this.documentNumberMap.get(documentInfo)) != null) {
            return n;
        }
        int n2 = this.numberOfDocuments++;
        this.documentNumberMap.put(documentInfo, new Integer(n2));
        return n2;
    }

    private NameEntry getNameEntry(int n) {
        int n2 = n & 0x3FF;
        int n3 = n >> 10 & 0x3FF;
        NameEntry nameEntry = this.hashslots[n2];
        int n4 = 1;
        while (n4 < n3) {
            if (nameEntry == null) {
                return null;
            }
            nameEntry = nameEntry.nextEntry;
            ++n4;
        }
        return nameEntry;
    }

    public synchronized int allocateNamespaceCode(String string, String string2) {
        String string3;
        short s = this.allocateCodeForPrefix(string);
        short s2 = this.allocateCodeForURI(string2);
        if (s != 0 && this.prefixesForUri[s2].indexOf(string3 = string + " ") < 0) {
            short s3 = s2;
            this.prefixesForUri[s3] = this.prefixesForUri[s3] + string3;
        }
        return (s << 16) + s2;
    }

    public int getNamespaceCode(String string, String string2) {
        String string3;
        short s = this.getCodeForPrefix(string);
        if (s < 0) {
            return -1;
        }
        short s2 = this.getCodeForURI(string2);
        if (s2 < 0) {
            return -1;
        }
        if (s != 0 && this.prefixesForUri[s2].indexOf(string3 = string + " ") < 0) {
            return -1;
        }
        return (s << 16) + s2;
    }

    public synchronized short allocateCodeForURI(String string) {
        short s = 0;
        while (s < this.urisUsed) {
            if (this.uris[s].equals(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        if (this.urisUsed >= this.uris.length) {
            if (this.urisUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace URIs");
            }
            String[] stringArray = new String[this.urisUsed * 2];
            String[] stringArray2 = new String[this.urisUsed * 2];
            System.arraycopy(this.prefixesForUri, 0, stringArray, 0, this.urisUsed);
            System.arraycopy(this.uris, 0, stringArray2, 0, this.urisUsed);
            this.prefixesForUri = stringArray;
            this.uris = stringArray2;
        }
        this.uris[this.urisUsed] = string;
        this.prefixesForUri[this.urisUsed] = "";
        short s2 = this.urisUsed;
        this.urisUsed = (short)(s2 + 1);
        return s2;
    }

    public short getCodeForURI(String string) {
        short s = 0;
        while (s < this.urisUsed) {
            if (this.uris[s].equals(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        return -1;
    }

    public synchronized short allocateCodeForPrefix(String string) {
        short s = 0;
        while (s < this.prefixesUsed) {
            if (this.prefixes[s].equals(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        if (this.prefixesUsed >= this.prefixes.length) {
            if (this.prefixesUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace prefixes");
            }
            String[] stringArray = new String[this.prefixesUsed * 2];
            System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixesUsed);
            this.prefixes = stringArray;
        }
        this.prefixes[this.prefixesUsed] = string;
        short s2 = this.prefixesUsed;
        this.prefixesUsed = (short)(s2 + 1);
        return s2;
    }

    public short getCodeForPrefix(String string) {
        short s = 0;
        while (s < this.prefixesUsed) {
            if (this.prefixes[s].equals(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        return -1;
    }

    public String suggestPrefixForURI(String string) {
        short s = this.getCodeForURI(string);
        if (s == -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        if (stringTokenizer.hasMoreElements()) {
            return (String)stringTokenizer.nextElement();
        }
        return null;
    }

    private int getPrefixIndex(short s, String string) {
        if (string.equals("")) {
            return 0;
        }
        if (this.prefixesForUri[s].equals(string + " ")) {
            return 1;
        }
        int n = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        while (stringTokenizer.hasMoreElements()) {
            if (string.equals(stringTokenizer.nextElement())) {
                return n;
            }
            if (n++ != 255) continue;
            throw new NamePoolLimitException("Too many prefixes for one namespace URI");
        }
        return -1;
    }

    public String getPrefixWithIndex(short s, int n) {
        if (n == 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefixesForUri[s]);
        int n2 = 1;
        while (stringTokenizer.hasMoreElements()) {
            String string = (String)stringTokenizer.nextElement();
            if (n2++ != n) continue;
            return string;
        }
        return null;
    }

    public synchronized int allocate(String string, String string2, String string3) {
        short s;
        if ((NamespaceConstant.isReserved(string2) || string2.equals("http://saxon.sf.net/")) && (s = StandardNames.getFingerprint(string2, string3)) != -1) {
            return s;
        }
        s = this.allocateCodeForURI(string2);
        return this.allocate(string, s, string3);
    }

    public synchronized int allocate(String string, short s, String string2) {
        int n = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n2 = 1;
        int n3 = this.getPrefixIndex(s, string);
        if (n3 < 0) {
            short s2 = s;
            this.prefixesForUri[s2] = this.prefixesForUri[s2] + string + " ";
            n3 = this.getPrefixIndex(s, string);
        }
        NameEntry nameEntry = null;
        if (this.hashslots[n] == null) {
            this.hashslots[n] = nameEntry = new NameEntry(s, string2);
        } else {
            nameEntry = this.hashslots[n];
            while (true) {
                boolean bl;
                boolean bl2 = nameEntry.localName.equals(string2);
                boolean bl3 = bl = nameEntry.uriCode == s;
                if (bl2 && bl) break;
                NameEntry nameEntry2 = nameEntry.nextEntry;
                if (++n2 >= 1024) {
                    throw new NamePoolLimitException("Saxon name pool is full");
                }
                if (nameEntry2 == null) {
                    NameEntry nameEntry3;
                    nameEntry.nextEntry = nameEntry3 = new NameEntry(s, string2);
                    break;
                }
                nameEntry = nameEntry2;
            }
        }
        return (n3 << 20) + (n2 << 10) + n;
    }

    public synchronized int allocateNamespaceCode(int n) {
        String string = this.getPrefix(n);
        short s = this.getURICode(n);
        short s2 = this.allocateCodeForPrefix(string);
        return (s2 << 16) + s;
    }

    public String getURI(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getURI(n);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        return this.uris[nameEntry.uriCode];
    }

    public short getURICode(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getURICode(n);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        return nameEntry.uriCode;
    }

    public String getLocalName(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getLocalName(n);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        return nameEntry.localName;
    }

    public String getPrefix(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getPrefix(n);
        }
        short s = this.getURICode(n);
        int n2 = n >> 20 & 0xFF;
        return this.getPrefixWithIndex(s, n2);
    }

    public String getDisplayName(int n) {
        int n2;
        String string;
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getDisplayName(n);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        if ((string = this.getPrefixWithIndex(nameEntry.uriCode, n2 = n >> 20 & 0xFF)) == null || string.equals("")) {
            return nameEntry.localName;
        }
        return string + ':' + nameEntry.localName;
    }

    public String getClarkName(int n) {
        if ((n & 0xFFC00) == 0) {
            return StandardNames.getClarkName(n);
        }
        NameEntry nameEntry = this.getNameEntry(n);
        if (nameEntry == null) {
            this.unknownNameCode(n);
        }
        if (nameEntry.uriCode == 0) {
            return nameEntry.localName;
        }
        String string = "{" + this.getURIFromURICode(nameEntry.uriCode) + "}" + nameEntry.localName;
        return string.intern();
    }

    public int allocateClarkName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.allocate("", string3, string2);
    }

    private void unknownNameCode(int n) {
        throw new IllegalArgumentException("Unknown name code " + n);
    }

    public int getFingerprint(String string, String string2) {
        int n;
        if ((NamespaceConstant.isReserved(string) || string.equals("http://saxon.sf.net/")) && (n = StandardNames.getFingerprint(string, string2)) != -1) {
            return n;
        }
        n = -1;
        short s = 0;
        while (s < this.urisUsed) {
            if (this.uris[s].equals(string)) {
                n = s;
                break;
            }
            s = (short)(s + 1);
        }
        if (n == -1) {
            return -1;
        }
        int n2 = (string2.hashCode() & Integer.MAX_VALUE) % 1023;
        int n3 = 1;
        NameEntry nameEntry = null;
        if (this.hashslots[n2] == null) {
            return -1;
        }
        nameEntry = this.hashslots[n2];
        while (true) {
            boolean bl;
            boolean bl2 = nameEntry.localName.equals(string2);
            boolean bl3 = bl = nameEntry.uriCode == n;
            if (bl2 && bl) break;
            NameEntry nameEntry2 = nameEntry.nextEntry;
            ++n3;
            if (nameEntry2 == null) {
                return -1;
            }
            nameEntry = nameEntry2;
        }
        return (n3 << 10) + n2;
    }

    public String getURIFromNamespaceCode(int n) {
        return this.uris[n & 0xFFFF];
    }

    public String getURIFromURICode(short s) {
        return this.uris[s];
    }

    public String getPrefixFromNamespaceCode(int n) {
        return this.prefixes[n >> 16];
    }

    public int getFingerprintForExpandedName(String string) {
        String string2;
        String string3;
        if (string.charAt(0) == '{') {
            int n = string.indexOf(125);
            if (n < 0) {
                throw new IllegalArgumentException("No closing '}' in parameter name");
            }
            string3 = string.substring(1, n);
            if (n == string.length()) {
                throw new IllegalArgumentException("Missing local part in parameter name");
            }
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return this.allocate("", string3, string2);
    }

    public void addSchemaType(int n, SchemaType schemaType) {
        if (this.typeIndex == null) {
            this.typeIndex = new HashMap();
        }
        this.typeIndex.put(new Integer(n), schemaType);
    }

    public void removeSchemaType(int n) {
        this.typeIndex.remove(new Integer(n));
    }

    public SchemaType getSchemaType(int n) {
        if (n < 1023) {
            return BuiltInSchemaFactory.getSchemaType(n);
        }
        return (SchemaType)this.typeIndex.get(new Integer(n));
    }

    public void addElementDeclaration(int n, SchemaComponentMarker schemaComponentMarker) {
        if (this.elementIndex == null) {
            this.elementIndex = new HashMap();
        }
        this.elementIndex.put(new Integer(n), schemaComponentMarker);
    }

    public void removeElementDeclaration(int n) {
        this.elementIndex.remove(new Integer(n));
    }

    public SchemaComponentMarker getElementDeclaration(int n) {
        return (SchemaComponentMarker)this.elementIndex.get(new Integer(n));
    }

    public void addAttributeDeclaration(int n, SchemaComponentMarker schemaComponentMarker) {
        if (this.attributeIndex == null) {
            this.attributeIndex = new HashMap();
        }
        this.attributeIndex.put(new Integer(n), schemaComponentMarker);
    }

    public void removeAttributeDeclaration(int n) {
        this.attributeIndex.remove(new Integer(n));
    }

    public SchemaComponentMarker getAttributeDeclaration(int n) {
        return (SchemaComponentMarker)this.attributeIndex.get(new Integer(n));
    }

    public synchronized void diagnosticDump() {
        int n;
        System.err.println("Contents of NamePool " + this);
        int n2 = 0;
        while (n2 < 1024) {
            NameEntry nameEntry = this.hashslots[n2];
            n = 0;
            while (nameEntry != null) {
                System.err.println("Fingerprint " + n + "/" + n2);
                System.err.println("  local name = " + nameEntry.localName + " uri code = " + nameEntry.uriCode);
                nameEntry = nameEntry.nextEntry;
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.prefixesUsed) {
            System.err.println("Prefix " + n3 + " = " + this.prefixes[n3]);
            ++n3;
        }
        n = 0;
        while (n < this.urisUsed) {
            System.err.println("URI " + n + " = " + this.uris[n]);
            System.err.println("Prefixes for URI " + n + " = " + this.prefixesForUri[n]);
            ++n;
        }
    }

    public class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String string) {
            super(string);
        }
    }

    private static class NameEntry
    implements Serializable {
        String localName;
        short uriCode;
        NameEntry nextEntry;

        public NameEntry(short s, String string) {
            this.uriCode = s;
            this.localName = string;
            this.nextEntry = null;
        }
    }
}

