/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.Assertions;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.CpClass;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpNameAndType;
import com.claritysys.jvm.classfile.CpRef;
import com.claritysys.jvm.classfile.CpString;
import com.claritysys.jvm.classfile.CpUtf8;
import com.claritysys.jvm.classfile.CpValue1;
import com.claritysys.jvm.classfile.CpValue2;
import com.claritysys.jvm.classfile.SigConverter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public final class ConstantPool {
    CpEntry[] pool;
    int count;
    boolean locked;
    CpEntry[] hashTable;
    private int rehashThreshold;
    private char[] utf8_chars;
    private byte[] utf8_bytes;
    private SigConverter sigConverter;
    private boolean autoImport;
    private boolean verifyClassNames = true;

    public ConstantPool() {
    }

    public ConstantPool(boolean autoImport) {
        if (autoImport) {
            this.getSigConverter();
            this.autoImport = autoImport;
        }
    }

    public ConstantPool(int capacity) {
        this.pool = new CpEntry[capacity + 1];
    }

    public ConstantPool(ConstantPool template) {
        CpEntry cpEntry;
        int i;
        this.count = template.count;
        this.pool = new CpEntry[template.pool.length];
        CpEntry[] templatePool = template.pool;
        CpEntry[] poolCopy = this.pool;
        for (i = this.count; i > 0; --i) {
            cpEntry = templatePool[i];
            CpEntry copy = (CpEntry)cpEntry.clone();
            copy.pool = this;
            copy.next = null;
            poolCopy[i] = copy;
        }
        for (i = this.count; i > 0; --i) {
            cpEntry = poolCopy[i];
            cpEntry.postClone();
        }
        CpEntry[] templateHash = template.hashTable;
        CpEntry[] hash = new CpEntry[templateHash.length];
        for (int i2 = 0; i2 < hash.length; ++i2) {
            CpEntry cpEntry2 = templateHash[i2];
            if (cpEntry2 == null) continue;
            hash[i2] = poolCopy[cpEntry2.index];
        }
        this.hashTable = hash;
        this.rehashThreshold = template.rehashThreshold;
        this.autoImport = template.autoImport;
        if (this.autoImport) {
            this.sigConverter = new SigConverter(template.sigConverter);
        }
    }

    public int getCount() {
        return this.count;
    }

    public CpEntry getPoolEntry(int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException("Invalid cp index: " + index + ", count=" + this.count);
        }
        return this.pool[index];
    }

    public String getUtf8AsString(int index) {
        return ((CpUtf8)this.getPoolEntry(index)).getString();
    }

    void rehash() {
        CpEntry entry;
        int i;
        CpEntry[] pool = this.pool;
        CpEntry[] hashTable = this.hashTable;
        if (hashTable != null && this.count > 0) {
            i = this.count;
            while (--i >= 0) {
                entry = pool[i];
                if (entry == null) continue;
                entry.next = null;
            }
        }
        this.hashTable = hashTable = new CpEntry[3 * pool.length];
        i = this.count;
        while (--i >= 0) {
            entry = pool[i];
            if (entry == null) continue;
            this.addToHashtable(entry);
        }
        this.rehashThreshold = (int)(0.6f * (float)hashTable.length);
        this.hashTable = hashTable;
    }

    void addToHashtable(CpEntry entry) {
        CpEntry[] hashTable = this.hashTable;
        int index = (entry.hash & Integer.MAX_VALUE) % hashTable.length;
        entry.next = hashTable[index];
        hashTable[index] = entry;
    }

    CpEntry addEntry(CpEntry entry) {
        if (this.locked) {
            throw new IllegalStateException("adding new entry to locked contant pool: " + entry);
        }
        CpEntry[] pool = this.pool;
        int index = ++this.count;
        if (pool == null) {
            pool = new CpEntry[239];
        } else {
            int POOL_SIZE = pool.length;
            if (index >= POOL_SIZE) {
                int oldSize = POOL_SIZE;
                int newSize = 2 * POOL_SIZE;
                CpEntry[] newPool = new CpEntry[newSize];
                for (int i = 0; i < oldSize; ++i) {
                    newPool[i] = pool[i];
                }
                pool = newPool;
            }
        }
        this.pool = pool;
        if (entry.tag == 5 || entry.tag == 6) {
            ++this.count;
        }
        if (this.hashTable == null || index >= this.rehashThreshold) {
            this.rehash();
        }
        Assertions.assertTrue(pool[index] == null, pool[index]);
        Assertions.assertTrue(entry.index == 0, entry);
        pool[index] = entry;
        entry.index = index;
        this.addToHashtable(entry);
        return entry;
    }

    public CpUtf8 addUtf8(String s) {
        int hash = s.hashCode();
        if (this.hashTable != null) {
            int index = (hash & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == hash && entry.tag == 1) {
                    CpUtf8 utf = (CpUtf8)entry;
                    if (utf.string.equals(s)) {
                        return utf;
                    }
                }
                entry = entry.next;
            }
        }
        return (CpUtf8)this.addEntry(new CpUtf8(this, hash, s));
    }

    public CpClass addClass(Class cls) {
        return this.addClass(this.addUtf8(cls.getName().replace('.', '/')));
    }

    public CpClass addJavaClass(String name) {
        return this.addClass(this.addUtf8(name.replace('.', '/')));
    }

    public CpClass addClass(String name) {
        if (name.charAt(0) == '@') {
            name = this.getSigConverter().getFullName(name.substring(1));
        }
        if (this.verifyClassNames) {
            int size = name.length();
            for (int i = 0; i < size; ++i) {
                char ch = name.charAt(i);
                if (ch != '.' && ch != ';') continue;
                throw new IllegalArgumentException("Improper VM class name format: " + name);
            }
        }
        return this.addClass(this.addUtf8(name));
    }

    public CpClass addClass(CpUtf8 name) {
        int h = name.hash ^ 0xF0F;
        if (this.hashTable != null) {
            int index = (h & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == h && entry.tag == 7) {
                    CpClass clas = (CpClass)entry;
                    if (clas.name == name) {
                        return clas;
                    }
                }
                entry = entry.next;
            }
        }
        if (this.autoImport) {
            this.getSigConverter().addImport(name.getString());
        }
        return (CpClass)this.addEntry(new CpClass(this, h, name));
    }

    CpValue1 addValue1(byte tag, int val) {
        int h = val;
        if (this.hashTable != null) {
            int index = (h & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == h && entry.tag == tag) {
                    CpValue1 val1 = (CpValue1)entry;
                    if (val1.value == val) {
                        return val1;
                    }
                }
                entry = entry.next;
            }
        }
        return (CpValue1)this.addEntry(new CpValue1(this, tag, h, val));
    }

    CpValue2 addValue2(byte tag, long val) {
        int h = (int)val;
        if (this.hashTable != null) {
            int index = (h & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == h && entry.tag == tag) {
                    CpValue2 val2 = (CpValue2)entry;
                    if (val2.value == val) {
                        return val2;
                    }
                }
                entry = entry.next;
            }
        }
        return (CpValue2)this.addEntry(new CpValue2(this, tag, h, val));
    }

    public CpValue1 addInteger(int val) {
        return this.addValue1((byte)3, val);
    }

    public CpValue2 addLong(long val) {
        return this.addValue2((byte)5, val);
    }

    public CpValue1 addFloat(float val) {
        return this.addValue1((byte)4, Float.floatToIntBits(val));
    }

    public CpValue2 addDouble(double val) {
        return this.addValue2((byte)6, Double.doubleToLongBits(val));
    }

    public CpString addString(String string) {
        return this.addString(this.addUtf8(string));
    }

    public CpString addString(CpUtf8 str) {
        int h = str.hash ^ 0xF30F;
        if (this.hashTable != null) {
            int index = (h & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == h && entry.tag == 8) {
                    CpString string = (CpString)entry;
                    if (string.str == str) {
                        return string;
                    }
                }
                entry = entry.next;
            }
        }
        return (CpString)this.addEntry(new CpString(this, h, str));
    }

    public CpNameAndType addNameAndType(CpUtf8 name, CpUtf8 type) {
        int h = name.hash ^ type.hash;
        if (this.hashTable != null) {
            int index = (h & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == h && entry.tag == 12) {
                    CpNameAndType nat = (CpNameAndType)entry;
                    if (nat.name == name && nat.type == type) {
                        return nat;
                    }
                }
                entry = entry.next;
            }
        }
        return (CpNameAndType)this.addEntry(new CpNameAndType(this, h, name, type));
    }

    public CpNameAndType addNameAndType(String name, String type) {
        return this.addNameAndType(this.addUtf8(name), this.addUtf8(type));
    }

    public CpRef addRef(byte tag, CpClass clas, CpNameAndType nameAndType) {
        int h = clas.hash ^ nameAndType.hash;
        if (this.hashTable != null) {
            int index = (h & Integer.MAX_VALUE) % this.hashTable.length;
            CpEntry entry = this.hashTable[index];
            while (entry != null) {
                if (entry.hash == h && entry.tag == tag) {
                    CpRef ref = (CpRef)entry;
                    if (ref.clas == clas && ref.nameAndType == nameAndType) {
                        return ref;
                    }
                }
                entry = entry.next;
            }
        }
        return (CpRef)this.addEntry(new CpRef(this, h, tag, clas, nameAndType));
    }

    public CpRef addMethodRef(boolean isInterface, String clasName, String name, String sig) {
        CpClass clas = this.addClass(clasName);
        return this.addMethodRef(isInterface, clas, name, sig);
    }

    public CpRef addMethodRef(boolean isInterface, CpClass cpClass, String name, String sig) {
        String vmSig = sig;
        if (vmSig.charAt(0) == '@') {
            vmSig = this.getSigConverter().toVmMethodSig(vmSig.substring(1));
        }
        CpNameAndType nameType = this.addNameAndType(name, vmSig);
        return this.addRef(isInterface ? (byte)11 : 10, cpClass, nameType);
    }

    public CpRef addMethodRef(boolean isInterface, CpClass inClass, String jlSig) {
        int pos2;
        CpClass cpClass;
        if (jlSig.charAt(0) != '@') {
            throw new IllegalArgumentException("Improper short name format: " + jlSig);
        }
        int pos = jlSig.indexOf(46, 1);
        if (pos == -1) {
            if (inClass == null) {
                throw new IllegalArgumentException("Missing method name: " + jlSig);
            }
            cpClass = inClass;
            pos = 0;
            pos2 = jlSig.indexOf(40, pos + 1);
        } else {
            String shortClass = jlSig.substring(1, pos);
            pos2 = jlSig.indexOf(40, pos + 1);
            if (pos2 == -1) {
                throw new IllegalArgumentException("Missing signature: " + jlSig);
            }
            SigConverter converter = this.getSigConverter();
            String vmClass = converter.getFullName(shortClass);
            cpClass = this.addClass(vmClass);
        }
        String methodName = jlSig.substring(pos + 1, pos2);
        String shortSignature = jlSig.substring(pos2);
        SigConverter converter = this.getSigConverter();
        String vmSignature = converter.toVmMethodSig(shortSignature);
        CpNameAndType nameType = this.addNameAndType(methodName, vmSignature);
        return this.addRef(isInterface ? (byte)11 : 10, cpClass, nameType);
    }

    public CpRef addMethodRef(CpClass clas, String name, String sig) {
        return this.addMethodRef(false, clas, name, sig);
    }

    public CpRef addMethodRef(int cpClassIndex, int nameIndex, int descriptorIndex) {
        CpClass clas = (CpClass)this.getPoolEntry(cpClassIndex);
        CpUtf8 name = (CpUtf8)this.getPoolEntry(nameIndex);
        CpUtf8 descriptor = (CpUtf8)this.getPoolEntry(descriptorIndex);
        CpNameAndType nameType = this.addNameAndType(name, descriptor);
        return this.addRef((byte)10, clas, nameType);
    }

    public CpRef addIMethodRef(String className, String name, String sig) {
        return this.addMethodRef(true, className, name, sig);
    }

    public CpRef addIMethodRef(CpClass clas, String name, String sig) {
        return this.addMethodRef(true, clas, name, sig);
    }

    public CpRef addFieldRef(String className, String name, String vmSig) {
        CpClass clas = this.addClass(className);
        CpNameAndType nameType = this.addNameAndType(name, vmSig);
        return this.addRef((byte)9, clas, nameType);
    }

    public CpRef addFieldRef(CpClass clas, String name, String vmSig) {
        CpNameAndType nameType = this.addNameAndType(name, vmSig);
        return this.addRef((byte)9, clas, nameType);
    }

    public CpRef addFieldRef(int cpClassIndex, int nameIndex, int descriptorIndex) {
        CpClass clas = (CpClass)this.getPoolEntry(cpClassIndex);
        CpUtf8 name = (CpUtf8)this.getPoolEntry(nameIndex);
        CpUtf8 descriptor = (CpUtf8)this.getPoolEntry(descriptorIndex);
        CpNameAndType nameType = this.addNameAndType(name, descriptor);
        return this.addRef((byte)9, clas, nameType);
    }

    public CpRef addFieldRefJL(String jlSig, String classDotField) {
        if (classDotField.charAt(0) != '@') {
            throw new IllegalArgumentException("Improper short name format: " + classDotField);
        }
        if (jlSig.charAt(0) != '@') {
            throw new IllegalArgumentException("Improper short sig format: " + jlSig);
        }
        jlSig = jlSig.substring(1);
        int pos = classDotField.indexOf(46, 1);
        if (pos == -1) {
            throw new IllegalArgumentException("Missing method name: " + classDotField);
        }
        String shortClass = classDotField.substring(1, pos);
        String fieldName = classDotField.substring(pos + 1);
        SigConverter sigConverter = this.getSigConverter();
        String vmSignature = sigConverter.getType(jlSig);
        String vmClass = sigConverter.getFullName(shortClass);
        return this.addFieldRef(vmClass, fieldName, vmSignature);
    }

    public SigConverter getSigConverter() {
        SigConverter converter = this.sigConverter;
        if (converter == null) {
            this.sigConverter = converter = new SigConverter();
        }
        return converter;
    }

    public String addImport(String fqClassName) {
        return this.getSigConverter().addImport(fqClassName);
    }

    public String addImport(Class clas) {
        return this.addImport(clas.getName());
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void write(DataOutput dstr) throws IOException {
        dstr.writeShort(this.count + 1);
        for (int i = 1; i <= this.count; ++i) {
            CpEntry entry = this.pool[i];
            if (entry == null) continue;
            entry.write(dstr);
        }
        this.locked = true;
    }

    public static ConstantPool fromStream(DataInputStream dataIn) throws IOException, ClassFileFormatException {
        CpEntry entry;
        int size = dataIn.readUnsignedShort() - 1;
        ConstantPool pool = new ConstantPool(size);
        block9: for (int index = 1; index <= size; ++index) {
            byte tag = dataIn.readByte();
            entry = pool.getOrCreateEntry(index, tag);
            switch (tag) {
                case 1: {
                    CpUtf8 utf8 = (CpUtf8)entry;
                    utf8.setString(dataIn.readUTF());
                    continue block9;
                }
                case 3: 
                case 4: {
                    CpValue1 value1 = (CpValue1)entry;
                    value1.setValue(dataIn.readInt());
                    continue block9;
                }
                case 5: 
                case 6: {
                    CpValue2 value2 = (CpValue2)entry;
                    value2.setValue(dataIn.readLong());
                    ++index;
                    continue block9;
                }
                case 7: {
                    CpUtf8 className;
                    CpClass cpClass = (CpClass)entry;
                    int classNameIndex = dataIn.readUnsignedShort();
                    cpClass.name = className = (CpUtf8)pool.getOrCreateEntry(classNameIndex, (byte)1);
                    continue block9;
                }
                case 8: {
                    CpUtf8 string;
                    int stringIndex = dataIn.readUnsignedShort();
                    ((CpString)entry).str = string = (CpUtf8)pool.getOrCreateEntry(stringIndex, (byte)1);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    CpRef ref = (CpRef)entry;
                    ref.clas = (CpClass)pool.getOrCreateEntry(dataIn.readUnsignedShort(), (byte)7);
                    ref.nameAndType = (CpNameAndType)pool.getOrCreateEntry(dataIn.readUnsignedShort(), (byte)12);
                    continue block9;
                }
                case 12: {
                    CpNameAndType nat = (CpNameAndType)entry;
                    nat.name = (CpUtf8)pool.getOrCreateEntry(dataIn.readUnsignedShort(), (byte)1);
                    nat.type = (CpUtf8)pool.getOrCreateEntry(dataIn.readUnsignedShort(), (byte)1);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag: " + tag);
                }
            }
        }
        CpEntry[] entries = pool.pool;
        pool.count = size;
        for (int index = 1; index <= size; ++index) {
            entry = entries[index];
            if (entry == null || entry.hash != 0) continue;
            entry.computeHash();
        }
        pool.rehash();
        return pool;
    }

    private CpEntry getOrCreateEntry(int index, byte tag) throws ClassFileFormatException {
        CpEntry entry = this.pool[index];
        if (entry == null) {
            switch (tag) {
                case 1: {
                    entry = new CpUtf8(this);
                    break;
                }
                case 3: 
                case 4: {
                    entry = new CpValue1(this, tag);
                    break;
                }
                case 5: 
                case 6: {
                    entry = new CpValue2(this, tag);
                    break;
                }
                case 7: {
                    entry = new CpClass(this);
                    break;
                }
                case 8: {
                    entry = new CpString(this);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    entry = new CpRef(this, tag);
                    break;
                }
                case 12: {
                    entry = new CpNameAndType(this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag: " + tag);
                }
            }
            this.pool[index] = entry;
            entry.index = index;
        } else if (entry.tag != tag) {
            throw new ClassFileFormatException("Conflicting constant pool tags, index=" + index + ", entry type=" + entry.tag + ", expected type=" + tag);
        }
        return entry;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(16384);
        for (int i = 1; i <= this.count; ++i) {
            buf.append(i).append(" - ").append(this.pool[i]).append("\n");
        }
        return buf.toString();
    }

    public void writeUTF(DataOutput out, String str) throws IOException {
        int strlen = str.length();
        if (this.utf8_chars == null || this.utf8_chars.length < strlen) {
            this.utf8_chars = new char[strlen < 1024 ? 1024 : 2 * strlen];
        }
        char[] charr = this.utf8_chars;
        str.getChars(0, strlen, charr, 0);
        int byteCount = strlen << 2;
        if (this.utf8_bytes == null || this.utf8_bytes.length < byteCount) {
            this.utf8_bytes = new byte[byteCount < 1024 ? 1024 : 2 * byteCount];
        }
        byte[] bytearr = this.utf8_bytes;
        int count = 2;
        for (int i = 0; i < strlen; ++i) {
            char c;
            if (bytearr.length <= count + 3) {
                byte[] bytes2 = new byte[bytearr.length * 2];
                System.arraycopy(bytearr, 0, bytes2, 0, count);
                this.utf8_bytes = bytes2;
                bytearr = bytes2;
            }
            if ((c = charr[i]) >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        int utflen = count - 2;
        if (utflen > 65535) {
            throw new IllegalArgumentException("UTF-8 string too large: " + utflen);
        }
        bytearr[0] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[1] = (byte)(utflen >>> 0 & 0xFF);
        out.write(bytearr, 0, count);
    }

    public boolean isVerifyClassNames() {
        return this.verifyClassNames;
    }

    public void setVerifyClassNames(boolean verifyClassNames) {
        this.verifyClassNames = verifyClassNames;
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }
}

