; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

declare i64 @llvm.cttz.i64(i64, i1)

declare i64 @llvm.ctlz.i64(i64, i1)

declare <8 x i64> @llvm.cttz.v8i64(<8 x i64>, i1)

define i32 @test0(i64 %x) {
; CHECK-LABEL: @test0(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i64 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[NON_ZERO:%.*]]
; CHECK:       non_zero:
; CHECK-NEXT:    [[CTZ:%.*]] = call i64 @llvm.cttz.i64(i64 [[X]], i1 false), !range !0
; CHECK-NEXT:    [[CTZ32:%.*]] = trunc i64 [[CTZ]] to i32
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[CTZ32]], [[NON_ZERO]] ], [ 0, [[START:%.*]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
start:
  %c = icmp eq i64 %x, 0
  br i1 %c, label %exit, label %non_zero

non_zero:
  %ctz = call i64 @llvm.cttz.i64(i64 %x, i1 false)
  %ctz32 = trunc i64 %ctz to i32
  br label %exit

exit:
  %res = phi i32 [ %ctz32, %non_zero ], [ 0, %start ]
  ret i32 %res
}

define i32 @test1(i64 %x) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i64 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[NON_ZERO:%.*]]
; CHECK:       non_zero:
; CHECK-NEXT:    [[CTZ:%.*]] = call i64 @llvm.ctlz.i64(i64 [[X]], i1 false), !range !0
; CHECK-NEXT:    [[CTZ32:%.*]] = trunc i64 [[CTZ]] to i32
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[CTZ32]], [[NON_ZERO]] ], [ 0, [[START:%.*]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
start:
  %c = icmp eq i64 %x, 0
  br i1 %c, label %exit, label %non_zero

non_zero:
  %ctz = call i64 @llvm.ctlz.i64(i64 %x, i1 false)
  %ctz32 = trunc i64 %ctz to i32
  br label %exit

exit:
  %res = phi i32 [ %ctz32, %non_zero ], [ 0, %start ]
  ret i32 %res
}

define <8 x i64> @test2(<8 x i64> %x) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[A:%.*]] = icmp eq <8 x i64> [[X:%.*]], zeroinitializer
; CHECK-NEXT:    [[B:%.*]] = bitcast <8 x i1> [[A]] to i8
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[B]], 0
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[NON_ZERO:%.*]]
; CHECK:       non_zero:
; CHECK-NEXT:    [[CTZ:%.*]] = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> [[X]], i1 false)
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi <8 x i64> [ [[CTZ]], [[NON_ZERO]] ], [ zeroinitializer, [[START:%.*]] ]
; CHECK-NEXT:    ret <8 x i64> [[RES]]
;
start:
  %a = icmp eq <8 x i64> %x, zeroinitializer
  %b = bitcast <8 x i1> %a to i8
  %c = icmp eq i8 %b, 0
  br i1 %c, label %exit, label %non_zero

non_zero:
  ; NB: We cannot determine that vectors are known to be zero based
  ; on the dominating condition
  %ctz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %x, i1 false)
  br label %exit

exit:
  %res = phi <8 x i64> [ %ctz, %non_zero ], [ zeroinitializer, %start ]
  ret <8 x i64> %res
}
