/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;

public class TextFileReader {
    private RandomAccessInterface dataFile;
    private RowInputInterface rowIn;
    private TextFileSettings textFileSettings;
    private String header;
    private boolean isReadOnly;
    private HsqlByteArrayOutputStream buffer;

    TextFileReader(RandomAccessInterface randomAccessInterface, TextFileSettings textFileSettings, RowInputInterface rowInputInterface, boolean bl) {
        this.dataFile = randomAccessInterface;
        this.textFileSettings = textFileSettings;
        this.rowIn = rowInputInterface;
        this.isReadOnly = bl;
        this.buffer = new HsqlByteArrayOutputStream(128);
    }

    public RowInputInterface readObject(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.buffer.reset();
        n = this.findNextUsedLinePos(n);
        if (n == -1) {
            return null;
        }
        try {
            this.dataFile.seek(n);
            while (!bl2) {
                int n2 = this.dataFile.read();
                bl4 = false;
                if (n2 == -1) {
                    if (this.buffer.size() == 0) {
                        return null;
                    }
                    bl2 = true;
                    if (bl3 || this.isReadOnly) break;
                    this.dataFile.write(TextFileSettings.BYTES_LINE_SEP, 0, TextFileSettings.BYTES_LINE_SEP.length);
                    this.buffer.write(TextFileSettings.BYTES_LINE_SEP);
                    break;
                }
                switch (n2) {
                    case 34: {
                        bl4 = true;
                        bl2 = bl3;
                        bl3 = false;
                        if (!this.textFileSettings.isQuoted) break;
                        bl = !bl;
                        break;
                    }
                    case 13: {
                        bl3 = !bl;
                        break;
                    }
                    case 10: {
                        bl2 = !bl;
                        break;
                    }
                    default: {
                        bl4 = true;
                        bl2 = bl3;
                        bl3 = false;
                    }
                }
                this.buffer.write(n2);
            }
            if (bl2) {
                String string;
                if (bl4) {
                    this.buffer.setPosition(this.buffer.size() - 1);
                }
                try {
                    string = this.buffer.toString(this.textFileSettings.stringEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = this.buffer.toString();
                }
                ((RowInputText)this.rowIn).setSource(string, n, this.buffer.size());
                return this.rowIn;
            }
            return null;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public int readHeaderLine() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.buffer.reset();
        try {
            this.dataFile.seek(0L);
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
        while (!bl) {
            int n;
            bl3 = false;
            try {
                n = this.dataFile.read();
                if (n == -1) {
                    if (this.buffer.size() == 0) {
                        return 0;
                    }
                    bl = true;
                    if (this.isReadOnly) break;
                    this.dataFile.write(TextFileSettings.BYTES_LINE_SEP, 0, TextFileSettings.BYTES_LINE_SEP.length);
                    this.buffer.write(TextFileSettings.BYTES_LINE_SEP);
                    break;
                }
            }
            catch (IOException iOException) {
                throw Error.error(483);
            }
            switch (n) {
                case 13: {
                    bl2 = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                default: {
                    bl3 = true;
                    bl = bl2;
                    bl2 = false;
                }
            }
            if (bl2 || bl) continue;
            this.buffer.write(n);
        }
        if (bl3) {
            this.buffer.setPosition(this.buffer.size() - 1);
        }
        try {
            this.header = this.buffer.toString(this.textFileSettings.stringEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.header = this.buffer.toString();
        }
        return this.buffer.size();
    }

    private int findNextUsedLinePos(int n) {
        try {
            int n2 = n;
            int n3 = n;
            boolean bl = false;
            this.dataFile.seek(n);
            block8: while (true) {
                int n4 = this.dataFile.read();
                ++n3;
                switch (n4) {
                    case 13: {
                        bl = true;
                        continue block8;
                    }
                    case 10: {
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        n2 = n3;
                        continue block8;
                    }
                    case 32: {
                        if (!bl) continue block8;
                        bl = false;
                        ((RowInputText)this.rowIn).skippedLine();
                        continue block8;
                    }
                    case -1: {
                        return -1;
                    }
                }
                break;
            }
            if (bl) {
                bl = false;
                ((RowInputText)this.rowIn).skippedLine();
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public String getHeaderLine() {
        return this.header;
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }
}

