/* serializer.c generated by valac 0.40.6, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>


#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
typedef struct _SerializerPrivate SerializerPrivate;
enum  {
	SERIALIZER_0_PROPERTY,
	SERIALIZER_ERROR_PROPERTY,
	SERIALIZER_NUM_PROPERTIES
};
static GParamSpec* serializer_properties[SERIALIZER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

struct _Serializer {
	GObject parent_instance;
	SerializerPrivate * priv;
};

struct _SerializerClass {
	GObjectClass parent_class;
};

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
	gchar* _error;
};


static gpointer serializer_parent_class = NULL;

GType display_format_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERIALIZER, SerializerPrivate))
Serializer* serializer_new (DisplayFormat format,
                            gint number_base,
                            gint trailing_digits);
Serializer* serializer_construct (GType object_type,
                                  DisplayFormat format,
                                  gint number_base,
                                  gint trailing_digits);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self,
                             Number* x);
static gchar* serializer_cast_to_string (Serializer* self,
                                  Number* x,
                                  gint* n_digits);
gint serializer_get_base (Serializer* self);
static gchar* serializer_cast_to_exponential_string (Serializer* self,
                                              Number* x,
                                              gboolean eng_format,
                                              gint* n_digits);
Number* serializer_from_string (Serializer* self,
                                const gchar* str);
Number* mp_set_from_string (const gchar* str,
                            gint default_base);
void serializer_set_base (Serializer* self,
                          gint number_base);
void serializer_set_representation_base (Serializer* self,
                                         guint representation_base);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_radix (Serializer* self,
                           gunichar radix);
gunichar serializer_get_radix (Serializer* self);
void serializer_set_thousands_separator (Serializer* self,
                                         gunichar separator);
gunichar serializer_get_thousands_separator (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
void serializer_set_thousands_separator_count (Serializer* self,
                                               gint count);
void serializer_set_show_thousands_separators (Serializer* self,
                                               gboolean visible);
gboolean serializer_get_show_thousands_separators (Serializer* self);
void serializer_set_show_trailing_zeroes (Serializer* self,
                                          gboolean visible);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
gint serializer_get_leading_digits (Serializer* self);
void serializer_set_leading_digits (Serializer* self,
                                    gint leading_digits);
gint serializer_get_trailing_digits (Serializer* self);
void serializer_set_trailing_digits (Serializer* self,
                                     gint trailing_digits);
DisplayFormat serializer_get_number_format (Serializer* self);
void serializer_set_number_format (Serializer* self,
                                   DisplayFormat format);
Number* number_real_component (Number* self);
static void serializer_cast_to_string_real (Serializer* self,
                                     Number* x,
                                     gint number_base,
                                     gboolean force_sign,
                                     gint* n_digits,
                                     GString* string);
gboolean number_is_complex (Number* self);
Number* number_imaginary_component (Number* self);
gboolean number_is_negative (Number* self);
Number* number_abs (Number* self);
Number* number_new_integer (gint64 real,
                            gint64 imag);
Number* number_construct_integer (GType object_type,
                                  gint64 real,
                                  gint64 imag);
Number* number_xpowy_integer (Number* self,
                              gint64 n);
Number* number_multiply_integer (Number* self,
                                 gint64 y);
Number* number_divide_integer (Number* self,
                               gint64 y);
Number* number_add (Number* self,
                    Number* y);
Number* number_floor (Number* self);
gboolean number_is_zero (Number* self);
Number* number_subtract (Number* self,
                         Number* y);
gint64 number_to_integer (Number* self);
void serializer_set_error (Serializer* self,
                           const gchar* value);
Number* number_fractional_component (Number* self);
static gint serializer_cast_to_exponential_string_real (Serializer* self,
                                                 Number* x,
                                                 GString* string,
                                                 gboolean eng_format,
                                                 gint* n_digits);
Number* number_divide (Number* self,
                       Number* y);
gint number_compare (Number* self,
                     Number* y);
Number* number_multiply (Number* self,
                         Number* y);
static void serializer_append_exponent (Serializer* self,
                                 GString* string,
                                 gint exponent);
const gchar* serializer_get_error (Serializer* self);
static void serializer_finalize (GObject * obj);
static void _vala_serializer_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_serializer_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);


GType
display_format_get_type (void)
{
	static volatile gsize display_format_type_id__volatile = 0;
	if (g_once_init_enter (&display_format_type_id__volatile)) {
		static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
		GType display_format_type_id;
		display_format_type_id = g_enum_register_static ("DisplayFormat", values);
		g_once_init_leave (&display_format_type_id__volatile, display_format_type_id);
	}
	return display_format_type_id__volatile;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


Serializer*
serializer_construct (GType object_type,
                      DisplayFormat format,
                      gint number_base,
                      gint trailing_digits)
{
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* tsep_string = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	self = (Serializer*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	_tmp1_ = g_strdup (_tmp0_);
	radix_string = _tmp1_;
	_tmp3_ = radix_string;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = radix_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* radix_utf8 = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = radix_string;
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) -1, NULL, NULL, NULL);
		radix_utf8 = _tmp6_;
		_tmp7_ = radix_utf8;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			_tmp8_ = radix_utf8;
			self->priv->radix = string_get_char (_tmp8_, (glong) 0);
		} else {
			self->priv->radix = (gunichar) '.';
		}
		_g_free0 (radix_utf8);
	} else {
		self->priv->radix = (gunichar) '.';
	}
	_tmp9_ = nl_langinfo (THOUSEP);
	_tmp10_ = g_strdup (_tmp9_);
	tsep_string = _tmp10_;
	_tmp12_ = tsep_string;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = tsep_string;
		_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* tsep_utf8 = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = tsep_string;
		_tmp15_ = g_locale_to_utf8 (_tmp14_, (gssize) -1, NULL, NULL, NULL);
		tsep_utf8 = _tmp15_;
		_tmp16_ = tsep_utf8;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			_tmp17_ = tsep_utf8;
			self->priv->tsep = string_get_char (_tmp17_, (glong) 0);
		} else {
			self->priv->tsep = (gunichar) ' ';
		}
		_g_free0 (tsep_utf8);
	} else {
		self->priv->tsep = (gunichar) ' ';
	}
	self->priv->tsep_count = 3;
	self->priv->number_base = number_base;
	self->priv->representation_base = (guint) number_base;
	self->priv->leading_digits = 12;
	self->priv->trailing_digits = trailing_digits;
	self->priv->show_zeroes = FALSE;
	self->priv->show_tsep = FALSE;
	self->priv->format = format;
	_g_free0 (tsep_string);
	_g_free0 (radix_string);
	return self;
}


Serializer*
serializer_new (DisplayFormat format,
                gint number_base,
                gint trailing_digits)
{
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
}


gchar*
serializer_to_string (Serializer* self,
                      Number* x)
{
	gchar* result = NULL;
	guint _tmp0_;
	gint _tmp1_;
	DisplayFormat _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->representation_base;
	_tmp1_ = self->priv->number_base;
	if (_tmp0_ != ((guint) _tmp1_)) {
		gint n_digits = 0;
		gchar* _tmp2_;
		n_digits = 0;
		_tmp2_ = serializer_cast_to_string (self, x, &n_digits);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->format;
	switch (_tmp3_) {
		default:
		case DISPLAY_FORMAT_AUTOMATIC:
		{
			gint n_digits = 0;
			gchar* s0 = NULL;
			gchar* _tmp4_;
			n_digits = 0;
			_tmp4_ = serializer_cast_to_string (self, x, &n_digits);
			s0 = _tmp4_;
			switch (serializer_get_base (self)) {
				case 2:
				{
					gint _tmp5_;
					_tmp5_ = n_digits;
					if (_tmp5_ <= 64) {
						result = s0;
						return result;
					} else {
						gchar* _tmp6_;
						_tmp6_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp6_;
						_g_free0 (s0);
						return result;
					}
				}
				case 8:
				{
					gint _tmp7_;
					_tmp7_ = n_digits;
					if (_tmp7_ <= 22) {
						result = s0;
						return result;
					} else {
						gchar* _tmp8_;
						_tmp8_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp8_;
						_g_free0 (s0);
						return result;
					}
				}
				case 16:
				{
					gint _tmp9_;
					_tmp9_ = n_digits;
					if (_tmp9_ <= 16) {
						result = s0;
						return result;
					} else {
						gchar* _tmp10_;
						_tmp10_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp10_;
						_g_free0 (s0);
						return result;
					}
				}
				default:
				case 10:
				{
					gint _tmp11_;
					gint _tmp12_;
					_tmp11_ = n_digits;
					_tmp12_ = self->priv->leading_digits;
					if (_tmp11_ <= _tmp12_) {
						result = s0;
						return result;
					} else {
						gchar* _tmp13_;
						_tmp13_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
						result = _tmp13_;
						_g_free0 (s0);
						return result;
					}
				}
			}
			_g_free0 (s0);
		}
		case DISPLAY_FORMAT_FIXED:
		{
			gint n_digits = 0;
			gchar* _tmp14_;
			n_digits = 0;
			_tmp14_ = serializer_cast_to_string (self, x, &n_digits);
			result = _tmp14_;
			return result;
		}
		case DISPLAY_FORMAT_SCIENTIFIC:
		{
			guint _tmp15_;
			_tmp15_ = self->priv->representation_base;
			if (_tmp15_ == ((guint) 10)) {
				gint n_digits = 0;
				gchar* _tmp16_;
				n_digits = 0;
				_tmp16_ = serializer_cast_to_exponential_string (self, x, FALSE, &n_digits);
				result = _tmp16_;
				return result;
			} else {
				gint n_digits = 0;
				gchar* _tmp17_;
				n_digits = 0;
				_tmp17_ = serializer_cast_to_string (self, x, &n_digits);
				result = _tmp17_;
				return result;
			}
		}
		case DISPLAY_FORMAT_ENGINEERING:
		{
			guint _tmp18_;
			_tmp18_ = self->priv->representation_base;
			if (_tmp18_ == ((guint) 10)) {
				gint n_digits = 0;
				gchar* _tmp19_;
				n_digits = 0;
				_tmp19_ = serializer_cast_to_exponential_string (self, x, TRUE, &n_digits);
				result = _tmp19_;
				return result;
			} else {
				gint n_digits = 0;
				gchar* _tmp20_;
				n_digits = 0;
				_tmp20_ = serializer_cast_to_string (self, x, &n_digits);
				result = _tmp20_;
				return result;
			}
		}
	}
}


Number*
serializer_from_string (Serializer* self,
                        const gchar* str)
{
	Number* result = NULL;
	gint _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = self->priv->number_base;
	_tmp1_ = mp_set_from_string (str, _tmp0_);
	result = _tmp1_;
	return result;
}


void
serializer_set_base (Serializer* self,
                     gint number_base)
{
	g_return_if_fail (self != NULL);
	self->priv->number_base = number_base;
}


gint
serializer_get_base (Serializer* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->number_base;
	result = _tmp0_;
	return result;
}


void
serializer_set_representation_base (Serializer* self,
                                    guint representation_base)
{
	g_return_if_fail (self != NULL);
	self->priv->representation_base = representation_base;
}


guint
serializer_get_representation_base (Serializer* self)
{
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->representation_base;
	result = _tmp0_;
	return result;
}


void
serializer_set_radix (Serializer* self,
                      gunichar radix)
{
	g_return_if_fail (self != NULL);
	self->priv->radix = radix;
}


gunichar
serializer_get_radix (Serializer* self)
{
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->radix;
	result = _tmp0_;
	return result;
}


void
serializer_set_thousands_separator (Serializer* self,
                                    gunichar separator)
{
	g_return_if_fail (self != NULL);
	self->priv->tsep = separator;
}


gunichar
serializer_get_thousands_separator (Serializer* self)
{
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->tsep;
	result = _tmp0_;
	return result;
}


gint
serializer_get_thousands_separator_count (Serializer* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tsep_count;
	result = _tmp0_;
	return result;
}


void
serializer_set_thousands_separator_count (Serializer* self,
                                          gint count)
{
	g_return_if_fail (self != NULL);
	self->priv->tsep_count = count;
}


void
serializer_set_show_thousands_separators (Serializer* self,
                                          gboolean visible)
{
	g_return_if_fail (self != NULL);
	self->priv->show_tsep = visible;
}


gboolean
serializer_get_show_thousands_separators (Serializer* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_tsep;
	result = _tmp0_;
	return result;
}


void
serializer_set_show_trailing_zeroes (Serializer* self,
                                     gboolean visible)
{
	g_return_if_fail (self != NULL);
	self->priv->show_zeroes = visible;
}


gboolean
serializer_get_show_trailing_zeroes (Serializer* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_zeroes;
	result = _tmp0_;
	return result;
}


gint
serializer_get_leading_digits (Serializer* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->leading_digits;
	result = _tmp0_;
	return result;
}


void
serializer_set_leading_digits (Serializer* self,
                               gint leading_digits)
{
	g_return_if_fail (self != NULL);
	self->priv->leading_digits = leading_digits;
}


gint
serializer_get_trailing_digits (Serializer* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->trailing_digits;
	result = _tmp0_;
	return result;
}


void
serializer_set_trailing_digits (Serializer* self,
                                gint trailing_digits)
{
	g_return_if_fail (self != NULL);
	self->priv->trailing_digits = trailing_digits;
}


DisplayFormat
serializer_get_number_format (Serializer* self)
{
	DisplayFormat result = 0;
	DisplayFormat _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->format;
	result = _tmp0_;
	return result;
}


void
serializer_set_number_format (Serializer* self,
                              DisplayFormat format)
{
	g_return_if_fail (self != NULL);
	self->priv->format = format;
}


static gchar*
serializer_cast_to_string (Serializer* self,
                           Number* x,
                           gint* n_digits)
{
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	guint _tmp3_;
	GString* _tmp4_;
	GString* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = number_real_component (x);
	x_real = _tmp1_;
	_tmp2_ = x_real;
	_tmp3_ = self->priv->representation_base;
	_tmp4_ = string;
	serializer_cast_to_string_real (self, _tmp2_, (gint) _tmp3_, FALSE, n_digits, _tmp4_);
	if (number_is_complex (x)) {
		Number* x_im = NULL;
		Number* _tmp5_;
		gboolean force_sign = FALSE;
		GString* _tmp6_;
		const gchar* _tmp7_;
		GString* s = NULL;
		GString* _tmp9_;
		gint n_complex_digits = 0;
		Number* _tmp10_;
		guint _tmp11_;
		gboolean _tmp12_;
		GString* _tmp13_;
		gint _tmp14_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		GString* _tmp18_;
		const gchar* _tmp19_;
		_tmp5_ = number_imaginary_component (x);
		x_im = _tmp5_;
		force_sign = TRUE;
		_tmp6_ = string;
		_tmp7_ = _tmp6_->str;
		if (g_strcmp0 (_tmp7_, "0") == 0) {
			GString* _tmp8_;
			_tmp8_ = string;
			g_string_assign (_tmp8_, "");
			force_sign = FALSE;
		}
		_tmp9_ = g_string_sized_new ((gsize) 1024);
		s = _tmp9_;
		n_complex_digits = 0;
		_tmp10_ = x_im;
		_tmp11_ = self->priv->representation_base;
		_tmp12_ = force_sign;
		_tmp13_ = s;
		serializer_cast_to_string_real (self, _tmp10_, (gint) _tmp11_, _tmp12_, &n_complex_digits, _tmp13_);
		_tmp14_ = n_complex_digits;
		if (_tmp14_ > (*n_digits)) {
			gint _tmp15_;
			_tmp15_ = n_complex_digits;
			*n_digits = _tmp15_;
		}
		_tmp18_ = s;
		_tmp19_ = _tmp18_->str;
		if (g_strcmp0 (_tmp19_, "0") == 0) {
			_tmp17_ = TRUE;
		} else {
			GString* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = s;
			_tmp21_ = _tmp20_->str;
			_tmp17_ = g_strcmp0 (_tmp21_, "+0") == 0;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			GString* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = s;
			_tmp23_ = _tmp22_->str;
			_tmp16_ = g_strcmp0 (_tmp23_, "−0") == 0;
		}
		if (_tmp16_) {
		} else {
			GString* _tmp24_;
			const gchar* _tmp25_;
			_tmp24_ = s;
			_tmp25_ = _tmp24_->str;
			if (g_strcmp0 (_tmp25_, "1") == 0) {
				GString* _tmp26_;
				_tmp26_ = string;
				g_string_append (_tmp26_, "i");
			} else {
				GString* _tmp27_;
				const gchar* _tmp28_;
				_tmp27_ = s;
				_tmp28_ = _tmp27_->str;
				if (g_strcmp0 (_tmp28_, "+1") == 0) {
					GString* _tmp29_;
					_tmp29_ = string;
					g_string_append (_tmp29_, "+i");
				} else {
					GString* _tmp30_;
					const gchar* _tmp31_;
					_tmp30_ = s;
					_tmp31_ = _tmp30_->str;
					if (g_strcmp0 (_tmp31_, "−1") == 0) {
						GString* _tmp32_;
						_tmp32_ = string;
						g_string_append (_tmp32_, "−i");
					} else {
						GString* _tmp33_;
						const gchar* _tmp34_;
						GString* _tmp41_;
						_tmp33_ = s;
						_tmp34_ = _tmp33_->str;
						if (g_strcmp0 (_tmp34_, "+0") == 0) {
							GString* _tmp35_;
							_tmp35_ = string;
							g_string_append (_tmp35_, "+");
						} else {
							GString* _tmp36_;
							const gchar* _tmp37_;
							_tmp36_ = s;
							_tmp37_ = _tmp36_->str;
							if (g_strcmp0 (_tmp37_, "0") != 0) {
								GString* _tmp38_;
								GString* _tmp39_;
								const gchar* _tmp40_;
								_tmp38_ = string;
								_tmp39_ = s;
								_tmp40_ = _tmp39_->str;
								g_string_append (_tmp38_, _tmp40_);
							}
						}
						_tmp41_ = string;
						g_string_append (_tmp41_, "i");
					}
				}
			}
		}
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp42_ = string;
	_tmp43_ = _tmp42_->str;
	_tmp44_ = g_strdup (_tmp43_);
	result = _tmp44_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
serializer_cast_to_string_real (Serializer* self,
                                Number* x,
                                gint number_base,
                                gboolean force_sign,
                                gint* n_digits,
                                GString* string)
{
	static const gchar digits[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	Number* number = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* temp = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	gint _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* rounded_number = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	gint i = 0;
	gssize last_non_zero = 0L;
	gssize _tmp44_;
	gunichar _tmp45_;
	Number* _tmp46_;
	Number* _tmp47_;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp66_;
	gboolean _tmp69_ = FALSE;
	const gchar* _tmp70_;
	gint _tmp71_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = _g_object_ref0 (x);
	number = _tmp0_;
	_tmp1_ = number;
	if (number_is_negative (_tmp1_)) {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = number;
		_tmp3_ = number_abs (_tmp2_);
		_g_object_unref0 (number);
		number = _tmp3_;
	}
	_tmp4_ = number_new_integer ((gint64) number_base, (gint64) 0);
	temp = _tmp4_;
	_tmp5_ = temp;
	_tmp6_ = self->priv->trailing_digits;
	_tmp7_ = number_xpowy_integer (_tmp5_, (gint64) (-(_tmp6_ + 1)));
	_g_object_unref0 (temp);
	temp = _tmp7_;
	_tmp8_ = temp;
	_tmp9_ = number_multiply_integer (_tmp8_, (gint64) number_base);
	_g_object_unref0 (temp);
	temp = _tmp9_;
	_tmp10_ = temp;
	_tmp11_ = number_divide_integer (_tmp10_, (gint64) 2);
	_g_object_unref0 (temp);
	temp = _tmp11_;
	_tmp12_ = number;
	_tmp13_ = temp;
	_tmp14_ = number_add (_tmp12_, _tmp13_);
	rounded_number = _tmp14_;
	_tmp15_ = rounded_number;
	_tmp16_ = number_floor (_tmp15_);
	_g_object_unref0 (temp);
	temp = _tmp16_;
	i = 0;
	{
		gboolean _tmp17_ = FALSE;
		_tmp17_ = TRUE;
		while (TRUE) {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gint _tmp25_;
			Number* t = NULL;
			Number* _tmp26_;
			Number* _tmp27_;
			Number* _tmp28_;
			Number* _tmp29_;
			Number* t2 = NULL;
			Number* _tmp30_;
			Number* _tmp31_;
			Number* t3 = NULL;
			Number* _tmp32_;
			Number* _tmp33_;
			Number* _tmp34_;
			gint64 d = 0LL;
			Number* _tmp35_;
			gboolean _tmp36_ = FALSE;
			gint64 _tmp37_;
			gint _tmp41_;
			Number* _tmp42_;
			Number* _tmp43_;
			if (!_tmp17_) {
				Number* _tmp18_;
				_tmp18_ = temp;
				if (!(!number_is_zero (_tmp18_))) {
					break;
				}
			}
			_tmp17_ = FALSE;
			if (number_base == 10) {
				gboolean _tmp21_;
				_tmp21_ = self->priv->show_tsep;
				_tmp20_ = _tmp21_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				gint _tmp22_;
				gint _tmp23_;
				_tmp22_ = i;
				_tmp23_ = self->priv->tsep_count;
				_tmp19_ = _tmp22_ == _tmp23_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				gunichar _tmp24_;
				_tmp24_ = self->priv->tsep;
				g_string_prepend_unichar (string, _tmp24_);
				i = 0;
			}
			_tmp25_ = i;
			i = _tmp25_ + 1;
			_tmp26_ = temp;
			_tmp27_ = number_divide_integer (_tmp26_, (gint64) number_base);
			t = _tmp27_;
			_tmp28_ = t;
			_tmp29_ = number_floor (_tmp28_);
			_g_object_unref0 (t);
			t = _tmp29_;
			_tmp30_ = t;
			_tmp31_ = number_multiply_integer (_tmp30_, (gint64) number_base);
			t2 = _tmp31_;
			_tmp32_ = temp;
			_tmp33_ = t2;
			_tmp34_ = number_subtract (_tmp32_, _tmp33_);
			t3 = _tmp34_;
			_tmp35_ = t3;
			d = number_to_integer (_tmp35_);
			_tmp37_ = d;
			if (_tmp37_ < ((gint64) 16)) {
				gint64 _tmp38_;
				_tmp38_ = d;
				_tmp36_ = _tmp38_ >= ((gint64) 0);
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				gint64 _tmp39_;
				gchar _tmp40_;
				_tmp39_ = d;
				_tmp40_ = digits[_tmp39_];
				g_string_prepend_c (string, _tmp40_);
			} else {
				g_string_prepend_c (string, '?');
				serializer_set_error (self, _ ("Overflow: the result couldn’t be calculated"));
				g_string_assign (string, "0");
				_g_object_unref0 (t3);
				_g_object_unref0 (t2);
				_g_object_unref0 (t);
				break;
			}
			_tmp41_ = *n_digits;
			*n_digits = _tmp41_ + 1;
			_tmp42_ = t;
			_tmp43_ = _g_object_ref0 (_tmp42_);
			_g_object_unref0 (temp);
			temp = _tmp43_;
			_g_object_unref0 (t3);
			_g_object_unref0 (t2);
			_g_object_unref0 (t);
		}
	}
	_tmp44_ = string->len;
	last_non_zero = _tmp44_;
	_tmp45_ = self->priv->radix;
	g_string_append_unichar (string, _tmp45_);
	_tmp46_ = rounded_number;
	_tmp47_ = number_fractional_component (_tmp46_);
	_g_object_unref0 (temp);
	temp = _tmp47_;
	{
		gboolean _tmp48_ = FALSE;
		i = 0;
		_tmp48_ = TRUE;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			Number* _tmp52_;
			Number* _tmp53_;
			Number* _tmp54_;
			Number* digit = NULL;
			Number* _tmp55_;
			Number* _tmp56_;
			gint64 d = 0LL;
			Number* _tmp57_;
			gint64 _tmp58_;
			gchar _tmp59_;
			gint64 _tmp60_;
			Number* _tmp62_;
			Number* _tmp63_;
			Number* _tmp64_;
			if (!_tmp48_) {
				gint _tmp49_;
				_tmp49_ = i;
				i = _tmp49_ + 1;
			}
			_tmp48_ = FALSE;
			_tmp50_ = i;
			_tmp51_ = self->priv->trailing_digits;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = temp;
			if (number_is_zero (_tmp52_)) {
				break;
			}
			_tmp53_ = temp;
			_tmp54_ = number_multiply_integer (_tmp53_, (gint64) number_base);
			_g_object_unref0 (temp);
			temp = _tmp54_;
			_tmp55_ = temp;
			_tmp56_ = number_floor (_tmp55_);
			digit = _tmp56_;
			_tmp57_ = digit;
			d = number_to_integer (_tmp57_);
			_tmp58_ = d;
			_tmp59_ = digits[_tmp58_];
			g_string_append_c (string, _tmp59_);
			_tmp60_ = d;
			if (_tmp60_ != ((gint64) 0)) {
				gssize _tmp61_;
				_tmp61_ = string->len;
				last_non_zero = _tmp61_;
			}
			_tmp62_ = temp;
			_tmp63_ = digit;
			_tmp64_ = number_subtract (_tmp62_, _tmp63_);
			_g_object_unref0 (temp);
			temp = _tmp64_;
			_g_object_unref0 (digit);
		}
	}
	_tmp66_ = self->priv->show_zeroes;
	if (!_tmp66_) {
		_tmp65_ = TRUE;
	} else {
		gint _tmp67_;
		_tmp67_ = self->priv->trailing_digits;
		_tmp65_ = _tmp67_ == 0;
	}
	if (_tmp65_) {
		gssize _tmp68_;
		_tmp68_ = last_non_zero;
		g_string_truncate (string, (gsize) _tmp68_);
	}
	_tmp70_ = string->str;
	if (g_strcmp0 (_tmp70_, "0") != 0) {
		_tmp69_ = TRUE;
	} else {
		_tmp69_ = force_sign;
	}
	if (_tmp69_) {
		if (number_is_negative (x)) {
			g_string_prepend (string, "−");
		} else {
			if (force_sign) {
				g_string_prepend (string, "+");
			}
		}
	}
	_tmp71_ = self->priv->number_base;
	if (number_base != _tmp71_) {
		static const gchar* sub_digits[10] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
		gint multiplier = 0;
		gint b = 0;
		multiplier = 1;
		b = number_base;
		while (TRUE) {
			gint _tmp72_;
			gint _tmp73_;
			_tmp72_ = multiplier;
			if (!((number_base / _tmp72_) != 0)) {
				break;
			}
			_tmp73_ = multiplier;
			multiplier = _tmp73_ * 10;
		}
		while (TRUE) {
			gint _tmp74_;
			gint d = 0;
			gint _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			const gchar* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			_tmp74_ = multiplier;
			if (!(_tmp74_ != 1)) {
				break;
			}
			_tmp75_ = multiplier;
			multiplier = _tmp75_ / 10;
			_tmp76_ = b;
			_tmp77_ = multiplier;
			d = _tmp76_ / _tmp77_;
			_tmp78_ = d;
			_tmp79_ = sub_digits[_tmp78_];
			g_string_append (string, _tmp79_);
			_tmp80_ = b;
			_tmp81_ = d;
			_tmp82_ = multiplier;
			b = _tmp80_ - (_tmp81_ * _tmp82_);
		}
	}
	_g_object_unref0 (rounded_number);
	_g_object_unref0 (temp);
	_g_object_unref0 (number);
}


static gint
serializer_cast_to_exponential_string_real (Serializer* self,
                                            Number* x,
                                            GString* string,
                                            gboolean eng_format,
                                            gint* n_digits)
{
	gint result = 0;
	Number* mantissa = NULL;
	Number* _tmp0_;
	Number* base_ = NULL;
	gint _tmp1_;
	Number* _tmp2_;
	Number* base3 = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* base10 = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* t = NULL;
	Number* _tmp7_;
	Number* base10inv = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	gint exponent = 0;
	Number* _tmp11_;
	Number* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (string != NULL, 0);
	if (number_is_negative (x)) {
		g_string_append (string, "−");
	}
	_tmp0_ = number_abs (x);
	mantissa = _tmp0_;
	_tmp1_ = self->priv->number_base;
	_tmp2_ = number_new_integer ((gint64) _tmp1_, (gint64) 0);
	base_ = _tmp2_;
	_tmp3_ = base_;
	_tmp4_ = number_xpowy_integer (_tmp3_, (gint64) 3);
	base3 = _tmp4_;
	_tmp5_ = base_;
	_tmp6_ = number_xpowy_integer (_tmp5_, (gint64) 10);
	base10 = _tmp6_;
	_tmp7_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp7_;
	_tmp8_ = t;
	_tmp9_ = base10;
	_tmp10_ = number_divide (_tmp8_, _tmp9_);
	base10inv = _tmp10_;
	exponent = 0;
	_tmp11_ = mantissa;
	if (!number_is_zero (_tmp11_)) {
		Number* _tmp39_;
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			gint _tmp15_;
			Number* _tmp16_;
			Number* _tmp17_;
			Number* _tmp18_;
			if (!eng_format) {
				Number* _tmp13_;
				Number* _tmp14_;
				_tmp13_ = mantissa;
				_tmp14_ = base10;
				_tmp12_ = number_compare (_tmp13_, _tmp14_) >= 0;
			} else {
				_tmp12_ = FALSE;
			}
			if (!_tmp12_) {
				break;
			}
			_tmp15_ = exponent;
			exponent = _tmp15_ + 10;
			_tmp16_ = mantissa;
			_tmp17_ = base10inv;
			_tmp18_ = number_multiply (_tmp16_, _tmp17_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp18_;
		}
		while (TRUE) {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gint _tmp28_;
			Number* _tmp29_;
			Number* _tmp30_;
			Number* _tmp31_;
			if (!eng_format) {
				Number* _tmp21_;
				Number* _tmp22_;
				_tmp21_ = mantissa;
				_tmp22_ = base_;
				_tmp20_ = number_compare (_tmp21_, _tmp22_) >= 0;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				gboolean _tmp23_ = FALSE;
				if (eng_format) {
					gboolean _tmp24_ = FALSE;
					Number* _tmp25_;
					Number* _tmp26_;
					_tmp25_ = mantissa;
					_tmp26_ = base3;
					if (number_compare (_tmp25_, _tmp26_) >= 0) {
						_tmp24_ = TRUE;
					} else {
						gint _tmp27_;
						_tmp27_ = exponent;
						_tmp24_ = (_tmp27_ % 3) != 0;
					}
					_tmp23_ = _tmp24_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp19_ = _tmp23_;
			}
			if (!_tmp19_) {
				break;
			}
			_tmp28_ = exponent;
			exponent = _tmp28_ + 1;
			_tmp29_ = mantissa;
			_tmp30_ = base_;
			_tmp31_ = number_divide (_tmp29_, _tmp30_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp31_;
		}
		while (TRUE) {
			gboolean _tmp32_ = FALSE;
			gint _tmp35_;
			Number* _tmp36_;
			Number* _tmp37_;
			Number* _tmp38_;
			if (!eng_format) {
				Number* _tmp33_;
				Number* _tmp34_;
				_tmp33_ = mantissa;
				_tmp34_ = base10inv;
				_tmp32_ = number_compare (_tmp33_, _tmp34_) < 0;
			} else {
				_tmp32_ = FALSE;
			}
			if (!_tmp32_) {
				break;
			}
			_tmp35_ = exponent;
			exponent = _tmp35_ - 10;
			_tmp36_ = mantissa;
			_tmp37_ = base10;
			_tmp38_ = number_multiply (_tmp36_, _tmp37_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp38_;
		}
		_tmp39_ = number_new_integer ((gint64) 1, (gint64) 0);
		_g_object_unref0 (t);
		t = _tmp39_;
		while (TRUE) {
			gboolean _tmp40_ = FALSE;
			Number* _tmp41_;
			Number* _tmp42_;
			gint _tmp45_;
			Number* _tmp46_;
			Number* _tmp47_;
			Number* _tmp48_;
			_tmp41_ = mantissa;
			_tmp42_ = t;
			if (number_compare (_tmp41_, _tmp42_) < 0) {
				_tmp40_ = TRUE;
			} else {
				gboolean _tmp43_ = FALSE;
				if (eng_format) {
					gint _tmp44_;
					_tmp44_ = exponent;
					_tmp43_ = (_tmp44_ % 3) != 0;
				} else {
					_tmp43_ = FALSE;
				}
				_tmp40_ = _tmp43_;
			}
			if (!_tmp40_) {
				break;
			}
			_tmp45_ = exponent;
			exponent = _tmp45_ - 1;
			_tmp46_ = mantissa;
			_tmp47_ = base_;
			_tmp48_ = number_multiply (_tmp46_, _tmp47_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp48_;
		}
	}
	_tmp49_ = mantissa;
	_tmp50_ = serializer_cast_to_string (self, _tmp49_, n_digits);
	_tmp51_ = _tmp50_;
	g_string_append (string, _tmp51_);
	_g_free0 (_tmp51_);
	result = exponent;
	_g_object_unref0 (base10inv);
	_g_object_unref0 (t);
	_g_object_unref0 (base10);
	_g_object_unref0 (base3);
	_g_object_unref0 (base_);
	_g_object_unref0 (mantissa);
	return result;
}


static gchar*
serializer_cast_to_exponential_string (Serializer* self,
                                       Number* x,
                                       gboolean eng_format,
                                       gint* n_digits)
{
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	gint exponent = 0;
	Number* _tmp2_;
	GString* _tmp3_;
	gint _tmp4_;
	GString* _tmp5_;
	gint _tmp6_;
	GString* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = number_real_component (x);
	x_real = _tmp1_;
	_tmp2_ = x_real;
	_tmp3_ = string;
	_tmp4_ = serializer_cast_to_exponential_string_real (self, _tmp2_, _tmp3_, eng_format, n_digits);
	exponent = _tmp4_;
	_tmp5_ = string;
	_tmp6_ = exponent;
	serializer_append_exponent (self, _tmp5_, _tmp6_);
	if (number_is_complex (x)) {
		Number* x_im = NULL;
		Number* _tmp7_;
		GString* _tmp8_;
		const gchar* _tmp9_;
		GString* s = NULL;
		GString* _tmp11_;
		gint n_complex_digits = 0;
		Number* _tmp12_;
		GString* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		GString* _tmp19_;
		const gchar* _tmp20_;
		GString* _tmp43_;
		gint _tmp44_;
		_tmp7_ = number_imaginary_component (x);
		x_im = _tmp7_;
		_tmp8_ = string;
		_tmp9_ = _tmp8_->str;
		if (g_strcmp0 (_tmp9_, "0") == 0) {
			GString* _tmp10_;
			_tmp10_ = string;
			g_string_assign (_tmp10_, "");
		}
		_tmp11_ = g_string_sized_new ((gsize) 1024);
		s = _tmp11_;
		n_complex_digits = 0;
		_tmp12_ = x_im;
		_tmp13_ = s;
		_tmp14_ = serializer_cast_to_exponential_string_real (self, _tmp12_, _tmp13_, eng_format, &n_complex_digits);
		exponent = _tmp14_;
		_tmp15_ = n_complex_digits;
		if (_tmp15_ > (*n_digits)) {
			gint _tmp16_;
			_tmp16_ = n_complex_digits;
			*n_digits = _tmp16_;
		}
		_tmp19_ = s;
		_tmp20_ = _tmp19_->str;
		if (g_strcmp0 (_tmp20_, "0") == 0) {
			_tmp18_ = TRUE;
		} else {
			GString* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = s;
			_tmp22_ = _tmp21_->str;
			_tmp18_ = g_strcmp0 (_tmp22_, "+0") == 0;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			GString* _tmp23_;
			const gchar* _tmp24_;
			_tmp23_ = s;
			_tmp24_ = _tmp23_->str;
			_tmp17_ = g_strcmp0 (_tmp24_, "−0") == 0;
		}
		if (_tmp17_) {
		} else {
			GString* _tmp25_;
			const gchar* _tmp26_;
			_tmp25_ = s;
			_tmp26_ = _tmp25_->str;
			if (g_strcmp0 (_tmp26_, "1") == 0) {
				GString* _tmp27_;
				_tmp27_ = string;
				g_string_append (_tmp27_, "i");
			} else {
				GString* _tmp28_;
				const gchar* _tmp29_;
				_tmp28_ = s;
				_tmp29_ = _tmp28_->str;
				if (g_strcmp0 (_tmp29_, "+1") == 0) {
					GString* _tmp30_;
					_tmp30_ = string;
					g_string_append (_tmp30_, "+i");
				} else {
					GString* _tmp31_;
					const gchar* _tmp32_;
					_tmp31_ = s;
					_tmp32_ = _tmp31_->str;
					if (g_strcmp0 (_tmp32_, "−1") == 0) {
						GString* _tmp33_;
						_tmp33_ = string;
						g_string_append (_tmp33_, "−i");
					} else {
						GString* _tmp34_;
						const gchar* _tmp35_;
						GString* _tmp42_;
						_tmp34_ = s;
						_tmp35_ = _tmp34_->str;
						if (g_strcmp0 (_tmp35_, "+0") == 0) {
							GString* _tmp36_;
							_tmp36_ = string;
							g_string_append (_tmp36_, "+");
						} else {
							GString* _tmp37_;
							const gchar* _tmp38_;
							_tmp37_ = s;
							_tmp38_ = _tmp37_->str;
							if (g_strcmp0 (_tmp38_, "0") != 0) {
								GString* _tmp39_;
								GString* _tmp40_;
								const gchar* _tmp41_;
								_tmp39_ = string;
								_tmp40_ = s;
								_tmp41_ = _tmp40_->str;
								g_string_append (_tmp39_, _tmp41_);
							}
						}
						_tmp42_ = string;
						g_string_append (_tmp42_, "i");
					}
				}
			}
		}
		_tmp43_ = string;
		_tmp44_ = exponent;
		serializer_append_exponent (self, _tmp43_, _tmp44_);
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp45_ = string;
	_tmp46_ = _tmp45_->str;
	_tmp47_ = g_strdup (_tmp46_);
	result = _tmp47_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static void
serializer_append_exponent (Serializer* self,
                            GString* string,
                            gint exponent)
{
	static const gunichar super_digits[10] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gchar* super_value = NULL;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (string != NULL);
	if (exponent == 0) {
		return;
	}
	g_string_append (string, "×10");
	if (exponent < 0) {
		exponent = -exponent;
		g_string_append_unichar (string, 8315U);
	}
	_tmp0_ = g_strdup_printf ("%d", exponent);
	super_value = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gunichar _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = super_value;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = super_value;
				_tmp8_ = i;
				_tmp9_ = super_digits[string_get (_tmp7_, (glong) _tmp8_) - '0'];
				g_string_append_unichar (string, _tmp9_);
			}
		}
	}
	_g_free0 (super_value);
}


const gchar*
serializer_get_error (Serializer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}


void
serializer_set_error (Serializer* self,
                      const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, serializer_get_error (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_error);
		self->priv->_error = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, serializer_properties[SERIALIZER_ERROR_PROPERTY]);
	}
}


static void
serializer_class_init (SerializerClass * klass)
{
	serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SerializerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_serializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_serializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SERIALIZER_ERROR_PROPERTY, serializer_properties[SERIALIZER_ERROR_PROPERTY] = g_param_spec_string ("error", "error", "error", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
serializer_instance_init (Serializer * self)
{
	self->priv = SERIALIZER_GET_PRIVATE (self);
	self->priv->_error = NULL;
}


static void
serializer_finalize (GObject * obj)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
	_g_free0 (self->priv->_error);
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
}


GType
serializer_get_type (void)
{
	static volatile gsize serializer_type_id__volatile = 0;
	if (g_once_init_enter (&serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
		GType serializer_type_id;
		serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
		g_once_init_leave (&serializer_type_id__volatile, serializer_type_id);
	}
	return serializer_type_id__volatile;
}


static void
_vala_serializer_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		g_value_set_string (value, serializer_get_error (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_serializer_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		serializer_set_error (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



