/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: TopLevelLayoutManager.java 1297404 2012-03-06 10:17:54Z vhennebert $ */

package org.apache.fop.layoutmgr;

import org.apache.fop.datatypes.Numeric;

/**
 * This interface is implemented by top-level layout managers such as the ones for fo:page-sequence
 * and fox:external-document.
 */
public interface TopLevelLayoutManager {

    /**
     * Activate the layout of this page sequence.
     * PageViewports corresponding to each page generated by this
     * page sequence will be created and sent to the AreaTreeModel
     * for rendering.
     */
    void activateLayout();

    /**
     * Act upon the force-page-count trait,
     * in relation to the initial-page-number trait of the following page-sequence.
     * @param nextPageSeqInitialPageNumber initial-page-number trait of next page-sequence
     */
    void doForcePageCount(Numeric nextPageSeqInitialPageNumber);

    /**
     * Finished the page-sequence and notifies everyone about it.
     */
    void finishPageSequence();

}
