/* a11y-profile-manager-indicator.c generated by valac 0.32.1, the Vala compiler
 * generated from a11y-profile-manager-indicator.vala, do not modify */

/* Copyright (C) 2016 Canonical Ltd.
 * Author: Luke Yelavich <luke.yelavich@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libappindicator/app-indicator.h>
#include <gtk/gtk.h>
#include <a11y-profile-manager.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <config.h>
#include <stdio.h>
#include <glib-unix.h>


#define TYPE_PROFILE_INDICATOR (profile_indicator_get_type ())
#define PROFILE_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE_INDICATOR, ProfileIndicator))
#define PROFILE_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE_INDICATOR, ProfileIndicatorClass))
#define IS_PROFILE_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE_INDICATOR))
#define IS_PROFILE_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE_INDICATOR))
#define PROFILE_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE_INDICATOR, ProfileIndicatorClass))

typedef struct _ProfileIndicator ProfileIndicator;
typedef struct _ProfileIndicatorClass ProfileIndicatorClass;
typedef struct _ProfileIndicatorPrivate ProfileIndicatorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ProfileIndicator {
	GObject parent_instance;
	ProfileIndicatorPrivate * priv;
};

struct _ProfileIndicatorClass {
	GObjectClass parent_class;
};

struct _ProfileIndicatorPrivate {
	GSettings* profile_settings;
	GSettings* a11y_settings;
	gchar* current_profile;
	AppIndicator* indicator;
	gboolean installer_mode;
	GPid at_pid;
	GHashTable* profiles;
	GtkCheckMenuItem* active_item;
	GtkRadioMenuItem* no_profile_item;
};


static gpointer profile_indicator_parent_class = NULL;

GType profile_indicator_get_type (void) G_GNUC_CONST;
#define PROFILE_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROFILE_INDICATOR, ProfileIndicatorPrivate))
enum  {
	PROFILE_INDICATOR_DUMMY_PROPERTY
};
static ProfileIndicator* profile_indicator_new (gboolean mode);
static ProfileIndicator* profile_indicator_construct (GType object_type, gboolean mode);
static void profile_indicator_setup (ProfileIndicator* self);
static void profile_indicator_deactivate_profile (ProfileIndicator* self, GtkCheckMenuItem* item);
static void _profile_indicator_deactivate_profile_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void profile_indicator_activate_profile (ProfileIndicator* self, GtkCheckMenuItem* item);
static void _profile_indicator_activate_profile_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void profile_indicator_active_profile_setting_changed (ProfileIndicator* self, GSettings* settings, const gchar* key);
static void _profile_indicator_active_profile_setting_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void profile_indicator_uv_access_status_changed (ProfileIndicator* self, GSettings* settings, const gchar* key);
static void _profile_indicator_uv_access_status_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void profile_indicator_start_at (ProfileIndicator* self, const gchar* command);
gint profile_indicator_main (gchar** args, int args_length1);
static gboolean __lambda4_ (void);
static gboolean ___lambda4__gsource_func (gpointer self);
static void profile_indicator_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static ProfileIndicator* profile_indicator_construct (GType object_type, gboolean mode) {
	ProfileIndicator * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GHashFunc _tmp5_ = NULL;
	GEqualFunc _tmp6_ = NULL;
	GDestroyNotify _tmp7_ = NULL;
	GDestroyNotify _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	self = (ProfileIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("com.canonical.a11y-profile-manager");
	_g_object_unref0 (self->priv->profile_settings);
	self->priv->profile_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.a11y");
	_g_object_unref0 (self->priv->a11y_settings);
	self->priv->a11y_settings = _tmp1_;
	_tmp2_ = self->priv->profile_settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "active-profile");
	_g_free0 (self->priv->current_profile);
	self->priv->current_profile = _tmp3_;
	_tmp4_ = mode;
	self->priv->installer_mode = _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = g_object_unref;
	_tmp8_ = g_object_unref;
	_tmp9_ = g_hash_table_new_full (_tmp5_, _tmp6_, _tmp7_, _tmp8_);
	_g_hash_table_unref0 (self->priv->profiles);
	self->priv->profiles = _tmp9_;
	return self;
}


static ProfileIndicator* profile_indicator_new (gboolean mode) {
	return profile_indicator_construct (TYPE_PROFILE_INDICATOR, mode);
}


static void _profile_indicator_deactivate_profile_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	profile_indicator_deactivate_profile ((ProfileIndicator*) self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _profile_indicator_activate_profile_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	profile_indicator_activate_profile ((ProfileIndicator*) self, _sender);
}


static void _profile_indicator_active_profile_setting_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	profile_indicator_active_profile_setting_changed ((ProfileIndicator*) self, _sender, key);
}


static void _profile_indicator_uv_access_status_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	profile_indicator_uv_access_status_changed ((ProfileIndicator*) self, _sender, key);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static void profile_indicator_setup (ProfileIndicator* self) {
	GtkMenu* profiles_menu = NULL;
	GtkMenu* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRadioMenuItem* _tmp2_ = NULL;
	GSList* radio_group = NULL;
	GtkRadioMenuItem* _tmp3_ = NULL;
	GSList* _tmp4_ = NULL;
	GSList* profile_list = NULL;
	GSList* _tmp5_ = NULL;
	GtkRadioMenuItem* _tmp6_ = NULL;
	GtkRadioMenuItem* _tmp7_ = NULL;
	GtkMenu* _tmp8_ = NULL;
	GtkRadioMenuItem* _tmp9_ = NULL;
	GSList* _tmp10_ = NULL;
	AppIndicator* _tmp32_ = NULL;
	AppIndicator* _tmp33_ = NULL;
	AppIndicator* _tmp34_ = NULL;
	GtkMenu* _tmp35_ = NULL;
	AppIndicator* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GSettings* _tmp38_ = NULL;
	GSettings* _tmp39_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	profiles_menu = _tmp0_;
	_tmp1_ = _ ("No Profile");
	_tmp2_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new_with_label (NULL, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->no_profile_item);
	self->priv->no_profile_item = _tmp2_;
	_tmp3_ = self->priv->no_profile_item;
	_tmp4_ = gtk_radio_menu_item_get_group (_tmp3_);
	radio_group = _tmp4_;
	_tmp5_ = a11y_profile_manager_list_profiles ();
	profile_list = _tmp5_;
	_tmp6_ = self->priv->no_profile_item;
	g_signal_connect_object ((GtkCheckMenuItem*) _tmp6_, "toggled", (GCallback) _profile_indicator_deactivate_profile_gtk_check_menu_item_toggled, self, 0);
	_tmp7_ = self->priv->no_profile_item;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	_tmp8_ = profiles_menu;
	_tmp9_ = self->priv->no_profile_item;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = profile_list;
	{
		GSList* profile_collection = NULL;
		GSList* profile_it = NULL;
		profile_collection = _tmp10_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			A11yProfileManagerProfile* _tmp11_ = NULL;
			A11yProfileManagerProfile* profile = NULL;
			_tmp11_ = _g_object_ref0 ((A11yProfileManagerProfile*) profile_it->data);
			profile = _tmp11_;
			{
				GtkRadioMenuItem* menu_item = NULL;
				GSList* _tmp12_ = NULL;
				A11yProfileManagerProfile* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				GtkRadioMenuItem* _tmp16_ = NULL;
				A11yProfileManagerProfile* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				GHashTable* _tmp23_ = NULL;
				GtkRadioMenuItem* _tmp24_ = NULL;
				GtkCheckMenuItem* _tmp25_ = NULL;
				A11yProfileManagerProfile* _tmp26_ = NULL;
				A11yProfileManagerProfile* _tmp27_ = NULL;
				GtkRadioMenuItem* _tmp28_ = NULL;
				GtkRadioMenuItem* _tmp29_ = NULL;
				GtkMenu* _tmp30_ = NULL;
				GtkRadioMenuItem* _tmp31_ = NULL;
				_tmp12_ = radio_group;
				_tmp13_ = profile;
				_tmp14_ = a11y_profile_manager_profile_get_name (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new_with_label (_tmp12_, _tmp15_);
				g_object_ref_sink (_tmp16_);
				menu_item = _tmp16_;
				_tmp17_ = profile;
				_tmp18_ = a11y_profile_manager_profile_get_dir_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = self->priv->current_profile;
				if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
					GtkRadioMenuItem* _tmp21_ = NULL;
					GtkRadioMenuItem* _tmp22_ = NULL;
					_tmp21_ = menu_item;
					gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp21_, TRUE);
					_tmp22_ = menu_item;
					self->priv->active_item = (GtkCheckMenuItem*) _tmp22_;
				}
				_tmp23_ = self->priv->profiles;
				_tmp24_ = menu_item;
				_tmp25_ = _g_object_ref0 ((GtkCheckMenuItem*) _tmp24_);
				_tmp26_ = profile;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				g_hash_table_insert (_tmp23_, _tmp25_, _tmp27_);
				_tmp28_ = menu_item;
				g_signal_connect_object ((GtkCheckMenuItem*) _tmp28_, "toggled", (GCallback) _profile_indicator_activate_profile_gtk_check_menu_item_toggled, self, 0);
				_tmp29_ = menu_item;
				gtk_widget_show ((GtkWidget*) _tmp29_);
				_tmp30_ = profiles_menu;
				_tmp31_ = menu_item;
				gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
				_g_object_unref0 (menu_item);
				_g_object_unref0 (profile);
			}
		}
	}
	_tmp32_ = app_indicator_new ("a11y-profile-manager-indicator", "accessibility-directory", APP_INDICATOR_CATEGORY_OTHER);
	_g_object_unref0 (self->priv->indicator);
	self->priv->indicator = _tmp32_;
	_tmp33_ = self->priv->indicator;
	app_indicator_set_status (_tmp33_, APP_INDICATOR_STATUS_ACTIVE);
	_tmp34_ = self->priv->indicator;
	_tmp35_ = profiles_menu;
	app_indicator_set_menu (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->indicator;
	_tmp37_ = _ ("Accessibility Profiles");
	app_indicator_set_icon_full (_tmp36_, "accessibility-directory", _tmp37_);
	_tmp38_ = self->priv->profile_settings;
	g_signal_connect_object (_tmp38_, "changed::active-profile", (GCallback) _profile_indicator_active_profile_setting_changed_g_settings_changed, self, 0);
	_tmp39_ = self->priv->a11y_settings;
	g_signal_connect_object (_tmp39_, "changed::always-show-universal-access-status", (GCallback) _profile_indicator_uv_access_status_changed_g_settings_changed, self, 0);
	__g_slist_free__g_object_unref0_0 (profile_list);
	_g_object_unref0 (profiles_menu);
}


static void profile_indicator_activate_profile (ProfileIndicator* self, GtkCheckMenuItem* item) {
	A11yProfileManagerProfile* profile = NULL;
	GHashTable* _tmp0_ = NULL;
	GtkCheckMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	A11yProfileManagerProfile* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->profiles;
	_tmp1_ = item;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	profile = (A11yProfileManagerProfile*) _tmp2_;
	_tmp3_ = profile;
	if (_tmp3_ != NULL) {
		GtkCheckMenuItem* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = item;
		_tmp5_ = gtk_check_menu_item_get_active (_tmp4_);
		if (_tmp5_) {
			GtkCheckMenuItem* _tmp6_ = NULL;
			GtkCheckMenuItem* _tmp7_ = NULL;
			GtkCheckMenuItem* _tmp15_ = NULL;
			A11yProfileManagerProfile* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			GSettings* _tmp20_ = NULL;
			A11yProfileManagerProfile* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			_tmp6_ = item;
			_tmp7_ = self->priv->active_item;
			if (_tmp6_ == _tmp7_) {
				return;
			}
			{
				A11yProfileManagerProfile* _tmp8_ = NULL;
				_tmp8_ = profile;
				a11y_profile_manager_profile_set_settings (_tmp8_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				GtkCheckMenuItem* _tmp12_ = NULL;
				GtkRadioMenuItem* _tmp13_ = NULL;
				GSettings* _tmp14_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp9_ = _ ("Unable to set profile settings: %s");
				_tmp10_ = e;
				_tmp11_ = _tmp10_->message;
				g_warning (_tmp9_, _tmp11_);
				self->priv->active_item = NULL;
				_g_free0 (self->priv->current_profile);
				self->priv->current_profile = NULL;
				_tmp12_ = item;
				gtk_check_menu_item_set_active (_tmp12_, FALSE);
				_tmp13_ = self->priv->no_profile_item;
				gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp13_, TRUE);
				_tmp14_ = self->priv->profile_settings;
				g_settings_reset (_tmp14_, "active-profile");
				_g_error_free0 (e);
				return;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp15_ = item;
			self->priv->active_item = _tmp15_;
			_tmp16_ = profile;
			_tmp17_ = a11y_profile_manager_profile_get_dir_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (self->priv->current_profile);
			self->priv->current_profile = _tmp19_;
			_tmp20_ = self->priv->profile_settings;
			_tmp21_ = profile;
			_tmp22_ = a11y_profile_manager_profile_get_dir_name (_tmp21_);
			_tmp23_ = _tmp22_;
			g_settings_set_string (_tmp20_, "active-profile", _tmp23_);
			_tmp25_ = self->priv->installer_mode;
			if (_tmp25_) {
				A11yProfileManagerProfile* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				_tmp26_ = profile;
				_tmp27_ = a11y_profile_manager_profile_get_at_command (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp24_ = _tmp28_ != NULL;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				A11yProfileManagerProfile* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				_tmp29_ = profile;
				_tmp30_ = a11y_profile_manager_profile_get_at_command (_tmp29_);
				_tmp31_ = _tmp30_;
				profile_indicator_start_at (self, _tmp31_);
			}
		} else {
			GPid _tmp32_ = 0;
			_tmp32_ = self->priv->at_pid;
			if (_tmp32_ > ((GPid) 0)) {
				GPid _tmp33_ = 0;
				_tmp33_ = self->priv->at_pid;
				g_spawn_close_pid (_tmp33_);
				self->priv->at_pid = (GPid) 0;
			}
			{
				A11yProfileManagerProfile* _tmp34_ = NULL;
				_tmp34_ = profile;
				a11y_profile_manager_profile_reset_settings (_tmp34_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp35_ = NULL;
				GError* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp35_ = _ ("Unable to reset profile settings: %s");
				_tmp36_ = e;
				_tmp37_ = _tmp36_->message;
				g_warning (_tmp35_, _tmp37_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	return;
}


static void profile_indicator_deactivate_profile (ProfileIndicator* self, GtkCheckMenuItem* item) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	A11yProfileManagerProfile* profile = NULL;
	GHashTable* _tmp2_ = NULL;
	GtkCheckMenuItem* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	A11yProfileManagerProfile* _tmp6_ = NULL;
	GSettings* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->profiles;
	_tmp3_ = self->priv->active_item;
	_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
	profile = (A11yProfileManagerProfile*) _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->current_profile);
	self->priv->current_profile = _tmp5_;
	self->priv->active_item = NULL;
	_tmp6_ = profile;
	if (_tmp6_ != NULL) {
		GPid _tmp7_ = 0;
		_tmp7_ = self->priv->at_pid;
		if (_tmp7_ > ((GPid) 0)) {
			GPid _tmp8_ = 0;
			_tmp8_ = self->priv->at_pid;
			g_spawn_close_pid (_tmp8_);
			self->priv->at_pid = (GPid) 0;
		}
		{
			A11yProfileManagerProfile* _tmp9_ = NULL;
			_tmp9_ = profile;
			a11y_profile_manager_profile_reset_settings (_tmp9_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = _ ("Unable to reset profile settings: %s");
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning (_tmp10_, _tmp12_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = self->priv->profile_settings;
	g_settings_reset (_tmp13_, "active-profile");
	return;
}


static void profile_indicator_active_profile_setting_changed (ProfileIndicator* self, GSettings* settings, const gchar* key) {
	gchar* current_setting = NULL;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = g_settings_get_string (_tmp0_, _tmp1_);
	current_setting = _tmp2_;
	_tmp3_ = current_setting;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkRadioMenuItem* _tmp4_ = NULL;
		_tmp4_ = self->priv->no_profile_item;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
		_g_free0 (current_setting);
		return;
	}
	_tmp5_ = current_setting;
	_tmp6_ = self->priv->current_profile;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GList* item_list = NULL;
		GHashTable* _tmp9_ = NULL;
		GList* _tmp10_ = NULL;
		GList* _tmp11_ = NULL;
		_tmp7_ = current_setting;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->current_profile);
		self->priv->current_profile = _tmp8_;
		_tmp9_ = self->priv->profiles;
		_tmp10_ = g_hash_table_get_keys (_tmp9_);
		item_list = _tmp10_;
		_tmp11_ = item_list;
		{
			GList* item_collection = NULL;
			GList* item_it = NULL;
			item_collection = _tmp11_;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				GtkCheckMenuItem* item = NULL;
				item = (GtkCheckMenuItem*) item_it->data;
				{
					A11yProfileManagerProfile* profile = NULL;
					GHashTable* _tmp12_ = NULL;
					GtkCheckMenuItem* _tmp13_ = NULL;
					gconstpointer _tmp14_ = NULL;
					A11yProfileManagerProfile* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					_tmp12_ = self->priv->profiles;
					_tmp13_ = item;
					_tmp14_ = g_hash_table_lookup (_tmp12_, _tmp13_);
					profile = (A11yProfileManagerProfile*) _tmp14_;
					_tmp15_ = profile;
					_tmp16_ = a11y_profile_manager_profile_get_dir_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = current_setting;
					if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
						GtkCheckMenuItem* _tmp19_ = NULL;
						GtkCheckMenuItem* _tmp27_ = NULL;
						gboolean _tmp28_ = FALSE;
						gboolean _tmp29_ = FALSE;
						_tmp19_ = item;
						self->priv->active_item = _tmp19_;
						{
							A11yProfileManagerProfile* _tmp20_ = NULL;
							_tmp20_ = profile;
							a11y_profile_manager_profile_set_settings (_tmp20_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch3_g_error;
							}
						}
						goto __finally3;
						__catch3_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp21_ = NULL;
							GError* _tmp22_ = NULL;
							const gchar* _tmp23_ = NULL;
							GtkCheckMenuItem* _tmp24_ = NULL;
							GtkRadioMenuItem* _tmp25_ = NULL;
							GSettings* _tmp26_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp21_ = _ ("Unable to set profile settings: %s");
							_tmp22_ = e;
							_tmp23_ = _tmp22_->message;
							g_warning (_tmp21_, _tmp23_);
							self->priv->active_item = NULL;
							_g_free0 (self->priv->current_profile);
							self->priv->current_profile = NULL;
							_tmp24_ = item;
							gtk_check_menu_item_set_active (_tmp24_, FALSE);
							_tmp25_ = self->priv->no_profile_item;
							gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp25_, TRUE);
							_tmp26_ = self->priv->profile_settings;
							g_settings_reset (_tmp26_, "active-profile");
							_g_error_free0 (e);
						}
						__finally3:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_list_free0 (item_list);
							_g_free0 (current_setting);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp27_ = item;
						gtk_check_menu_item_set_active (_tmp27_, TRUE);
						_tmp29_ = self->priv->installer_mode;
						if (_tmp29_) {
							A11yProfileManagerProfile* _tmp30_ = NULL;
							const gchar* _tmp31_ = NULL;
							const gchar* _tmp32_ = NULL;
							_tmp30_ = profile;
							_tmp31_ = a11y_profile_manager_profile_get_at_command (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp28_ = _tmp32_ != NULL;
						} else {
							_tmp28_ = FALSE;
						}
						if (_tmp28_) {
							A11yProfileManagerProfile* _tmp33_ = NULL;
							const gchar* _tmp34_ = NULL;
							const gchar* _tmp35_ = NULL;
							_tmp33_ = profile;
							_tmp34_ = a11y_profile_manager_profile_get_at_command (_tmp33_);
							_tmp35_ = _tmp34_;
							profile_indicator_start_at (self, _tmp35_);
						}
					}
				}
			}
		}
		_g_list_free0 (item_list);
	}
	_g_free0 (current_setting);
	return;
}


static void profile_indicator_uv_access_status_changed (ProfileIndicator* self, GSettings* settings, const gchar* key) {
	gboolean uv_status = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "always-show-universal-access-status");
	uv_status = _tmp1_;
	_tmp2_ = uv_status;
	if (!_tmp2_) {
		gtk_main_quit ();
		return;
	}
}


static void profile_indicator_start_at (ProfileIndicator* self, const gchar* command) {
	GPid _tmp0_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_tmp0_ = self->priv->at_pid;
	if (_tmp0_ == ((GPid) 0)) {
		{
			gchar** argv = NULL;
			gint argv_length1 = 0;
			gint _argv_size_ = 0;
			const gchar* _tmp1_ = NULL;
			gchar** _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gchar** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			GPid _tmp5_ = 0;
			_tmp1_ = command;
			g_shell_parse_argv (_tmp1_, &_tmp3_, &_tmp2_, &_inner_error_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp2_;
			argv_length1 = _tmp3_;
			_argv_size_ = argv_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch4_g_error;
			}
			_tmp4_ = argv;
			_tmp4__length1 = argv_length1;
			g_spawn_async (NULL, _tmp4_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp5_, &_inner_error_);
			self->priv->at_pid = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch4_g_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = _ ("Unable to start assistive technology: %s");
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning (_tmp6_, _tmp8_);
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean __lambda4_ (void) {
	gboolean result = FALSE;
	gtk_main_quit ();
	result = TRUE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ();
	return result;
}


gint profile_indicator_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean installer_mode = FALSE;
	GOptionEntry installer_option = {0};
	GOptionEntry _tmp0_ = {0};
	GOptionEntry null_option = {0};
	GOptionEntry _tmp1_ = {0};
	GOptionEntry* options = NULL;
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_ = {0};
	GOptionEntry* _tmp4_ = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	GOptionContext* context = NULL;
	const gchar* _tmp5_ = NULL;
	GOptionContext* _tmp6_ = NULL;
	GOptionContext* _tmp7_ = NULL;
	GOptionEntry* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GOptionContext* _tmp9_ = NULL;
	GOptionGroup* _tmp10_ = NULL;
	ProfileIndicator* profile_indicator = NULL;
	gboolean _tmp20_ = FALSE;
	ProfileIndicator* _tmp21_ = NULL;
	ProfileIndicator* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	installer_mode = FALSE;
	_tmp0_.long_name = "installer";
	_tmp0_.short_name = 'i';
	_tmp0_.flags = 0;
	_tmp0_.arg = G_OPTION_ARG_NONE;
	_tmp0_.arg_data = &installer_mode;
	_tmp0_.description = "Start the indicator in installer mode";
	_tmp0_.arg_description = NULL;
	installer_option = _tmp0_;
	_tmp1_.long_name = NULL;
	null_option = _tmp1_;
	_tmp2_ = installer_option;
	_tmp3_ = null_option;
	_tmp4_ = g_new0 (GOptionEntry, 2);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	options = _tmp4_;
	options_length1 = 2;
	_options_size_ = options_length1;
	_tmp5_ = _ ("- Accessibility Profile Manager Unity Desktop Indicator");
	_tmp6_ = g_option_context_new (_tmp5_);
	context = _tmp6_;
	_tmp7_ = context;
	_tmp8_ = options;
	_tmp8__length1 = options_length1;
	g_option_context_add_main_entries (_tmp7_, _tmp8_, GETTEXT_PACKAGE);
	_tmp9_ = context;
	_tmp10_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp9_, _tmp10_);
	{
		GOptionContext* _tmp11_ = NULL;
		_tmp11_ = context;
		g_option_context_parse (_tmp11_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		FILE* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "%s\n", _tmp14_);
		_tmp15_ = stderr;
		_tmp16_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp17_ = args;
		_tmp17__length1 = args_length1;
		_tmp18_ = _tmp17_[0];
		fprintf (_tmp15_, _tmp16_, _tmp18_);
		_tmp19_ = stderr;
		fprintf (_tmp19_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		options = (g_free (options), NULL);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		options = (g_free (options), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp20_ = installer_mode;
	_tmp21_ = profile_indicator_new (_tmp20_);
	profile_indicator = _tmp21_;
	_tmp22_ = profile_indicator;
	profile_indicator_setup (_tmp22_);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGTERM, ___lambda4__gsource_func, NULL, NULL);
	gtk_main ();
	result = EXIT_SUCCESS;
	_g_object_unref0 (profile_indicator);
	_g_option_context_free0 (context);
	options = (g_free (options), NULL);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return profile_indicator_main (argv, argc);
}


static void profile_indicator_class_init (ProfileIndicatorClass * klass) {
	profile_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ProfileIndicatorPrivate));
	G_OBJECT_CLASS (klass)->finalize = profile_indicator_finalize;
}


static void profile_indicator_instance_init (ProfileIndicator * self) {
	self->priv = PROFILE_INDICATOR_GET_PRIVATE (self);
	self->priv->at_pid = (GPid) 0;
}


static void profile_indicator_finalize (GObject* obj) {
	ProfileIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE_INDICATOR, ProfileIndicator);
	_g_object_unref0 (self->priv->profile_settings);
	_g_object_unref0 (self->priv->a11y_settings);
	_g_free0 (self->priv->current_profile);
	_g_object_unref0 (self->priv->indicator);
	_g_hash_table_unref0 (self->priv->profiles);
	_g_object_unref0 (self->priv->no_profile_item);
	G_OBJECT_CLASS (profile_indicator_parent_class)->finalize (obj);
}


GType profile_indicator_get_type (void) {
	static volatile gsize profile_indicator_type_id__volatile = 0;
	if (g_once_init_enter (&profile_indicator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfileIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProfileIndicator), 0, (GInstanceInitFunc) profile_indicator_instance_init, NULL };
		GType profile_indicator_type_id;
		profile_indicator_type_id = g_type_register_static (G_TYPE_OBJECT, "ProfileIndicator", &g_define_type_info, 0);
		g_once_init_leave (&profile_indicator_type_id__volatile, profile_indicator_type_id);
	}
	return profile_indicator_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



