/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  parallel_oper.lex
Dates:		  22 Sept. 2005
Purpose:	  start of a parallel thread expression or chained call
              ||| T {NS_xxx::TH_xxx | NULL}
Output:       "|||" or "|t|"
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |parallel_oper| thread.\fbreak
Recognize the parallel operator in its 2 drags:
quoted and unprotected. 
The same goes for the chained "procedure call" operator.
It overloads on the \TRAshift operator used by \Olinker.
@/
fsm	
(fsm-id	"parallel_oper.lex"
,fsm-filename parallel_oper
,fsm-namespace NS_parallel_oper
,fsm-class Cparallel_oper
,fsm-version "1.0",fsm-date "22 Sept 2005",fsm-debug "false"
,fsm-comments "Lexer for Parallel operator: \\PARshift.")
parallel-parser	
(	
  parallel-thread-function
    TH_parallel_oper
  ***
  parallel-la-boundary
    eolr - "|"
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rparallel_oper (
  lhs {
    user-declaration
      public:
      CAbs_lr1_sym* rtn_sym_;
    ***
    op
      rtn_sym_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
      RSVP(rtn_sym_);
      rtn_sym_ = 0;      
    ***  
  }
){
  -> "|" "|" "|" {
    op 
      rtn_sym_ = NS_yacco2_k_symbols::PTR_LR1_parallel_operator__; 
    ***}
  -> "\"" "|" "|" "|" "\"" {
    op 
      rtn_sym_ = NS_yacco2_k_symbols::PTR_LR1_parallel_operator__; 
    ***
    }
  -> "|" "t" "|" {
    op 
      rtn_sym_ = NS_yacco2_k_symbols::PTR_LR1_fset_transience_operator__; 
    ***}
  -> "\"" "|" "t" "|" "\"" {
    op 
      rtn_sym_ = NS_yacco2_k_symbols::PTR_LR1_fset_transience_operator__; 
    ***
    }
}
}// end of rules
