/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:     la_expr_src.lex
dates:    20 May 2005	
Purpose:  Extract Grammar's lookahead expression 
			chopped up into strings, literals, identifiers, operators
			and placed into a tok_can container for post compilation.
errors:   Err_no_end_of_code
          Err_comment_overrun
          Err_bad_eos
          Err_bad_esc
          Err_no_syntax_code_present
          Err_bad_term_in_la_expr
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |la_expr_src| Thread.\fbreak
Extract Grammar's lookahead expression 
chopped up into strings, literals, identifiers, 
operators, lr k constants, and keywords to be 
 placed into a |tok_can| container for post compilation.
 Apart from the keywords and lr k constants, 
 the tokens are processed before the definition  of a
 grammar's vocabulary --- Terminals and Rules.
 It is only after the grammar is completely parsed that 
 these tokens can be verified against the symbol table.
 
 The parsed expression is placed into a token container of |T_la_expr_src|
by |parallel_parser_phrase_th| for post evaluation by
|la_expr_lexical| and |la_expr| grammars.
@/
fsm	
(fsm-id	"la_expr_src.lex",fsm-filename la_expr_src,fsm-namespace NS_la_expr_src
,fsm-class	Cla_expr_src{
  user-prefix-declaration
#include "c_string.h"
#include "identifier.h"
#include "c_literal.h"
#include "lint_balls.h"
#include "o2_code_end.h"
#include "la_lrk_T.h"
#include "yacco2_stbl.h"
using namespace NS_yacco2_terminals;
  ***
  user-declaration
    public: 
    T_la_expr_src* exp_;
  ***
  op
    exp_ = new T_la_expr_src;
    exp_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    parser__->set_use_all_shift_on();
  ***
  constructor
    exp_ = 0;
  ***
  }
,fsm-version "1.0",fsm-date "30 dec 2002",fsm-debug "false"
,fsm-comments	"Lexer: 1st stage of Lookahead source expression\n converted into raw character tokens for post evaluation.")
parallel-parser	
(	
  parallel-thread-function
    TH_la_expr_src
  ***
  parallel-la-boundary
eog
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rla_expr_src	 (){
  -> Rtoks
}

Rtoks  (){
  -> 	Rtok  
  -> 	Rtoks Rtok  
}

Rtok  (){
  -> ||| "c-string"	NS_c_string::TH_c_string{
    op
      Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      fsm->exp_->la_tok_can()->push_back(*sf->p2__);
    ***			
    } 
  -> ||| "c-literal"	NS_c_literal::TH_c_literal{
    op
      Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      fsm->exp_->la_tok_can()->push_back(*sf->p2__);
    ***			
    } 
  -> ||| "#***"	NS_o2_code_end::TH_o2_code_end{
    op
	Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      T_eocode* k = sf->p2__;
       k->set_auto_delete(true);
      rule_info__.parser__->set_use_all_shift_off();
		fsm->exp_->la_tok_can()->push_back(*yacco2::PTR_LR1_eog__);
		fsm->exp_->la_tok_can()->push_back(*yacco2::PTR_LR1_eog__);
		RSVP(fsm->exp_);
		fsm->exp_=0;
		rule_info__.parser__->set_stop_parse(true);
    ***			
    } 
  -> ||| identifier	NS_identifier::TH_identifier{
    op
      Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      fsm->exp_->la_tok_can()->push_back(*sf->p2__);
    ***			
    } 
  -> |+| {
/@
Watch out for overrun.
@/
    op
      Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
		CAbs_lr1_sym* la_sym = sf->p1__;
		using namespace NS_yacco2_T_enum;
		using namespace NS_yacco2_terminals;
		int id = la_sym->enumerated_id__;
		if(id == T_Enum::T_LR1_eog_){
			CAbs_lr1_sym* sym = new Err_no_end_of_code;
			sym->set_rc(*la_sym,__FILE__,__LINE__);
			RSVP(sym);
			rule_info__.parser__->set_stop_parse(true);
			return;
		}
      fsm->exp_->la_tok_can()->push_back(*la_sym);
    ***			
    } 
  -> ||| "bad eos" NULL {// errors
    op
       RSVP(sf->p2__);
       rule_info__.parser__->set_stop_parse(true);
    ***			
    } 
  -> ||| "bad esc" NULL {// errors
    op
       RSVP(sf->p2__);
       rule_info__.parser__->set_stop_parse(true);
    ***			
    } 
  -> ||| "comment-overrun" NULL {// errors
    op
       RSVP(sf->p2__);
       rule_info__.parser__->set_stop_parse(true);
    ***			
    } 
  -> ||| |+| NS_la_lrk_T::TH_la_lrk_T {
    op
    Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      fsm->exp_->la_tok_can()->push_back(*sf->p2__);
   ***			
    } 
 -> "+" {
    op
      Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      fsm->exp_->la_tok_can()->push_back(*sf->p1__);
    ***
    }
 -> "-" {
    op
      Cla_expr_src* fsm = (Cla_expr_src*)rule_info__.parser__->fsm_tbl__;
      fsm->exp_->la_tok_can()->push_back(*sf->p1__);
    ***
    }
 -> Rlint
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> |.|
}

Rla_minus  (){
  ->  "+"
  ->  "-"
}
}// end of rules
