/* 
   special version for ConTeXt
   (2007/08/11 --ak)
   (2009/04/29 --ak)
   (2012/05/14 --ak)
   (2013/08/14 --ak)
   (2014/01/22 --ak)
*/

#include <kpathsea/config.h>
#include <kpathsea/kpathsea.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <process.h>


#define SBUF    256
#define MAXARG  512

char *getlname(char *name)
{
  HANDLE hnd;
  WIN32_FIND_DATA ffd;

  char *path = NULL;
  char buff[SBUF];
  char buff2[SBUF];
  char *p, *fp;

  strcpy(buff, name);
  for(p = buff; *p; p++) {
    if(IS_KANJI(p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }
  fp = buff;
  if(p = strrchr(fp, '/')) {
    p++;
    fp = p;
  }
  if(p = strrchr(fp, ':')) {
    p++;
    fp = p;
  }
  if(p = strrchr(fp, '.')) *p = '\0';
  strcpy(buff2, fp);

  if(SearchPath((char *)getenv("PATH"), buff2, ".exe", SBUF, buff, &fp)) {
    if ((hnd = FindFirstFile(buff, &ffd)) == NULL) {
      return NULL;
    }
    FindClose(hnd);

    path = (char *)xmalloc(strlen(buff) + 1);
    strcpy(path, buff);
    for(p=path; *p; p++) {
      if(IS_KANJI(p)) {
        p++;
        continue;
      }
      if(*p == '\\') *p = '/';
    }
    if(p = strrchr(path, '/')) *p = '\0';

  }
  else {
    return NULL;
  }
  return path;
}

/* search for the script in the TeX bin directory */
int searchscr1(char *path, char *name, char *ext, char *dstname)
{
  char *fname;
  int  ret = 0;
  fname = concatn(path, "/", name, ext, NULL);
  if(_access(fname, 0) == 0) {
    strcpy(dstname, fname);
    ret = 1;
  }
  free(fname);
  return ret;
}

/* search for the script under $TEXMF/scripts// */
int searchscr2(char *name, char *ext, char *dstname, int isluap)
{
  char *fname, *fullname;
  int  ret = 0;
  fname = concat(name, ext);
  fullname = kpse_find_file(fname, kpse_texmfscripts_format, 0);
  if(!fullname && isluap) {
    fullname = kpse_find_file(fname, kpse_lua_format, 0);
  }
  if(fullname) {
    strcpy(dstname, fullname);
    free(fullname);
    ret = 1;
  }
  free(fname);
  return ret;
}

static int is_include_space(char *s)
{
  char *p;
  p = strchr(s, ' ');
  if(p) return 1;
  p = strchr(s, '\t');
  if(p) return 1;
  return 0;
}

int main(int ac, char **av)
{
  int i, ret, trees;
  char *argv[MAXARG];
  char *p;
  char *av0;
  char scrname[SBUF];
  char *fullname;
  char cmdname[SBUF];
  char fullbin[SBUF];

  int  kind;

  for(i=0; i <MAXARG; i++)
    argv[i] = NULL;

  kpse_set_program_name(av[0], NULL);
  av0 = kpse_program_basename(av[0]);
  cmdname[0] = '\0';
  trees = 0;

  if(ac>MAXARG - 5) {
    fprintf(stderr, "Too many arguments.\n");
    exit (100);
  }

  p = getlname(av0);
  if(!p) {
    fprintf(stderr, "Failed to find script loader.\n");
    exit (100);
  }

  scrname[0] = '\0';

  if((stricmp(av0, "context") == 0) ||
     (stricmp(av0, "metatex") == 0) ||
     (stricmp(av0, "mptopdf") == 0))
    kind = 1;
  else if(stricmp(av0, "luatools") == 0) {
    kind = 1;
    strcpy(av0, "base");
  }
  else if(stricmp(av0, "mtxrun") == 0)
    kind = 2;
  else if(stricmp(av0, "contextjit") == 0)
    kind = 3;
  else if(stricmp(av0, "mtxrunjit") == 0)
    kind = 4;
  else
    kind = 0;

  if(kind == 0) {
/* ruby (suffix .rb) */
    if(searchscr1(p, av0, ".rb", scrname))
      goto Found;

/* lua (suffix .lua) */
    if(searchscr1(p, av0, ".lua", scrname))
      goto Found;

    if(searchscr1(p, av0, ".tlu", scrname))
      goto Found;

    if(searchscr1(p, av0, ".texlua", scrname))
      goto Found;

/* python (suffix .py) */
    if(searchscr1(p, av0, ".py", scrname))
      goto Found;

/* perl (suffix .pl) */
    if(searchscr1(p, av0, ".pl", scrname))
      goto Found;

/* search script under $TEXMF/scripts */

/* ruby */
    if(searchscr2(av0, ".rb", scrname, 0))
      goto Found;

/* lua */
    if(searchscr2(av0, ".lua", scrname, 1))
      goto Found;

    if(searchscr2(av0, ".tlu", scrname, 1))
      goto Found;

    if(searchscr2(av0, ".texlua", scrname, 1))
      goto Found;

/* python */
    if(searchscr2(av0, ".py", scrname, 0))
      goto Found;

/* perl */
    if(searchscr2(av0, ".pl", scrname, 0))
      goto Found;

    if(!scrname[0]) {
      fprintf(stderr, "Failed to find script.\n");
      exit (100);
    }
  }

 Found:

/* mtxrun.lua */
  fullname = kpse_find_file("mtxrun", kpse_lua_format, 0);
  if(fullname == NULL) {
    fullname = kpse_find_file("mtxrun.lua", kpse_texmfscripts_format, 0);
  }

  if(fullname == NULL) {
    fprintf(stderr, "I cannot find mtxrun.lua.\n");
    exit (2);
  }

  strcpy(cmdname, fullname);
  free(fullname);

  if(kind == 3 || kind == 4) {
    argv[0] = xmalloc(14);
    strcpy(argv[0], "texluajit.exe");
  } else {
    argv[0] = xmalloc(11);
    strcpy(argv[0], "texlua.exe");
  }
  if(is_include_space(cmdname)) {
    argv[1] = concat3("\"", cmdname, "\"");
  } else {
    argv[1] = xmalloc(strlen(cmdname) + 1);
    strcpy(argv[1], cmdname);
  }

  if(kind == 1 || kind == 3) {
    argv[2] = xmalloc(9);
    strcpy(argv[2], "--script");
    if(kind == 1) {
      argv[3] = xmalloc(strlen(av0) + 1);
      strcpy(argv[3], av0);
    } else {
      argv[3] = xmalloc(8);
      strcpy(argv[3], "context");
    }
    for(i=1; i < ac; i++) {
      if(is_include_space(av[i])) {
	argv[i+3] = concat3("\"", av[i], "\"");
      } else {
	argv[i+3] = xmalloc(strlen(av[i]) + 1);
	strcpy(argv[i+3], av[i]);
      }
    }
    argv[ac+3] = NULL;
  } else if(kind == 2 || kind == 4) {
    for(i=1; i < ac; i++) {
      if(is_include_space(av[i])) {
	argv[i+1] = concat3("\"", av[i], "\"");
      } else {
	argv[i+1] = xmalloc(strlen(av[i]) + 1);
	strcpy(argv[i+1], av[i]);
      }
    }
    argv[ac+1] = NULL;
  } else {
    argv[2] = xmalloc(10);
    strcpy(argv[2], "--usekpse");
    argv[3] = xmalloc(10);
    strcpy(argv[3], "--execute");
    if(is_include_space(scrname)) {
      argv[4] = concat3("\"", scrname, "\"");
    } else {
      argv[4] = xmalloc(strlen(scrname) + 1);
      strcpy(argv[4], scrname);
    }
    for(i=1; i < ac; i++) {
      if(is_include_space(av[i])) {
	argv[i+4] = concat3("\"", av[i], "\"");
      } else {
	argv[i+4] = xmalloc(strlen(av[i]) + 1);
	strcpy(argv[i+4], av[i]);
      }
    }
    argv[ac+4] = NULL;
  }

  p = kpse_var_value("SELFAUTOLOC");
  strcpy(fullbin, p);
  strcat(fullbin, "/");
  if(kind == 3 || kind == 4)
    strcat(fullbin, "texluajit.exe");
  else
    strcat(fullbin, "texlua.exe");
  free(p);

/*
  fprintf(stderr, "%d %s\n", kind, fullbin);
  for(i=0; i < ac + 4; i++)
    fprintf(stderr, "%s ", argv[i]);
  fprintf(stderr, "\n");
  return (0);
*/

  ret = _spawnv(_P_WAIT, fullbin, argv);

  for(i=0; i < ac + 4; i++) {
    if(argv[i])
      free(argv[i]);
    else
      break;
  }
  return ret;
}
