/*
 * Decompiled with CFR 0.152.
 */
package nts.builder;

import nts.base.Dimen;
import nts.base.Glue;
import nts.builder.ListBuilder;
import nts.io.Log;
import nts.node.Box;
import nts.node.BoxLeaders;
import nts.node.BoxSizes;
import nts.node.HKernNode;
import nts.node.HLeadRuleNode;
import nts.node.HLeadersNode;
import nts.node.HSkipNode;
import nts.node.Leaders;
import nts.node.NamedHSkipNode;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.RuleNode;

public abstract class HorizBuilder
extends ListBuilder {
    public static final int NORMAL_SPACE_FACTOR = 1000;
    private int spaceFactor = 1000;

    public boolean isHorizontal() {
        return true;
    }

    public boolean isCharAllowed() {
        return true;
    }

    public void addKern(Dimen kern) {
        this.addNode(new HKernNode(kern));
    }

    public void addSkip(Glue skip) {
        this.addNode(new HSkipNode(skip));
    }

    public void addNamedSkip(Glue skip, String name) {
        this.addNode(new NamedHSkipNode(skip, name));
    }

    public void addRule(BoxSizes sizes) {
        this.addNode(new RuleNode(sizes));
        this.resetSpaceFactor();
    }

    public void addLeaders(Glue skip, Leaders lead) {
        this.addNode(new HLeadersNode(skip, lead));
    }

    public void addLeadRule(Glue skip, BoxSizes sizes, String desc) {
        this.addNode(new HLeadRuleNode(skip, sizes, desc));
    }

    public BoxLeaders.Mover getBoxLeadMover() {
        return HLeadersNode.BOX_MOVER;
    }

    public void addBox(Node box) {
        super.addBox(box);
        this.resetSpaceFactor();
    }

    protected NodeEnum unBoxList(Box box) {
        return box.getHorizList();
    }

    public void adjustSpaceFactor(int sf) {
        if (sf > 0) {
            this.spaceFactor = sf <= 1000 || this.spaceFactor >= 1000 ? sf : 1000;
        }
    }

    public int getSpaceFactor() {
        return this.spaceFactor;
    }

    public int nearestValidSpaceFactor() {
        return this.spaceFactor;
    }

    public void setSpaceFactor(int sf) {
        if (sf > 0) {
            this.spaceFactor = sf;
        }
    }

    public void resetSpaceFactor() {
        this.spaceFactor = 1000;
    }

    protected void specialShow(Log log) {
        log.startLine().add("spacefactor ").add(this.getSpaceFactor());
    }

    protected HorizBuilder(int line, NodeList list) {
        super(line, list);
    }

    protected HorizBuilder(int line) {
        super(line);
    }
}

