/* vputn.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

#if defined (IF_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

void v_putn (char c, int count)
{
  if (count > 0)
    {
#if defined (IF_WIN32)
      IF_WIN32
        {
          DWORD r;
          WriteConsole(            
            GetStdHandle(STD_OUTPUT_HANDLE),
            &c,1,&r,NULL);
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          if (_v_mem != NULL)
            {
              char *p;

              p = _v_mem + (_v_y * _v_width + _v_x) * 2;
              while (count > 0)
                {
                  p[0] = c;
                  p[1] = (char)_v_attr;
                  --count; p += 2;
                }
            }
          else
            {
              union REGS r;

              r.h.ah = 0x09;
              r.h.bh = 0;
              r.h.bl = (unsigned char)_v_attr;
              r.h.al = c;
              r.x.cx = count;
              _int86 (0x10, &r, &r);
            }
        }
#endif
    }
}
