/* port.h (c) Rainer Schnitker 1996 */

#ifndef _PORT_H
#define _PORT_H

#ifdef __linux__

#define O_BINARY 0

#define tell(fd)            lseek(fd, 0, SEEK_CUR)
#define chsize(handle, ptr) ftruncate(handle, ptr)
#define stricmp             strcasecmp

long    filelength (int fd);
int     strlwr(char *);
int     strupr(char *);

#else /* EMX, DJGPP */

#include <io.h>

#endif /* not __linux__ */

#if !defined (_MAX_PATH)
#define _MAX_PATH   260
#define _MAX_DRIVE    3
#define _MAX_DIR    256
#define _MAX_FNAME  256
#define _MAX_EXT    256
#endif

#include <stdio.h>
int     _path (char *dst, const char *name);
int     _abspath (char *dst, const char *src, int size);
void    _splitpath (const char *src, char *drive, char *dir, char *fname, char *ext);
char *  _strncpy (char *string1, const char *string2, size_t size);
FILE *  _fsopen (const char *fname, const char *mode, int shflag);
void    _searchenv (const char *name, const char *var, char *path);

#endif /* _PORT_H */
