/*****

      $Source: d:\gunther\source\grc/RCS/portio.h,v $
      $Author: gunther $
      $Date: 1996/01/02 23:17:24 $
      $Revision: 1.1 $

 *****/

#ifndef _PORTIO_H
#define _PORTIO_H

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

extern int byte_order;
extern int dest_order;

enum
{
    BYTEORDER_UP,
    BYTEORDER_DOWN
};


int byteorder();
void init_portio(int, char **);

void reverse_byteorder(void *, void *, int);

int pio_write(FILE *, void *, int);
int pio_read(FILE *, void *, int);

#define write_int8(b, f)    pio_write(f, b, 1)
#define write_int16(b, f)   pio_write(f, b, 2)
#define write_int32(b, f)   pio_write(f, b, 4)

#define read_int8(b, f)     pio_read(f, b, 1)
#define read_int16(b, f)    pio_read(f, b, 2)
#define read_int32(b, f)    pio_read(f, b, 4)

#ifdef __cplusplus
}
#endif

#endif

