/***************************************************************************\
*                                                                           *
*   WINDEF.H                                                                *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINDEF_H)
#define _WINDEF_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(RC_INVOKED)
#define VOID void
#define CONST const
typedef void		*PVOID;
typedef void		*NPVOID;
typedef void		*LPVOID;
typedef const void	*LPCVOID;
typedef void		*HANDLE;
typedef HANDLE	*PHANDLE;
typedef HANDLE	*LPHANDLE;
typedef unsigned char	BYTE;
typedef BYTE		*PBYTE;
typedef BYTE		*LPBYTE;
typedef unsigned char	UCHAR;
typedef UCHAR		*PUCHAR;
typedef char		*PSZ;
typedef short		SHORT;
typedef SHORT		*PSHORT;
typedef short		USHORT;
typedef USHORT	*PUSHORT;
typedef unsigned short	WORD;
typedef WORD		*PWORD;
typedef WORD		*LPWORD;
typedef unsigned short	ATOM;
typedef int		BOOL;
typedef BOOL		*PBOOL;
typedef BOOL		*LPBOOL;
typedef int		INT;
typedef INT		*PINT;
typedef INT		*LPINT;
typedef int             	HFILE;
typedef unsigned int	UINT;
typedef UINT		*PUINT;
typedef unsigned int	WPARAM;
typedef long		LONG;
typedef LONG		*PLONG;
typedef LONG            	*LPLONG;
typedef long		LPARAM;
typedef long		LRESULT;
typedef unsigned long	ULONG;
typedef ULONG		*PULONG;
typedef unsigned long	DWORD;
typedef DWORD		*PDWORD;
typedef DWORD		*LPDWORD;
typedef unsigned long	COLORREF;
typedef COLORREF	*LPCOLORREF;
typedef float		FLOAT;
typedef FLOAT		*PFLOAT;

/* characters: Ansi and Unicode */

typedef char		CHAR;
typedef wchar_t		WCHAR;

typedef char		*PCHAR;
typedef wchar_t		*PWCHAR;
typedef char		*NPSTR;
typedef wchar_t		*NWPSTR;
typedef char		*LPCH;
typedef wchar_t		*LPWCH;
typedef char		*LPSTR;
typedef wchar_t		*LPWSTR;
typedef char		*PPCH;
typedef wchar_t		*PWCH;
typedef char		*PSTR;
typedef wchar_t		*PWSTR;

typedef const char	*LPCCH;
typedef const wchar_t	*LPCWCH;
typedef const char	*LPCSTR;
typedef const wchar_t	*LPCWSTR;
typedef const char	*PCCH;
typedef const wchar_t	*PCWCH;
typedef const char	*PCSTR;
typedef const wchar_t	*PCWSTR;

#ifdef UNICODE
typedef wchar_t 	TCHAR;
typedef wchar_t 	*PTCHAR;
typedef wchar_t 	*LPTCHAR;
typedef wchar_t 	TBYTE;
typedef wchar_t 	*PTBYTE;
typedef wchar_t 	*LPTCH;
typedef wchar_t 	*PTCH;
typedef wchar_t 	*PTSTR;
typedef wchar_t 	*LPTSTR;
typedef const wchar_t	*LPCTSTR;
#define __STRING(str) L##str
#else
typedef char		TCHAR;
typedef char		*PTCHAR;
typedef char		*LPTCHAR;
typedef unsigned char	TBYTE;
typedef unsigned char	*PTBYTE;
typedef char		*LPTCH;
typedef char		*PTCH;
typedef char		*PTSTR;
typedef char		*LPTSTR;
typedef const char	*LPCTSTR;
#define __STRING(str) str
#endif
#define TEXT(str) __STRING(str)
#endif /*RC_INVOKED */

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef MAX_PATH
#define MAX_PATH 260
#endif

#define WINAPI __stdcall
#define APIENTRY __stdcall
#define CALLBACK __stdcall
#define PASCAL __stdcall
#define FAR
#define NEAR
#define IN
#define OUT
#define OPTIONAL

#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))
#define MAKELONG(a, b)      ((LONG)(((WORD)(a)) | ((DWORD)((WORD)(b))) << 16))
#define MAKELPARAM(l, h)      (LPARAM)MAKELONG(l, h)
#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((WORD)(w) >> 8) & 0xFF))

#if !defined(RC_INVOKED)
#ifdef STRICT
#define DECLARE_HANDLE(h) struct h##__ {unsigned help;}; typedef struct h##__ *h
#else
#define DECLARE_HANDLE(h) typedef HANDLE h
#endif

#define INVALID_HANDLE_VALUE	((HANDLE) -1)

DECLARE_HANDLE(HACCEL);
DECLARE_HANDLE(HBITMAP);
DECLARE_HANDLE(HBRUSH);
DECLARE_HANDLE(HDC);
DECLARE_HANDLE(HDESK);
DECLARE_HANDLE(HENHMETAFILE);
DECLARE_HANDLE(HFONT);
DECLARE_HANDLE(HGLOBAL);
DECLARE_HANDLE(HGLRC);
DECLARE_HANDLE(HHOOK);
DECLARE_HANDLE(HICON);
DECLARE_HANDLE(HINSTANCE);
DECLARE_HANDLE(HKL);
DECLARE_HANDLE(HLOCAL);
DECLARE_HANDLE(HMENU);
DECLARE_HANDLE(HMETAFILE);
DECLARE_HANDLE(HMODUL);
DECLARE_HANDLE(HPALETTE);
DECLARE_HANDLE(HPEN);
DECLARE_HANDLE(HRGN);
DECLARE_HANDLE(HRSRC);
DECLARE_HANDLE(HSTR);
DECLARE_HANDLE(HTASK);
DECLARE_HANDLE(HWINSTA);
DECLARE_HANDLE(HWND);
typedef HINSTANCE HMODULE;
typedef HICON HCURSOR;
typedef VOID *HGDIOBJ;

typedef struct {
    long        x;
    long        y;
} POINTL, *PPOINTL, POINT, *PPOINT, *LPPOINT;

typedef struct {
    short       x;
    short       y;
} POINTS, *PPOINTS, *LPPOINTS;

typedef struct {
    long        cx;
    long        cy;
} SIZEL, *PSIZEL, SIZE, *PSIZE, *LPSIZE;

typedef struct {
    long        left;
    long        top;
    long        right;
    long        bottom;
} RECTL, *PRECTL, *LPRECTL, RECT, *PRECT, *LPRECT;

/* functions */
typedef int WINAPI (*PROC)();
typedef int WINAPI (*FARPROC)();

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int);

#endif /* RC_INVOKED */

#ifndef max
#define max(a, b) (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a, b) (((a) < (b)) ? (a) : (b))
#endif

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINDEF_H) */
