//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseBooleanArray;

public class Parsegraphics {
	
	public static volatile SparseArray<Float> thisypos = new SparseArray<Float>();
	public static volatile SparseBooleanArray error = new SparseBooleanArray();
	public static volatile SparseArray<String> errormessage = new SparseArray<String>();
    
    public void parsegraphics(Canvas canvas, Block block, ParagraphBlock paragraphblock, Integer tid, Integer containerwidth, Integer containerheight, Integer tablelinenumber, ArrayList<Integer> tablehlinecounter, Integer superblocknumber, SuperBlock superblock ,SparseArray<ArrayList<String>> superblockline,SparseIntArray superblocknumline, SparseIntArray superblockstartline, SparseIntArray superblockendline, ArrayList<Typeface> tf , Float ypos, String attribute2, String attribute) {
      	
    	int i,j;
    	int tid2=tid*1000;
	    int captionnumline=-1;
        int viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
 
		float adjusty=ypos;
		float adjustx=0.0f;
		float thisypos2=0;
		
		String currentline="";
		String bitmapname="";
		
		   
            ArrayList<String> captionline = new ArrayList<String>();
    		
		    error.put(tid,false);
		    errormessage.put(tid,"");
		    
			Paint textpaint = new Paint();
		    Rect textbounds = new Rect();
			textpaint.setTextSize(Integer.parseInt(attribute.substring(1,4)));
			textpaint.setTypeface(tf.get(Integer.parseInt(attribute.substring(4,7))));
			textpaint.getTextBounds("Aj",0,"Aj".length(),textbounds);

			Boolean captionattop=false;
			int tablefirstline=superblockstartline.get(superblocknumber);
			int lastline=superblockendline.get(superblocknumber)-superblockstartline.get(superblocknumber);
			String sfontsize;

            	  for (i=0;i<=lastline;i++){                      
                     
                 currentline=superblockline.get(superblocknumber).get(i);	
                 String line=currentline.trim();
 
                if (line.length() >=15 && line.substring(0,15).equals("!begin{caption}")){
                	if (i==0){captionattop=true;} else {captionattop=false;};
              	 
                	 Boolean caption=true;
            			i++;
            			currentline=superblockline.get(superblocknumber).get(i);
            			line=currentline.trim();
            			if (line.length() >=13  && line.substring(0,13).equals("!end{caption}")){caption=false;i++;captionnumline++;}
                
                	 while(caption){
                		 j=line.indexOf("!!");
                		 line=line.substring(0,j);

                		 captionline.add(line);
                			i++;captionnumline++;
                			currentline=superblockline.get(superblocknumber).get(i);      
                			line=currentline.trim();
                			if (line.length() >=13  && line.substring(0,13).equals("!end{caption}")){caption=false;i++;}
                	 }
                	 tablelinenumber=tablelinenumber-captionnumline-1;
                	 if(captionattop){tablefirstline=i+tablefirstline;
                	 currentline=superblockline.get(superblocknumber).get(i);}            	
                 } }                
 
// Add top caption
            	  SuperBlock.tablestartline.put(tid2+SuperBlock.tablenumber.get(tid), SuperBlock.superblocklinenumber.get(tid)+1);
                  if (captionattop){
                      Parsetext caption = new Parsetext();
                      for (i=0;i<=captionnumline;i++){
               			sfontsize=Integer.toString(Header.fontsize);
              			if (sfontsize.length()==1){
              				attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
              			} else if (sfontsize.length()==2){
              				attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
              			} else if (sfontsize.length()==3){
              				attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
              			}					
                			caption.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, captionline.get(i), Header.leftsidemargin , adjusty, tf, attribute2, attribute, false, 0.0f);                			  		
                			thisypos2=Parsetext.thisypos.get(tid);
                			error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
                			adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(SuperBlock.superblocklinewidth.get(tid).size()-1))/2;
                  			for (int ij=0;ij<=SuperBlock.blockxpos.get(SuperBlock.superblocklinenumber.get(tid)+tid2).size()-1;ij++){
                  				SuperBlock.blockxpos.get(SuperBlock.superblocklinenumber.get(tid)+tid2).set(ij,SuperBlock.blockxpos.get(SuperBlock.superblocklinenumber.get(tid)+tid2).get(ij)+adjustx);
                  			}	 
                			adjusty=Parsetext.thisypos.get(tid);
                			thisypos.put(tid,adjusty); 
                      }}

            		  if (!captionattop){
            			  currentline=superblockline.get(superblocknumber).get(0);
            		  } else {
            			  currentline=superblockline.get(superblocknumber).get(i+captionnumline+1);
            		  }

            		  currentline=currentline.trim();
            		  j=currentline.indexOf("!!");
            		  bitmapname=currentline.substring(0,j);
            		  if (!DocumentBitmap.usedbitmap.contains(bitmapname)){
            			  DocumentBitmap.usedbitmap.add(bitmapname);}
            		  ArrayList<String> tsubblock = new ArrayList<String>();
            		  ArrayList<Float> tsubblockxpos = new ArrayList<Float>();
            		  ArrayList<Float> tsubblockypos = new ArrayList<Float>();
            		  ArrayList<String> tsubblockattribute = new ArrayList<String>();
            					
            		  tsubblock.add(bitmapname);
            		  tsubblockxpos.add((containerwidth-DocumentBitmap.bitmapwidth.get(bitmapname))/2);
            		  tsubblockypos.add(adjusty);
            		  tsubblockattribute.add("g");
            		  
            		  synchronized(this){
            			  superblock.create(tid);             						
               			  superblock.add(tid,tsubblock,tsubblockxpos,tsubblockypos,tsubblockattribute,DocumentBitmap.bitmapwidth.get(bitmapname) , DocumentBitmap.bitmapheight.get(bitmapname), 0.0f,'t',0);                     
            		  }
            		  thisypos2 = adjusty+DocumentBitmap.bitmapheight.get(bitmapname)+Header.linegap;
            		  thisypos.put(tid,thisypos2); 
  
              if (!captionattop){
              Parsetext caption = new Parsetext();
              for (i=0;i<=captionnumline;i++){
       			sfontsize=Integer.toString(Header.fontsize);
      			if (sfontsize.length()==1){
      				attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
      			} else if (sfontsize.length()==2){
      				attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
      			} else if (sfontsize.length()==3){
      				attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
      			}					
        			caption.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, captionline.get(i), Header.leftsidemargin , thisypos2, tf, attribute2, attribute, false, 0.0f);                			  		
        			thisypos2=Parsetext.thisypos.get(tid);
        			error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
        			adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(SuperBlock.superblocklinewidth.get(tid).size()-1))/2;
          			for (int ij=0;ij<=SuperBlock.blockxpos.get(SuperBlock.superblocklinenumber.get(tid)+tid2).size()-1;ij++){
          				SuperBlock.blockxpos.get(SuperBlock.superblocklinenumber.get(tid)+tid2).set(ij,SuperBlock.blockxpos.get(SuperBlock.superblocklinenumber.get(tid)+tid2).get(ij)+adjustx);
          			}	 
        			thisypos.put(tid,Parsetext.thisypos.get(tid)); 
              }}
              SuperBlock.tableendline.put(tid2+SuperBlock.tablenumber.get(tid), SuperBlock.superblocklinenumber.get(tid));
              SuperBlock.tableheight.put(tid2+SuperBlock.tablenumber.get(tid),thisypos.get(tid)-ypos);
}}
    
   
