/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/* str_fun.h */

#ifndef STR_FUN_H
#define STR_FUN_H

/* String for sorting */

#define SSTRING " !\"#$%()*+-/.:;<>=?0123456789\
aAbBcCdDeEfFgG\
hHiIjJkKlLmMnN\
oOpPqQrRsStTuU\
vVwWxXyYzZ\
[]^_|{}"


void upper(char * s);
int countitem(const char * s1, const char * sepstring);
void extractitem(int num, const char * s1, const char * sepstring, char * itemstr);
void komma_in_punkt(char * zeile);
void string_in_long(const char *s, long * zahl, int * f_code);
void string_in_double(char *s, double * zahl, int * f_code);
void str_ins_char(char * str1,char c1,int posit);
void str_del_char(char * str1,int posit);
void str_over_char(char * str1,char c1,int posit);
unsigned int is_substring(const char * subs, const char * textzeile);
void ltrim(char * zeile, const char c);
void rtrim(char * zeile, const char c);
void trim (char * zeile, const char c);
void wwrap(char * tzeile, long zlaenge);
int strlimcat(char * dest, const char * src, long maxl);
void strlimcpy(char * dest, const char * src, int maxl);
int strcmp_fun(const char * s1, const char * s2, const char * sortstring);
int isvalidfilename(const char * fname);
int isvalidfilename2(const char * fname);
void extract_subs(
                  char * outstring,
                  const char * instring,
                  unsigned position,
                  unsigned laenge
                 );
int locate_substring(const char * subs, const char * textzeile);
int locate_substring_from_pos(const char * subs, const char * textzeile, int pos);
int serepl(char * ziel,
           const char * such,
           const char * ers,
           int maxlen,
           int * pos_vor_rest,
           char * zieltemp);

int parameter_auswerten_str(int ac, char * av[], char * muster, char * aus);
int parameter_auswerten_long(int ac, char * av[], char * muster, long * wert);
int return_uncommented_portion(char * aus, char * ein, const char kzeich);

int satzzeichen(const char * zeile);
void endst_satzzeichen_entfernen(char * zeile);
int translate_string(char * text, const char * von, const char * nach);
int tr_db_to_bibtex(char * zle, char * ausgabe, int max_laenge);

#endif


